/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.xmppcomponent;

import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.conf.ConfigurationException;
import tigase.disco.ServiceEntity;
import tigase.disco.ServiceIdentity;
import tigase.disco.XMPPService;
import tigase.net.ConnectionType;
import tigase.net.SocketType;
import tigase.server.ConnectionManager;
import tigase.server.Packet;
import tigase.util.Algorithms;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.XMPPIOService;

public class ComponentConnectionManager
extends ConnectionManager<XMPPIOService<Object>>
implements XMPPService {
    public static final String SECRET_PROP_KEY = "secret";
    public static final String PORT_ROUTING_TABLE_PROP_KEY = "routing-table";
    public static final String PACK_ROUTED_KEY = "pack-routed";
    public static final String RETURN_SERVICE_DISCO_KEY = "service-disco";
    public static final boolean RETURN_SERVICE_DISCO_VAL = true;
    public static final String IDENTITY_TYPE_KEY = "identity-type";
    public static final String IDENTITY_TYPE_VAL = "generic";
    private static final Logger log = Logger.getLogger(ComponentConnectionManager.class.getName());
    public int[] PORTS = new int[]{5555};
    public String PORT_LOCAL_HOST_PROP_VAL = "localhost";
    public String PORT_REMOTE_HOST_PROP_VAL = "comp-1.localhost";
    public ConnectionType PORT_TYPE_PROP_VAL = ConnectionType.accept;
    public SocketType PORT_SOCKET_PROP_VAL = SocketType.plain;
    public String SECRET_PROP_VAL = "someSecret";
    public String[] PORT_ROUTING_TABLE_PROP_VAL = new String[]{this.PORT_REMOTE_HOST_PROP_VAL, ".*@" + this.PORT_REMOTE_HOST_PROP_VAL, ".*\\." + this.PORT_REMOTE_HOST_PROP_VAL};
    public boolean PACK_ROUTED_VAL = false;
    private ServiceEntity serviceEntity = null;
    private boolean pack_routed = this.PACK_ROUTED_VAL;
    private String identity_type = "generic";
    private String service_id = "it doesn't matter";

    @Override
    public Map<String, Object> getDefaults(Map<String, Object> params) {
        String config_type = (String)params.get("config-type");
        if (config_type.equals("--gen-config-sm")) {
            this.PACK_ROUTED_VAL = true;
            this.PORT_TYPE_PROP_VAL = ConnectionType.accept;
        }
        if (config_type.equals("--gen-config-cs")) {
            this.PACK_ROUTED_VAL = true;
            this.PORT_TYPE_PROP_VAL = ConnectionType.connect;
            this.PORT_IFC_PROP_VAL = new String[]{"localhost"};
        }
        boolean def_found = false;
        for (String key : params.keySet()) {
            String gen_ext_comp = "--ext-comp";
            if (!key.startsWith("--ext-comp")) continue;
            String end = key.substring("--ext-comp".length());
            if (this.getName().endsWith(end)) {
                gen_ext_comp = key;
            }
            if (params.get(gen_ext_comp) == null) continue;
            def_found = true;
            log.config("Found default configuration: " + (String)params.get(gen_ext_comp));
            String[] comp_params = ((String)params.get(gen_ext_comp)).split(",");
            int idx = 0;
            if (comp_params.length >= idx + 1) {
                this.PORT_LOCAL_HOST_PROP_VAL = comp_params[idx++];
                log.config("Setting PORT_LOCAL_HOST_PROP_VAL to " + this.PORT_LOCAL_HOST_PROP_VAL);
            }
            if (comp_params.length >= idx + 1) {
                this.PORT_REMOTE_HOST_PROP_VAL = comp_params[idx++];
                log.config("Setting PORT_REMOTE_HOST_PROP_VAL to " + this.PORT_REMOTE_HOST_PROP_VAL);
                this.PORT_ROUTING_TABLE_PROP_VAL = new String[]{this.PORT_REMOTE_HOST_PROP_VAL};
                if (config_type.equals("--gen-config-cs")) {
                    this.PORT_IFC_PROP_VAL = new String[]{this.PORT_REMOTE_HOST_PROP_VAL};
                }
            }
            if (comp_params.length >= idx + 1) {
                try {
                    this.PORTS[0] = Integer.decode(comp_params[idx++]);
                }
                catch (NumberFormatException e) {
                    log.warning("Incorrect component port number: " + comp_params[idx - 1]);
                    this.PORTS[0] = 5555;
                }
                log.config("Setting PORTS[0] to " + this.PORTS[0]);
            }
            if (comp_params.length >= idx + 1) {
                this.SECRET_PROP_VAL = comp_params[idx++];
                log.config("Setting SECRET_PROP_VAL to " + this.SECRET_PROP_VAL);
            }
            if (comp_params.length >= idx + 1) {
                if (comp_params[idx++].equals("ssl")) {
                    this.PORT_SOCKET_PROP_VAL = SocketType.ssl;
                }
                log.config("Setting PORT_SOCKET_PROP_VAL to " + (Object)((Object)this.PORT_SOCKET_PROP_VAL));
            }
            if (comp_params.length >= idx + 1) {
                this.PORT_TYPE_PROP_VAL = comp_params[idx++].equals("accept") ? ConnectionType.accept : ConnectionType.connect;
                log.config("Setting PORT_TYPE_PROP_VAL to " + (Object)((Object)this.PORT_TYPE_PROP_VAL));
            }
            if (comp_params.length >= idx + 1) {
                this.PORT_ROUTING_TABLE_PROP_VAL = new String[]{comp_params[idx++]};
                break;
            }
            if (config_type.equals("--gen-config-comp")) {
                this.PORT_ROUTING_TABLE_PROP_VAL = new String[]{".*"};
                break;
            }
            String regex_host = this.PORT_REMOTE_HOST_PROP_VAL.replace(".", "\\.");
            this.PORT_ROUTING_TABLE_PROP_VAL = new String[]{regex_host, ".*@" + regex_host, ".*\\." + regex_host};
            break;
        }
        if (!def_found) {
            this.PORT_LOCAL_HOST_PROP_VAL = "localhost";
            this.PORT_REMOTE_HOST_PROP_VAL = this.getName() + ".localhost";
            String regex_host = this.PORT_REMOTE_HOST_PROP_VAL.replace(".", "\\.");
            this.PORT_ROUTING_TABLE_PROP_VAL = new String[]{regex_host, ".*@" + regex_host, ".*\\." + regex_host};
        }
        Map<String, Object> props = super.getDefaults(params);
        props.put(PACK_ROUTED_KEY, this.PACK_ROUTED_VAL);
        props.put(RETURN_SERVICE_DISCO_KEY, true);
        props.put(IDENTITY_TYPE_KEY, IDENTITY_TYPE_VAL);
        return props;
    }

    @Override
    public List<Element> getDiscoFeatures(JID from) {
        return null;
    }

    @Override
    public Element getDiscoInfo(String node, JID jid, JID from) {
        if (jid != null && this.getName().equals(jid.getLocalpart())) {
            return this.serviceEntity.getDiscoInfo(node);
        }
        return null;
    }

    @Override
    public List<Element> getDiscoItems(String node, JID jid, JID from) {
        if (this.getName().equals(jid.getLocalpart())) {
            return this.serviceEntity.getDiscoItems(node, null);
        }
        return Arrays.asList(this.serviceEntity.getDiscoItem(null, BareJID.toString(this.getName(), jid.toString())));
    }

    @Override
    public void processPacket(Packet packet) {
        if (log.isLoggable(Level.FINER)) {
            log.finer("Processing packet: " + packet.getElemName() + ", type: " + (Object)((Object)packet.getType()));
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Processing packet: " + packet);
        }
        if (packet.getStanzaTo() != null && packet.getStanzaTo().equals(this.getComponentId())) {
            try {
                this.addOutPacket(Authorization.FEATURE_NOT_IMPLEMENTED.getResponseMessage(packet, "Not implemented", true));
            }
            catch (PacketErrorTypeException e) {
                log.warning("Packet processing exception: " + e);
            }
            return;
        }
        if (this.pack_routed && packet.getElemName() != "route") {
            this.writePacketToSocket(packet.packRouted());
        } else {
            this.writePacketToSocket(packet);
        }
    }

    @Override
    public Queue<Packet> processSocketData(XMPPIOService<Object> serv) {
        Packet p = null;
        while ((p = serv.getReceivedPackets().poll()) != null) {
            if (log.isLoggable(Level.FINER)) {
                log.finer("Processing packet: " + p.getElemName() + ", type: " + (Object)((Object)p.getType()));
            }
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Processing socket data: " + p);
            }
            if (p.getElemName().equals("handshake")) {
                this.processHandshake(p, serv);
                continue;
            }
            Packet result = p;
            if (p.isRouted()) {
                try {
                    result = p.unpackRouted();
                }
                catch (TigaseStringprepException ex) {
                    log.warning("Packet stringprep addressing problem, dropping packet: " + p);
                    return null;
                }
            }
            this.addOutPacket(result);
        }
        return null;
    }

    @Override
    public boolean processUndeliveredPacket(Packet packet, Long stamp, String errorMessage) {
        this.addPacket(packet);
        return true;
    }

    @Override
    public void reconnectionFailed(Map<String, Object> port_props) {
    }

    @Override
    public void serviceStarted(XMPPIOService<Object> serv) {
        super.serviceStarted(serv);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("c2c connection opened: " + serv.getRemoteAddress() + ", type: " + serv.connectionType().toString() + ", id=" + serv.getUniqueId());
        }
        switch (serv.connectionType()) {
            case connect: {
                String compName = (String)serv.getSessionData().get("local-host");
                String data = "<stream:stream xmlns='jabber:component:accept' xmlns:stream='http://etherx.jabber.org/streams' to='" + compName + "'>";
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("cid: " + (String)serv.getSessionData().get("cid") + ", sending: " + data);
                }
                serv.xmppStreamOpen(data);
                break;
            }
        }
    }

    @Override
    public boolean serviceStopped(XMPPIOService<Object> service) {
        boolean result = super.serviceStopped(service);
        if (result) {
            ConcurrentMap<String, Object> sessionData = service.getSessionData();
            String[] routings = (String[])sessionData.get(PORT_ROUTING_TABLE_PROP_KEY);
            this.updateRoutings(routings, false);
            ConnectionType type = service.connectionType();
            if (type == ConnectionType.connect) {
                this.addWaitingTask(sessionData);
            }
            String addr = (String)sessionData.get("remote-host");
            this.removeComponentDomain(addr);
            if (log.isLoggable(Level.FINE)) {
                log.fine("Disonnected from: " + addr);
            }
            this.updateServiceDiscovery(addr, "XEP-0114 disconnected");
        }
        return result;
    }

    @Override
    public void setProperties(Map<String, Object> props) throws ConfigurationException {
        super.setProperties(props);
        this.pack_routed = (Boolean)props.get(PACK_ROUTED_KEY);
        this.identity_type = (String)props.get(IDENTITY_TYPE_KEY);
        this.serviceEntity = new ServiceEntity("XEP-0114 " + this.getName(), null, "XEP-0114");
        this.serviceEntity.addIdentities(new ServiceIdentity("component", this.identity_type, "XEP-0114 " + this.getName()));
    }

    @Override
    public void tlsHandshakeCompleted(XMPPIOService<Object> service) {
    }

    @Override
    public void xmppStreamClosed(XMPPIOService<Object> serv) {
        if (log.isLoggable(Level.FINER)) {
            log.finer("Stream closed.");
        }
    }

    @Override
    public String[] xmppStreamOpened(XMPPIOService<Object> service, Map<String, String> attribs) {
        if (log.isLoggable(Level.FINER)) {
            log.finer("Stream opened: " + attribs.toString());
        }
        switch (service.connectionType()) {
            case connect: {
                String id = attribs.get("id");
                service.getSessionData().put("sessionID", id);
                String secret = (String)service.getSessionData().get(SECRET_PROP_KEY);
                try {
                    String digest = Algorithms.hexDigest(id, secret, "SHA");
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("Calculating digest: id=" + id + ", secret=" + secret + ", digest=" + digest);
                    }
                    return new String[]{"<handshake>" + digest + "</handshake>"};
                }
                catch (NoSuchAlgorithmException e) {
                    log.log(Level.SEVERE, "Can not generate digest for pass phrase.", e);
                    return null;
                }
            }
            case accept: {
                String hostname = attribs.get("to");
                service.getSessionData().put("hostname-key", hostname);
                String id = UUID.randomUUID().toString();
                service.getSessionData().put("sessionID", id);
                return new String[]{"<stream:stream xmlns='jabber:component:accept' xmlns:stream='http://etherx.jabber.org/streams' from='" + hostname + "' id='" + id + "'>"};
            }
        }
        return null;
    }

    @Override
    protected int[] getDefPlainPorts() {
        return this.PORTS;
    }

    @Override
    protected long getMaxInactiveTime() {
        return 86400000000L;
    }

    @Override
    protected Map<String, Object> getParamsForPort(int port) {
        TreeMap<String, Object> defs = new TreeMap<String, Object>();
        defs.put(SECRET_PROP_KEY, this.SECRET_PROP_VAL);
        defs.put("local-host", this.PORT_LOCAL_HOST_PROP_VAL);
        defs.put(PORT_ROUTING_TABLE_PROP_KEY, this.PORT_ROUTING_TABLE_PROP_VAL);
        defs.put("type", (Object)this.PORT_TYPE_PROP_VAL);
        defs.put("socket", (Object)this.PORT_SOCKET_PROP_VAL);
        defs.put("remote-host", this.PORT_REMOTE_HOST_PROP_VAL);
        defs.put("ifc", this.PORT_IFC_PROP_VAL);
        defs.put("max-reconnects", 1800000);
        return defs;
    }

    @Override
    protected String getServiceId(Packet packet) {
        return this.service_id;
    }

    @Override
    protected String getUniqueId(XMPPIOService<Object> serv) {
        return this.service_id;
    }

    @Override
    protected XMPPIOService<Object> getXMPPIOServiceInstance() {
        return new XMPPIOService<Object>();
    }

    private void processHandshake(Packet p, XMPPIOService<Object> serv) {
        switch (serv.connectionType()) {
            case connect: {
                String data = p.getElemCData();
                if (data == null) {
                    String[] routings = (String[])serv.getSessionData().get(PORT_ROUTING_TABLE_PROP_KEY);
                    this.updateRoutings(routings, true);
                    String addr = (String)serv.getSessionData().get("remote-host");
                    this.addComponentDomain(addr);
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Connected to: " + addr);
                    }
                    this.updateServiceDiscovery(addr, "XEP-0114 connected");
                    break;
                }
                log.warning("Incorrect packet received: " + p);
                break;
            }
            case accept: {
                String digest = p.getElemCData();
                String id = (String)serv.getSessionData().get("sessionID");
                String secret = (String)serv.getSessionData().get(SECRET_PROP_KEY);
                try {
                    String loc_digest = Algorithms.hexDigest(id, secret, "SHA");
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("Calculating digest: id=" + id + ", secret=" + secret + ", digest=" + loc_digest);
                    }
                    if (digest != null && digest.equals(loc_digest)) {
                        Packet resp = Packet.packetInstance(new Element("handshake"));
                        this.writePacketToSocket(serv, resp);
                        String[] routings = (String[])serv.getSessionData().get(PORT_ROUTING_TABLE_PROP_KEY);
                        this.updateRoutings(routings, true);
                        String addr = (String)serv.getSessionData().get("hostname-key");
                        this.addComponentDomain(addr);
                        if (log.isLoggable(Level.FINE)) {
                            log.fine("Connected to: " + addr);
                        }
                        this.updateServiceDiscovery(addr, "XEP-0114 connected");
                        break;
                    }
                    log.info("Handshaking passwords don't match, disconnecting...");
                    serv.stop();
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Handshaking error.", e);
                }
                break;
            }
        }
    }

    private void updateRoutings(String[] routings, boolean add) {
        if (add) {
            log.info("Adding routings: " + Arrays.toString(routings));
            for (String route : routings) {
                try {
                    this.addRegexRouting(route);
                }
                catch (Exception e) {
                    log.warning("Can not add regex routing '" + route + "' : " + e);
                }
            }
        } else {
            log.info("Removing routings: " + Arrays.toString(routings));
            for (String route : routings) {
                try {
                    this.removeRegexRouting(route);
                }
                catch (Exception e) {
                    log.warning("Can not remove regex routing '" + route + "' : " + e);
                }
            }
        }
    }

    private void updateServiceDiscovery(String jid, String name) {
        ServiceEntity item = new ServiceEntity(jid, null, name);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Modifing service-discovery info: " + item.toString());
        }
        this.serviceEntity.addItems(item);
    }
}

