/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.xmppclient;

import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.server.ConnectionManager;
import tigase.server.Iq;
import tigase.server.Packet;
import tigase.server.xmppclient.XMPPIOProcessor;
import tigase.stats.StatisticsList;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.JID;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.StreamError;
import tigase.xmpp.XMPPIOService;

public class RegistrationThrottlingProcessor
implements XMPPIOProcessor {
    private static final Logger log = Logger.getLogger(RegistrationThrottlingProcessor.class.getCanonicalName());
    public static final String ID = "registration-throttling";
    private static final String[] REGISTER_PATH = Iq.IQ_QUERY_PATH;
    private static final String[] REMOVE_PATH = new String[]{"iq", "query", "remove"};
    private static final String[] USERNAME_PATH = new String[]{"iq", "query", "username"};
    private static final String XMLNS = "jabber:iq:register";
    private ConnectionManager connectionManager;
    private Timer timer = new Timer("registration-timer", true);
    private ConcurrentHashMap<String, List<Long>> registrations = new ConcurrentHashMap();
    private Integer limit = 4;
    private Duration period = Duration.ofDays(1L);
    private AtomicBoolean cleanUpScheduled = new AtomicBoolean(false);

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public void getStatistics(StatisticsList list) {
    }

    @Override
    public Element[] supStreamFeatures(XMPPIOService service) {
        return new Element[0];
    }

    @Override
    public boolean processIncoming(XMPPIOService service, Packet packet) {
        if (packet.getType() != StanzaType.set || !XMLNS.equals(packet.getAttributeStaticStr(REGISTER_PATH, "xmlns"))) {
            return false;
        }
        JID to = packet.getStanzaTo();
        if (!(to == null || to.getLocalpart() == null && this.connectionManager.isLocalDomain(to.getDomain()))) {
            return false;
        }
        if (packet.getElement().findChild(REMOVE_PATH) != null) {
            return false;
        }
        if (this.checkLimits(service, packet)) {
            return false;
        }
        try {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "User from IP {0} exceeded registration limit trying to register account {1}", new Object[]{service.getRemoteAddress(), packet.getElemCDataStaticStr(USERNAME_PATH)});
            }
            Packet errorPacket = Authorization.POLICY_VIOLATION.getResponseMessage(packet, "Policy violation", true);
            Element streamError = new Element("policy-violation");
            streamError.setXMLNS("urn:ietf:params:xml:ns:xmpp-stanzas");
            String result = this.connectionManager.xmppStreamError(service, Arrays.asList(streamError));
            service.writeRawData(errorPacket.getElement().toString());
            service.writeRawData(result);
            service.writeRawData("</stream:stream>");
        }
        catch (IOException | PacketErrorTypeException ex) {
            log.log(Level.FINEST, "Exception while registration request to check policy violation");
        }
        service.stop();
        return true;
    }

    @Override
    public boolean processOutgoing(XMPPIOService service, Packet packet) {
        return false;
    }

    @Override
    public void packetsSent(XMPPIOService service) throws IOException {
    }

    @Override
    public void processCommand(XMPPIOService service, Packet packet) {
    }

    @Override
    public boolean serviceStopped(XMPPIOService service, boolean streamClosed) {
        return false;
    }

    @Override
    public void setConnectionManager(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    @Override
    public void setProperties(Map<String, Object> props) {
        String tmp = (String)props.get("period");
        if (tmp != null) {
            this.period = Duration.parse(tmp);
        }
        if (props.containsKey("limit")) {
            this.limit = (Integer)props.get("limit");
        }
    }

    @Override
    public void streamError(XMPPIOService service, StreamError streamError) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanUpFromTimer() {
        Iterator<Map.Entry<String, List<Long>>> it = this.registrations.entrySet().iterator();
        while (it.hasNext()) {
            List<Long> registrationTimes;
            Map.Entry<String, List<Long>> e = it.next();
            List<Long> list = registrationTimes = e.getValue();
            synchronized (list) {
                this.cleanUp(registrationTimes);
                if (registrationTimes.isEmpty()) {
                    it.remove();
                }
            }
        }
        Optional earliest = this.registrations.values().stream().flatMap(times -> times.stream()).min(Long::compare);
        if (earliest.isPresent()) {
            this.timer.schedule((TimerTask)new CleanUpTask(), System.currentTimeMillis() - (Long)earliest.get());
        } else {
            this.cleanUpScheduled.compareAndSet(true, false);
        }
    }

    protected boolean checkLimits(XMPPIOService service, Packet packet) {
        boolean result = this.checkLimits(service);
        this.scheduleCleanUpIfNeeded();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkLimits(XMPPIOService service) {
        List registrationTimes;
        List list = registrationTimes = this.registrations.computeIfAbsent(service.getRemoteAddress(), k -> new ArrayList());
        synchronized (list) {
            this.cleanUp(registrationTimes);
            if (registrationTimes.size() <= this.limit) {
                registrationTimes.add(System.currentTimeMillis());
            }
            return registrationTimes.size() <= this.limit;
        }
    }

    protected void cleanUp(List<Long> registrationTimes) {
        long oldestAllowed = System.currentTimeMillis() - this.period.toMillis() + 5000L;
        registrationTimes.removeIf(ts -> ts < oldestAllowed);
    }

    protected void scheduleCleanUpIfNeeded() {
        if (this.cleanUpScheduled.compareAndSet(false, true)) {
            this.timer.schedule((TimerTask)new CleanUpTask(), this.period.toMillis());
        }
    }

    protected class CleanUpTask
    extends TimerTask {
        protected CleanUpTask() {
        }

        @Override
        public void run() {
            RegistrationThrottlingProcessor.this.cleanUpFromTimer();
        }
    }
}

