/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.websocket;

import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.server.websocket.WebSocketProtocolIfc;
import tigase.server.websocket.WebSocketXMPPIOService;
import tigase.util.Base64;

public class WebSocketHybi
implements WebSocketProtocolIfc {
    private static final Logger log = Logger.getLogger(WebSocketHybi.class.getCanonicalName());
    public static final String ID = "hybi";
    private static final String GUID = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
    private static final String RESPONSE_HEADER = "HTTP/1.1 101 Switching Protocols\r\nUpgrade: websocket\r\nConnection: Upgrade\r\nAccess-Control-Allow-Origin: *\r\nAccess-Control-Allow-Headers: Content-Type\r\nAccess-Control-Max-Age: 86400\r\n";
    private static final String WS_ACCEPT_KEY = "Sec-WebSocket-Accept";
    private static final String WS_KEY_KEY = "Sec-WebSocket-Key";
    private static final String CLOSE_CODE = "close-code";
    private static final boolean ALLOW_UNMASKED_FROM_CLIENT = Boolean.getBoolean("ws-allow-unmasked-frames");
    private static final int PROTOCOL_ERROR = 1003;
    private static byte[] EMPTY = new byte[0];

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public boolean handshake(WebSocketXMPPIOService service, Map<String, String> headers, byte[] buf) throws NoSuchAlgorithmException, IOException {
        if (!headers.containsKey("Sec-WebSocket-Version")) {
            return false;
        }
        StringBuilder response = new StringBuilder(RESPONSE_HEADER.length() * 2);
        response.append(RESPONSE_HEADER);
        int version = Integer.parseInt(headers.get("Sec-WebSocket-Version"));
        String key = headers.get(WS_KEY_KEY) + GUID;
        MessageDigest md = MessageDigest.getInstance("SHA1");
        byte[] resp = md.digest(key.getBytes());
        response.append("Sec-WebSocket-Protocol").append(": ");
        if (headers.get("Sec-WebSocket-Protocol").contains("xmpp-framing")) {
            response.append("xmpp-framing");
        } else {
            response.append("xmpp");
        }
        response.append("\r\n");
        response.append("Sec-WebSocket-Accept: ");
        response.append(Base64.encode(resp));
        response.append("\r\n");
        response.append("\r\n");
        service.maskingKey = new byte[4];
        service.writeRawData(response.toString());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer decodeFrame(WebSocketXMPPIOService service, ByteBuffer buf) {
        ByteBuffer unmasked;
        block21: {
            if (!buf.hasRemaining()) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Socket: {0}, no content remainging to process", new Object[]{service});
                }
                return null;
            }
            boolean masked = false;
            byte type = 0;
            int position = buf.position();
            unmasked = null;
            try {
                byte[] data;
                if (service.frameLength == -1L) {
                    type = buf.get();
                    if ((type & 0xF) == 8) {
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "Socket: {0}, closing connection due to client request {1}", new Object[]{service, String.format("%02X ", type)});
                        }
                        service.setState(WebSocketXMPPIOService.State.closing);
                        this.closeConnection(service, null);
                        return null;
                    }
                    byte b2 = buf.get();
                    boolean bl = masked = (b2 & 0x80) == 128;
                    if (!masked && !ALLOW_UNMASKED_FROM_CLIENT) {
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "Socket: {0}, closing connection due to protocol error - unmasked frame sent by client {1}", new Object[]{service, String.format("%02X ", type)});
                        }
                        this.closeConnection(service, 1003);
                        return null;
                    }
                    service.frameLength = b2 & 0x7F;
                    if (service.frameLength > 125L) {
                        long l = service.frameLength = service.frameLength == 126L ? (long)(buf.getShort() & 0xFFFF) : buf.getLong();
                    }
                    if (masked) {
                        buf.get(service.maskingKey);
                    }
                }
                if ((long)buf.remaining() >= service.frameLength) {
                    data = new byte[(int)service.frameLength];
                    buf.get(data);
                    if (masked) {
                        byte[] maskingKey = service.maskingKey;
                        for (int i = 0; i < data.length; ++i) {
                            data[i] = (byte)(data[i] ^ maskingKey[i % 4]);
                        }
                    }
                } else {
                    buf.position(position);
                    service.frameLength = -1L;
                    return null;
                }
                unmasked = ByteBuffer.wrap(data);
                service.frameLength = -1L;
                if (service.frameLength != -1L) break block21;
                if ((type & 0xA) == 10) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "Socket: {0}, ignoring pong frame", new Object[]{service});
                    }
                    unmasked = ByteBuffer.wrap(EMPTY);
                    break block21;
                }
                if ((type & 9) != 9) break block21;
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Socket: {0}, sending response on ping frame", new Object[]{service});
                }
                type = (byte)((byte)(type ^ 9) | 0xA);
                try {
                    ByteBuffer header = this.createFrameHeader(type, unmasked.remaining());
                    service.writeInProgress.lock();
                    service.writeBytes(header);
                    service.writeBytes(unmasked);
                }
                finally {
                    service.writeInProgress.unlock();
                }
                unmasked = ByteBuffer.wrap(EMPTY);
            }
            catch (BufferUnderflowException ex) {
                buf.position(position);
                service.frameLength = -1L;
                unmasked = null;
            }
        }
        return unmasked;
    }

    @Override
    public void encodeFrameAndWrite(WebSocketXMPPIOService service, ByteBuffer buf) throws IOException {
        int size = buf.remaining();
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Socket: {0}, sending encoded data size = {1}", new Object[]{service, size});
        }
        ByteBuffer bbuf = this.createFrameHeader((byte)-127, size);
        service.writeBytes(bbuf);
        service.writeBytes(buf);
    }

    @Override
    public void closeConnection(WebSocketXMPPIOService service) {
        if (!service.isConnected()) {
            return;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Socket: {0}, sending close frame", service);
        }
        service.setState(WebSocketXMPPIOService.State.closed);
        Integer code = (Integer)service.getSessionData().get(CLOSE_CODE);
        int len = 0;
        if (code != null) {
            len += 2;
        }
        ByteBuffer bbuf = this.createFrameHeader((byte)-120, len);
        service.writeBytes(bbuf);
        if (code != null) {
            ByteBuffer buf = ByteBuffer.allocate(2);
            buf.putShort(code.shortValue());
            buf.flip();
            service.writeBytes(buf);
        }
    }

    private void closeConnection(WebSocketXMPPIOService service, Integer code) {
        if (code != null) {
            service.getSessionData().put(CLOSE_CODE, code);
        }
        switch (service.getState()) {
            case closing: {
                service.setState(WebSocketXMPPIOService.State.closed);
                break;
            }
            case handshaked: {
                service.setState(WebSocketXMPPIOService.State.closing);
                break;
            }
        }
    }

    private ByteBuffer createFrameHeader(byte type, int size) {
        ByteBuffer bbuf = ByteBuffer.allocate(12);
        bbuf.put(type);
        if (size <= 125) {
            bbuf.put((byte)size);
        } else if (size <= 65535) {
            bbuf.put((byte)126);
            bbuf.putShort((short)size);
        } else {
            bbuf.put((byte)127);
            bbuf.putLong(size);
        }
        bbuf.flip();
        return bbuf;
    }
}

