/*
 * Decompiled with CFR 0.152.
 */
package tigase.server;

import java.util.List;
import tigase.server.Command;
import tigase.server.Packet;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.JID;

public class Iq
extends Packet {
    public static final String ELEM_NAME = "iq";
    public static final String QUERY_NAME = "query";
    public static final String[] IQ_QUERY_PATH = new String[]{"iq", "query"};
    public static final String[] IQ_PUBSUB_PATH = new String[]{"iq", "pubsub"};
    public static final String[] IQ_ERROR_PATH = new String[]{"iq", "error"};
    public static final String[] IQ_COMMAND_PATH = new String[]{"iq", "command"};
    public static final String[] IQ_CHAT_PATH = new String[]{"iq", "chat"};
    public static final String[] IQ_BIND_RESOURCE_PATH = new String[]{"iq", "bind", "resource"};
    public static final String[] IQ_BIND_PATH = new String[]{"iq", "bind"};
    private Command command = null;
    private String iqQueryXMLNS = null;
    private String strCommand = null;
    private boolean serviceDisco = false;
    private boolean cmd = false;

    public Iq(Element elem) throws TigaseStringprepException {
        super(elem);
        this.init();
    }

    public Iq(Element elem, JID stanzaFrom, JID stanzaTo) {
        super(elem, stanzaFrom, stanzaTo);
        this.init();
    }

    public static Packet commandResultForm(Iq packet) throws TigaseStringprepException {
        Packet result = packet.commandResult(Command.DataType.form);
        return result;
    }

    public static Packet commandResultResult(Iq packet) throws TigaseStringprepException {
        Packet result = packet.commandResult(Command.DataType.result);
        return result;
    }

    public static Iq createRosterPacket(String iq_type, String iq_id, JID from, JID to, JID item_jid, String item_name, String[] item_groups, String subscription, String item_type) {
        Element iq = new Element(ELEM_NAME, new String[]{"type", "id"}, new String[]{iq_type, iq_id});
        iq.setXMLNS("jabber:client");
        if (from != null) {
            iq.addAttribute("from", from.toString());
        }
        if (to != null) {
            iq.addAttribute("to", to.toString());
        }
        Element query = new Element(QUERY_NAME);
        query.setXMLNS("jabber:iq:roster");
        iq.addChild(query);
        Element item = new Element("item", new String[]{"jid"}, new String[]{item_jid.toString()});
        if (item_type != null) {
            item.addAttribute("type", item_type);
        }
        if (item_name != null) {
            item.addAttribute("name", item_name);
        }
        if (subscription != null) {
            item.addAttribute("subscription", subscription);
        }
        if (item_groups != null) {
            for (String gr : item_groups) {
                Element group = new Element("group", gr);
                item.addChild(group);
            }
        }
        query.addChild(item);
        return new Iq(iq, from, to);
    }

    public Packet commandResult(Command.DataType cmd_type) {
        return this.okResult(Command.createCommandEl(this.strCommand, cmd_type), 0);
    }

    @Override
    public Command getCommand() {
        return this.command;
    }

    public String getIQChildName() {
        List<Element> children = this.elem.getChildren();
        if (children != null && children.size() > 0) {
            return children.get(0).getName();
        }
        return null;
    }

    public String getIQXMLNS() {
        if (this.iqQueryXMLNS == null) {
            this.iqQueryXMLNS = this.elem.getXMLNSStaticStr(IQ_QUERY_PATH);
        }
        return this.iqQueryXMLNS;
    }

    @Override
    protected String[] getElNameErrorPath() {
        return IQ_ERROR_PATH;
    }

    public String getStrCommand() {
        return this.strCommand;
    }

    @Override
    public boolean isCommand() {
        return this.cmd;
    }

    @Override
    public boolean isServiceDisco() {
        return this.serviceDisco;
    }

    private void init() {
        Element child = this.elem.getChild("command", "http://jabber.org/protocol/commands");
        if (child != null) {
            this.cmd = true;
            this.strCommand = child.getAttributeStaticStr("node");
            this.command = Command.valueof(this.strCommand);
        }
        this.serviceDisco = this.isXMLNSStaticStr(IQ_QUERY_PATH, "http://jabber.org/protocol/disco#info") || this.isXMLNSStaticStr(IQ_QUERY_PATH, "http://jabber.org/protocol/disco#items");
    }
}

