/*
 * Decompiled with CFR 0.152.
 */
package tigase.monitor;

import java.lang.reflect.Field;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.kernel.BeanUtils;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.kernel.core.DependencyManager;
import tigase.kernel.core.Kernel;

@Bean(name="bean-configurator")
public class BeanConfigurator {
    public static final String NAME = "bean-configurator";
    @Inject
    private Kernel kernel;
    protected final Logger log = Logger.getLogger(this.getClass().getName());

    public void configureBeans(Map<String, Object> props) {
        for (Map.Entry<String, Object> entry : props.entrySet()) {
            if (!entry.getKey().contains("/")) continue;
            String[] tmp = entry.getKey().split("/");
            if (!this.kernel.isBeanClassRegistered(tmp[0])) {
                this.log.config("There is no bean '" + tmp[0] + "'.");
                continue;
            }
            try {
                Object bean = this.kernel.getInstance(tmp[0]);
                BeanUtils.setValue(bean, tmp[1], entry.getValue());
                this.log.config("Property has set: " + tmp[0] + "." + tmp[1] + "=" + entry.getValue());
            }
            catch (Exception e) {
                this.log.log(Level.CONFIG, "Cannot set property " + tmp[1] + " of bean " + tmp[0], e);
            }
        }
    }

    private Field getField(String fieldName, Object bean) {
        Field[] fields;
        for (Field field : fields = DependencyManager.getAllFields(bean.getClass())) {
            if (!field.getName().equals(fieldName)) continue;
            return field;
        }
        return null;
    }
}

