/*
 * Decompiled with CFR 0.152.
 */
package tigase.licence;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.cluster.SessionManagerClustered;
import tigase.conf.Configurable;
import tigase.conf.ConfiguratorAbstract;
import tigase.server.XMPPServer;
import tigase.server.xmppsession.SessionManager;
import tigase.stats.StatisticsCollector;
import tigase.stats.collector.StatisticsData;
import tigase.sys.TigaseRuntime;
import tigase.util.DNSResolverFactory;
import tigase.vhosts.VHostManager;
import tigase.vhosts.VHostManagerIfc;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;

public class LicenceCheckerUpdater {
    private static final Logger a = Logger.getLogger("tigase.stats");
    private static final BareJID b = BareJID.bareJIDInstanceNS((String)"invalid-hostname");
    protected static ConfiguratorAbstract configurator;
    protected static SessionManager sess;
    private static StatisticsCollector c;
    protected static VHostManagerIfc vhost;

    public static StatisticsData updateData() {
        a.finest("updating statistics data");
        StatisticsData statisticsData = null;
        try {
            if (configurator == null || sess == null || c == null || vhost == null) {
                LicenceCheckerUpdater.init();
            }
            statisticsData = new StatisticsData(LicenceCheckerUpdater.getHostname());
            statisticsData.addVHosts(LicenceCheckerUpdater.getVHosts());
            statisticsData.setUptime(LicenceCheckerUpdater.getUptime());
            statisticsData.setHeapUsed(LicenceCheckerUpdater.getHeapUsed());
            statisticsData.setHeapMax(LicenceCheckerUpdater.getHeapMax());
            statisticsData.setUsersOnline(LicenceCheckerUpdater.getUserOnline());
            statisticsData.setUsersActive(LicenceCheckerUpdater.getUserActive());
            statisticsData.setClusterNodesCount(LicenceCheckerUpdater.getClusterNodesCount());
            statisticsData.setMaxSessionsToday(LicenceCheckerUpdater.getMaxSessionsToday());
            statisticsData.setMaxSessionsYesterday(LicenceCheckerUpdater.getMaxSessionsYesterday());
            statisticsData.setAdditionalData(LicenceCheckerUpdater.getComponentInfo().toString());
        }
        catch (Exception exception) {
            a.log(Level.SEVERE, "Problem creating StatisticsData", exception);
        }
        return statisticsData;
    }

    public String getMissingLicenseWarning() {
        return "This installation contains Tigase ACS package, not an open source software.\nThe Tigase ACS is only available under a commercial license.\nThe full text of the commercial license agreement is available upon request.\n\nThe Tigase ACS component is provided free of charge for testing and\ndevelopment purposes only. Any use of the component on production systems,\neither commercial or not-for-profit, requires the purchase of a license.\n\nIf the Tigase ACS component is activated without a valid license, it will\ncontinue to work, including its full set of features, but it will send\ncertain statistical information to Tigase's servers on a regular basis.\nIf the Tigase ACS component cannot access our servers to send information,\nit will stop working. Once a valid license is installed, the Tigase ACS\ncomponent will stop sending statistical information to Tigase's servers.\n\nBy activating the Tigase ACS component without a valid license you agree\nand accept that the component will send certain statistical information\n(such as DNS domain names, vhost names, number of online users, number of\ncluster nodes, etc.) which may be considered confidential and proprietary\nby the user. You accept and confirm that such information, which may be\nconsidered confidential or proprietary, will be transferred to Tigase's\nservers and that you will not pursue any remedy at law as a result of the\ninformation transfer.\nIf the Tigase ACS component is installed but not activated, no statistical\ninformation will be sent to Tigase's servers.";
    }

    protected static long getHeapMax() {
        return TigaseRuntime.getTigaseRuntime().getHeapMemMax();
    }

    protected static long getHeapUsed() {
        return TigaseRuntime.getTigaseRuntime().getHeapMemUsed();
    }

    protected static BareJID getHostname() {
        BareJID bareJID;
        try {
            String string = DNSResolverFactory.getInstance().getDefaultHost();
            bareJID = string != null && !string.trim().isEmpty() ? BareJID.bareJIDInstance((String)string) : (sess != null && sess.getDefVHostItem() != null ? sess.getDefVHostItem() : b);
        }
        catch (Exception exception) {
            bareJID = b;
            a.log(Level.SEVERE, "Error during obtaining hostname", exception);
        }
        return bareJID;
    }

    protected static long getUptime() {
        return TigaseRuntime.getTigaseRuntime().getUptime();
    }

    public static StatisticsCollector getStats() {
        return c;
    }

    protected static long getUserOnline() {
        long l;
        String string = (String)c.getAllStats().getValue("sess-man/Open user connections");
        if (string != null) {
            l = Long.valueOf(string);
        } else {
            System.out.println("error getting number");
            l = 0L;
        }
        return l;
    }

    protected static long getUserActive() {
        long l;
        String string = (String)c.getAllStats().getValue("sess-man/Active user connections");
        if (string != null) {
            l = Long.valueOf(string);
        } else {
            System.out.println("error getting number");
            l = 0L;
        }
        return l;
    }

    protected static long getMaxSessionsToday() {
        long l;
        String string = (String)c.getAllStats().getValue("sess-man/Maximum user sessions today");
        if (string != null) {
            l = Long.valueOf(string);
        } else {
            System.out.println("error getting number");
            l = 0L;
        }
        return l;
    }

    protected static long getMaxSessionsYesterday() {
        long l;
        String string = (String)c.getAllStats().getValue("sess-man/Maximum user sessions yesterday");
        if (string != null) {
            l = Long.valueOf(string);
        } else {
            System.out.println("error getting number");
            l = 0L;
        }
        return l;
    }

    protected static List<BareJID> getVHosts() {
        ArrayList<BareJID> arrayList = new ArrayList<BareJID>();
        for (JID jID : vhost.getAllVHosts()) {
            arrayList.add(jID.getBareJID());
        }
        return arrayList;
    }

    protected static Element getComponentInfo() {
        Element element = new Element("components");
        try {
            Object object = configurator.getProperties("message-router");
            Object object2 = new ArrayList<String>(10);
            object2.addAll(Arrays.asList((String[])object.get("components/msg-receivers/id-names")));
            object2.addAll(Arrays.asList((String[])object.get("components/registrators/id-names")));
            object = object2.iterator();
            while (object.hasNext()) {
                object2 = (String)object.next();
                if ((object2 = (Configurable)configurator.getComponent((String)object2)) == null) continue;
                element.addChild((XMLNodeIfc)object2.getComponentInfo().toElement());
            }
        }
        catch (Exception exception) {
            a.log(Level.SEVERE, "Problem obtaining Configurator", exception);
        }
        return element;
    }

    public static int getClusterNodesCount() {
        if (sess instanceof SessionManagerClustered) {
            return ((SessionManagerClustered)sess).getStrategy().getNodesConnected().size() + 1;
        }
        return -1;
    }

    protected static void init() {
        configurator = XMPPServer.getConfigurator();
        if (configurator != null) {
            sess = (SessionManager)configurator.getComponent("sess-man");
            c = (StatisticsCollector)configurator.getComponent("stats");
            vhost = (VHostManager)configurator.getComponent("vhost-man");
        }
    }

    static {
        sess = null;
        vhost = null;
        LicenceCheckerUpdater.init();
    }
}

