/*
 * Decompiled with CFR 0.152.
 */
package tigase.licence;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.ws.http.HTTPException;
import tigase.db.RepositoryFactory;
import tigase.licence.Licence;
import tigase.licence.TOTP;
import tigase.licence.c;
import tigase.licence.utils.DataLoader;
import tigase.licence.utils.TooManyRequestsHTTPException;
import tigase.licence.utils.VHostsRetriever;
import tigase.xml.Element;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;

public class InstallationIdRetriever {
    private static final Logger a = Logger.getLogger(InstallationIdRetriever.class.getCanonicalName());
    private static String b = null;
    private static InstallationIdRetriever c = null;
    private static long d = 0L;
    private DataLoader e = new DataLoader();
    private final BareJID f = BareJID.bareJIDInstanceNS((String)"licence-library");
    private final Path g = Paths.get("etc/installation-id", new String[0]);

    static InstallationIdRetriever a() {
        if (c == null) {
            c = new InstallationIdRetriever();
        }
        return c;
    }

    public static void main(String[] args) {
        Object object = new ArrayList<JID>();
        object.add(JID.jidInstanceNS((String)"vhost1"));
        object.add(JID.jidInstanceNS((String)"vhost2"));
        object.add(JID.jidInstanceNS((String)"vhost3"));
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("hash1");
        arrayList.add("hash2");
        arrayList.add("hash3");
        InstallationIdRetriever installationIdRetriever = InstallationIdRetriever.a();
        try {
            Element element;
            block6: {
                Object object2;
                int n;
                Object[] objectArray;
                Object[] objectArray2;
                String string;
                Level level;
                Logger logger;
                element = null;
                try {
                    element = installationIdRetriever.loadData(null, (List<JID>)object, arrayList);
                    break block6;
                }
                catch (TooManyRequestsHTTPException tooManyRequestsHTTPException) {
                    logger = a;
                    level = Level.WARNING;
                    string = "Server returned error {0}: {1}; next retry in {2}s)";
                    Object[] objectArray3 = new Object[3];
                    objectArray3[0] = tooManyRequestsHTTPException.getStatusCode();
                    objectArray3[1] = tooManyRequestsHTTPException.getMessage();
                    objectArray2 = objectArray3;
                    objectArray = objectArray3;
                    n = 2;
                    object2 = tooManyRequestsHTTPException.getRetryAfter();
                }
                catch (IOException | HTTPException throwable) {
                    logger = a;
                    level = Level.WARNING;
                    string = "Server returned error: {0}{1}";
                    Object[] objectArray4 = new Object[2];
                    objectArray4[0] = throwable.getMessage();
                    objectArray2 = objectArray4;
                    objectArray = objectArray4;
                    n = 1;
                    object2 = throwable instanceof HTTPException ? ", code: " + ((HTTPException)throwable).getStatusCode() : "";
                }
                objectArray2[n] = object2;
                logger.log(level, string, objectArray);
            }
            System.out.println("element: " + element);
            if (element != null) {
                object = element.getCDataStaticStr(new String[]{"command", "fields", "item", "value"});
                System.out.println("installationID: " + (String)object);
            }
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            return;
        }
    }

    private InstallationIdRetriever() {
        try {
            String string = System.getProperty("user-db-uri");
            string = RepositoryFactory.getUserRepository(null, (String)string, null);
            if (!string.userExists(this.f)) {
                string.addUser(this.f);
            }
            return;
        }
        catch (Exception exception) {
            a.log(Level.WARNING, "There was a problem adding user {0} to the repository! Please make sure your database is configured correctly", new Object[]{this.f});
            if (a.isLoggable(Level.FINEST)) {
                a.log(Level.FINEST, "There was a problem adding user " + this.f + " to the repository! Please make sure your database is configured correctly", exception);
            }
            return;
        }
    }

    final synchronized String b() {
        if ((System.currentTimeMillis() - d) / 1000L / 60L < 10L) {
            return b;
        }
        d = System.currentTimeMillis();
        if (b == null) {
            long l = 2L;
            int n = 1;
            int n2 = 0;
            do {
                try {
                    b = this.c();
                }
                catch (TooManyRequestsHTTPException tooManyRequestsHTTPException) {
                    n = 10;
                    l = tooManyRequestsHTTPException.getRetryAfter() + 5;
                    a.log(Level.WARNING, "Server returned error {0}: {1}; next retry in {2}s (retries left: {3})", new Object[]{tooManyRequestsHTTPException.getStatusCode(), tooManyRequestsHTTPException.getMessage(), l, 10 - n2});
                    try {
                        Thread.sleep(l * 1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        a.log(Level.FINE, "There was a problem delaying the subsequent request");
                    }
                }
                catch (IOException | HTTPException throwable) {
                    a.log(Level.WARNING, "Server returned error: {0}{1}; next retry in {2}s (retries left: {3})", new Object[]{throwable.getMessage(), throwable instanceof HTTPException ? ", code: " + ((HTTPException)throwable).getStatusCode() : "", l, n - n2});
                }
            } while (b == null && ++n2 < n);
        }
        return b;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static List<Licence> a(String string, boolean bl) throws NoSuchAlgorithmException, InvalidKeySpecException {
        ArrayList<Licence> arrayList = new ArrayList<Licence>();
        Iterable<Path> iterable = Paths.get("./etc/", new String[0]);
        if (!iterable.toFile().exists()) {
            return null;
        }
        try {
            iterable = Files.newDirectoryStream((Path)iterable, "*.licence");
            Throwable throwable = null;
            try {
                c c2 = new c();
                for (Path path : iterable) {
                    Licence licence = c2.loadLicence(path.toFile());
                    String string2 = licence.getPropertyAsString(string);
                    if (bl) {
                        if (string2 == null) continue;
                        arrayList.add(licence);
                        continue;
                    }
                    if (string2 != null) continue;
                    arrayList.add(licence);
                }
                if (iterable == null) return arrayList;
            }
            catch (Throwable throwable2) {
                try {
                    Throwable throwable3 = throwable2;
                    throwable = throwable2;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    if (iterable == null) throw throwable4;
                    if (throwable != null) {
                        try {
                            iterable.close();
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                        throw throwable4;
                    } else {
                        iterable.close();
                    }
                    throw throwable4;
                }
            }
            iterable.close();
            return arrayList;
        }
        catch (IOException iOException) {
            a.log(Level.WARNING, "There was a problem reading current licence files", iOException);
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    protected Element loadData(String url, List<JID> managedVHosts, List<String> oldLicencesHashes) throws TooManyRequestsHTTPException, GeneralSecurityException, IOException {
        String string;
        void var3_3;
        Object object = managedVHosts;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<data><fields>");
        DataLoader.addRequestItems(stringBuffer, "vhosts", object);
        DataLoader.addRequestItems(stringBuffer, "legacy-hash", var3_3);
        object = new TOTP();
        stringBuffer.append("<item><var>totp</var><value>").append(((TOTP)object).generateTOTP()).append("</value></item>");
        stringBuffer.append("</fields></data>");
        object = stringBuffer.toString();
        string = url == null ? "https://license.tigase.software/register" : string;
        return this.e.loadData(string, (String)object);
    }

    private String c() throws TooManyRequestsHTTPException, IOException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        try {
            object4 = System.getProperty("user-db-uri");
            object3 = RepositoryFactory.getUserRepository(null, (String)object4, null);
            object2 = object3.getData(this.f, "installation-id");
            if (a.isLoggable(Level.FINEST)) {
                a.log(Level.FINEST, "Retrieved installationID from database: {0}", new Object[]{object2});
            }
            if (object2 != null) {
                if (a.isLoggable(Level.WARNING)) {
                    a.log(Level.WARNING, "Retrieved installationID from database: {0}", new Object[]{object2});
                }
                return object2;
            }
        }
        catch (Exception exception) {
            a.log(Level.WARNING, "There was a problem accessing repository to retrieve ID", exception.getMessage());
            if (a.isLoggable(Level.FINEST)) {
                a.log(Level.FINEST, "There was a problem accessing repository to retrieve ID", exception);
            }
            return null;
        }
        if (this.g.toFile().exists() && this.g.toFile().length() != 0L) {
            object4 = new Scanner(this.g);
            object3 = new StringBuilder();
            while (((Scanner)object4).hasNextLine()) {
                ((StringBuilder)object3).append(((Scanner)object4).nextLine());
            }
            a.log(Level.WARNING, "\n\n\n  =====================================\n  You already obtained installation-id: " + ((StringBuilder)object3).toString() + "\n  However it's not stored in the database which may result in cluster\n  not obtaining correct licences!\n  \n  Please make sure that database and cluster is working correctly!\n  =====================================\n\n");
            object2 = ((StringBuilder)object3).toString();
        }
        object4 = System.getProperty("installation-id");
        if (object2 == null && object4 != null) {
            if (a.isLoggable(Level.FINEST)) {
                a.log(Level.FINEST, "Retrieved installationID from file: {0}", new Object[]{object4});
            }
            object2 = object4;
        }
        if (object2 == null) {
            try {
                Object object5;
                object4 = this;
                object3 = new ArrayList();
                object = InstallationIdRetriever.a("licence-nr", false);
                if (object != null && !object.isEmpty()) {
                    object.forEach(arg_0 -> InstallationIdRetriever.a((List)object3, arg_0));
                }
                if (!object3.isEmpty()) {
                    a.log(Level.WARNING, "Legacy licences present, if you want to obtain installation-id manually please include following digest codes in the form: {0})", object3);
                }
                if ((object4 = ((InstallationIdRetriever)object4).loadData(null, VHostsRetriever.getManagedVHosts(), (List<String>)object3)) != null) {
                    object3 = object4.getCDataStaticStr(new String[]{"command", "fields", "item", "value"});
                    a.log(Level.FINE, "Retrieved installationId: {0} from request: {1}", new Object[]{object3, object4});
                    object5 = object3;
                } else {
                    object5 = object3 = null;
                }
                if (a.isLoggable(Level.FINEST)) {
                    a.log(Level.FINEST, "Retrieved installationID from server: {0}", new Object[]{object3});
                }
                if (object3 != null && !((String)object3).isEmpty()) {
                    object2 = object3;
                }
            }
            catch (GeneralSecurityException generalSecurityException) {
                a.log(Level.WARNING, "There was a problem retrieving installation-id from the server", generalSecurityException);
            }
        }
        if (object2 == null) {
            boolean bl = false;
            object4 = null;
            try {
                object = InstallationIdRetriever.a("installation-id", true);
                if (object != null && !object.isEmpty()) {
                    object = object.iterator();
                    while (object.hasNext()) {
                        Object object6 = (Licence)object.next();
                        if (object6 == null || (object6 = object6.getPropertyAsString("installation-id")) == null) continue;
                        if (object4 == null || ((String)object4).equals(object6)) {
                            object4 = object6;
                            bl = true;
                            continue;
                        }
                        if (((String)object4).equals(object6)) continue;
                        bl = false;
                    }
                    if (bl && object4 != null) {
                        object2 = object4;
                    }
                }
            }
            catch (NoSuchAlgorithmException | InvalidKeySpecException generalSecurityException) {
                a.log(Level.WARNING, "There was a problem retrieving installation-id from existing files", generalSecurityException);
            }
        }
        if (object2 != null) {
            try {
                object3 = System.getProperty("user-db-uri");
                object4 = RepositoryFactory.getUserRepository(null, (String)object3, null);
                object4.setData(this.f, "installation-id", (String)object2);
                if (a.isLoggable(Level.FINEST)) {
                    a.log(Level.FINEST, "Stored installationID in database: {0}", object3);
                }
            }
            catch (Exception exception) {
                a.log(Level.WARNING, "There was a problem accessing repository to store ID", exception.getMessage());
            }
            try {
                if (!this.g.getParent().toFile().exists()) {
                    this.g.getParent().toFile().mkdirs();
                }
                Files.write(this.g, ((String)object2).getBytes(), new OpenOption[0]);
                if (a.isLoggable(Level.FINEST)) {
                    a.log(Level.FINEST, "Stored installationID in file: {0}", new Object[]{this.g.toAbsolutePath()});
                }
            }
            catch (IOException iOException) {
                a.log(Level.WARNING, "There was a problem writing ID to a file", iOException);
            }
            a.log(Level.WARNING, "Your installation-id is: {0} and it has been written to database and to the file: {1}", new Object[]{object2, this.g.toAbsolutePath()});
        } else {
            a.log(Level.WARNING, "There was a problem obtaining installation-id! Please read 'Licensing' chapter from Tigase Administration Guide for more information how to obtain installation-id");
        }
        return object2;
    }

    private static /* synthetic */ void a(List list, Licence licence) {
        list.add(licence.getLicenceDigest());
    }
}

