/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.cm.impl;

import java.io.IOException;
import org.apache.felix.cm.impl.ConfigurationAdapter;
import org.apache.felix.cm.impl.ConfigurationImpl;
import org.apache.felix.cm.impl.ConfigurationManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationPermission;

public class ConfigurationAdminImpl
implements ConfigurationAdmin {
    private ConfigurationManager configurationManager;
    private Bundle bundle;

    ConfigurationAdminImpl(ConfigurationManager configurationManager, Bundle bundle) {
        this.configurationManager = configurationManager;
        this.bundle = bundle;
    }

    void dispose() {
        this.bundle = null;
        this.configurationManager = null;
    }

    Bundle getBundle() {
        return this.bundle;
    }

    public Configuration createFactoryConfiguration(String factoryPid) throws IOException {
        this.configurationManager.log(4, "createFactoryConfiguration(factoryPid={0})", new Object[]{factoryPid});
        ConfigurationImpl config = this.configurationManager.createFactoryConfiguration(factoryPid, this.getBundle().getLocation());
        return this.wrap(config);
    }

    public Configuration createFactoryConfiguration(String factoryPid, String location) throws IOException {
        this.configurationManager.log(4, "createFactoryConfiguration(factoryPid={0}, location={1})", new Object[]{factoryPid, location});
        this.checkPermission(location == null ? "*" : location);
        ConfigurationImpl config = this.configurationManager.createFactoryConfiguration(factoryPid, location);
        return this.wrap(config);
    }

    public Configuration getConfiguration(String pid) throws IOException {
        this.configurationManager.log(4, "getConfiguration(pid={0})", new Object[]{pid});
        ConfigurationImpl config = this.configurationManager.getConfiguration(pid);
        if (config == null) {
            config = this.configurationManager.createConfiguration(pid, this.getBundle().getLocation());
        } else if (config.getBundleLocation() == null) {
            this.configurationManager.log(4, "Binding configuration {0} (isNew: {1}) to bundle {2}", new Object[]{config.getPid(), config.isNew() ? Boolean.TRUE : Boolean.FALSE, this.getBundle().getLocation()});
            config.setStaticBundleLocation(this.getBundle().getLocation());
        } else {
            this.checkPermission(config.getBundleLocation());
        }
        return this.wrap(config);
    }

    public Configuration getConfiguration(String pid, String location) throws IOException {
        this.configurationManager.log(4, "getConfiguration(pid={0}, location={1})", new Object[]{pid, location});
        this.checkPermission(location == null ? "*" : location);
        ConfigurationImpl config = this.configurationManager.getConfiguration(pid);
        if (config == null) {
            config = this.configurationManager.createConfiguration(pid, location);
        } else {
            String configLocation = config.getBundleLocation();
            this.checkPermission(configLocation == null ? "*" : configLocation);
        }
        return this.wrap(config);
    }

    public Configuration[] listConfigurations(String filter) throws IOException, InvalidSyntaxException {
        this.configurationManager.log(4, "listConfigurations(filter={0})", new Object[]{filter});
        ConfigurationImpl[] ci = this.configurationManager.listConfigurations(this, filter);
        if (ci == null || ci.length == 0) {
            return null;
        }
        Configuration[] cfgs = new Configuration[ci.length];
        for (int i = 0; i < cfgs.length; ++i) {
            cfgs[i] = this.wrap(ci[i]);
        }
        return cfgs;
    }

    private Configuration wrap(ConfigurationImpl configuration) {
        return new ConfigurationAdapter(this, configuration);
    }

    boolean hasPermission(String name) {
        try {
            this.checkPermission(name);
            return true;
        }
        catch (SecurityException se) {
            return false;
        }
    }

    void checkPermission(String name) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (name != null && !name.equals(this.getBundle().getLocation())) {
                try {
                    sm.checkPermission(new ConfigurationPermission(name, "configure"));
                    this.configurationManager.log(4, "Explicit Permission; grant CONFIGURE permission on configuration bound to {0} to bundle {1}", new Object[]{name, this.getBundle().getLocation()});
                }
                catch (SecurityException se) {
                    this.configurationManager.log(4, "No Permission; denied CONFIGURE permission on configuration bound to {0} to bundle {1}; reason: {2}", new Object[]{name, this.getBundle().getLocation(), se.getMessage()});
                    throw se;
                }
            } else if (this.configurationManager.isLogEnabled(4)) {
                this.configurationManager.log(4, "Implicit Permission; grant CONFIGURE permission on configuration bound to {0} to bundle {1}", new Object[]{name, this.getBundle().getLocation()});
            }
        } else if (this.configurationManager.isLogEnabled(4)) {
            this.configurationManager.log(4, "No SecurityManager installed; grant CONFIGURE permission on configuration bound to {0} to bundle {1}", new Object[]{name, this.getBundle().getLocation()});
        }
    }
}

