-- QUERY START:
if exists (select * from sys.columns where object_id = object_id('dbo.tig_ma_jids') and name = 'jid_fragment' and max_length > 900)
begin
	IF EXISTS (select 1 from sys.indexes WHERE object_id = object_id('dbo.tig_ma_jids') AND NAME ='tig_ma_jids_jid')
	begin
	    drop index tig_ma_jids_jid on tig_ma_jids;
	end
	alter table tig_ma_jids drop column jid_fragment;
	alter table tig_ma_jids add jid_fragment as left(jid, 255);
end
-- QUERY END:

-- QUERY START:
IF NOT EXISTS ( select 1
	from sys.indexes i
	inner join sys.index_columns ic on i.object_id = ic.object_id and i.index_id = ic.index_id
	inner join sys.columns c on ic.object_id = c.object_id and ic.column_id = c.column_id
	where
		i.object_id = object_id('dbo.tig_ma_jids') and i.name = 'tig_ma_jids_jid'
		and ic.is_included_column = 1 and c.name = 'jid')
	begin
	IF EXISTS (select 1 from sys.indexes WHERE object_id = object_id('dbo.tig_ma_jids') AND NAME ='tig_ma_jids_jid')
	begin
		drop index tig_ma_jids_jid on tig_ma_jids;
	end
	create index tig_ma_jids_jid on tig_ma_jids (jid_fragment) include (jid, jid_id);
	end
-- QUERY END:

-- QUERY START:
if not exists (select * from sys.columns where object_id = object_id('dbo.tig_ma_msgs') and name = 'jingle_sid')
    alter table [dbo].[tig_ma_msgs] add [jingle_sid] nvarchar(128) null;
-- QUERY END:
-- QUERY START:
if not exists (select * from sys.columns where object_id = object_id('dbo.tig_ma_msgs') and name = 'jingle_reason')
alter table [dbo].[tig_ma_msgs] add [jingle_reason] nvarchar(50) null;
-- QUERY END:
-- QUERY START:
if not exists (select * from sys.columns where object_id = object_id('dbo.tig_ma_msgs') and name = 'jingle_action')
alter table [dbo].[tig_ma_msgs] add [jingle_action] nvarchar(50) null;
-- QUERY END:
-- QUERY START:
if not exists (select * from sys.columns where object_id = object_id('dbo.tig_ma_msgs') and name = 'jingle_offline')
alter table [dbo].[tig_ma_msgs] add [jingle_offline] bit default 0;
-- QUERY END:

-- QUERY START:
update tig_ma_msgs set
	[jingle_sid] = cast(msg as xml).value('(iq/*:jingle/@sid)[1]','nvarchar(128)'),
	[jingle_action] = cast(msg as xml).value('(iq/*:jingle/@action)[1]','nvarchar(50)'),
	[jingle_reason] = case cast(cast(msg as xml).query('local-name((iq/*:jingle/*:reason/*)[1]) != "text"') as varchar(100))
		when 'true' then cast(msg as xml).value('local-name((iq/*:jingle/*:reason/*)[1])','nvarchar(50)')
		else cast(msg as xml).value('local-name((iq/*:jingle/*:reason/*)[2])','nvarchar(50)')
	end
where
	item_type = 'call' and jingle_sid is null and jingle_action is null and type = 'set';
-- QUERY END:

-- QUERY START:
update tig_ma_msgs set
	[jingle_offline] = case cast(msg as xml).value('(iq/*:jingle/@offline)[1]', 'varchar(100)')
		when 'true' then 1
		else 0
	end
where item_type = 'call' and jingle_offline is null;
-- QUERY END:

-- QUERY START:
update tig_ma_msgs set
	[jingle_reason] = null
where LEN(jingle_reason) = 0;
-- QUERY END:

-- QUERY START:
if not exists (select * from sys.indexes where object_id = object_id('dbo.tig_ma_msgs') and name = 'tig_ma_msgs_owner_id_buddy_id_ts')
    create index tig_ma_msgs_owner_id_buddy_id_ts on tig_ma_msgs (owner_id, buddy_id, ts);
-- QUERY END:

-- QUERY START:
if not exists (select * from sys.indexes where object_id = object_id('dbo.tig_ma_msgs') and name = 'tig_ma_msgs_owner_id_buddy_id_jingle_sid_ts')
    create index tig_ma_msgs_owner_id_buddy_id_jingle_sid_ts on tig_ma_msgs (owner_id, buddy_id, jingle_sid, ts) include (jingle_action, msg_id);
-- QUERY END:

-- QUERY START:
if not exists (select 1
	from sys.indexes i
	inner join sys.index_columns ic on i.object_id = ic.object_id and i.index_id = ic.index_id
	inner join sys.columns c on ic.object_id = c.object_id and ic.column_id = c.column_id
	where
		i.object_id = object_id('dbo.tig_ma_msgs') and i.name = 'tig_ma_msgs_owner_id_buddy_id_index'
		and ic.is_included_column = 1 and c.name = 'offline')
	begin
	IF EXISTS (select 1 from sys.indexes WHERE object_id = object_id('dbo.tig_ma_msgs') AND NAME ='tig_ma_msgs_owner_id_buddy_id_index')
	    begin
		drop index tig_ma_msgs_owner_id_buddy_id_index on tig_ma_msgs;
		end
	create index tig_ma_msgs_owner_id_buddy_id_index on tig_ma_msgs (owner_id, buddy_id) include (ts, direction, type, item_type, jingle_sid, jingle_action, jingle_reason, jingle_offline, stanza_hash, offline);
	end
-- QUERY END:
