/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.history;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.conf.ConfigurationException;
import tigase.db.RepositoryFactory;
import tigase.muc.history.DerbySqlHistoryProvider;
import tigase.muc.history.HistoryProvider;
import tigase.muc.history.MemoryHistoryProvider;
import tigase.muc.history.MySqlHistoryProvider;
import tigase.muc.history.NoneHistoryProvider;
import tigase.muc.history.PostgreSqlHistoryProvider;
import tigase.muc.history.SqlserverSqlHistoryProvider;

public class HistoryManagerFactory {
    public static final String DB_CLASS_KEY = "history-db";
    public static final String DB_URI_KEY = "history-db-uri";
    protected static final Logger log = Logger.getLogger(HistoryManagerFactory.class.getName());

    public static HistoryProvider getHistoryManager(Map<String, Object> params) throws ConfigurationException {
        try {
            String uri = (String)params.get(DB_URI_KEY);
            String cl = (String)params.get(DB_CLASS_KEY);
            if (uri == null && cl == null) {
                return null;
            }
            if (log.isLoggable(Level.CONFIG)) {
                log.config("Using History Provider; params.size: " + params.size() + "; uri: " + uri + "; cl: " + cl);
            }
            Class cls = null;
            if (cl != null) {
                if (cl.trim().equals("none")) {
                    return new NoneHistoryProvider();
                }
                if (cl.trim().equals("memory")) {
                    return new MemoryHistoryProvider();
                }
                if (cl.contains("mysql")) {
                    cls = MySqlHistoryProvider.class;
                } else if (cl.contains("derby")) {
                    cls = DerbySqlHistoryProvider.class;
                } else if (cl.contains("pgsql")) {
                    cls = PostgreSqlHistoryProvider.class;
                } else if (cl.contains("sqlserver")) {
                    cls = SqlserverSqlHistoryProvider.class;
                }
            }
            if (cls == null) {
                cls = RepositoryFactory.getRepoClass(HistoryProvider.class, (String)uri);
            }
            if (cls == null) {
                throw new ConfigurationException("Not found implementation of History Provider for " + uri);
            }
            HistoryProvider provider = (HistoryProvider)cls.newInstance();
            provider.initRepository(uri, null);
            return provider;
        }
        catch (Exception e) {
            throw new ConfigurationException("Cannot initialize History Provider", e);
        }
    }
}

