/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.ext.monitor;

import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import tigase.disteventbus.EventBus;
import tigase.disteventbus.EventHandler;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.Inject;
import tigase.monitor.MonitorComponent;
import tigase.monitor.MonitorExtension;
import tigase.xml.Element;

@Bean(name="monitor-mailer")
public class MonitorMailer
implements Initializable,
MonitorExtension {
    public static final String ID = "monitor-mailer";
    private static final String a = "remote";
    @Inject
    private MonitorComponent b;
    @Inject(nullAllowed=false)
    private EventBus c;
    private String d;
    private final EventHandler e = new EventHandler(){

        public void onEvent(String name, String xmlns, Element event) {
            MonitorMailer.this.onEvent(name, xmlns, event);
        }
    };
    protected final Logger log = Logger.getLogger(this.getClass().getName());
    private Session f;
    private String[] g;

    public EventBus getEventBus() {
        return this.c;
    }

    private String a(Map<String, Object> map, String string) {
        String string2;
        try {
            string2 = (String)map.get(string);
        }
        catch (Exception exception) {
            string2 = null;
            this.log.warning("Problem on reading property '" + string + "'");
        }
        if (string2 == null) {
            throw new RuntimeException("Property '" + string + "' is not defined!");
        }
        return string2;
    }

    public void initialize() {
    }

    protected void onEvent(String name, String xmlns, Element event) {
        if (event.getAttributeStaticStr(a) != null) {
            return;
        }
        String string = "Tigase Monitor Notification";
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Tigase Monitor generated event!\n\n");
        stringBuilder.append("hostname: ").append(this.b.getDefHostName()).append('\n');
        if ("SampleTaskEnabled".equals(name)) {
            String string2 = event.getCData(new String[]{"SampleTaskEnabled", "message"});
            string = string + " - " + string2;
            stringBuilder.append("This is notification from sample monitor task.").append('\n');
            for (Element element : event.getChildren()) {
                stringBuilder.append("    ").append(element.getName()).append(": ").append(element.getCData()).append('\n');
            }
        } else {
            stringBuilder.append("Event: ").append(name).append('\n');
            for (Element element : event.getChildren()) {
                stringBuilder.append("    ").append(element.getName()).append(": ").append(element.getCData()).append('\n');
            }
        }
        this.a(string, stringBuilder.toString());
    }

    private void a(String string, String string2) {
        try {
            this.log.fine("Sending mail: " + string2);
            MimeMessage mimeMessage = new MimeMessage(this.f);
            mimeMessage.setFrom((Address)new InternetAddress(this.d));
            for (String string3 : this.g) {
                mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)string3));
            }
            mimeMessage.setSubject(string);
            mimeMessage.setText(string2);
            Transport.send((Message)mimeMessage);
        }
        catch (Exception exception) {
            this.log.log(Level.WARNING, "Can't send mail", exception);
        }
    }

    public void setEventBus(EventBus eventBus) {
        this.c = eventBus;
    }

    public void setProperties(Map<String, Object> props) {
        this.log.config("Configuring Monitor Mailer");
        Properties properties = new Properties();
        properties.put("mail.smtp.auth", "true");
        properties.put("mail.smtp.starttls.enable", "true");
        properties.put("mail.smtp.ssl.trust", "*");
        properties.put("mail.smtps.ssl.trust", "*");
        properties.put("mail.smtp.ssl.checkserveridentity", "false");
        properties.put("mail.smtp.ssl.trust", "*");
        properties.put("mail.smtp.starttls.checkserveridentity", "false");
        properties.put("mail.smtp.starttls.trust", "*");
        try {
            properties.put("mail.smtp.host", this.a(props, "mailer-smtp-host"));
            properties.put("mail.smtp.port", this.a(props, "mailer-smtp-port"));
            final String string = this.a(props, "mailer-smtp-username");
            this.log.log(Level.CONFIG, "Setting username: {0}", string);
            final String string2 = this.a(props, "mailer-smtp-password");
            if (string2 != null && !string2.isEmpty()) {
                this.log.log(Level.CONFIG, "Setting password: {0}", string2.replaceAll(".", "*"));
            }
            this.d = this.a(props, "mailer-from-address");
            this.log.log(Level.CONFIG, "Setting fromAddress: {0}", this.d);
            this.g = this.a(props, "mailer-to-addresses").split(",");
            this.log.log(Level.CONFIG, "Setting toAddresses: {0}", this.g);
            this.f = Session.getInstance((Properties)properties, (Authenticator)new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(string, string2);
                }
            });
            this.log.log(Level.CONFIG, "Setting session: {0}", this.f);
        }
        catch (RuntimeException runtimeException) {
            this.log.warning(runtimeException.getMessage());
            this.log.warning("Mailer is not started");
            return;
        }
        this.log.config("Initializing Monitor Mailer");
        this.c.addHandler(null, "tigase:monitor:event", this.e);
    }
}

