/*
 * Decompiled with CFR 0.152.
 */
package tigase.socks5;

import java.io.IOException;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.socks5.AbstractConnectionManager;
import tigase.socks5.Socks5IOService;
import tigase.socks5.Stream;
import tigase.stats.StatisticsList;

public abstract class Socks5ConnectionManager
extends AbstractConnectionManager<Socks5IOService<?>> {
    private static final Logger log = Logger.getLogger(Socks5ConnectionManager.class.getCanonicalName());
    private static final long STREAM_CREATION_TIMEOUT = TimeUnit.MINUTES.toMillis(2L);
    private ConcurrentHashMap<String, Stream> streams = new ConcurrentHashMap();
    private AtomicLong servicesCompleted = new AtomicLong(0L);
    private AtomicLong kbytesTransferred = new AtomicLong(0L);

    public void packetsReady(Socks5IOService service) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void registerStream(String sid, Socks5IOService con) {
        Stream stream = this.streams.get(sid);
        if (stream == null) {
            stream = new Stream(sid, this);
            this.streams.put(sid, stream);
        }
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "registered connection = {0} for stream = {1}", new Object[]{con.toString(), stream.toString()});
        }
        stream.addConnection(con);
    }

    @Override
    public void serviceStarted(Socks5IOService<?> serv) {
        super.serviceStarted(serv);
        serv.setConnectionManager(this);
        this.addTimerTask(new AuthenticationTimer(serv.getUniqueId()), STREAM_CREATION_TIMEOUT);
    }

    @Override
    public boolean serviceStopped(Socks5IOService<?> serv) {
        long bytesTransferred = serv.getBytesReceived() + serv.getBytesSent();
        this.kbytesTransferred.addAndGet(bytesTransferred / 1024L);
        this.servicesCompleted.incrementAndGet();
        return super.serviceStopped(serv);
    }

    public void socketDataProcessed(Socks5IOService service) {
    }

    public void tlsHandshakeCompleted(Socks5IOService service) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void unregisterStream(Stream stream) {
        this.streams.remove(stream.getSID());
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "unregistered connections for stream = {0}", new Object[]{stream.toString()});
        }
    }

    @Override
    public void getStatistics(StatisticsList list) {
        super.getStatistics(list);
        long servicesCompleted = this.servicesCompleted.get();
        long kbytesTransferred = this.kbytesTransferred.get();
        list.add(this.getName(), "Open streams", this.streams.size(), Level.INFO);
        list.add(this.getName(), "KBytes tranferred", kbytesTransferred, Level.INFO);
        list.add(this.getName(), "Transfers completed", servicesCompleted / 2L, Level.INFO);
        if (servicesCompleted == 0L) {
            servicesCompleted = 1L;
        }
        list.add(this.getName(), "Average transfer size in KB", kbytesTransferred / servicesCompleted, Level.INFO);
    }

    public Stream getStream(String cid) {
        return this.streams.get(cid);
    }

    public boolean hasStream(String cid) {
        return this.streams.contains(cid);
    }

    @Override
    protected Socks5IOService getIOServiceInstance() throws IOException {
        return new Socks5IOService();
    }

    @Override
    protected boolean isHighThroughput() {
        return true;
    }

    private class AuthenticationTimer
    extends TimerTask {
        private final String connId;

        public AuthenticationTimer(String connId) {
            this.connId = connId;
        }

        @Override
        public void run() {
            Socks5IOService serv = (Socks5IOService)((Object)Socks5ConnectionManager.this.services.get(this.connId));
            if (serv == null) {
                return;
            }
            try {
                if (serv.getState() != Socks5IOService.State.Active) {
                    if (log.isLoggable(Level.FINER)) {
                        log.log(Level.FINER, "closing Socks5 connection not in active state with id  = {0}", serv.getUniqueId());
                    }
                    Socks5ConnectionManager.this.services.remove(serv.getUniqueId());
                    if (serv.isConnected()) {
                        serv.stop();
                    }
                }
            }
            catch (Exception ex) {
                log.log(Level.FINE, "exception while checking for if service " + serv.getUniqueId() + " timed out before activation", ex);
            }
        }
    }
}

