/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.EnumSet;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.db.TigaseDBException;
import tigase.db.UserNotFoundException;
import tigase.server.Packet;
import tigase.server.Permissions;
import tigase.sys.TigaseRuntime;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPProcessorAbstract;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.XMPPStopListenerIfc;
import tigase.xmpp.impl.annotation.DiscoFeatures;
import tigase.xmpp.impl.annotation.Handle;
import tigase.xmpp.impl.annotation.Handles;
import tigase.xmpp.impl.annotation.Id;
import tigase.xmpp.impl.roster.RosterAbstract;
import tigase.xmpp.impl.roster.RosterElement;
import tigase.xmpp.impl.roster.RosterFactory;

@Id(value="jabber:iq:last")
@DiscoFeatures(value={"jabber:iq:last"})
@Handles(value={@Handle(path={"iq", "query"}, xmlns="jabber:iq:last"), @Handle(path={"presence"}, xmlns="jabber:client"), @Handle(path={"message"}, xmlns="jabber:client")})
public class LastActivity
extends XMPPProcessorAbstract
implements XMPPStopListenerIfc {
    protected static final String XMLNS = "jabber:iq:last";
    protected static final String ID = "jabber:iq:last";
    private static final String LAST_ACTIVITY_KEY = "LAST_ACTIVITY_KEY";
    private static final String LAST_STATUS_KEY = "LAST_STATUS_KEY";
    private static final Logger log = Logger.getLogger(LastActivity.class.getName());
    private static final String PROTECTION_LEVEL_KEY = "protection-level";
    private static final String[] STATUS_PATH = new String[]{"presence", "status"};
    private static final EnumSet<RosterAbstract.SubscriptionType> inTypes = EnumSet.of(RosterAbstract.SubscriptionType.both, RosterAbstract.SubscriptionType.from);
    private static final EnumSet<RosterAbstract.SubscriptionType> outTypes = EnumSet.of(RosterAbstract.SubscriptionType.both, RosterAbstract.SubscriptionType.to);
    private ProtectionLevel protectionLevel = ProtectionLevel.ALL;

    private static long getLastActivity(NonAuthUserRepository repo, BareJID requestedJid) throws UserNotFoundException {
        String result = repo.getPublicData(requestedJid, "jabber:iq:last", LAST_ACTIVITY_KEY, "-1");
        if (result != null) {
            return Long.parseLong(result);
        }
        throw new UserNotFoundException(requestedJid + " doesn't exist");
    }

    private static long getLastActivity(XMPPResourceConnection session, boolean global) {
        Long res = null;
        res = global ? (Long)session.getCommonSessionData(LAST_ACTIVITY_KEY) : (Long)session.getSessionData(LAST_ACTIVITY_KEY);
        return res == null ? -1L : res;
    }

    private static long getLastActivity(XMPPResourceConnection session, Packet packet) {
        return LastActivity.getLastActivity(session, packet.getStanzaTo().getResource() == null || packet.getStanzaTo().getResource().length() == 0);
    }

    protected static RosterAbstract getRosterUtil() {
        return RosterFactory.getRosterImplementation(true);
    }

    private static String getStatus(NonAuthUserRepository repo, BareJID requestedJid) throws UserNotFoundException {
        return repo.getPublicData(requestedJid, "jabber:iq:last", LAST_STATUS_KEY, null);
    }

    private static Packet preventFromINFLoop(Packet packet) {
        packet.setPacketTo(null);
        return packet;
    }

    private static void setLastActivity(XMPPResourceConnection session, Long last) {
        session.putCommonSessionData(LAST_ACTIVITY_KEY, last);
        session.putSessionData(LAST_ACTIVITY_KEY, last);
    }

    private String getStatus(XMPPResourceConnection session) {
        return session.getPresence() == null ? null : session.getPresence().getChildCDataStaticStr(STATUS_PATH);
    }

    private void handleLastActivityRequest(Packet packet, long last, String status, Queue<Packet> results) throws PacketErrorTypeException {
        if (last >= 0L) {
            long result = (System.currentTimeMillis() - last) / 1000L;
            Packet resp = packet.okResult((Element)null, 0);
            Element q = status == null ? new Element("query", new String[]{"xmlns", "seconds"}, new String[]{"jabber:iq:last", "" + result}) : new Element("query", status, new String[]{"xmlns", "seconds"}, new String[]{"jabber:iq:last", "" + result});
            resp.getElement().addChild(q);
            results.offer(resp);
        } else {
            results.offer(LastActivity.preventFromINFLoop(Authorization.ITEM_NOT_FOUND.getResponseMessage(packet, "Unknown last activity time", false)));
        }
    }

    @Override
    public void init(Map<String, Object> settings) throws TigaseDBException {
        super.init(settings);
        if (settings.containsKey(PROTECTION_LEVEL_KEY)) {
            this.protectionLevel = ProtectionLevel.valueOf((String)settings.get(PROTECTION_LEVEL_KEY));
        }
    }

    @Override
    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws XMPPException {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Processing packet: {0}", packet);
        }
        if (packet.getElemName() == "iq") {
            super.process(packet, session, repo, results, settings);
        } else if (session != null && packet.getStanzaFrom() != null && session.isAuthorized() && session.getBareJID().equals(packet.getStanzaFrom().getBareJID())) {
            long time = System.currentTimeMillis();
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Updating last:activity of user " + session.getUserName() + " to " + time);
            }
            LastActivity.setLastActivity(session, time);
        }
    }

    @Override
    public void processFromUserPacket(JID connectionId, Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws PacketErrorTypeException {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Process From user packet: {0}", packet);
        }
        switch (packet.getType()) {
            case get: {
                switch (this.protectionLevel) {
                    case BUDDIES: {
                        if (LastActivity.getRosterUtil() == null) {
                            log.warning("Roster factory returned null");
                            results.offer(LastActivity.preventFromINFLoop(Authorization.SERVICE_UNAVAILABLE.getResponseMessage(packet, null, false)));
                            break;
                        }
                        try {
                            RosterElement element = LastActivity.getRosterUtil().getRosterElement(session, packet.getStanzaTo());
                            if (element == null || !outTypes.contains((Object)element.getSubscription())) {
                                results.offer(LastActivity.preventFromINFLoop(Authorization.FORBIDDEN.getResponseMessage(packet, null, false)));
                                break;
                            }
                            super.processFromUserPacket(connectionId, packet, session, repo, results, settings);
                        }
                        catch (TigaseDBException | NotAuthorizedException e) {
                            if (log.isLoggable(Level.FINE)) {
                                log.log(Level.FINE, e.getMessage(), e);
                            }
                            results.offer(LastActivity.preventFromINFLoop(Authorization.SERVICE_UNAVAILABLE.getResponseMessage(packet, null, false)));
                        }
                        break;
                    }
                    case ALL: {
                        super.processFromUserPacket(connectionId, packet, session, repo, results, settings);
                    }
                }
                break;
            }
            case error: 
            case result: {
                super.processFromUserPacket(connectionId, packet, session, repo, results, settings);
                break;
            }
            default: {
                results.offer(LastActivity.preventFromINFLoop(Authorization.BAD_REQUEST.getResponseMessage(packet, "Message type is incorrect", false)));
            }
        }
    }

    @Override
    public void processFromUserToServerPacket(JID connectionId, Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws PacketErrorTypeException {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Processing from user to server packet: {0}", packet);
        }
        packet.processedBy("jabber:iq:last");
        if (packet.getPermissions() == Permissions.ADMIN) {
            this.handleLastActivityRequest(packet, TigaseRuntime.getTigaseRuntime().getUptime(), null, results);
        } else {
            results.offer(LastActivity.preventFromINFLoop(Authorization.FORBIDDEN.getResponseMessage(packet, null, false)));
        }
    }

    @Override
    public void processNullSessionPacket(Packet packet, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws PacketErrorTypeException {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Processing null session packet: {0}", packet);
        }
        packet.processedBy("jabber:iq:last");
        switch (packet.getType()) {
            case get: {
                BareJID requestedJid = packet.getStanzaTo().getBareJID();
                try {
                    long last = LastActivity.getLastActivity(repo, requestedJid);
                    String status = LastActivity.getStatus(repo, requestedJid);
                    this.handleLastActivityRequest(packet, last, status, results);
                }
                catch (UserNotFoundException e) {
                    results.offer(LastActivity.preventFromINFLoop(Authorization.FORBIDDEN.getResponseMessage(packet, null, false)));
                }
            }
            case error: 
            case result: {
                super.processNullSessionPacket(packet, repo, results, settings);
                break;
            }
            default: {
                results.offer(LastActivity.preventFromINFLoop(Authorization.BAD_REQUEST.getResponseMessage(packet, "Message type is incorrect", false)));
            }
        }
    }

    @Override
    public void processServerSessionPacket(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws PacketErrorTypeException {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Processing server session packet: {0}", packet);
        }
        packet.processedBy("jabber:iq:last");
        this.handleLastActivityRequest(packet, TigaseRuntime.getTigaseRuntime().getUptime(), null, results);
    }

    @Override
    public void processToUserPacket(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws PacketErrorTypeException {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Processing to user packet: {0}", packet);
        }
        packet.processedBy("jabber:iq:last");
        switch (packet.getType()) {
            case get: {
                long last = LastActivity.getLastActivity(session, packet);
                String status = this.getStatus(session);
                switch (this.protectionLevel) {
                    case BUDDIES: {
                        if (LastActivity.getRosterUtil() == null) {
                            log.warning("Roster factory returned null");
                            results.offer(LastActivity.preventFromINFLoop(Authorization.SERVICE_UNAVAILABLE.getResponseMessage(packet, null, false)));
                            break;
                        }
                        try {
                            RosterElement element = LastActivity.getRosterUtil().getRosterElement(session, packet.getStanzaFrom());
                            if (element == null || !inTypes.contains((Object)element.getSubscription())) {
                                results.offer(LastActivity.preventFromINFLoop(Authorization.FORBIDDEN.getResponseMessage(packet, null, false)));
                                break;
                            }
                            this.handleLastActivityRequest(packet, last, status, results);
                        }
                        catch (TigaseDBException | NotAuthorizedException e) {
                            if (log.isLoggable(Level.FINE)) {
                                log.log(Level.FINE, e.getMessage(), e);
                            }
                            results.offer(LastActivity.preventFromINFLoop(Authorization.SERVICE_UNAVAILABLE.getResponseMessage(packet, null, false)));
                        }
                        break;
                    }
                    case ALL: {
                        this.handleLastActivityRequest(packet, last, status, results);
                    }
                }
                break;
            }
            case error: 
            case result: {
                super.processToUserPacket(packet, session, repo, results, settings);
                break;
            }
            default: {
                results.offer(LastActivity.preventFromINFLoop(Authorization.BAD_REQUEST.getResponseMessage(packet, "Message type is incorrect", false)));
            }
        }
    }

    @Override
    public void stopped(XMPPResourceConnection session, Queue<Packet> results, Map<String, Object> settings) {
        if (session != null && session.isAuthorized()) {
            long last = LastActivity.getLastActivity(session, false);
            String status = this.getStatus(session);
            try {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Persiting last:activity of user " + session.getUserName() + " in storage (value=" + last + ", status=" + status + ").");
                }
                session.setPublicData("jabber:iq:last", LAST_ACTIVITY_KEY, String.valueOf(last));
                session.setPublicData("jabber:iq:last", LAST_STATUS_KEY, status);
            }
            catch (NotAuthorizedException e) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("session isn't authorized" + session);
                }
            }
            catch (TigaseDBException e) {
                log.warning("Tigase Db Exception");
            }
        }
    }

    static enum ProtectionLevel {
        ALL,
        BUDDIES;

    }
}

