/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.Queue;
import java.util.logging.Level;
import tigase.db.NonAuthUserRepository;
import tigase.server.Packet;
import tigase.stats.CounterValue;
import tigase.stats.StatisticsList;
import tigase.xmpp.Authorization;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPPacketFilterIfc;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.annotation.AnnotatedXMPPProcessor;
import tigase.xmpp.impl.annotation.HandleStanzaTypes;
import tigase.xmpp.impl.annotation.Id;

@Id(value="error-counter")
@HandleStanzaTypes(value={StanzaType.error})
public class ErrorCounter
extends AnnotatedXMPPProcessor
implements XMPPPacketFilterIfc {
    private static final String SM_COMP = "sess-man";
    private final ErrorStatisticsHolder holder = new ErrorStatisticsHolder();

    @Override
    public void getStatistics(StatisticsList list) {
        super.getStatistics(list);
        this.holder.getStatistics(list);
    }

    @Override
    public String[][] supElementNamePaths() {
        return ALL_PATHS;
    }

    @Override
    public void filter(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results) {
        for (Packet r : results) {
            this.process(r, session);
        }
    }

    protected void process(Packet packet, XMPPResourceConnection session) {
        if (super.canHandle(packet, session) == Authorization.AUTHORIZED) {
            this.holder.count(packet);
        }
    }

    public static class ErrorStatisticsHolder {
        private static final String[] ERROR_NAMES;
        private final CounterValue[] counters = new CounterValue[ERROR_NAMES.length];

        public static String[] getErrorNames() {
            return ERROR_NAMES;
        }

        public ErrorStatisticsHolder() {
            for (int i = 0; i < ERROR_NAMES.length; ++i) {
                this.counters[i] = new CounterValue(ERROR_NAMES[i], Level.FINER);
            }
        }

        public void count(Packet packet) {
            String condition = packet.getErrorCondition();
            Authorization val = Authorization.getByCondition(condition);
            if (val != null) {
                this.counters[val.ordinal()].inc();
            } else {
                this.counters[this.counters.length - 1].inc();
            }
        }

        public void getStatistics(StatisticsList list) {
            for (CounterValue c : this.counters) {
                list.add(ErrorCounter.SM_COMP, "ErrorStats/" + c.getName() + "ErrorsNumber", c.getValue(), c.getLevel());
            }
        }

        static {
            int counters = Authorization.values().length + 1;
            ERROR_NAMES = new String[counters];
            Authorization[] vals = Authorization.values();
            for (int i = 0; i < vals.length; ++i) {
                String name = vals[i].getCondition();
                if (name == null) {
                    name = vals[i].name().toLowerCase();
                }
                StringBuilder sb = new StringBuilder();
                sb.append(vals[i].getErrorCode());
                for (String part : name.split("-")) {
                    sb.append(Character.toUpperCase(part.charAt(0)));
                    sb.append(part.substring(1));
                }
                ErrorStatisticsHolder.ERROR_NAMES[i] = sb.toString();
            }
            ErrorStatisticsHolder.ERROR_NAMES[vals.length] = "0Unknown";
        }
    }
}

