/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.AuthRepository;
import tigase.db.AuthorizationException;
import tigase.db.TigaseDBException;
import tigase.db.UserRepository;
import tigase.server.Presence;
import tigase.server.xmppsession.SessionManagerHandler;
import tigase.util.TigaseStringprepException;
import tigase.vhosts.VHostItem;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;
import tigase.xmpp.NoConnectionIdException;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.RepositoryAccess;
import tigase.xmpp.XMPPSession;

public class XMPPResourceConnection
extends RepositoryAccess {
    public static final String ALL_RESOURCES_CAPS_KEY = "caps";
    public static final String ALL_RESOURCES_KEY = "all-resources";
    public static final String ALL_RESOURCES_PRIORITY_KEY = "priority";
    public static final String AUTHENTICATION_TIMEOUT_KEY = "authentication-timeout";
    public static final String CLOSING_KEY = "closing-conn";
    public static final String ERROR_KEY = "error-key";
    public static final String PRESENCE_KEY = "user-presence";
    private static final Logger log = Logger.getLogger(XMPPResourceConnection.class.getName());
    private long authenticationTime = 0L;
    private JID connectionId = null;
    private String connectionState = null;
    private long creationTime = 0L;
    private String defLang = "en";
    private long id_counter = 0L;
    private long lastAccessed = 0L;
    private SessionManagerHandler loginHandler = null;
    private long packets_counter = 0L;
    private XMPPSession parentSession = null;
    private int priority = 0;
    private String resource = null;
    private Map<String, Object> sessionData = null;
    private String sessionId = null;
    private boolean tmpSession = false;
    private JID userJid = null;

    public XMPPResourceConnection(JID connectionId, UserRepository rep, AuthRepository authRepo, SessionManagerHandler loginHandler) {
        super(rep, authRepo);
        long currTime = System.currentTimeMillis();
        this.connectionId = connectionId;
        this.loginHandler = loginHandler;
        this.creationTime = currTime;
        this.lastAccessed = currTime;
        this.sessionData = new ConcurrentHashMap<String, Object>(4, 0.9f);
    }

    public void authorizeJID(BareJID jid, boolean anonymous) throws TigaseStringprepException {
        this.authState = Authorization.AUTHORIZED;
        this.is_anonymous = anonymous;
        if (jid != null && this.getDomain().getVhost() != null && !jid.getDomain().equals(this.getDomain().getVhost().getDomain())) {
            this.loginHandler.handleDomainChange(jid.getDomain(), this);
        }
        this.loginHandler.handleLogin(jid, this);
        this.login();
    }

    public Object computeCommonSessionDataIfAbsent(String key, Function<String, Object> valueFactory) {
        if (this.parentSession != null) {
            return this.parentSession.computeCommonSessionDataIfAbsent(key, valueFactory);
        }
        return valueFactory.apply(key);
    }

    public Object computeSessionDataIfAbsent(String key, Function<String, Object> valueFactory) {
        this.setLastAccessed(System.currentTimeMillis());
        return this.sessionData.computeIfAbsent(key, valueFactory);
    }

    public final JID getjid() {
        return this.userJid;
    }

    public void incPacketsCounter() {
        ++this.packets_counter;
    }

    @Deprecated
    public final Authorization loginDigest(String user, String digest, String id, String alg) throws NotAuthorizedException, AuthorizationException, TigaseDBException, TigaseStringprepException {
        BareJID userId = BareJID.bareJIDInstance(user, this.getDomain().getVhost().getDomain());
        Authorization result = super.loginDigest(userId, digest, id, alg);
        if (result == Authorization.AUTHORIZED) {
            this.loginHandler.handleLogin(userId, this);
        }
        return result;
    }

    @Override
    @Deprecated
    public final Authorization loginOther(Map<String, Object> props) throws NotAuthorizedException, AuthorizationException, TigaseDBException {
        Authorization result = super.loginOther(props);
        if (result == Authorization.AUTHORIZED) {
            BareJID user = (BareJID)props.get("user-id");
            if (log.isLoggable(Level.FINEST)) {
                log.finest("UserAuthRepository.USER_ID_KEY: " + user);
            }
            this.loginHandler.handleLogin(user, this);
        }
        return result;
    }

    @Deprecated
    public final Authorization loginPlain(String user, String password) throws NotAuthorizedException, AuthorizationException, TigaseDBException, TigaseStringprepException {
        BareJID userId = BareJID.bareJIDInstance(user, this.getDomain().getVhost().getDomain());
        Authorization result = super.loginPlain(userId, password);
        if (result == Authorization.AUTHORIZED) {
            this.loginHandler.handleLogin(userId, this);
        }
        return result;
    }

    @Override
    public final void logout() throws NotAuthorizedException {
        this.loginHandler.handleLogout(this.getBareJID(), this);
        this.streamClosed();
        super.logout();
    }

    public String nextStanzaId() {
        return "tig" + ++this.id_counter;
    }

    public void putCommonSessionData(String key, Object value) {
        if (this.parentSession != null) {
            this.parentSession.putCommonSessionData(key, value);
        }
    }

    public Object putCommonSessionDataIfAbsent(String key, Object value) {
        if (this.parentSession != null) {
            return this.parentSession.putCommonSessionDataIfAbsent(key, value);
        }
        return null;
    }

    public final void putSessionData(String key, Object value) {
        this.setLastAccessed(System.currentTimeMillis());
        this.sessionData.put(key, value);
    }

    public Object putSessionDataIfAbsent(String key, Object value) {
        this.setLastAccessed(System.currentTimeMillis());
        return this.sessionData.putIfAbsent(key, value);
    }

    @Override
    public void queryAuth(Map<String, Object> authProps) throws TigaseDBException {
        super.queryAuth(authProps);
    }

    public Object removeCommonSessionData(String key) {
        return this.parentSession == null ? null : this.parentSession.removeCommonSessionData(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeParentSession(XMPPSession parent) {
        XMPPResourceConnection xMPPResourceConnection = this;
        synchronized (xMPPResourceConnection) {
            this.parentSession = null;
        }
    }

    public final void removeSessionData(String key) {
        this.setLastAccessed(System.currentTimeMillis());
        this.sessionData.remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void streamClosed() {
        XMPPResourceConnection xMPPResourceConnection = this;
        synchronized (xMPPResourceConnection) {
            if (this.parentSession != null) {
                this.parentSession.streamClosed(this);
                this.parentSession = null;
            }
        }
        this.resource = null;
        this.sessionId = null;
    }

    public String toString() {
        return "XMPPResourceConnection=[user_jid=" + this.userJid + ", packets=" + this.packets_counter + ", connectioId=" + this.connectionId + ", domain=" + this.domain.getVhost().getDomain() + ", authState=" + this.getAuthState().name() + ", isAnon=" + this.isAnonymous() + ", isTmp=" + this.isTmpSession() + ", parentSession hash=" + System.identityHashCode(this.parentSession) + ", parentSession liveTime=" + (this.parentSession != null ? Long.valueOf(this.parentSession.getLiveTime()) : "") + "]";
    }

    @Override
    public Authorization unregister(String name_param) throws NotAuthorizedException, TigaseDBException, TigaseStringprepException {
        Authorization auth_res = super.unregister(name_param);
        return auth_res;
    }

    public List<XMPPResourceConnection> getActiveSessions() throws NotAuthorizedException {
        if (!this.isAuthorized()) {
            throw new NotAuthorizedException("Session has not been yet authorised.");
        }
        return this.parentSession.getActiveResources();
    }

    public JID[] getAllResourcesJIDs() {
        return this.parentSession == null ? null : this.parentSession.getJIDs();
    }

    public AuthRepository getAuthRepository() {
        return this.authRepo;
    }

    public long getAuthTime() {
        return this.authenticationTime - this.creationTime;
    }

    @Override
    public final BareJID getBareJID() throws NotAuthorizedException {
        if (!this.isAuthorized()) {
            throw new NotAuthorizedException("Session has not been yet authorised.");
        }
        return this.userJid.getBareJID();
    }

    public Object getCommonSessionData(String key) {
        return this.parentSession == null ? null : this.parentSession.getCommonSessionData(key);
    }

    public JID getConnectionId() throws NoConnectionIdException {
        return this.getConnectionId(true);
    }

    public JID getConnectionId(boolean updateLastAccessed) throws NoConnectionIdException {
        if (updateLastAccessed) {
            this.setLastAccessed(System.currentTimeMillis());
        }
        if (this.connectionId == null) {
            throw new NoConnectionIdException("Connection ID not set for this session. This is probably the SM session to handle traffic addressed to the server itself. Or maybe it's a bug.");
        }
        return this.connectionId;
    }

    public JID getConnectionId(JID jid) throws NoConnectionIdException {
        JID result = null;
        if (jid != null) {
            if (jid.getResource() != null && this.parentSession != null) {
                XMPPResourceConnection conn = this.parentSession.getResourceForResource(jid.getResource());
                if (conn == null) {
                    throw new NoConnectionIdException("No connection available for given resource.");
                }
                result = conn.getConnectionId();
            } else if (jid.getResource() == null || jid.getResource().equals(this.resource)) {
                result = this.connectionId;
            }
        } else {
            result = this.connectionId;
        }
        return result;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public String getDefLang() {
        return this.defLang;
    }

    public final JID getJID() throws NotAuthorizedException {
        if (!this.isAuthorized()) {
            throw new NotAuthorizedException("Session has not been yet authorised.");
        }
        return this.userJid;
    }

    public long getLastAccessed() {
        return this.lastAccessed;
    }

    public long getPacketsCounter() {
        return this.packets_counter;
    }

    public XMPPSession getParentSession() {
        return this.parentSession;
    }

    public Element getPresence() {
        return (Element)this.getSessionData(PRESENCE_KEY);
    }

    public int getPriority() {
        return this.priority;
    }

    public String getResource() {
        return this.resource;
    }

    public final Object getSessionData(String key) {
        this.setLastAccessed(System.currentTimeMillis());
        return this.sessionData.get(key);
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public JID getSMComponentId() {
        return this.loginHandler.getComponentId();
    }

    @Deprecated
    public BareJID getUserId() throws NotAuthorizedException {
        return this.getBareJID();
    }

    @Override
    public final String getUserName() throws NotAuthorizedException {
        if (!this.isAuthorized()) {
            throw new NotAuthorizedException("Session has not been yet authorised.");
        }
        return this.parentSession.getUserName();
    }

    @Override
    public boolean isAuthorized() {
        return super.isAuthorized() && this.parentSession != null;
    }

    public boolean isLocalDomain(String outDomain, boolean includeComponents) {
        return this.loginHandler.isLocalDomain(outDomain, includeComponents);
    }

    public boolean isResourceSet() {
        return this.resource != null;
    }

    public boolean isServerSession() {
        return false;
    }

    public boolean isTmpSession() {
        return this.tmpSession;
    }

    public boolean isUserId(BareJID bareJID) throws NotAuthorizedException {
        if (!this.isAuthorized()) {
            throw new NotAuthorizedException("Session has not been yet authorised.");
        }
        return this.userJid.getBareJID().equals(bareJID);
    }

    public void setConnectionId(JID connectionId) {
        this.connectionId = connectionId;
    }

    public void setDefLang(String lang) {
        this.defLang = lang;
    }

    public void setLastAccessed(long argLastAccessed) {
        this.lastAccessed = argLastAccessed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParentSession(XMPPSession parent) throws TigaseStringprepException {
        XMPPResourceConnection xMPPResourceConnection = this;
        synchronized (xMPPResourceConnection) {
            if (parent != null) {
                this.userJid = JID.jidInstance(parent.getUserName(), this.domain.getVhost().getDomain(), this.resource != null ? this.resource : this.sessionId);
            }
            this.parentSession = parent;
        }
    }

    public void setPresence(Element packet) {
        this.putSessionData(PRESENCE_KEY, packet);
        String pr_str = packet.getCDataStaticStr(Presence.PRESENCE_PRIORITY_PATH);
        if (pr_str != null) {
            int pr = 1;
            try {
                pr = Integer.decode(pr_str);
            }
            catch (NumberFormatException e) {
                if (log.isLoggable(Level.FINER)) {
                    log.finer("Incorrect priority value: " + pr_str + ", setting 1 as default.");
                }
                pr = 1;
            }
            this.setPriority(pr);
        } else {
            if (this.getPriority() != 0 && !"unavailable".equals(packet.getAttributeStaticStr("type"))) {
                packet.addChild(new Element(ALL_RESOURCES_PRIORITY_KEY, String.valueOf(this.getPriority())));
            }
            this.putSessionData(PRESENCE_KEY, packet);
        }
        this.loginHandler.handlePresenceSet(this);
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public void setResource(String argResource) throws NotAuthorizedException, TigaseStringprepException {
        if (!this.isAuthorized()) {
            throw new NotAuthorizedException("Session has not been yet authorised.");
        }
        this.resource = argResource;
        if (this.parentSession != null) {
            this.parentSession.addResourceConnection(this);
        }
        this.userJid = this.userJid.copyWithResource(this.resource == null ? this.sessionId : this.resource);
        this.loginHandler.handleResourceBind(this);
    }

    public void setSessionId(String argSessionId) {
        this.sessionId = argSessionId;
    }

    public void setTmpSession(boolean tmp) {
        this.tmpSession = tmp;
    }

    @Override
    protected void login() {
        this.authenticationTime = System.currentTimeMillis();
    }

    public boolean isEncrypted() {
        String tls = (String)this.getSessionData("starttls");
        return tls != null && "true".equals(tls);
    }

    public boolean isTlsRequired() {
        VHostItem vhost = this.getDomain();
        try {
            if (null != this.getSessionData("SSL") && ((Boolean)this.getSessionData("SSL")).booleanValue()) {
                return false;
            }
            if ("c2s".equals(this.getConnectionId().getLocalpart())) {
                return vhost.isTlsRequired();
            }
            return false;
        }
        catch (NoConnectionIdException e) {
            log.log(Level.WARNING, "Can't check sessionId", e);
            return vhost.isTlsRequired();
        }
    }
}

