/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.ssender;

import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.server.ssender.SenderTask;
import tigase.server.ssender.StanzaHandler;

public class FileTask
extends SenderTask {
    private static final Logger log = Logger.getLogger("tigase.server.ssender.FileTask");
    private StanzaHandler handler = null;
    private String init_str = null;
    private String file_mask = null;
    private String directory = null;

    @Override
    public void init(StanzaHandler handler, String initString) throws IOException {
        this.handler = handler;
        this.init_str = initString;
        if (this.init_str.endsWith(File.separator)) {
            this.file_mask = "";
            this.directory = this.init_str;
        } else {
            int idx = this.init_str.lastIndexOf(File.separator);
            this.directory = this.init_str.substring(0, idx);
            this.file_mask = this.init_str.substring(idx + 1, this.init_str.length());
        }
        log.config("file_mask='" + this.file_mask + "', directory='" + this.directory + "'");
    }

    @Override
    public String getInitString() {
        return this.init_str;
    }

    private String readFile(File ffile) throws IOException {
        StringBuilder result = new StringBuilder();
        char[] buff = new char[16384];
        FileReader fr = new FileReader(ffile);
        int res = fr.read(buff);
        while (res > 0) {
            result.append(buff, 0, res);
            res = fr.read(buff);
        }
        fr.close();
        return result.toString();
    }

    @Override
    public void run() {
        try {
            File fdir = new File(this.directory);
            String[] files = fdir.list(new MaskFilter(this.file_mask));
            if (files != null) {
                for (String file : files) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("Processing file: " + file);
                    }
                    File ffile = new File(fdir, file);
                    String stanza = this.readFile(ffile);
                    this.handler.handleStanza(stanza);
                    ffile.delete();
                }
            }
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Error retrieving stanzas from database: ", e);
        }
    }

    private static class MaskFilter
    implements FilenameFilter {
        private String mask = null;

        private MaskFilter(String mask) {
            this.mask = mask.startsWith("*") ? mask.substring(1) : mask;
        }

        @Override
        public boolean accept(File file, String name) {
            return name.endsWith(this.mask);
        }
    }
}

