/*
 * Decompiled with CFR 0.152.
 */
package tigase.server;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import tigase.server.Command;
import tigase.xml.Element;
import tigase.xml.XMLUtils;

public class DataForm {
    public static final String FIELD_EL = "field";
    public static final String VALUE_EL = "value";
    protected static final String[] FIELD_VALUE_PATH = new String[]{"field", "value"};
    private static final Logger log = Logger.getLogger(DataForm.class.getName());

    public static void addCheckBoxField(Element el, String f_name, boolean f_value) {
        DataForm.addFieldValue(el, f_name, Boolean.toString(f_value), "boolean");
    }

    public static Element addDataForm(Element el, Command.DataType data_type) {
        Element x = new Element("x", new String[]{"xmlns", "type"}, new String[]{"jabber:x:data", data_type.name()});
        el.addChild(x);
        return x;
    }

    public static void addFieldMultiValue(Element el, String f_name, List<String> f_value) {
        Element x = el.getChild("x", "jabber:x:data");
        if (x == null) {
            x = DataForm.addDataForm(el, Command.DataType.result);
        }
        if (f_value != null) {
            Element field = new Element(FIELD_EL, new String[]{"var", "type"}, new String[]{XMLUtils.escape(f_name), "text-multi"});
            for (String val : f_value) {
                if (val == null) continue;
                Element value = new Element(VALUE_EL, XMLUtils.escape(val));
                field.addChild(value);
            }
            x.addChild(field);
        }
    }

    public static void addFieldMultiValue(Element el, String f_name, Throwable ex) {
        Element x = el.getChild("x", "jabber:x:data");
        if (x == null) {
            x = DataForm.addDataForm(el, Command.DataType.submit);
        }
        ArrayList<String> f_value = null;
        if (ex != null) {
            f_value = new ArrayList<String>(100);
            f_value.add(ex.getLocalizedMessage());
            for (StackTraceElement ste : ex.getStackTrace()) {
                f_value.add("  " + ste.toString());
            }
        }
        if (f_value != null) {
            Element field = new Element(FIELD_EL, new String[]{"var", "type"}, new String[]{XMLUtils.escape(f_name), "text-multi"});
            for (String val : f_value) {
                if (val == null) continue;
                Element value = new Element(VALUE_EL, XMLUtils.escape(val));
                field.addChild(value);
            }
            x.addChild(field);
        }
    }

    public static void addField(Element el, String f_name, String f_label, String type) {
        Element x = el.getChild("x", "jabber:x:data");
        if (x == null) {
            x = DataForm.addDataForm(el, Command.DataType.submit);
        }
        Element field = new Element(FIELD_EL, new String[]{"var", "type", "label"}, new String[]{XMLUtils.escape(f_name), type, f_label});
        x.addChild(field);
    }

    public static void addFieldValue(Element el, String f_name, String f_value) {
        Element x = el.getChild("x", "jabber:x:data");
        if (x == null) {
            x = DataForm.addDataForm(el, Command.DataType.submit);
        }
        Element field = new Element(FIELD_EL, new Element[]{new Element(VALUE_EL, XMLUtils.escape(f_value))}, new String[]{"var"}, new String[]{XMLUtils.escape(f_name)});
        x.addChild(field);
    }

    public static void addFieldValue(Element el, String f_name, String f_value, String label, String[] labels, String[] options) {
        Element x = el.getChild("x", "jabber:x:data");
        if (x == null) {
            x = DataForm.addDataForm(el, Command.DataType.submit);
        }
        Element field = new Element(FIELD_EL, new Element[]{new Element(VALUE_EL, XMLUtils.escape(f_value))}, new String[]{"var", "type", "label"}, new String[]{XMLUtils.escape(f_name), "list-single", XMLUtils.escape(label)});
        for (int i = 0; i < labels.length; ++i) {
            field.addChild(new Element("option", new Element[]{new Element(VALUE_EL, XMLUtils.escape(options[i]))}, new String[]{"label"}, new String[]{XMLUtils.escape(labels[i])}));
        }
        x.addChild(field);
    }

    public static void addFieldValue(Element el, String f_name, String[] f_values, String label, String[] labels, String[] options) {
        int i;
        Element x = el.getChild("x", "jabber:x:data");
        if (x == null) {
            x = DataForm.addDataForm(el, Command.DataType.submit);
        }
        Element field = new Element(FIELD_EL, new String[]{"var", "type", "label"}, new String[]{XMLUtils.escape(f_name), "list-multi", XMLUtils.escape(label)});
        for (i = 0; i < labels.length; ++i) {
            field.addChild(new Element("option", new Element[]{new Element(VALUE_EL, XMLUtils.escape(options[i]))}, new String[]{"label"}, new String[]{XMLUtils.escape(labels[i])}));
        }
        for (i = 0; i < f_values.length; ++i) {
            field.addChild(new Element(VALUE_EL, XMLUtils.escape(f_values[i])));
        }
        x.addChild(field);
    }

    public static void addFieldValue(Element el, String f_name, String f_value, String label, String[] labels, String[] options, String type) {
        Element x = el.getChild("x", "jabber:x:data");
        if (x == null) {
            x = DataForm.addDataForm(el, Command.DataType.submit);
        }
        Element field = new Element(FIELD_EL, new Element[]{new Element(VALUE_EL, XMLUtils.escape(f_value))}, new String[]{"var", "type", "label"}, new String[]{XMLUtils.escape(f_name), type, XMLUtils.escape(label)});
        for (int i = 0; i < labels.length; ++i) {
            field.addChild(new Element("option", new Element[]{new Element(VALUE_EL, XMLUtils.escape(options[i]))}, new String[]{"label"}, new String[]{XMLUtils.escape(labels[i])}));
        }
        x.addChild(field);
    }

    public static void addFieldValue(Element el, String f_name, String f_value, String type) {
        Element x = el.getChild("x", "jabber:x:data");
        if (x == null) {
            x = DataForm.addDataForm(el, Command.DataType.submit);
        }
        Element field = new Element(FIELD_EL, new Element[]{new Element(VALUE_EL, XMLUtils.escape(f_value))}, new String[]{"var", "type"}, new String[]{XMLUtils.escape(f_name), type});
        x.addChild(field);
    }

    public static void addFieldValue(Element el, String f_name, String f_value, String type, String label) {
        Element x = el.getChild("x", "jabber:x:data");
        if (x == null) {
            x = DataForm.addDataForm(el, Command.DataType.submit);
        }
        Element field = new Element(FIELD_EL, new Element[]{new Element(VALUE_EL, XMLUtils.escape(f_value))}, new String[]{"var", "type", "label"}, new String[]{XMLUtils.escape(f_name), type, XMLUtils.escape(label)});
        x.addChild(field);
    }

    public static void addHiddenField(Element el, String f_name, String f_value) {
        DataForm.addFieldValue(el, f_name, f_value, "hidden");
    }

    public static void addInstructions(Element el, String instructions) {
        Element x = el.getChild("x", "jabber:x:data");
        if (x == null) {
            x = DataForm.addDataForm(el, Command.DataType.submit);
        }
        x.addChild(new Element("instructions", instructions));
    }

    public static void addTextField(Element el, String f_name, String f_value) {
        DataForm.addFieldValue(el, f_name, f_value, "fixed");
    }

    public static void addTitle(Element el, String title) {
        Element x = el.getChild("x", "jabber:x:data");
        if (x == null) {
            x = DataForm.addDataForm(el, Command.DataType.submit);
        }
        x.addChild(new Element("title", title));
    }

    public static String getFieldValue(Element el, String f_name) {
        List<Element> children;
        Element x = el.getChild("x", "jabber:x:data");
        if (x != null && (children = x.getChildren()) != null) {
            for (Element child : children) {
                String value;
                if (!child.getName().equals(FIELD_EL) || !child.getAttributeStaticStr("var").equals(f_name) || (value = child.getChildCDataStaticStr(FIELD_VALUE_PATH)) == null) continue;
                return XMLUtils.unescape(value);
            }
        }
        return null;
    }

    public static String[] getFieldValues(Element el, String f_name) {
        List<Element> children;
        Element x = el.getChild("x", "jabber:x:data");
        if (x != null && (children = x.getChildren()) != null) {
            for (Element child : children) {
                if (!child.getName().equals(FIELD_EL) || !child.getAttributeStaticStr("var").equals(f_name)) continue;
                LinkedList<String> values = new LinkedList<String>();
                List<Element> val_children = child.getChildren();
                if (val_children != null) {
                    for (Element val_child : val_children) {
                        String value;
                        if (!val_child.getName().equals(VALUE_EL) || (value = val_child.getCData()) == null) continue;
                        values.add(XMLUtils.unescape(value));
                    }
                }
                return values.toArray(new String[0]);
            }
        }
        return null;
    }

    public static boolean removeFieldValue(Element el, String f_name) {
        List<Element> children;
        Element x = el.getChild("x", "jabber:x:data");
        if (x != null && (children = x.getChildren()) != null) {
            for (Element child : children) {
                if (!child.getName().equals(FIELD_EL) || !child.getAttributeStaticStr("var").equals(f_name)) continue;
                return x.removeChild(child);
            }
        }
        return false;
    }

    public static String getFieldKeyStartingWith(Element el, String f_name) {
        List<Element> children;
        Element x = el.getChild("x", "jabber:x:data");
        if (x != null && (children = x.getChildren()) != null) {
            for (Element child : children) {
                if (!child.getName().equals(FIELD_EL) || !child.getAttributeStaticStr("var").startsWith(f_name)) continue;
                return child.getAttributeStaticStr("var");
            }
        }
        return null;
    }
}

