/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.repository.derby;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.logging.Logger;

public class StoredProcedures {
    private static final Logger log = Logger.getLogger(tigase.db.derby.StoredProcedures.class.getName());

    public static Long tigPubSubEnsureServiceJid(String serviceJid) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = conn.prepareStatement("select service_id from tig_pubsub_service_jids where service_jid = ?");
            ps.setString(1, serviceJid);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                Long l = rs.getLong(1);
                return l;
            }
            ps = conn.prepareStatement("insert into tig_pubsub_service_jids (service_jid) values (?)", 1);
            ps.setString(1, serviceJid);
            ps.executeUpdate();
            rs = ps.getGeneratedKeys();
            if (rs.next()) {
                Long l = rs.getLong(1);
                return l;
            }
            Long l = null;
            return l;
        }
    }

    public static Long tigPubSubEnsureJid(String jid) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = conn.prepareStatement("select jid_id from tig_pubsub_jids where jid = ?");
            ps.setString(1, jid);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                Long l = rs.getLong(1);
                return l;
            }
            ps = conn.prepareStatement("insert into tig_pubsub_jids (jid) values (?)", 1);
            ps.setString(1, jid);
            ps.executeUpdate();
            rs = ps.getGeneratedKeys();
            if (rs.next()) {
                Long l = rs.getLong(1);
                return l;
            }
            Long l = null;
            return l;
        }
    }

    public static void tigPubSubCreateNode(String serviceJid, String nodeName, Integer nodeType, String nodeCreator, String nodeConf, Long collectionId, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            long serviceJidId = StoredProcedures.tigPubSubEnsureServiceJid(serviceJid);
            long nodeCreatorId = StoredProcedures.tigPubSubEnsureJid(nodeCreator);
            PreparedStatement ps = conn.prepareStatement("insert into tig_pubsub_nodes (service_id,name,type,creator_id,creation_date,configuration,collection_id) values (?, ?, ?, ?, ?, ?, ?)", 1);
            ps.setLong(1, serviceJidId);
            ps.setString(2, nodeName);
            ps.setInt(3, nodeType);
            ps.setLong(4, nodeCreatorId);
            ps.setTimestamp(5, new Timestamp(System.currentTimeMillis()));
            ps.setString(6, nodeConf);
            if (collectionId == null) {
                ps.setNull(7, -5);
            } else {
                ps.setLong(7, collectionId);
            }
            ps.executeUpdate();
            data[0] = ps.getGeneratedKeys();
        }
    }

    public static void tigPubSubRemoveNode(Long nodeId, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = conn.prepareStatement("delete from tig_pubsub_items where node_id = ?");
            ps.setLong(1, nodeId);
            ps.executeUpdate();
            ps = conn.prepareStatement("delete from tig_pubsub_subscriptions where node_id = ?");
            ps.setLong(1, nodeId);
            ps.executeUpdate();
            ps = conn.prepareStatement("delete from tig_pubsub_affiliations where node_id = ?");
            ps.setLong(1, nodeId);
            ps.executeUpdate();
            ps = conn.prepareStatement("delete from tig_pubsub_nodes where node_id = ?");
            ps.setLong(1, nodeId);
            ps.executeUpdate();
        }
    }

    public static void tigPubSubGetItem(Long nodeId, String itemId, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = conn.prepareStatement("select data, p.jid, creation_date, update_date from tig_pubsub_items pi inner join tig_pubsub_jids p on p.jid_id = pi.publisher_id where node_id = ? and id = ?");
            ps.setLong(1, nodeId);
            ps.setString(2, itemId);
            data[0] = ps.executeQuery();
        }
    }

    public static void tigPubSubWriteItem(Long nodeId, String itemId, String publisher, String itemData, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = conn.prepareStatement("select 1 from tig_pubsub_items where node_id = ? and id = ?");
            ps.setLong(1, nodeId);
            ps.setString(2, itemId);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                ps = conn.prepareStatement("update tig_pubsub_items set update_date = ?, data = ? where node_id = ? and id = ?;");
                ps.setTimestamp(1, new Timestamp(System.currentTimeMillis()));
                ps.setString(2, itemData);
                ps.setLong(3, nodeId);
                ps.setString(4, itemId);
                ps.executeUpdate();
            } else {
                long publisherId = StoredProcedures.tigPubSubEnsureJid(publisher);
                ps = conn.prepareStatement("insert into tig_pubsub_items (node_id, id, creation_date, update_date, publisher_id, data) values (?, ?, ?, ?, ?, ?)");
                ps.setLong(1, nodeId);
                ps.setString(2, itemId);
                Timestamp ts = new Timestamp(System.currentTimeMillis());
                ps.setTimestamp(3, ts);
                ps.setTimestamp(4, ts);
                ps.setLong(5, publisherId);
                ps.setString(6, itemData);
                ps.executeUpdate();
            }
        }
    }

    public static void tigPubSubDeleteItem(Long nodeId, String itemId, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = conn.prepareStatement("delete from tig_pubsub_items where node_id = ? and id = ?");
            ps.setLong(1, nodeId);
            ps.setString(2, itemId);
            ps.executeUpdate();
        }
    }

    public static void tigPubSubGetNodeId(String serviceJid, String nodeName, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = conn.prepareStatement("select n.node_id from tig_pubsub_nodes n inner join tig_pubsub_service_jids sj on n.service_id = sj.service_id where sj.service_jid = ? and n.name = ?");
            ps.setString(1, serviceJid);
            ps.setString(2, nodeName);
            data[0] = ps.executeQuery();
        }
    }

    public static void tigPubSubGetNodeMeta(String serviceJid, String nodeName, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = conn.prepareStatement("select n.node_id, n.configuration, cj.jid, n.creation_date from tig_pubsub_nodes n inner join tig_pubsub_service_jids sj on n.service_id = sj.service_id inner join tig_pubsub_jids cj on cj.jid_id = n.creator_id where sj.service_jid = ? and n.name = ?");
            ps.setString(1, serviceJid);
            ps.setString(2, nodeName);
            data[0] = ps.executeQuery();
        }
    }

    public static void tigPubSubGetNodeItemIds(Long nodeId, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = conn.prepareStatement("select id from tig_pubsub_items where node_id = ? order by creation_date");
            ps.setLong(1, nodeId);
            data[0] = ps.executeQuery();
        }
    }

    public static void tigPubSubGetNodeItemIdsSince(Long nodeId, Timestamp since, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = conn.prepareStatement("select id from tig_pubsub_items where node_id = ? and creation_date >= ? order by creation_date");
            ps.setLong(1, nodeId);
            ps.setTimestamp(2, since);
            data[0] = ps.executeQuery();
        }
    }

    public static void tigPubSubGetAllNodes(String serviceJid, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = conn.prepareStatement("select n.name, n.node_id from tig_pubsub_nodes n inner join tig_pubsub_service_jids sj on n.service_id = sj.service_id where sj.service_jid = ?");
            ps.setString(1, serviceJid);
            data[0] = ps.executeQuery();
        }
    }

    public static void tigPubSubGetRootNodes(String serviceJid, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = conn.prepareStatement("select n.name, n.node_id from tig_pubsub_nodes n inner join tig_pubsub_service_jids sj on n.service_id = sj.service_id where sj.service_jid = ? and collection_id is null");
            ps.setString(1, serviceJid);
            data[0] = ps.executeQuery();
        }
    }

    public static void tigPubSubGetChildNodes(String serviceJid, String collection, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = conn.prepareStatement("select n.name, n.node_id from tig_pubsub_nodes n inner join tig_pubsub_service_jids sj on n.service_id = sj.service_id inner join tig_pubsub_nodes p on p.node_id = n.collection_id and p.service_id = sj.service_id where sj.service_jid = ? and p.name = ?");
            ps.setString(1, serviceJid);
            ps.setString(2, collection);
            data[0] = ps.executeQuery();
        }
    }

    public static void tigPubSubDeleteAllNodes(String serviceJid, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = conn.prepareStatement("delete from tig_pubsub_items where node_id in (select n.node_id from tig_pubsub_nodes n inner join tig_pubsub_service_jids sj on n.service_id = sj.service_id where sj.service_jid = ?)");
            ps.setString(1, serviceJid);
            ps.executeUpdate();
            ps = conn.prepareStatement("delete from tig_pubsub_affiliations where node_id in (select n.node_id from tig_pubsub_nodes n inner join tig_pubsub_service_jids sj on n.service_id = sj.service_id where sj.service_jid = ?)");
            ps.setString(1, serviceJid);
            ps.executeUpdate();
            ps = conn.prepareStatement("delete from tig_pubsub_subscriptions where node_id in (select n.node_id from tig_pubsub_nodes n inner join tig_pubsub_service_jids sj on n.service_id = sj.service_id where sj.service_jid = ?)");
            ps.setString(1, serviceJid);
            ps.executeUpdate();
            ps = conn.prepareStatement("delete from tig_pubsub_nodes where node_id in (select n.node_id from tig_pubsub_nodes n inner join tig_pubsub_service_jids sj on n.service_id = sj.service_id where sj.service_jid = ?)");
            ps.setString(1, serviceJid);
            ps.executeUpdate();
        }
    }

    public static void tigPubSubSetNodeConfiguration(Long nodeId, String conf, Long collectionId, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = conn.prepareStatement("update tig_pubsub_nodes set configuration = ?, collection_id = ? where node_id = ?");
            ps.setString(1, conf);
            if (collectionId == null) {
                ps.setNull(2, -5);
            } else {
                ps.setLong(2, collectionId);
            }
            ps.setLong(3, nodeId);
            ps.executeUpdate();
        }
    }

    public static void tigPubSubSetNodeAffiliation(Long nodeId, String jid, String affil, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = conn.prepareStatement("select 1 from tig_pubsub_affiliations pa inner join tig_pubsub_jids pj on pa.jid_id = pj.jid_id where pa.node_id = ? and pj.jid = ?");
            ps.setLong(1, nodeId);
            ps.setString(2, jid);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                if ("none".equals(affil)) {
                    ps = conn.prepareStatement("delete from tig_pubsub_affiliations where node_id = ? and jid_id = ( select jid_id from tig_pubsub_jids where jid = ?)");
                    ps.setLong(1, nodeId);
                    ps.setString(2, jid);
                    ps.executeUpdate();
                } else {
                    long jidId = StoredProcedures.tigPubSubEnsureJid(jid);
                    ps = conn.prepareStatement("update tig_pubsub_affiliations set affiliation = ? where node_id = ? and jid_id = ?;");
                    ps.setString(1, affil);
                    ps.setLong(2, nodeId);
                    ps.setLong(3, jidId);
                    ps.executeUpdate();
                }
            } else {
                if ("none".equals(affil)) {
                    return;
                }
                long jidId = StoredProcedures.tigPubSubEnsureJid(jid);
                ps = conn.prepareStatement("insert into tig_pubsub_affiliations (node_id, jid_id, affiliation) values (?, ?, ?)");
                ps.setLong(1, nodeId);
                ps.setLong(2, jidId);
                ps.setString(3, affil);
                ps.executeUpdate();
            }
        }
    }

    public static void tigPubSubGetNodeConfiguration(Long nodeId, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = conn.prepareStatement("select configuration from tig_pubsub_nodes where node_id = ?");
            ps.setLong(1, nodeId);
            data[0] = ps.executeQuery();
        }
    }

    public static void tigPubSubGetNodeAffiliations(Long nodeId, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = conn.prepareStatement("select pj.jid, pa.affiliation from tig_pubsub_affiliations pa inner join tig_pubsub_jids pj on pa.jid_id = pj.jid_id where pa.node_id = ?");
            ps.setLong(1, nodeId);
            data[0] = ps.executeQuery();
        }
    }

    public static void tigPubSubGetNodeSubscriptions(Long nodeId, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = conn.prepareStatement("select pj.jid, ps.subscription, ps.subscription_id from tig_pubsub_subscriptions ps inner join tig_pubsub_jids pj on ps.jid_id = pj.jid_id where ps.node_id = ?");
            ps.setLong(1, nodeId);
            data[0] = ps.executeQuery();
        }
    }

    public static void tigPubSubSetNodeSubscription(Long nodeId, String jid, String subscr, String subscrId, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            long jidId = StoredProcedures.tigPubSubEnsureJid(jid);
            PreparedStatement ps = conn.prepareStatement("select 1 from tig_pubsub_subscriptions where node_id = ? and jid_id = ?");
            ps.setLong(1, nodeId);
            ps.setLong(2, jidId);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                ps = conn.prepareStatement("update tig_pubsub_subscriptions set subscription = ? where node_id = ? and jid_id = ?;");
                ps.setString(1, subscr);
                ps.setLong(2, nodeId);
                ps.setLong(3, jidId);
                ps.executeUpdate();
            } else {
                ps = conn.prepareStatement("insert into tig_pubsub_subscriptions (node_id, jid_id, subscription, subscription_id) values (?, ?, ?, ?)");
                ps.setLong(1, nodeId);
                ps.setLong(2, jidId);
                ps.setString(3, subscr);
                ps.setString(4, subscrId);
                ps.executeUpdate();
            }
        }
    }

    public static void tigPubSubDeleteNodeSubscription(Long nodeId, String jid, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = conn.prepareStatement("delete from tig_pubsub_subscriptions where node_id = ? and jid_id = (select jid_id from tig_pubsub_jids where jid = ?)");
            ps.setLong(1, nodeId);
            ps.setString(2, jid);
            ps.executeUpdate();
        }
    }

    public static void tigPubSubGetUserAffiliations(String serviceJid, String jid, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = conn.prepareStatement("select n.name, pa.affiliation from tig_pubsub_nodes n inner join tig_pubsub_service_jids sj on sj.service_id = n.service_id inner join tig_pubsub_affiliations pa on pa.node_id = n.node_id inner join tig_pubsub_jids pj on pj.jid_id = pa.jid_id where pj.jid = ? and sj.service_jid = ?");
            ps.setString(1, jid);
            ps.setString(2, serviceJid);
            data[0] = ps.executeQuery();
        }
    }

    public static void tigPubSubGetUserSubscriptions(String serviceJid, String jid, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = conn.prepareStatement("select n.name, ps.subscription, ps.subscription_id from tig_pubsub_nodes n inner join tig_pubsub_service_jids sj on sj.service_id = n.service_id inner join tig_pubsub_subscriptions ps on ps.node_id = n.node_id inner join tig_pubsub_jids pj on pj.jid_id = ps.jid_id where pj.jid = ? and sj.service_jid = ?");
            ps.setString(1, jid);
            ps.setString(2, serviceJid);
            data[0] = ps.executeQuery();
        }
    }

    public static void tigPubSubGetNodeItemsMeta(Long nodeId, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = conn.prepareStatement("select id, creation_date, update_date from tig_pubsub_items where node_id = ? order by creation_date");
            ps.setLong(1, nodeId);
            data[0] = ps.executeQuery();
        }
    }

    public static void tigPubSubFixNode(Long nodeId, Timestamp creationDate) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = conn.prepareStatement("update tig_pubsub_nodes set creation_date = ? where node_id = ?");
            if (creationDate == null) {
                ps.setNull(1, 93);
            } else {
                ps.setTimestamp(1, creationDate);
            }
            ps.setLong(2, nodeId);
            ps.executeUpdate();
        }
    }

    public static void tigPubSubFixItem(Long nodeId, String itemId, Timestamp creationDate, Timestamp updateDate) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = conn.prepareStatement("update tig_pubsub_items set creation_date = ?, update_date = ? where node_id = ? and id = ?");
            if (creationDate == null) {
                ps.setNull(1, 93);
            } else {
                ps.setTimestamp(1, creationDate);
            }
            if (updateDate == null) {
                ps.setNull(2, 93);
            } else {
                ps.setTimestamp(2, updateDate);
            }
            ps.setLong(3, nodeId);
            ps.setString(4, itemId);
            ps.executeUpdate();
        }
    }

    public static void tigPubSubRemoveService(String serviceJid, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = conn.prepareStatement("delete from tig_pubsub_items where node_id in (select n.node_id from tig_pubsub_nodes n inner join tig_pubsub_service_jids sj on n.service_id = sj.service_id where sj.service_jid = ?)");
            ps.setString(1, serviceJid);
            ps.executeUpdate();
            ps = conn.prepareStatement("delete from tig_pubsub_affiliations where node_id in (select n.node_id from tig_pubsub_nodes n inner join tig_pubsub_service_jids sj on n.service_id = sj.service_id where sj.service_jid = ?)");
            ps.setString(1, serviceJid);
            ps.executeUpdate();
            ps = conn.prepareStatement("delete from tig_pubsub_subscriptions where node_id in (select n.node_id from tig_pubsub_nodes n inner join tig_pubsub_service_jids sj on n.service_id = sj.service_id where sj.service_jid = ?)");
            ps.setString(1, serviceJid);
            ps.executeUpdate();
            ps = conn.prepareStatement("delete from tig_pubsub_nodes where node_id in (select n.node_id from tig_pubsub_nodes n inner join tig_pubsub_service_jids sj on n.service_id = sj.service_id where sj.service_jid = ?)");
            ps.setString(1, serviceJid);
            ps.executeUpdate();
            ps = conn.prepareStatement("delete from tig_pubsub_service_jids where service_jid = ?");
            ps.setString(1, serviceJid);
            ps.executeUpdate();
            ps = conn.prepareStatement("delete from tig_pubsub_affiliations where jid_id in (select j.jid_id from tig_pubsub_jids j where j.jid = ?)");
            ps.setString(1, serviceJid);
            ps.executeUpdate();
            ps = conn.prepareStatement("delete from tig_pubsub_subscriptions where jid_id in (select j.jid_id from tig_pubsub_jids j where j.jid = ?)");
            ps.setString(1, serviceJid);
            ps.executeUpdate();
        }
    }
}

