/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.Bindings;
import tigase.adhoc.AdHocScriptCommandManager;
import tigase.component2.AbstractComponent;
import tigase.component2.PacketWriter;
import tigase.conf.Configurable;
import tigase.conf.ConfigurationException;
import tigase.db.DBInitException;
import tigase.db.RepositoryFactory;
import tigase.db.TigaseDBException;
import tigase.db.UserNotFoundException;
import tigase.db.UserRepository;
import tigase.disteventbus.EventBus;
import tigase.disteventbus.EventBusFactory;
import tigase.disteventbus.EventHandler;
import tigase.osgi.ModulesManagerImpl;
import tigase.pubsub.LeafNodeConfig;
import tigase.pubsub.PubSubConfig;
import tigase.pubsub.modules.AdHocConfigCommandModule;
import tigase.pubsub.modules.CapsModule;
import tigase.pubsub.modules.DefaultConfigModule;
import tigase.pubsub.modules.DiscoverInfoModule;
import tigase.pubsub.modules.DiscoverItemsModule;
import tigase.pubsub.modules.JabberVersionModule;
import tigase.pubsub.modules.ManageAffiliationsModule;
import tigase.pubsub.modules.ManageSubscriptionModule;
import tigase.pubsub.modules.NodeConfigModule;
import tigase.pubsub.modules.NodeCreateModule;
import tigase.pubsub.modules.NodeDeleteModule;
import tigase.pubsub.modules.PendingSubscriptionModule;
import tigase.pubsub.modules.PresenceCollectorModule;
import tigase.pubsub.modules.PublishItemModule;
import tigase.pubsub.modules.PurgeItemsModule;
import tigase.pubsub.modules.RetractItemModule;
import tigase.pubsub.modules.RetrieveAffiliationsModule;
import tigase.pubsub.modules.RetrieveItemsModule;
import tigase.pubsub.modules.RetrieveSubscriptionsModule;
import tigase.pubsub.modules.SubscribeNodeModule;
import tigase.pubsub.modules.UnsubscribeNodeModule;
import tigase.pubsub.modules.XmppPingModule;
import tigase.pubsub.modules.XsltTool;
import tigase.pubsub.modules.commands.DefaultConfigCommand;
import tigase.pubsub.modules.commands.DeleteAllNodesCommand;
import tigase.pubsub.modules.commands.LoadTestCommand;
import tigase.pubsub.modules.commands.ReadAllNodesCommand;
import tigase.pubsub.modules.commands.RebuildDatabaseCommand;
import tigase.pubsub.modules.commands.RetrieveItemsCommand;
import tigase.pubsub.modules.ext.presence.PresenceNodeSubscriptions;
import tigase.pubsub.modules.ext.presence.PresenceNotifierModule;
import tigase.pubsub.repository.IPubSubDAO;
import tigase.pubsub.repository.IPubSubRepository;
import tigase.pubsub.repository.ISubscriptions;
import tigase.pubsub.repository.PubSubDAO;
import tigase.pubsub.repository.PubSubDAOPool;
import tigase.pubsub.repository.PubSubRepositoryWrapper;
import tigase.pubsub.repository.RepositoryException;
import tigase.pubsub.repository.cached.CachedPubSubRepository;
import tigase.server.DisableDisco;
import tigase.server.Packet;
import tigase.stats.StatisticHolder;
import tigase.stats.StatisticsList;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.StanzaType;

public class PubSubComponent
extends AbstractComponent<PubSubConfig>
implements Configurable,
DisableDisco {
    public static final String ADMINS_KEY = "admin";
    private static final String COMPONENT = "component";
    public static final String DEFAULT_LEAF_NODE_CONFIG_KEY = "default-node-config";
    public static final String DELAYED_ROOT_COLLECTION_LOADING_KEY = "delayed-root-collection-loading";
    private static final String MAX_CACHE_SIZE = "pubsub-repository-cache-size";
    private static final Pattern PARAMETRIZED_PROPERTY_PATTERN = Pattern.compile("(.+)\\[(.*)\\]|(.+)");
    protected static final String PUBSUB_REPO_CLASS_PROP_KEY = "pubsub-repo-class";
    protected static final String PUBSUB_REPO_POOL_SIZE_PROP_KEY = "pubsub-repo-pool-size";
    protected static final String PUBSUB_REPO_URL_PROP_KEY = "pubsub-repo-url";
    private AdHocConfigCommandModule adHocCommandsModule;
    protected CapsModule capsModule;
    protected LeafNodeConfig defaultNodeConfig;
    private PubSubDAO directPubSubRepository;
    protected Integer maxRepositoryCacheSize;
    protected PendingSubscriptionModule pendingSubscriptionModule;
    protected PresenceCollectorModule presenceCollectorModule;
    protected PresenceNotifierModule presenceNotifierModule;
    protected PublishItemModule publishNodeModule;
    protected IPubSubRepository pubsubRepository;
    private AdHocScriptCommandManager scriptCommandManager;
    protected UserRepository userRepository;
    private XsltTool xslTransformer;
    private RemoveUserEventHandler removeUserEventHandler = new RemoveUserEventHandler();

    public static Map<String, Object> getProperties(String key, Map<String, Object> props) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : props.entrySet()) {
            Matcher matcher = PARAMETRIZED_PROPERTY_PATTERN.matcher(entry.getKey());
            if (!matcher.find()) continue;
            String keyBaseName = matcher.group(1) != null ? matcher.group(1) : matcher.group(3);
            String keyMod = matcher.group(2);
            if (!keyBaseName.equals(key)) continue;
            result.put(keyMod, entry.getValue());
        }
        return result;
    }

    public PubSubComponent() {
        this.scriptCommandManager = new AdHocScriptCommandManagerImpl(this);
    }

    @Override
    protected PubSubConfig createComponentConfigInstance(AbstractComponent<?> abstractComponent) {
        PubSubConfig result = new PubSubConfig(abstractComponent);
        return result;
    }

    protected PubSubDAO createDAO(Map<String, Object> props) throws RepositoryException {
        Map<String, Object> classNames = PubSubComponent.getProperties(PUBSUB_REPO_CLASS_PROP_KEY, props);
        Map<String, Object> resUris = PubSubComponent.getProperties(PUBSUB_REPO_URL_PROP_KEY, props);
        Map<String, Object> poolSizes = PubSubComponent.getProperties(PUBSUB_REPO_POOL_SIZE_PROP_KEY, props);
        String default_cls_name = (String)classNames.get(null);
        PubSubDAOPool dao_pool = new PubSubDAOPool();
        dao_pool.init(null, null, this.userRepository);
        for (Map.Entry<String, Object> e : resUris.entrySet()) {
            int dao_pool_size;
            String domain = e.getKey();
            String resUri = (String)e.getValue();
            String className = classNames.containsKey(domain) ? (String)classNames.get(domain) : null;
            Class repoClass = null;
            if (className == null) {
                try {
                    repoClass = RepositoryFactory.getRepoClass(IPubSubDAO.class, (String)resUri);
                }
                catch (DBInitException ex) {
                    this.log.log(Level.FINE, "could not autodetect PubSubDAO implementation for domain = {0} for uri = {1}", new Object[]{domain == null ? "default" : domain, resUri});
                }
            }
            if (repoClass == null) {
                if (className == null) {
                    className = default_cls_name;
                }
                try {
                    repoClass = ModulesManagerImpl.getInstance().forName(className);
                }
                catch (ClassNotFoundException ex) {
                    throw new RepositoryException("could not find class " + className + " to use as PubSubDAO implementation for domain " + (domain == null ? "default" : domain), ex);
                }
            }
            HashMap<String, String> repoParams = new HashMap<String, String>();
            try {
                Object value = poolSizes.containsKey(domain) ? poolSizes.get(domain) : poolSizes.get(null);
                dao_pool_size = value instanceof Integer ? (Integer)value : Integer.parseInt((String)value);
            }
            catch (Exception ex) {
                dao_pool_size = 10;
            }
            if (this.log.isLoggable(Level.FINER)) {
                this.log.finer("Creating DAO for domain=" + domain + "; class=" + (repoClass == null ? className : repoClass.getCanonicalName()) + "; uri=" + resUri + "; poolSize=" + dao_pool_size);
            }
            for (int i = 0; i < dao_pool_size; ++i) {
                try {
                    IPubSubDAO dao = (IPubSubDAO)repoClass.newInstance();
                    dao.init(resUri, repoParams, this.userRepository);
                    dao_pool.addDao(domain == null ? null : BareJID.bareJIDInstanceNS((String)domain), dao);
                    continue;
                }
                catch (InstantiationException ex) {
                    throw new RepositoryException("Cound not create instance of " + repoClass.getCanonicalName(), ex);
                }
                catch (IllegalAccessException ex) {
                    throw new RepositoryException("Cound not create instance of " + repoClass.getCanonicalName(), ex);
                }
            }
            if (!this.log.isLoggable(Level.CONFIG)) continue;
            this.log.config("Registered DAO for " + (domain == null ? "default " : "") + "domain " + (domain == null ? "" : domain));
        }
        return dao_pool;
    }

    protected IPubSubRepository createPubSubRepository(PubSubDAO directRepository) {
        PubSubRepositoryWrapper wrapper = new PubSubRepositoryWrapper(new CachedPubSubRepository(directRepository, this.maxRepositoryCacheSize)){

            @Override
            public ISubscriptions getNodeSubscriptions(BareJID serviceJid, String nodeName) throws RepositoryException {
                return new PresenceNodeSubscriptions(serviceJid, nodeName, super.getNodeSubscriptions(serviceJid, nodeName), PubSubComponent.this.presenceNotifierModule);
            }
        };
        return wrapper;
    }

    @Override
    public Map<String, Object> getDefaults(Map<String, Object> params) {
        Map<String, Object> props = super.getDefaults(params);
        String repo_uri = null;
        if (params.get("--user-db-uri") != null) {
            repo_uri = (String)params.get("--user-db-uri");
        }
        props.put(PUBSUB_REPO_URL_PROP_KEY, repo_uri);
        props.put(PUBSUB_REPO_POOL_SIZE_PROP_KEY, 10);
        props.put(MAX_CACHE_SIZE, "2000");
        String[] admins = params.get("--admins") != null ? ((String)params.get("--admins")).split(",") : new String[]{"admin@" + this.getDefHostName()};
        props.put(ADMINS_KEY, admins);
        props.put(DELAYED_ROOT_COLLECTION_LOADING_KEY, false);
        return props;
    }

    public String getDiscoDescription() {
        return "PubSub";
    }

    @Override
    public void getStatistics(StatisticsList list) {
        super.getStatistics(list);
        if (this.pubsubRepository instanceof StatisticHolder) {
            ((StatisticHolder)this.pubsubRepository).getStatistics(this.getName(), list);
        }
    }

    @Override
    public void everyHour() {
        super.everyHour();
        if (this.pubsubRepository instanceof StatisticHolder) {
            ((StatisticHolder)this.pubsubRepository).everyHour();
        }
    }

    @Override
    public void everyMinute() {
        super.everyMinute();
        if (this.pubsubRepository instanceof StatisticHolder) {
            ((StatisticHolder)this.pubsubRepository).everyMinute();
        }
    }

    @Override
    public void everySecond() {
        super.everySecond();
        if (this.pubsubRepository instanceof StatisticHolder) {
            ((StatisticHolder)this.pubsubRepository).everySecond();
        }
    }

    public int hashCodeForPacket(Packet packet) {
        int hash = packet.hashCode();
        return hash;
    }

    protected void init() {
        PacketWriter writer = this.getWriter();
        this.xslTransformer = new XsltTool();
        if (!this.isRegistered(CapsModule.class)) {
            this.capsModule = this.registerModule(new CapsModule((PubSubConfig)this.componentConfig, writer));
        }
        if (!this.isRegistered(PresenceCollectorModule.class)) {
            this.presenceCollectorModule = this.registerModule(new PresenceCollectorModule((PubSubConfig)this.componentConfig, writer, this.capsModule));
        }
        if (!this.isRegistered(PublishItemModule.class)) {
            this.publishNodeModule = this.registerModule(new PublishItemModule((PubSubConfig)this.componentConfig, writer, this.xslTransformer, this.presenceCollectorModule));
        }
        if (!this.isRegistered(RetractItemModule.class)) {
            this.registerModule(new RetractItemModule((PubSubConfig)this.componentConfig, writer, this.publishNodeModule));
        }
        if (!this.isRegistered(PendingSubscriptionModule.class)) {
            this.pendingSubscriptionModule = this.registerModule(new PendingSubscriptionModule((PubSubConfig)this.componentConfig, writer));
        }
        if (!this.isRegistered(ManageSubscriptionModule.class)) {
            this.registerModule(new ManageSubscriptionModule((PubSubConfig)this.componentConfig, writer));
        }
        if (!this.isRegistered(SubscribeNodeModule.class)) {
            this.registerModule(new SubscribeNodeModule((PubSubConfig)this.componentConfig, writer, this.pendingSubscriptionModule, this.publishNodeModule));
        }
        if (!this.isRegistered(NodeCreateModule.class)) {
            this.registerModule(new NodeCreateModule((PubSubConfig)this.componentConfig, writer, this.defaultNodeConfig, this.publishNodeModule));
        }
        if (!this.isRegistered(NodeDeleteModule.class)) {
            this.registerModule(new NodeDeleteModule((PubSubConfig)this.componentConfig, writer, this.publishNodeModule));
        }
        if (!this.isRegistered(DefaultConfigModule.class)) {
            this.registerModule(new DefaultConfigModule((PubSubConfig)this.componentConfig, this.defaultNodeConfig, writer));
        }
        if (!this.isRegistered(NodeConfigModule.class)) {
            this.registerModule(new NodeConfigModule((PubSubConfig)this.componentConfig, writer, this.defaultNodeConfig, this.publishNodeModule));
        }
        if (!this.isRegistered(UnsubscribeNodeModule.class)) {
            this.registerModule(new UnsubscribeNodeModule((PubSubConfig)this.componentConfig, writer));
        }
        if (!this.isRegistered(ManageAffiliationsModule.class)) {
            this.registerModule(new ManageAffiliationsModule((PubSubConfig)this.componentConfig, writer));
        }
        if (!this.isRegistered(RetrieveItemsModule.class)) {
            this.registerModule(new RetrieveItemsModule((PubSubConfig)this.componentConfig, writer));
        }
        if (!this.isRegistered(PurgeItemsModule.class)) {
            this.registerModule(new PurgeItemsModule((PubSubConfig)this.componentConfig, writer, this.publishNodeModule));
        }
        if (!this.isRegistered(JabberVersionModule.class)) {
            this.registerModule(new JabberVersionModule((PubSubConfig)this.componentConfig, writer));
        }
        if (!this.isRegistered(AdHocConfigCommandModule.class)) {
            this.adHocCommandsModule = this.registerModule(new AdHocConfigCommandModule((PubSubConfig)this.componentConfig, writer, this.scriptCommandManager));
        }
        if (!this.isRegistered(DiscoverInfoModule.class)) {
            this.registerModule(new DiscoverInfoModule((PubSubConfig)this.componentConfig, writer, this.modulesManager));
        }
        if (!this.isRegistered(DiscoverItemsModule.class)) {
            this.registerModule(new DiscoverItemsModule((PubSubConfig)this.componentConfig, writer, this.adHocCommandsModule));
        }
        if (!this.isRegistered(RetrieveAffiliationsModule.class)) {
            this.registerModule(new RetrieveAffiliationsModule((PubSubConfig)this.componentConfig, writer));
        }
        if (!this.isRegistered(RetrieveSubscriptionsModule.class)) {
            this.registerModule(new RetrieveSubscriptionsModule((PubSubConfig)this.componentConfig, writer));
        }
        if (!this.isRegistered(XmppPingModule.class)) {
            this.registerModule(new XmppPingModule((PubSubConfig)this.componentConfig, writer));
        }
        if (!this.isRegistered(PresenceNotifierModule.class)) {
            this.presenceNotifierModule = this.registerModule(new PresenceNotifierModule((PubSubConfig)this.componentConfig, writer, this.publishNodeModule));
        }
        this.pubsubRepository.init();
    }

    public void initBindings(Bindings binds) {
        super.initBindings(binds);
        binds.put(COMPONENT, (Object)this);
    }

    public void initialize(String[] admins, PubSubDAO pubSubDAO, IPubSubRepository createPubSubRepository, LeafNodeConfig defaultNodeConfig, boolean delayedRootCollectionLoading) throws UserNotFoundException, TigaseDBException, RepositoryException {
        ((PubSubConfig)this.componentConfig).setAdmins(admins);
        if (!this.userRepository.userExists(((PubSubConfig)this.componentConfig).getServiceBareJID())) {
            this.userRepository.addUser(((PubSubConfig)this.componentConfig).getServiceBareJID());
        }
        this.directPubSubRepository = pubSubDAO;
        this.pubsubRepository = this.createPubSubRepository(pubSubDAO);
        this.pubsubRepository.setDelayedRootCollectionLoading(delayedRootCollectionLoading);
        this.defaultNodeConfig = defaultNodeConfig;
        this.defaultNodeConfig.read(this.userRepository, (PubSubConfig)this.componentConfig, DEFAULT_LEAF_NODE_CONFIG_KEY);
        this.defaultNodeConfig.write(this.userRepository, (PubSubConfig)this.componentConfig, DEFAULT_LEAF_NODE_CONFIG_KEY);
        ((PubSubConfig)this.componentConfig).setPubSubRepository(this.pubsubRepository);
        this.init();
        DefaultConfigCommand configCommand = new DefaultConfigCommand((PubSubConfig)this.componentConfig, this.userRepository);
        configCommand.addDefaultNodeConfigurationChangedHandler(new DefaultConfigCommand.DefaultNodeConfigurationChangedHandler(){

            @Override
            public void onDefaultConfigurationChanged(Packet packet, PubSubConfig config) {
                PubSubComponent.this.onChangeDefaultNodeConfig();
            }
        });
        this.adHocCommandsModule.register(new RebuildDatabaseCommand((PubSubConfig)this.componentConfig, this.directPubSubRepository));
        this.adHocCommandsModule.register(configCommand);
        this.adHocCommandsModule.register(new DeleteAllNodesCommand((PubSubConfig)this.componentConfig, this.directPubSubRepository, this.userRepository));
        this.adHocCommandsModule.register(new LoadTestCommand((PubSubConfig)this.componentConfig, this.pubsubRepository, this));
        this.adHocCommandsModule.register(new ReadAllNodesCommand((PubSubConfig)this.componentConfig, this.directPubSubRepository, this.pubsubRepository));
        this.adHocCommandsModule.register(new RetrieveItemsCommand((PubSubConfig)this.componentConfig, this.pubsubRepository, this.userRepository));
    }

    @Override
    public boolean isDiscoNonAdmin() {
        return true;
    }

    public boolean isSubdomain() {
        return true;
    }

    public void onChangeDefaultNodeConfig() {
        try {
            this.defaultNodeConfig.read(this.userRepository, (PubSubConfig)this.componentConfig, DEFAULT_LEAF_NODE_CONFIG_KEY);
            this.log.info("Node " + this.getComponentId() + " read default node configuration.");
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "Reading default config error", e);
        }
    }

    public int processingInThreads() {
        return Runtime.getRuntime().availableProcessors() * 4;
    }

    public int processingOutThreads() {
        return Runtime.getRuntime().availableProcessors() * 4;
    }

    @Override
    public void processPacket(Packet packet) {
        if (!this.checkPubSubServiceJid(packet)) {
            return;
        }
        super.processPacket(packet);
    }

    @Override
    public void setProperties(Map<String, Object> props) throws ConfigurationException {
        String maxCache;
        super.setProperties(props);
        if (props.size() == 1) {
            return;
        }
        if (this.pubsubRepository != null) {
            this.pubsubRepository.destroy();
        }
        if (this.directPubSubRepository != null) {
            this.directPubSubRepository.destroy();
        }
        if ((maxCache = (String)props.get(MAX_CACHE_SIZE)) != null) {
            try {
                this.maxRepositoryCacheSize = Integer.valueOf(maxCache);
                props.put(MAX_CACHE_SIZE, this.maxRepositoryCacheSize.toString());
            }
            catch (Exception e) {
                this.maxRepositoryCacheSize = null;
                props.put(MAX_CACHE_SIZE, "off");
            }
        }
        this.userRepository = (UserRepository)props.get("shared-user-repo");
        try {
            PubSubDAO dao = this.createDAO(props);
            boolean delayedRootCollectionLoading = (Boolean)props.get(DELAYED_ROOT_COLLECTION_LOADING_KEY);
            this.initialize((String[])props.get(ADMINS_KEY), dao, null, new LeafNodeConfig("default"), delayedRootCollectionLoading);
        }
        catch (Exception e) {
            this.log.severe("Can't initialize pubsub repository: " + e);
            e.printStackTrace();
        }
    }

    public void start() {
        super.start();
        EventBus eventBus = EventBusFactory.getInstance();
        eventBus.addHandler("remove", "tigase:user", (EventHandler)this.removeUserEventHandler);
    }

    public void stop() {
        super.stop();
        EventBus eventBus = EventBusFactory.getInstance();
        eventBus.removeHandler("remove", "tigase:user", (EventHandler)this.removeUserEventHandler);
    }

    protected boolean processScriptCommand(Packet pc, Queue<Packet> results) {
        if (!this.checkPubSubServiceJid(pc)) {
            return true;
        }
        return super.processScriptCommand(pc, results);
    }

    protected boolean checkPubSubServiceJid(Packet packet) {
        if (packet.getStanzaTo() != null && this.getName().equals(packet.getStanzaTo().getLocalpart()) && packet.getType() != StanzaType.result) {
            try {
                Packet result = Authorization.SERVICE_UNAVAILABLE.getResponseMessage(packet, null, true);
                this.addOutPacket(result);
            }
            catch (PacketErrorTypeException ex) {
                this.log.log(Level.FINE, "Packet already of type=error, while preparing error response", ex);
            }
            return false;
        }
        return true;
    }

    private class RemoveUserEventHandler
    implements EventHandler {
        private final String[] JID_PATH = new String[]{"remove", "jid"};

        private RemoveUserEventHandler() {
        }

        public void onEvent(String name, String xmlns, Element event) {
            if (!"remove".equals(name) || !"tigase:user".equals(xmlns)) {
                return;
            }
            String jidStr = event.getChildCData(this.JID_PATH);
            BareJID jid = BareJID.bareJIDInstanceNS((String)jidStr);
            try {
                PubSubComponent.this.pubsubRepository.onUserRemoved(jid);
            }
            catch (RepositoryException ex) {
                PubSubComponent.this.log.log(Level.WARNING, "could not remove PubSub data for removed user " + jidStr, (Throwable)((Object)ex));
            }
        }
    }

    private class AdHocScriptCommandManagerImpl
    implements AdHocScriptCommandManager {
        private final PubSubComponent component;

        public AdHocScriptCommandManagerImpl(PubSubComponent component) {
            this.component = component;
        }

        @Override
        public List<Element> getCommandListItems(JID senderJid, JID toJid) {
            return this.component.getScriptItems("http://jabber.org/protocol/commands", toJid, senderJid);
        }

        @Override
        public List<Packet> process(Packet packet) {
            ArrayDeque<Packet> results = new ArrayDeque<Packet>();
            if (this.component.processScriptCommand(packet, results)) {
                return new ArrayList<Packet>(results);
            }
            return null;
        }

        @Override
        public boolean canCallCommand(JID jid, String commandId) {
            return this.component.canCallCommand(jid, commandId);
        }
    }
}

