/*
 * Decompiled with CFR 0.152.
 */
package tigase.archive.db;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.archive.AbstractCriteria;
import tigase.archive.db.AbstractMessageArchiveRepository;
import tigase.archive.db.MessageArchiveRepository;
import tigase.db.DBInitException;
import tigase.db.DataRepository;
import tigase.db.Repository;
import tigase.db.RepositoryFactory;
import tigase.db.TigaseDBException;
import tigase.util.Base64;
import tigase.xml.DomBuilderHandler;
import tigase.xml.Element;
import tigase.xml.SimpleHandler;
import tigase.xml.SimpleParser;
import tigase.xml.SingletonFactory;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;
import tigase.xmpp.RSM;

@Repository.Meta(supportedUris={"jdbc:[^:]+:.*"})
public class JDBCMessageArchiveRepository
extends AbstractMessageArchiveRepository<Criteria> {
    public static final String JIDS_ID = "jid_id";
    public static final String JIDS_JID = "jid";
    public static final String JIDS_DOMAIN = "domain";
    public static final String JIDS_TABLE = "tig_ma_jids";
    private static final Logger log = Logger.getLogger(JDBCMessageArchiveRepository.class.getCanonicalName());
    private static final long LONG_NULL = 0L;
    private static final long MILIS_PER_DAY = 86400000L;
    public static final String MSGS_ID = "msg_id";
    public static final String MSGS_BUDDY_ID = "buddy_id";
    public static final String MSGS_BUDDY_RESOURCE = "buddy_res";
    private static final String MSGS_BODY = "body";
    private static final String MSGS_DIRECTION = "direction";
    public static final String MSGS_MSG = "msg";
    public static final String MSGS_OWNER_ID = "owner_id";
    protected static final String MSGS_HASH = "stanza_hash";
    public static final String MSGS_TABLE = "tig_ma_msgs";
    private static final String MSGS_TIMESTAMP = "ts";
    private static final String MSGS_TYPE = "type";
    private static final String TAGS_TABLE = "tig_ma_tags";
    private static final String TAGS_ID = "tag_id";
    private static final String TAGS_TAG = "tag";
    private static final String TAGS_OWNER_ID = "owner_id";
    private static final String MSGS_TAGS_TABLE = "tig_ma_msgs_tags";
    private static final SimpleParser parser = SingletonFactory.getParserInstance();
    private static final String GET_JID_IDS_QUERY = "select jid, jid_id from tig_ma_jids where jid = ? or jid = ?";
    private static final String GET_JID_ID_QUERY = "select jid, jid_id from tig_ma_jids where jid = ?";
    private static final String ADD_JID_QUERY = "insert into tig_ma_jids (jid, domain) values (?, ?)";
    private static final String DERBY_CREATE_JIDS = "create table tig_ma_jids ( jid_id bigint generated by default as identity not null, jid varchar(2049), primary key ( jid_id ));create unique index tig_ma_jids_jid on tig_ma_jids (jid);";
    private static final String PGSQL_CREATE_JIDS = "create table tig_ma_jids ( jid_id bigserial, jid varchar(2049), primary key (jid_id)); create unique index tig_ma_jids_jid on tig_ma_jids ( jid);";
    private static final String SQLSERVER_CREATE_JIDS = "create table tig_ma_jids ( jid_id bigint identity(1,1), jid nvarchar(2049),jid_fragment as left (jid, 765),primary key (jid_id)); create unique index tig_ma_jids_jid on tig_ma_jids ( jid_fragment );";
    private static final String MYSQL_CREATE_JIDS = "create table tig_ma_jids ( jid_id bigint unsigned NOT NULL auto_increment, jid varchar(2049), primary key (jid_id)); ";
    private static final String[] GET_MESSAGE_FIELDS = new String[]{"msg", "ts", "direction"};
    private static final String GENERIC_GET_MESSAGES_COUNT = "select count(m.ts) from tig_ma_msgs m where m.owner_id = ?";
    private static final String GENERIC_GET_MESSAGES_ORDER_BY = " order by ts";
    private static final String GENERIC_GET_COLLECTIONS_SELECT = "select min(m.ts) as ts, j.jid from tig_ma_msgs m inner join tig_ma_jids j on m.buddy_id = j.jid_id where m.owner_id = ? ";
    private static final String GENERIC_GET_COLLECTIONS_SELECT_WITH_TYPE = "select min(m.ts) as ts, j.jid, case when m.type = 'groupchat' then 'groupchat' else '' end as type from tig_ma_msgs m inner join tig_ma_jids j on m.buddy_id = j.jid_id where m.owner_id = ? ";
    private static final String MSSQL2008_GET_COLLECTIONS_SELECT = "select x.ts, x.jid from ( select min(m.ts) as ts, j.jid, ROW_NUMBER() over (order by min(m.ts), j.jid) as rn from tig_ma_msgs m inner join tig_ma_jids j on m.buddy_id = j.jid_id where m.owner_id = ? ";
    private static final String MSSQL2008_GET_COLLECTIONS_SELECT_WITH_TYPE = "select x.ts, x.jid, x.type from ( select min(m.ts) as ts, j.jid, case when m.type = 'groupchat' then 'groupchat' else '' end as type, ROW_NUMBER() over (order by min(m.ts), j.jid) as rn from tig_ma_msgs m inner join tig_ma_jids j on m.buddy_id = j.jid_id where m.owner_id = ? ";
    private static final String GENERIC_GET_COLLECTIONS_SELECT_GROUP = " group by date(m.ts), m.buddy_id, j.jid";
    private static final String GENERIC_GET_COLLECTIONS_SELECT_GROUP_WITH_TYPE = " group by date(m.ts), m.buddy_id, j.jid, case when m.type = 'groupchat' then 'groupchat' else '' end ";
    private static final String MSSQL2008_GET_COLLECTIONS_SELECT_GROUP = " group by cast(m.ts as date), m.buddy_id, j.jid) x ";
    private static final String MSSQL2008_GET_COLLECTIONS_SELECT_GROUP_WITH_TYPE = " group by cast(m.ts as date), m.buddy_id, j.jid, case when m.type = 'groupchat' then 'groupchat' else '' end ) x ";
    private static final String GENERIC_GET_COLLECTIONS_SELECT_ORDER = " order by min(m.ts), j.jid";
    private static final String MSSQL2008_GET_COLLECTIONS_SELECT_ORDER = " order by x.ts, x.jid";
    private static final String GENERIC_GET_COLLECTIONS_COUNT = "select count(1) from (select min(m.ts) as ts, m.buddy_id from tig_ma_msgs m where m.owner_id = ? ";
    private static final String GENERIC_GET_COLLECTIONS_COUNT_GROUP = "group by date(m.ts), m.buddy_id) x";
    private static final String GENERIC_GET_COLLECTIONS_COUNT_GROUP_WITH_TYPE = "group by date(m.ts), m.buddy_id, case when m.type = 'groupchat' then 'groupchat' else '' end ) x";
    private static final String MSSQL2008_GET_COLLECTIONS_COUNT_GROUP = "group by cast(m.ts as date), m.buddy_id) x";
    private static final String MSSQL2008_GET_COLLECTIONS_COUNT_GROUP_WITH_TYPE = "group by cast(m.ts as date), m.buddy_id, case when m.type = 'groupchat' then 'groupchat' else '' end ) x";
    private static final String GENERIC_LIMIT = " limit ? offset ?";
    private static final String DERBY_LIMIT = " offset ? rows fetch next ? rows only";
    private static final String MSSQL2008_LIMIT = " where x.rn > ? and x.rn <= ?";
    private static final String DERBY_CREATE_TAGS = "create table tig_ma_tags ( tag_id bigint generated by default as identity not null, tag varchar(255), owner_id bigint references  tig_ma_jids(jid_id) on delete cascade, primary key ( tag_id ));create index tig_ma_tags_owner_id on tig_ma_tags (owner_id);create unique index tig_ma_tags_tag_owner_id on tig_ma_tags ( owner_id,tag);";
    private static final String PGSQL_CREATE_TAGS = "create table tig_ma_tags ( tag_id bigserial, tag varchar(255), owner_id bigint not null,\tprimary key (tag_id), foreign key (owner_id) references tig_ma_jids (jid_id) on delete cascade ); create index tig_ma_tags_owner_id on tig_ma_tags (owner_id);create unique index tig_ma_tags_tag_owner_id on tig_ma_tags ( owner_id,tag);";
    private static final String SQLSERVER_CREATE_TAGS = "create table tig_ma_tags ( tag_id bigint identity(1,1), tag nvarchar(255),owner_id bigint not null,primary key (tag_id), foreign key (owner_id) references tig_ma_jids(jid_id) on delete cascade ); create index tig_ma_tags_owner_id on tig_ma_tags (owner_id);create unique index tig_ma_tags_tag_owner_id on tig_ma_tags ( owner_id,tag);";
    private static final String MYSQL_CREATE_TAGS = "create table tig_ma_tags ( tag_id bigint unsigned NOT NULL auto_increment, tag varchar(255), owner_id bigint unsigned not null,  primary key (tag_id), foreign key (owner_id) references tig_ma_jids(jid_id) on delete cascade, key tig_ma_tags_owner_id ( owner_id ),  unique key tig_ma_tags_tag_owner_id ( owner_id,tag ) ); ";
    private static final String DERBY_CREATE_MSGS_TAGS = "create table tig_ma_msgs_tags (msg_id bigint not null references tig_ma_msgs(msg_id) on delete cascade, tag_id bigint not null references tig_ma_tags(tag_id) on delete cascade);create index tig_ma_msgs_tags_msg_id on tig_ma_msgs_tags (msg_id);create index tig_ma_msgs_tags_tag_id on tig_ma_msgs_tags (tag_id);";
    private static final String PGSQL_CREATE_MSGS_TAGS = "create table tig_ma_msgs_tags (msg_id bigint not null, tag_id bigint not null, foreign key (msg_id) references tig_ma_msgs(msg_id) on delete cascade, foreign key (tag_id) references tig_ma_tags(tag_id) on delete cascade);create index tig_ma_msgs_tags_msg_id on tig_ma_msgs_tags (msg_id);create index tig_ma_msgs_tags_tag_id on tig_ma_msgs_tags (tag_id);";
    private static final String SQLSERVER_CREATE_MSGS_TAGS = "create table tig_ma_msgs_tags (msg_id bigint not null, tag_id bigint not null, foreign key (msg_id) references tig_ma_msgs(msg_id) on delete cascade, foreign key (tag_id) references tig_ma_tags(tag_id) on delete cascade);create index tig_ma_msgs_tags_msg_id on tig_ma_msgs_tags (msg_id);create index tig_ma_msgs_tags_tag_id on tig_ma_msgs_tags (tag_id);";
    private static final String MYSQL_CREATE_MSGS_TAGS = "create table tig_ma_msgs_tags (msg_id bigint unsigned not null, tag_id bigint unsigned not null, foreign key (msg_id) references tig_ma_msgs(msg_id) on delete cascade, foreign key (tag_id) references tig_ma_tags(tag_id) on delete cascade,  key tig_ma_msgs_tags_msg_id (msg_id),  key tig_ma_msgs_tags_tag_id (tag_id) );";
    private static final String[][] GET_COLLECTIONS_WHERES = new String[][]{{"FROM", " and m.ts >= ? "}, {"TO", " and m.ts <= ? "}, {"WITH", " and m.buddy_id = ? "}};
    private static final String[] GET_COLLECTIONS_COMBINATIONS = new String[]{"", "FROM", "FROM_TO", "FROM_TO_WITH", "FROM_WITH", "TO", "TO_WITH", "WITH"};
    private static final String ADD_MESSAGE_1 = "insert into tig_ma_msgs (owner_id, buddy_id, ts, direction, type, body, msg, stanza_hash) values (?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String DERBY_ADD_MESSAGE = "insert into tig_ma_msgs (owner_id, buddy_id, buddy_res, ts, direction, type, body, msg, stanza_hash) select ?, ?, ?, ?, ?, ?, ?, ?, ? from SYSIBM.SYSDUMMY1  where not exists (select 1 from tig_ma_msgs m where m.owner_id = ? and m.buddy_id = ? and m.ts between ? and ? and m.stanza_hash = ? )";
    private static final String PGSQL_ADD_MESSAGE = "insert into tig_ma_msgs (owner_id, buddy_id, buddy_res, ts, direction, type, body, msg, stanza_hash) select ?, ?, ?, ?, ?, ?, ?, ?, ? where not exists (select 1 from tig_ma_msgs m where m.owner_id = ? and m.buddy_id = ? and m.ts between ? and ? and m.stanza_hash = ? )";
    private static final String MYSQL_ADD_MESSAGE = "insert into tig_ma_msgs (owner_id, buddy_id, buddy_res, ts, direction, type, body, msg, stanza_hash) values (?, ?, ? , ?, ?, ?, ?, ?, ?) on duplicate key update direction = direction";
    private static final String SQLSERVER_ADD_MESSAGE = "insert into tig_ma_msgs (owner_id, buddy_id, buddy_res, ts, direction, type, body, msg, stanza_hash) select tmp.owner_id, tmp.buddy_id, tmp.buddy_res, tmp.ts, tmp.direction, tmp.type, tmp.body, msg, tmp.stanza_hash from (select ? as owner_id, ? as buddy_id, ? as buddy_res, ? as ts, ? as direction, ? as type, ? as body, ? as msg, ? as stanza_hash) as tmp where not exists (select 1 from tig_ma_msgs m where m.owner_id = ? and m.buddy_id = ? and m.ts between ? and ? and m.stanza_hash = ?)";
    private static final String DELETE_EXPIRED_MSGS = "delete from tig_ma_msgs where ts < ? and EXISTS( select 1 from tig_ma_jids j where j.jid_id = owner_id and j.domain = ? ) ";
    private static final String REMOVE_MSGS = "delete from tig_ma_msgs where owner_id = ? and buddy_id = ? and ts <= ? and ts >= ?";
    private static final String DERBY_CREATE_MSGS = "create table tig_ma_msgs (msg_id bigint generated by default as identity not null PRIMARY KEY,owner_id bigint references tig_ma_jids(jid_id),buddy_id bigint references tig_ma_jids(jid_id),ts timestamp, direction smallint, type varchar(20), body varchar(32672), msg varchar(32672),stanza_hash varchar(50));create index tig_ma_msgs_owner_id_index on tig_ma_msgs (owner_id);create index tig_ma_msgs_owner_id_buddy_id_index on tig_ma_msgs (owner_id, buddy_id);create index tig_ma_msgs_owner_id_ts_buddy_id_index on tig_ma_msgs (owner_id, ts, buddy_id);create unique index tig_ma_msgs_owner_id_ts_buddy_id_stanza_hash_index on tig_ma_msgs (owner_id, ts, buddy_id, stanza_hash);";
    private static final String PGSQL_CREATE_MSGS = "create table tig_ma_msgs (msg_id bigserial, owner_id bigint, buddy_id bigint, ts timestamp, direction smallint, type varchar(20), body text, msg text,stanza_hash varchar(50), primary key (msg_id), foreign key (buddy_id) references tig_ma_jids (jid_id), foreign key (owner_id) references tig_ma_jids (jid_id) ); create index tig_ma_msgs_owner_id_index on tig_ma_msgs ( owner_id); create index tig_ma_msgs_owner_id_buddy_id_index on tig_ma_msgs ( owner_id, buddy_id); create index tig_ma_msgs_owner_id_ts_buddy_id_index on tig_ma_msgs ( owner_id, ts, buddy_id); create unique index tig_ma_msgs_owner_id_ts_buddy_id_stanza_hash_index on tig_ma_msgs ( owner_id, ts, stanza_hash, buddy_id); ";
    private static final String SQLSERVER_CREATE_MSGS = "create table tig_ma_msgs (msg_id bigint IDENTITY(1,1) NOT NULL, owner_id bigint, buddy_id bigint, ts datetime, direction smallint, type nvarchar(20),body ntext, msg ntext,stanza_hash varchar(50),  primary key (msg_id), foreign key (buddy_id) references tig_ma_jids (jid_id), foreign key (owner_id) references tig_ma_jids (jid_id) ); create index tig_ma_msgs_owner_id_index on tig_ma_msgs ( owner_id); create index tig_ma_msgs_owner_id_buddy_id_index on tig_ma_msgs ( owner_id, buddy_id); create index tig_ma_msgs_owner_id_ts_buddy_id_index on tig_ma_msgs ( owner_id, ts, buddy_id); create unique index tig_ma_msgs_owner_id_ts_buddy_id_stanza_hash_index on tig_ma_msgs (owner_id, ts, buddy_id, stanza_hash);";
    private static final String MYSQL_CREATE_MSGS = "create table tig_ma_msgs (msg_id bigint unsigned NOT NULL auto_increment, owner_id bigint unsigned, buddy_id bigint unsigned, ts timestamp, direction smallint, type varchar(20),body text, msg text,stanza_hash varchar(50),  primary key (msg_id),  foreign key (buddy_id) references tig_ma_jids (jid_id), foreign key (owner_id) references tig_ma_jids (jid_id), key (owner_id), key (owner_id, buddy_id), key (owner_id, ts, buddy_id), unique index using hash (owner_id, ts, buddy_id, stanza_hash));";
    private static final String ADD_TAG = "insert into tig_ma_tags (owner_id, tag) values (?,?)";
    private static final String ADD_MESSAGE_TAG = "insert into tig_ma_msgs_tags (msg_id, tag_id) values (?,?)";
    private static final String GET_TAG_IDS = "select tag_id, tag from tig_ma_tags WHERE owner_id = ? AND ( ";
    private static final String GET_TAG_IDS_WHERE_PART = "tag = ? ";
    private static final String GET_TAG_IDS_END = " )";
    private static final String GET_TAGS_FOR_USER = "select t.tag from tig_ma_tags t inner join tig_ma_jids j on t.owner_id = j.jid_id where j.jid = ? and t.tag like ? ";
    private static final String GET_TAGS_FOR_USER_COUNT = "select count(t.tag_id) from tig_ma_tags t inner join tig_ma_jids j on t.owner_id = j.jid_id where j.jid = ? and t.tag like ? ";
    private static final String GET_TAGS_FOR_USER_ORDER = " order by tag";
    private static final String SQLSERVER_GET_TAGS_FOR_USER = "select x.tag from ( select t.tag, ROW_NUMBER() over (order by t.tag) as rn from tig_ma_tags t inner join tig_ma_jids j on t.owner_id = j.jid_id where j.jid = ? and t.tag like ? ) x ";
    private static final String STORE_PLAINTEXT_BODY_KEY = "store-plaintext-body";
    private static final String GROUP_BY_TYPE_KEY = "group-by-chat-type";
    private static final String DELETE_EXPIRED_QUERY_TIMEOUT_KEY = "remove-expired-messages-query-timeout";
    private static final int DEF_DELETE_EXPIRED_QUERY_TIMEOUT_VAL = 300;
    protected String ADD_MESSAGE;
    protected DataRepository data_repo = null;
    private boolean storePlaintextBody = true;
    private boolean groupByType = false;
    private int delete_expired_timeout = 300;

    private static String getMessagesSelectQuery(DataRepository.dbTypes dbType, List<String> fields, String where) {
        StringBuilder sb = new StringBuilder("select ");
        int idx = fields.indexOf(JIDS_JID);
        switch (dbType) {
            case sqlserver: 
            case jtds: {
                JDBCMessageArchiveRepository.addFieldsToMessagesStartBuilder(sb, "x", fields);
                sb.append(" from (select ");
                ArrayList<String> subqueryFields = new ArrayList<String>(fields);
                if (idx > -1) {
                    subqueryFields.remove(idx);
                    subqueryFields.add(idx, MSGS_BUDDY_ID);
                }
                JDBCMessageArchiveRepository.addFieldsToMessagesStartBuilder(sb, "m", subqueryFields);
                sb.append(", ROW_NUMBER() over (order by m.ts) as rn");
                break;
            }
            default: {
                JDBCMessageArchiveRepository.addFieldsToMessagesStartBuilder(sb, "m", fields);
            }
        }
        sb.append(" from tig_ma_msgs m");
        switch (dbType) {
            case sqlserver: 
            case jtds: {
                break;
            }
            default: {
                if (idx <= -1) break;
                sb.append(" inner join tig_ma_jids b ON b.jid_id = m.buddy_id");
            }
        }
        sb.append(" where m.owner_id = ? ");
        sb.append(where);
        switch (dbType) {
            case derby: {
                sb.append(GENERIC_GET_MESSAGES_ORDER_BY).append(DERBY_LIMIT);
                break;
            }
            case sqlserver: 
            case jtds: {
                sb.append(") x");
                if (idx > -1) {
                    sb.append(" inner join tig_ma_jids b ON b.jid_id = x.buddy_id");
                }
                sb.append(MSSQL2008_LIMIT).append(GENERIC_GET_MESSAGES_ORDER_BY);
                break;
            }
            default: {
                sb.append(GENERIC_GET_MESSAGES_ORDER_BY).append(GENERIC_LIMIT);
            }
        }
        return sb.toString();
    }

    private static void addFieldsToMessagesStartBuilder(StringBuilder sb, String tablePrefix, List<String> fields) {
        for (int i = 0; i < fields.size(); ++i) {
            String field = fields.get(i);
            if (i > 0) {
                sb.append(", ");
            }
            if (JIDS_JID.equals(field)) {
                sb.append("b.").append(JIDS_JID);
                continue;
            }
            sb.append(tablePrefix).append(".").append(field);
        }
    }

    private static String getMessagesCountQuery(DataRepository.dbTypes dbType, String where) {
        return GENERIC_GET_MESSAGES_COUNT + where;
    }

    protected String[] getCollectionsCombinations() {
        return GET_COLLECTIONS_COMBINATIONS;
    }

    protected String[][] getCollectionsWheres() {
        return GET_COLLECTIONS_WHERES;
    }

    public void initRepository(String conn_str, Map<String, String> params) throws DBInitException {
        try {
            this.data_repo = RepositoryFactory.getDataRepository(null, (String)conn_str, params);
            this.storePlaintextBody = params.containsKey(STORE_PLAINTEXT_BODY_KEY) ? Boolean.parseBoolean(params.get(STORE_PLAINTEXT_BODY_KEY)) : true;
            this.initRepositoryDbSchema();
            switch (this.data_repo.getDatabaseType()) {
                case derby: {
                    this.ADD_MESSAGE = DERBY_ADD_MESSAGE;
                    break;
                }
                case postgresql: {
                    this.ADD_MESSAGE = PGSQL_ADD_MESSAGE;
                    break;
                }
                case mysql: {
                    this.ADD_MESSAGE = MYSQL_ADD_MESSAGE;
                    break;
                }
                case sqlserver: 
                case jtds: {
                    this.ADD_MESSAGE = SQLSERVER_ADD_MESSAGE;
                }
            }
            if (!params.containsKey("ignoreStatementInitialization")) {
                StringBuilder sb = new StringBuilder();
                for (Map.Entry<String, String> e : params.entrySet()) {
                    sb.append(", " + e.getKey() + " = " + e.getValue());
                }
                this.groupByType = params.containsKey(GROUP_BY_TYPE_KEY) ? Boolean.parseBoolean(params.get(GROUP_BY_TYPE_KEY)) : false;
            }
            if (params.containsKey(DELETE_EXPIRED_QUERY_TIMEOUT_KEY)) {
                this.delete_expired_timeout = Integer.parseInt(params.get(DELETE_EXPIRED_QUERY_TIMEOUT_KEY));
                log.log(Level.FINEST, "setting remove-expired-messages-query-timeout to {0}", this.delete_expired_timeout);
            }
            this.initPreparedStatements(params);
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "MessageArchiveDB initialization exception", ex);
        }
    }

    protected void initRepositoryDbSchema() throws SQLException {
        switch (this.data_repo.getDatabaseType()) {
            case mysql: {
                this.data_repo.checkTable(JIDS_TABLE, MYSQL_CREATE_JIDS);
                this.data_repo.checkTable(MSGS_TABLE, MYSQL_CREATE_MSGS);
                break;
            }
            case derby: {
                this.data_repo.checkTable(JIDS_TABLE, DERBY_CREATE_JIDS);
                this.data_repo.checkTable(MSGS_TABLE, DERBY_CREATE_MSGS);
                break;
            }
            case postgresql: {
                this.data_repo.checkTable(JIDS_TABLE, PGSQL_CREATE_JIDS);
                this.data_repo.checkTable(MSGS_TABLE, PGSQL_CREATE_MSGS);
                break;
            }
            case sqlserver: 
            case jtds: {
                this.data_repo.checkTable(JIDS_TABLE, SQLSERVER_CREATE_JIDS);
                this.data_repo.checkTable(MSGS_TABLE, SQLSERVER_CREATE_MSGS);
            }
        }
        this.checkDB();
        switch (this.data_repo.getDatabaseType()) {
            case mysql: {
                this.data_repo.checkTable(TAGS_TABLE, MYSQL_CREATE_TAGS);
                this.data_repo.checkTable(MSGS_TAGS_TABLE, MYSQL_CREATE_MSGS_TAGS);
                break;
            }
            case derby: {
                this.data_repo.checkTable(TAGS_TABLE, DERBY_CREATE_TAGS);
                this.data_repo.checkTable(MSGS_TAGS_TABLE, DERBY_CREATE_MSGS_TAGS);
                break;
            }
            case postgresql: {
                this.data_repo.checkTable(TAGS_TABLE, PGSQL_CREATE_TAGS);
                this.data_repo.checkTable(MSGS_TAGS_TABLE, "create table tig_ma_msgs_tags (msg_id bigint not null, tag_id bigint not null, foreign key (msg_id) references tig_ma_msgs(msg_id) on delete cascade, foreign key (tag_id) references tig_ma_tags(tag_id) on delete cascade);create index tig_ma_msgs_tags_msg_id on tig_ma_msgs_tags (msg_id);create index tig_ma_msgs_tags_tag_id on tig_ma_msgs_tags (tag_id);");
                break;
            }
            case sqlserver: 
            case jtds: {
                this.data_repo.checkTable(TAGS_TABLE, SQLSERVER_CREATE_TAGS);
                this.data_repo.checkTable(MSGS_TAGS_TABLE, "create table tig_ma_msgs_tags (msg_id bigint not null, tag_id bigint not null, foreign key (msg_id) references tig_ma_msgs(msg_id) on delete cascade, foreign key (tag_id) references tig_ma_tags(tag_id) on delete cascade);create index tig_ma_msgs_tags_msg_id on tig_ma_msgs_tags (msg_id);create index tig_ma_msgs_tags_tag_id on tig_ma_msgs_tags (tag_id);");
            }
        }
    }

    protected void initPreparedStatements(Map<String, String> params) throws SQLException {
        if (params.containsKey("ignoreStatementInitialization")) {
            return;
        }
        this.data_repo.initPreparedStatement(ADD_JID_QUERY, ADD_JID_QUERY);
        this.data_repo.initPreparedStatement(GET_JID_ID_QUERY, GET_JID_ID_QUERY);
        this.data_repo.initPreparedStatement(GET_JID_IDS_QUERY, GET_JID_IDS_QUERY);
        this.data_repo.initPreparedStatement(this.ADD_MESSAGE, this.ADD_MESSAGE, 1);
        this.data_repo.initPreparedStatement(DELETE_EXPIRED_MSGS, DELETE_EXPIRED_MSGS);
        HashMap<String, String> combinations = new HashMap<String, String>();
        for (String combination : this.getCollectionsCombinations()) {
            StringBuilder sbMain = new StringBuilder();
            if (!combination.isEmpty()) {
                String[] whereParts;
                for (String part : whereParts = combination.split("_")) {
                    for (String[] where : this.getCollectionsWheres()) {
                        if (!part.equals(where[0])) continue;
                        sbMain.append(where[1]);
                    }
                }
            }
            for (int j = 0; j < 6; ++j) {
                StringBuilder combinationSb1 = new StringBuilder().append(combination);
                StringBuilder querySb1 = new StringBuilder().append((CharSequence)sbMain);
                if (j > 0) {
                    if (combinationSb1.length() > 0) {
                        combinationSb1.append("_");
                    }
                    combinationSb1.append("TAGS[").append(j).append("]");
                    querySb1.append(" and EXISTS( select 1 from ").append(TAGS_TABLE).append(" t inner join ").append(MSGS_TAGS_TABLE).append(" tm on t.").append(TAGS_ID).append(" = tm.").append(TAGS_ID).append(" where m.").append(MSGS_ID).append(" = tm.").append(MSGS_ID).append(" and (");
                    for (int x = 0; x < j; ++x) {
                        if (x > 0) {
                            querySb1.append(" or ");
                        }
                        querySb1.append("t.").append(TAGS_TAG).append(" = ?");
                    }
                    querySb1.append(" )) ");
                }
                for (int i = 0; i < 6; ++i) {
                    StringBuilder combinationSb = new StringBuilder().append((CharSequence)combinationSb1);
                    StringBuilder querySb = new StringBuilder().append((CharSequence)querySb1);
                    if (i > 0) {
                        if (combinationSb.length() > 0) {
                            combinationSb.append("_");
                        }
                        combinationSb.append("CONTAINS[").append(i).append("]");
                        for (int x = 0; x < i; ++x) {
                            querySb.append(" and m.").append(MSGS_BODY).append(" like ? ");
                        }
                    }
                    combinations.put(combinationSb.toString(), querySb.toString());
                }
            }
        }
        for (Map.Entry entry : combinations.entrySet()) {
            StringBuilder select = new StringBuilder();
            StringBuilder count = new StringBuilder().append(GENERIC_GET_COLLECTIONS_COUNT);
            switch (this.data_repo.getDatabaseType()) {
                case sqlserver: 
                case jtds: {
                    if (this.groupByType) {
                        select.append(MSSQL2008_GET_COLLECTIONS_SELECT_WITH_TYPE);
                        break;
                    }
                    select.append(MSSQL2008_GET_COLLECTIONS_SELECT);
                    break;
                }
                default: {
                    if (this.groupByType) {
                        select.append(GENERIC_GET_COLLECTIONS_SELECT_WITH_TYPE);
                        break;
                    }
                    select.append(GENERIC_GET_COLLECTIONS_SELECT);
                }
            }
            select.append((String)entry.getValue());
            count.append((String)entry.getValue());
            switch (this.data_repo.getDatabaseType()) {
                case sqlserver: 
                case jtds: {
                    if (this.groupByType) {
                        select.append(MSSQL2008_GET_COLLECTIONS_SELECT_GROUP_WITH_TYPE);
                        count.append(MSSQL2008_GET_COLLECTIONS_COUNT_GROUP_WITH_TYPE);
                        break;
                    }
                    select.append(MSSQL2008_GET_COLLECTIONS_SELECT_GROUP);
                    count.append(MSSQL2008_GET_COLLECTIONS_COUNT_GROUP);
                    break;
                }
                default: {
                    if (this.groupByType) {
                        select.append(" group by date(m.ts), m.buddy_id, j.jid, case when m.type = 'groupchat' then 'groupchat' else '' end  order by min(m.ts), j.jid");
                        count.append(GENERIC_GET_COLLECTIONS_COUNT_GROUP_WITH_TYPE);
                        break;
                    }
                    select.append(" group by date(m.ts), m.buddy_id, j.jid order by min(m.ts), j.jid");
                    count.append(GENERIC_GET_COLLECTIONS_COUNT_GROUP);
                }
            }
            switch (this.data_repo.getDatabaseType()) {
                case derby: {
                    select.append(DERBY_LIMIT);
                    break;
                }
                case sqlserver: 
                case jtds: {
                    select.append(MSSQL2008_LIMIT).append(MSSQL2008_GET_COLLECTIONS_SELECT_ORDER);
                    break;
                }
                default: {
                    select.append(GENERIC_LIMIT);
                }
            }
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "prepared collection select query for " + (String)entry.getKey() + " as '" + select.toString() + "'");
                log.log(Level.FINEST, "prepared collection count query for " + (String)entry.getKey() + " as '" + count.toString() + "'");
            }
            this.data_repo.initPreparedStatement("GET_COLLECTIONS_" + (String)entry.getKey() + "_SELECT", select.toString());
            this.data_repo.initPreparedStatement("GET_COLLECTIONS_" + (String)entry.getKey() + "_COUNT", count.toString());
        }
        for (Map.Entry entry : combinations.entrySet()) {
            List<String> fields = this.getMessageFields((String)entry.getKey());
            String select = JDBCMessageArchiveRepository.getMessagesSelectQuery(this.data_repo.getDatabaseType(), fields, (String)entry.getValue());
            String count = JDBCMessageArchiveRepository.getMessagesCountQuery(this.data_repo.getDatabaseType(), (String)entry.getValue());
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "prepared messages select query for " + (String)entry.getKey() + " as '" + select + "'");
                log.log(Level.FINEST, "prepared messages count query for " + (String)entry.getKey() + " as '" + count + "'");
            }
            this.data_repo.initPreparedStatement("GET_MESSAGES_" + (String)entry.getKey() + "_SELECT", select);
            this.data_repo.initPreparedStatement("GET_MESSAGES_" + (String)entry.getKey() + "_COUNT", count);
        }
        this.data_repo.initPreparedStatement(REMOVE_MSGS, REMOVE_MSGS);
        for (int i = 0; i <= 5; ++i) {
            StringBuilder stringBuilder = new StringBuilder().append(GET_TAG_IDS);
            for (int j = 1; j <= i; ++j) {
                if (j > 1) {
                    stringBuilder.append(" or ");
                }
                stringBuilder.append(GET_TAG_IDS_WHERE_PART);
            }
            if (i == 0) {
                stringBuilder.append("1=1");
            }
            stringBuilder.append(")");
            this.data_repo.initPreparedStatement("select tag_id, tag from tig_ma_tags WHERE owner_id = ? AND ( _" + i, stringBuilder.toString());
        }
        this.data_repo.initPreparedStatement(ADD_TAG, ADD_TAG, 1);
        this.data_repo.initPreparedStatement(ADD_MESSAGE_TAG, ADD_MESSAGE_TAG);
        this.data_repo.initPreparedStatement(GET_TAGS_FOR_USER_COUNT, GET_TAGS_FOR_USER_COUNT);
        switch (this.data_repo.getDatabaseType()) {
            case derby: {
                this.data_repo.initPreparedStatement(GET_TAGS_FOR_USER, "select t.tag from tig_ma_tags t inner join tig_ma_jids j on t.owner_id = j.jid_id where j.jid = ? and t.tag like ?  order by tag offset ? rows fetch next ? rows only");
                break;
            }
            case sqlserver: 
            case jtds: {
                this.data_repo.initPreparedStatement(GET_TAGS_FOR_USER, "select x.tag from ( select t.tag, ROW_NUMBER() over (order by t.tag) as rn from tig_ma_tags t inner join tig_ma_jids j on t.owner_id = j.jid_id where j.jid = ? and t.tag like ? ) x  where x.rn > ? and x.rn <= ? order by tag");
                break;
            }
            default: {
                this.data_repo.initPreparedStatement(GET_TAGS_FOR_USER, "select t.tag from tig_ma_tags t inner join tig_ma_jids j on t.owner_id = j.jid_id where j.jid = ? and t.tag like ?  order by tag limit ? offset ?");
            }
        }
    }

    @Override
    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkDB() {
        Statement stmt = null;
        try {
            String alterTable;
            try {
                stmt = this.data_repo.createStatement(null);
                stmt.executeQuery("select body from tig_ma_msgs where owner_id = 0");
            }
            catch (SQLException ex) {
                alterTable = null;
                switch (this.data_repo.getDatabaseType()) {
                    case derby: {
                        alterTable = "alter table tig_ma_msgs add body varchar(32672)";
                        break;
                    }
                    case mysql: {
                        alterTable = "alter table tig_ma_msgs add body text";
                        break;
                    }
                    case postgresql: {
                        alterTable = "alter table tig_ma_msgs add body text";
                        break;
                    }
                    case sqlserver: 
                    case jtds: {
                        alterTable = "alter table tig_ma_msgs add body ntext";
                    }
                }
                try {
                    stmt.execute(alterTable);
                }
                catch (SQLException ex1) {
                    log.log(Level.SEVERE, "could not alter table tig_ma_msgs to add missing column by SQL:\n" + alterTable, ex1);
                }
            }
            this.data_repo.release(stmt, null);
            try {
                stmt = this.data_repo.createStatement(null);
                stmt.executeQuery("select msg_id from tig_ma_msgs where owner_id = 0");
            }
            catch (SQLException ex) {
                alterTable = null;
                try {
                    switch (this.data_repo.getDatabaseType()) {
                        case derby: {
                            alterTable = "alter table tig_ma_msgs add msg_id bigint generated by default as identity not null";
                            stmt.execute(alterTable);
                            alterTable = "alter table tig_ma_msgs add primary key (msg_id)";
                            stmt.execute(alterTable);
                            break;
                        }
                        case mysql: {
                            alterTable = "alter table tig_ma_msgs add msg_id bigint unsigned NOT NULL auto_increment, add primary key (msg_id)";
                            stmt.execute(alterTable);
                            break;
                        }
                        case postgresql: {
                            alterTable = "alter table tig_ma_msgs add msg_id serial";
                            stmt.execute(alterTable);
                            alterTable = "alter table tig_ma_msgs add primary key (msg_id)";
                            stmt.execute(alterTable);
                            break;
                        }
                        case sqlserver: 
                        case jtds: {
                            alterTable = "alter table tig_ma_msgs add msg_id bigint identity(1,1)";
                            stmt.execute(alterTable);
                            alterTable = "alter table tig_ma_msgs add primary key (msg_id)";
                            stmt.execute(alterTable);
                        }
                    }
                }
                catch (SQLException ex1) {
                    log.log(Level.SEVERE, "could not alter table tig_ma_msgs to add missing column by SQL:\n" + alterTable, ex1);
                }
            }
            this.data_repo.release(stmt, null);
            try {
                ResultSet rs;
                stmt = this.data_repo.createStatement(null);
                int executeUpdate = stmt.executeUpdate("insert into tig_ma_msgs ( type )  VALUES (  \"unsubscribed\"  )", 1);
                if (executeUpdate > 0 && (rs = stmt.getGeneratedKeys()).next()) {
                    int id = rs.getInt(1);
                    stmt.executeUpdate("delete from tig_ma_msgs where msg_id = " + id);
                }
            }
            catch (SQLException ex) {
                alterTable = null;
                log.log(Level.INFO, "altering table tig_ma_msgs extend size of type column");
                try {
                    switch (this.data_repo.getDatabaseType()) {
                        case derby: {
                            alterTable = "alter table tig_ma_msgs ALTER COLUMN type SET DATA TYPE varchar(20)";
                            stmt.execute(alterTable);
                            break;
                        }
                        case mysql: {
                            alterTable = "alter table tig_ma_msgs MODIFY COLUMN type varchar(20);";
                            stmt.execute(alterTable);
                            break;
                        }
                        case postgresql: {
                            alterTable = "alter table tig_ma_msgs ALTER COLUMN type TYPE varchar(20);";
                            stmt.execute(alterTable);
                            break;
                        }
                        case sqlserver: 
                        case jtds: {
                            alterTable = "alter table tig_ma_msgs ALTER COLUMN type varchar(20);";
                            stmt.execute(alterTable);
                        }
                    }
                }
                catch (SQLException ex1) {
                    log.log(Level.SEVERE, "could not alter table tig_ma_msgs to increase type column lenght:\n" + alterTable, ex1);
                }
            }
            this.data_repo.release(stmt, null);
            try {
                stmt = this.data_repo.createStatement(null);
                stmt.executeQuery("select stanza_hash from tig_ma_msgs where owner_id = 0");
            }
            catch (SQLException ex) {
                alterTable = null;
                try {
                    switch (this.data_repo.getDatabaseType()) {
                        case sqlserver: 
                        case jtds: {
                            alterTable = "alter table tig_ma_msgs add stanza_hash varchar(50)";
                            stmt.execute(alterTable);
                            alterTable = "create unique index tig_ma_msgs_owner_id_ts_buddy_id_stanza_hash_index on tig_ma_msgs (owner_id, ts, buddy_id, stanza_hash) WHERE stanza_hash is not null";
                            stmt.execute(alterTable);
                            break;
                        }
                        default: {
                            alterTable = "alter table tig_ma_msgs add stanza_hash varchar(50)";
                            stmt.execute(alterTable);
                            alterTable = "create unique index tig_ma_msgs_owner_id_ts_buddy_id_stanza_hash_index on tig_ma_msgs (owner_id, ts, buddy_id, stanza_hash)";
                            stmt.execute(alterTable);
                            break;
                        }
                    }
                }
                catch (SQLException ex1) {
                    log.log(Level.SEVERE, "could not alter table tig_ma_msgs to add missing column by SQL:\n" + alterTable, ex1);
                }
            }
            this.data_repo.release(stmt, null);
            try {
                stmt = this.data_repo.createStatement(null);
                stmt.executeQuery("select buddy_res from tig_ma_msgs where owner_id = 0");
            }
            catch (SQLException ex) {
                alterTable = null;
                try {
                    switch (this.data_repo.getDatabaseType()) {
                        case sqlserver: 
                        case jtds: {
                            alterTable = "alter table tig_ma_msgs add buddy_res nvarchar(1024)";
                            break;
                        }
                        default: {
                            alterTable = "alter table tig_ma_msgs add buddy_res varchar(1024)";
                        }
                    }
                    stmt.execute(alterTable);
                    switch (this.data_repo.getDatabaseType()) {
                        case mysql: {
                            alterTable = "create index tig_ma_msgs_owner_id_buddy_id_buddy_res_index on tig_ma_msgs (owner_id,buddy_id,buddy_res(255))";
                            break;
                        }
                        case sqlserver: 
                        case jtds: {
                            alterTable = null;
                            break;
                        }
                        default: {
                            alterTable = "create index tig_ma_msgs_owner_id_buddy_id_buddy_res_index on tig_ma_msgs (owner_id,buddy_id,buddy_res)";
                        }
                    }
                    if (alterTable != null) {
                        stmt.execute(alterTable);
                    }
                }
                catch (SQLException ex1) {
                    log.log(Level.SEVERE, "could not alter table tig_ma_msgs to add missing column by SQL:\n" + alterTable, ex1);
                }
            }
            finally {
                this.data_repo.release(stmt, null);
            }
            try {
                stmt = this.data_repo.createStatement(null);
                stmt.executeQuery("select domain from tig_ma_jids where 1 = 0");
            }
            catch (SQLException ex) {
                alterTable = null;
                try {
                    switch (this.data_repo.getDatabaseType()) {
                        case sqlserver: 
                        case jtds: {
                            alterTable = "alter table tig_ma_jids add domain nvarchar(1024)";
                            break;
                        }
                        default: {
                            alterTable = "alter table tig_ma_jids add domain varchar(1024)";
                        }
                    }
                    stmt.execute(alterTable);
                }
                catch (SQLException ex1) {
                    log.log(Level.SEVERE, "could not alter table tig_ma_jids to add missing column by SQL:\n" + alterTable, ex1);
                }
            }
            finally {
                this.data_repo.release(stmt, null);
            }
            try {
                stmt = this.data_repo.createStatement(null);
                ResultSet rs = stmt.executeQuery("select count(jid_id) from tig_ma_jids where domain IS NULL");
                rs.next();
                int count = rs.getInt(1);
                rs.close();
                if (count > 0) {
                    String alterTable2 = null;
                    switch (this.data_repo.getDatabaseType()) {
                        case sqlserver: 
                        case jtds: {
                            alterTable2 = "update tig_ma_jids set domain = SUBSTRING(jid, CHARINDEX('@',jid) + 1, LEN(jid)) WHERE domain IS NULL";
                            break;
                        }
                        case derby: 
                        case mysql: {
                            alterTable2 = "update tig_ma_jids set domain = SUBSTR(jid, LOCATE('@', jid) + 1) WHERE domain IS NULL";
                            break;
                        }
                        case postgresql: {
                            alterTable2 = "update tig_ma_jids set domain = substr(jid, strpos(jid, '@') + 1) WHERE domain IS NULL";
                            break;
                        }
                    }
                    stmt.execute(alterTable2);
                }
            }
            catch (SQLException ex) {
                log.log(Level.SEVERE, "could not update table tig_ma_jids to add missing values for column domain :\n", ex);
            }
            finally {
                this.data_repo.release(stmt, null);
            }
        }
        finally {
            this.data_repo.release(stmt, null);
        }
        String alterTable = "";
        try {
            stmt = this.data_repo.createStatement(null);
            switch (this.data_repo.getDatabaseType()) {
                case mysql: {
                    alterTable = "create index tig_ma_jids_domain_index on tig_ma_jids (domain(255))";
                    break;
                }
                case sqlserver: 
                case jtds: {
                    alterTable = null;
                    break;
                }
                default: {
                    alterTable = "create index tig_ma_jids_domain_index on tig_ma_jids (domain)";
                }
            }
            if (alterTable != null) {
                stmt.execute(alterTable);
            }
            if ((alterTable = "create index tig_ma_msgs_ts_index on tig_ma_msgs (ts)") != null) {
                stmt.execute(alterTable);
            }
            log.log(Level.FINEST, "added missing index timestamp and domain");
        }
        catch (SQLException count) {
        }
        finally {
            this.data_repo.release(stmt, null);
        }
        try {
            String query = "select 1 from tig_ma_jids where tig_ma_jids.jid <> LOWER(tig_ma_jids.jid)";
            stmt = this.data_repo.createStatement(null);
            ResultSet rs = stmt.executeQuery(query);
            if (rs.next()) {
                stmt.executeUpdate("update tig_ma_jids set jid = LOWER(jid), domain = LOWER(domain) where jid <> LOWER(jid) or domain <> LOWER(domain)");
            }
            rs.close();
            log.log(Level.FINEST, "lowercased domain and local part of barejid ");
        }
        catch (SQLException ex1) {
            log.log(Level.SEVERE, "could not update 'jid' and 'domain' with lowercased values", ex1);
        }
        finally {
            this.data_repo.release(stmt, null);
        }
        try {
            if (this.data_repo.getDatabaseType() == DataRepository.dbTypes.mysql) {
                alterTable = "create unique index tig_ma_msgs_owner_id_buddy_id_stanza_hash_index on tig_ma_msgs (owner_id, buddy_id, stanza_hash)";
                stmt = this.data_repo.createStatement(null);
                stmt.execute(alterTable);
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            this.data_repo.release(stmt, null);
        }
        try {
            if (this.data_repo.getDatabaseType() == DataRepository.dbTypes.mysql) {
                stmt = this.data_repo.createStatement(null);
                stmt.execute("create index tig_ma_jids_jid_index on tig_ma_jids (jid(255))");
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            this.data_repo.release(stmt, null);
        }
    }

    @Override
    public void archiveMessage(BareJID owner, JID buddy, MessageArchiveRepository.Direction direction, Date timestamp, Element msg, Set<String> tags) {
        this.archiveMessage(owner, buddy, direction, timestamp, msg, tags, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void archiveMessage(BareJID owner, JID buddy, MessageArchiveRepository.Direction direction, Date timestamp, Element msg, Set<String> tags, Map<String, Object> additionalData) {
        block19: {
            try {
                PreparedStatement add_message_tag_st;
                long owner_id;
                ResultSet rs = null;
                String owner_str = owner.toString();
                String buddy_str = buddy.getBareJID().toString();
                long[] jids_ids = this.getJidsIds(owner_str, buddy_str);
                long l = owner_id = jids_ids[0] != 0L ? jids_ids[0] : this.addJidId(owner);
                long buddy_id = jids_ids[1] != 0L ? jids_ids[1] : (buddy_str.equals(owner_str) ? owner_id : this.addJidId(buddy.getBareJID()));
                Timestamp mtime = new Timestamp(timestamp.getTime());
                msg.addAttribute("time", String.valueOf(mtime.getTime()));
                String type = msg.getAttributeStaticStr(MSGS_TYPE);
                String msgStr = msg.toString();
                String body = this.storePlaintextBody ? msg.getChildCData(MSG_BODY_PATH) : null;
                String hash = this.generateHashOfMessageAsString(direction, msg, mtime, additionalData);
                PreparedStatement add_message_st = this.data_repo.getPreparedStatement(owner, this.ADD_MESSAGE);
                Long msgId = null;
                PreparedStatement preparedStatement = add_message_st;
                synchronized (preparedStatement) {
                    try {
                        int i = 1;
                        add_message_st.setLong(i++, owner_id);
                        add_message_st.setLong(i++, buddy_id);
                        add_message_st.setString(i++, buddy.getResource());
                        add_message_st.setTimestamp(i++, mtime);
                        add_message_st.setShort(i++, direction.getValue());
                        add_message_st.setString(i++, type);
                        add_message_st.setString(i++, body);
                        add_message_st.setString(i++, msgStr);
                        add_message_st.setString(i++, hash);
                        i = this.addMessageAdditionalInfo(add_message_st, i, additionalData);
                        if (this.data_repo.getDatabaseType() != DataRepository.dbTypes.mysql) {
                            add_message_st.setLong(i++, owner_id);
                            add_message_st.setLong(i++, buddy_id);
                            if ("groupchat".equals(type)) {
                                add_message_st.setTimestamp(i++, new Timestamp(mtime.getTime() - 1800000L));
                                add_message_st.setTimestamp(i++, new Timestamp(mtime.getTime() + 1800000L));
                            } else {
                                add_message_st.setTimestamp(i++, mtime);
                                add_message_st.setTimestamp(i++, mtime);
                            }
                            add_message_st.setString(i++, hash);
                        }
                        add_message_st.executeUpdate();
                        if (tags != null && (rs = add_message_st.getGeneratedKeys()).next()) {
                            switch (this.data_repo.getDatabaseType()) {
                                case postgresql: {
                                    msgId = rs.getLong(MSGS_ID);
                                    break;
                                }
                                default: {
                                    msgId = rs.getLong(1);
                                }
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        this.data_repo.release(null, rs);
                        throw throwable;
                    }
                    this.data_repo.release(null, rs);
                }
                if (msgId == null) {
                    return;
                }
                if (tags == null || tags.isEmpty()) break block19;
                Map<String, Long> tagsMap = this.ensureTags(owner, owner_id, tags);
                PreparedStatement preparedStatement2 = add_message_tag_st = this.data_repo.getPreparedStatement(owner, ADD_MESSAGE_TAG);
                synchronized (preparedStatement2) {
                    for (Long tagId : tagsMap.values()) {
                        add_message_tag_st.setLong(1, msgId);
                        add_message_tag_st.setLong(2, tagId);
                        add_message_tag_st.addBatch();
                    }
                    add_message_tag_st.executeBatch();
                }
            }
            catch (SQLException ex) {
                log.log(Level.WARNING, "Problem adding new entry to DB: " + msg, ex);
            }
        }
    }

    protected int addMessageAdditionalInfo(PreparedStatement stmt, int i, Map<String, Object> additionalData) throws SQLException {
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteExpiredMessages(BareJID owner, LocalDateTime before) throws TigaseDBException {
        try {
            PreparedStatement delete_expired_msgs_st = this.data_repo.getPreparedStatement(owner, DELETE_EXPIRED_MSGS);
            long timestamp_long = before.toEpochSecond(ZoneOffset.UTC) * 1000L;
            Timestamp ts = new Timestamp(timestamp_long);
            PreparedStatement preparedStatement = delete_expired_msgs_st;
            synchronized (preparedStatement) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "executing removal of expired messages for domain {0} with timeout set to {1} seconds", new Object[]{owner, this.delete_expired_timeout});
                }
                delete_expired_msgs_st.setQueryTimeout(this.delete_expired_timeout);
                delete_expired_msgs_st.setTimestamp(1, ts);
                delete_expired_msgs_st.setString(2, owner.toString().toLowerCase());
                delete_expired_msgs_st.executeUpdate();
            }
        }
        catch (SQLException ex) {
            throw new TigaseDBException("Could not remove expired messages", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Long> ensureTags(BareJID owner, long owner_id, Set<String> tags) throws SQLException {
        PreparedStatement preparedStatement;
        HashMap<String, Long> tagsMap = new HashMap<String, Long>();
        ResultSet rs = null;
        Iterator<String> it = tags.iterator();
        int iters = tags.size() / 5 + 1;
        for (int i = 0; i < iters; ++i) {
            PreparedStatement get_tag_ids_st;
            int params = i == iters - 1 ? tags.size() % 5 : 5;
            preparedStatement = get_tag_ids_st = this.data_repo.getPreparedStatement(owner, "select tag_id, tag from tig_ma_tags WHERE owner_id = ? AND ( _" + params);
            synchronized (preparedStatement) {
                try {
                    get_tag_ids_st.setLong(1, owner_id);
                    for (int j = 0; j < params; ++j) {
                        String tag = it.next();
                        get_tag_ids_st.setString(j + 2, tag);
                    }
                    rs = get_tag_ids_st.executeQuery();
                    while (rs.next()) {
                        long id = rs.getLong(1);
                        String tag = rs.getString(2);
                        tagsMap.put(tag, id);
                    }
                }
                catch (Throwable throwable) {
                    this.data_repo.release(null, rs);
                    throw throwable;
                }
                this.data_repo.release(null, rs);
                rs = null;
                continue;
            }
        }
        if (tagsMap.size() < tags.size()) {
            PreparedStatement add_tag_st = this.data_repo.getPreparedStatement(owner, ADD_TAG);
            for (String tag : tags) {
                if (tagsMap.containsKey(tag)) continue;
                preparedStatement = add_tag_st;
                synchronized (preparedStatement) {
                    try {
                        add_tag_st.setLong(1, owner_id);
                        add_tag_st.setString(2, tag);
                        add_tag_st.executeUpdate();
                        rs = add_tag_st.getGeneratedKeys();
                        if (rs.next()) {
                            tagsMap.put(tag, rs.getLong(1));
                        }
                    }
                    finally {
                        this.data_repo.release(null, rs);
                    }
                    rs = null;
                }
            }
        }
        return tagsMap;
    }

    @Override
    public List<Element> getCollections(BareJID owner, Criteria crit) throws TigaseDBException {
        try {
            Integer count;
            long[] jids_ids = crit.getWith() == null ? this.getJidsIds(owner.toString()) : this.getJidsIds(owner.toString(), crit.getWith());
            crit.setOwnerId(jids_ids[0]);
            if (jids_ids.length > 1) {
                crit.setBuddyId(jids_ids[1]);
            }
            if ((count = this.getCollectionsCount(owner, crit)) == null) {
                count = 0;
            }
            crit.setSize(count);
            List<Element> results = this.getCollectionsItems(owner, crit);
            RSM rsm = crit.getRSM();
            rsm.setResults(count, Integer.valueOf(crit.getOffset()));
            if (!results.isEmpty()) {
                rsm.setFirst(String.valueOf(crit.getOffset()));
                rsm.setLast(String.valueOf(crit.getOffset() + (results.size() - 1)));
            }
            return results;
        }
        catch (SQLException ex) {
            throw new TigaseDBException("Cound not retrieve collections", (Throwable)ex);
        }
    }

    @Override
    public List<Element> getItems(BareJID owner, Criteria crit) throws TigaseDBException {
        try {
            Integer count;
            long[] jids_ids = crit.getWith() != null ? this.getJidsIds(owner.toString(), crit.getWith()) : this.getJidsIds(owner.toString());
            crit.setOwnerId(jids_ids[0]);
            if (jids_ids.length > 1) {
                crit.setBuddyId(jids_ids[1]);
            }
            if ((count = this.getItemsCount(owner, crit)) == null) {
                count = 0;
            }
            crit.setSize(count);
            List<Element> items = this.getItemsItems(owner, crit);
            RSM rsm = crit.getRSM();
            rsm.setResults(count, Integer.valueOf(crit.getOffset()));
            if (items != null && !items.isEmpty()) {
                rsm.setFirst(String.valueOf(crit.getOffset()));
                rsm.setLast(String.valueOf(crit.getOffset() + (items.size() - 1)));
            }
            return items;
        }
        catch (SQLException ex) {
            throw new TigaseDBException("Cound not retrieve items", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeItems(BareJID owner, String withJid, Date start, Date end) throws TigaseDBException {
        try {
            PreparedStatement remove_msgs_st;
            long[] jids_ids = this.getJidsIds(owner.toString(), withJid);
            if (start == null) {
                start = new Date(0L);
            }
            if (end == null) {
                end = new Date(0L);
            }
            Timestamp start_ = new Timestamp(start.getTime());
            Timestamp end_ = new Timestamp(end.getTime());
            PreparedStatement preparedStatement = remove_msgs_st = this.data_repo.getPreparedStatement(owner, REMOVE_MSGS);
            synchronized (preparedStatement) {
                PreparedStatement preparedStatement2 = remove_msgs_st;
                synchronized (preparedStatement2) {
                    remove_msgs_st.setLong(1, jids_ids[0]);
                    remove_msgs_st.setLong(2, jids_ids[1]);
                    remove_msgs_st.setTimestamp(3, end_);
                    remove_msgs_st.setTimestamp(4, start_);
                    remove_msgs_st.executeUpdate();
                }
            }
        }
        catch (SQLException ex) {
            throw new TigaseDBException("Cound not remove items", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getTags(BareJID owner, String startsWith, Criteria crit) throws TigaseDBException {
        ArrayList<String> results = new ArrayList<String>();
        try {
            PreparedStatement get_tags_st;
            PreparedStatement get_tags_count_st;
            ResultSet rs = null;
            int count = 0;
            startsWith = startsWith + "%";
            PreparedStatement preparedStatement = get_tags_count_st = this.data_repo.getPreparedStatement(owner, GET_TAGS_FOR_USER_COUNT);
            synchronized (preparedStatement) {
                try {
                    get_tags_count_st.setString(1, owner.toString().toLowerCase());
                    get_tags_count_st.setString(2, startsWith);
                    rs = get_tags_count_st.executeQuery();
                    if (rs.next()) {
                        count = rs.getInt(1);
                    }
                }
                catch (Throwable throwable) {
                    this.data_repo.release(null, rs);
                    throw throwable;
                }
                this.data_repo.release(null, rs);
            }
            crit.setSize(count);
            PreparedStatement preparedStatement2 = get_tags_st = this.data_repo.getPreparedStatement(owner, GET_TAGS_FOR_USER);
            synchronized (preparedStatement2) {
                try {
                    int i = 1;
                    get_tags_st.setString(i++, owner.toString().toLowerCase());
                    get_tags_st.setString(i++, startsWith);
                    switch (this.data_repo.getDatabaseType()) {
                        case derby: {
                            get_tags_st.setInt(i++, crit.getOffset());
                            get_tags_st.setInt(i++, crit.getLimit());
                            break;
                        }
                        case sqlserver: 
                        case jtds: {
                            get_tags_st.setInt(i++, crit.getOffset());
                            get_tags_st.setInt(i++, crit.getOffset() + crit.getLimit());
                            break;
                        }
                        default: {
                            get_tags_st.setInt(i++, crit.getLimit());
                            get_tags_st.setInt(i++, crit.getOffset());
                        }
                    }
                    rs = get_tags_st.executeQuery();
                    while (rs.next()) {
                        results.add(rs.getString(1));
                    }
                }
                finally {
                    this.data_repo.release(null, rs);
                }
            }
            RSM rsm = crit.getRSM();
            rsm.setResults(Integer.valueOf(count), Integer.valueOf(crit.getOffset()));
            if (results != null && !results.isEmpty()) {
                rsm.setFirst(String.valueOf(crit.getOffset()));
                rsm.setLast(String.valueOf(crit.getOffset() + (results.size() - 1)));
            }
        }
        catch (SQLException ex) {
            throw new TigaseDBException("Could not retrieve known tags from database", (Throwable)ex);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Element> getCollectionsItems(BareJID owner, Criteria crit) throws SQLException {
        LinkedList<Element> results = new LinkedList<Element>();
        ResultSet selectRs = null;
        PreparedStatement get_collections_st = this.data_repo.getPreparedStatement(owner, "GET_COLLECTIONS_" + crit.getQueryName() + "_SELECT");
        int i = 2;
        PreparedStatement preparedStatement = get_collections_st;
        synchronized (preparedStatement) {
            try {
                crit.setItemsQueryParams(get_collections_st, this.data_repo.getDatabaseType());
                selectRs = get_collections_st.executeQuery();
                while (selectRs.next()) {
                    Timestamp startTs = selectRs.getTimestamp(1);
                    String with = selectRs.getString(2);
                    String type = null;
                    if (this.groupByType) {
                        type = selectRs.getString(3);
                    }
                    this.addCollectionToResults(results, crit, with, startTs, type);
                }
            }
            catch (Throwable throwable) {
                this.data_repo.release(null, selectRs);
                throw throwable;
            }
            this.data_repo.release(null, selectRs);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer getCollectionsCount(BareJID owner, Criteria crit) throws SQLException {
        ResultSet countRs = null;
        Integer count = null;
        PreparedStatement get_collections_count = this.data_repo.getPreparedStatement(owner, "GET_COLLECTIONS_" + crit.getQueryName() + "_COUNT");
        int i = 2;
        PreparedStatement preparedStatement = get_collections_count;
        synchronized (preparedStatement) {
            try {
                crit.setCountQueryParams(get_collections_count, this.data_repo.getDatabaseType());
                countRs = get_collections_count.executeQuery();
                if (countRs.next()) {
                    count = countRs.getInt(1);
                }
            }
            catch (Throwable throwable) {
                this.data_repo.release(null, countRs);
                throw throwable;
            }
            this.data_repo.release(null, countRs);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Element> getItemsItems(BareJID owner, Criteria crit) throws SQLException {
        PreparedStatement get_messages_st;
        ResultSet rs = null;
        ArrayDeque<Item> results = new ArrayDeque<Item>();
        boolean i = true;
        boolean containsWith = crit.getQueryName().contains("WITH");
        PreparedStatement preparedStatement = get_messages_st = this.data_repo.getPreparedStatement(owner, "GET_MESSAGES_" + crit.getQueryName() + "_SELECT");
        synchronized (preparedStatement) {
            try {
                crit.setItemsQueryParams(get_messages_st, this.data_repo.getDatabaseType());
                rs = get_messages_st.executeQuery();
                while (rs.next()) {
                    Item item = this.newItemInstance();
                    item.read(rs, crit, containsWith);
                    results.offer(item);
                }
            }
            catch (Throwable throwable) {
                this.data_repo.release(null, rs);
                throw throwable;
            }
            this.data_repo.release(null, rs);
        }
        LinkedList<Element> msgs = new LinkedList<Element>();
        if (!results.isEmpty()) {
            DomBuilderHandler domHandler = new DomBuilderHandler();
            Object startTimestamp = crit.getStart();
            Item item = null;
            while ((item = (Item)results.poll()) != null) {
                if (startTimestamp == null) {
                    startTimestamp = item.timestamp;
                }
                parser.parse((SimpleHandler)domHandler, item.message.toCharArray(), 0, item.message.length());
                Queue queue = domHandler.getParsedElements();
                Element msg = null;
                while ((msg = (Element)queue.poll()) != null) {
                    this.addMessageToResults((List<Element>)msgs, crit, (Date)startTimestamp, item, msg);
                }
            }
            crit.setStart((Date)startTimestamp);
        }
        return msgs;
    }

    protected Element addMessageToResults(List<Element> msgs, Criteria crit, Date startTimestamp, Item item, Element msg) {
        return this.addMessageToResults(msgs, crit, startTimestamp, msg, item.timestamp, item.direction, item.with);
    }

    protected Item newItemInstance() {
        return new Item();
    }

    protected List<String> getMessageFields(String combination) {
        ArrayList<String> fields = new ArrayList<String>();
        fields.addAll(Arrays.asList(GET_MESSAGE_FIELDS));
        if (!combination.contains("WITH")) {
            fields.add(JIDS_JID);
        }
        return fields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer getItemsCount(BareJID owner, Criteria crit) throws SQLException {
        PreparedStatement get_messages_st;
        Integer count = null;
        ResultSet rs = null;
        PreparedStatement preparedStatement = get_messages_st = this.data_repo.getPreparedStatement(owner, "GET_MESSAGES_" + crit.getQueryName() + "_COUNT");
        synchronized (preparedStatement) {
            try {
                crit.setCountQueryParams(get_messages_st, this.data_repo.getDatabaseType());
                rs = get_messages_st.executeQuery();
                if (rs.next()) {
                    count = rs.getInt(1);
                }
            }
            catch (Throwable throwable) {
                this.data_repo.release(null, rs);
                throw throwable;
            }
            this.data_repo.release(null, rs);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected long[] getJidsIds(String ... jids) throws SQLException {
        PreparedStatement get_jids_id_st;
        ResultSet rs = null;
        long[] results = new long[jids.length];
        Arrays.fill(results, 0L);
        if (jids.length == 1) {
            PreparedStatement get_jid_id_st;
            PreparedStatement preparedStatement = get_jid_id_st = this.data_repo.getPreparedStatement(null, GET_JID_ID_QUERY);
            synchronized (preparedStatement) {
                block12: {
                    long[] lArray;
                    try {
                        get_jid_id_st.setString(1, jids[0].toLowerCase());
                        rs = get_jid_id_st.executeQuery();
                        if (!rs.next()) break block12;
                        results[0] = rs.getLong(JIDS_ID);
                        lArray = results;
                    }
                    catch (Throwable throwable) {
                        this.data_repo.release(null, rs);
                        throw throwable;
                    }
                    this.data_repo.release(null, rs);
                    return lArray;
                }
                this.data_repo.release(null, rs);
                return results;
            }
        }
        PreparedStatement preparedStatement = get_jids_id_st = this.data_repo.getPreparedStatement(null, GET_JID_IDS_QUERY);
        synchronized (preparedStatement) {
            try {
                for (int i = 0; i < jids.length; ++i) {
                    get_jids_id_st.setString(i + 1, jids[i].toLowerCase());
                }
                rs = get_jids_id_st.executeQuery();
                int cnt = 0;
                while (rs.next()) {
                    String db_jid = rs.getString(JIDS_JID);
                    for (int i = 0; i < jids.length; ++i) {
                        if (!db_jid.equalsIgnoreCase(jids[i])) continue;
                        results[i] = rs.getLong(JIDS_ID);
                        ++cnt;
                    }
                }
            }
            catch (Throwable throwable) {
                this.data_repo.release(null, rs);
                throw throwable;
            }
            this.data_repo.release(null, rs);
            return results;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long addJidId(BareJID jid) throws SQLException {
        PreparedStatement add_jid_st = this.data_repo.getPreparedStatement(null, ADD_JID_QUERY);
        try {
            PreparedStatement preparedStatement = add_jid_st;
            synchronized (preparedStatement) {
                add_jid_st.setString(1, jid.toString().toLowerCase());
                add_jid_st.setString(2, jid.getDomain().toLowerCase());
                add_jid_st.executeUpdate();
            }
        }
        catch (SQLException ex) {
            log.log(Level.FINEST, "Exception adding jid to tig_ma_jids table, it may occur if other thread added this jid in the meantime", ex);
        }
        long[] jid_ids = this.getJidsIds(jid.toString());
        if (jid_ids != null) {
            return jid_ids[0];
        }
        log.log(Level.WARNING, "I have just added new jid but it was not found.... {0}", jid);
        return 0L;
    }

    private String generateHashOfMessageAsString(MessageArchiveRepository.Direction direction, Element msg, Date ts, Map<String, Object> additionalData) {
        byte[] result = this.generateHashOfMessage(direction, msg, ts, additionalData);
        return result != null ? Base64.encode((byte[])result) : null;
    }

    @Override
    public AbstractCriteria newCriteriaInstance() {
        return new Criteria();
    }

    public static class Criteria
    extends AbstractCriteria<Timestamp> {
        private long ownerId;
        private long buddyId;
        protected String queryName;

        @Override
        protected Timestamp convertTimestamp(Date date) {
            if (date == null) {
                return null;
            }
            return new Timestamp(date.getTime());
        }

        public String getQueryName() {
            if (this.queryName == null) {
                return this.updateQueryName();
            }
            return this.queryName;
        }

        public String updateQueryName() {
            StringBuilder query = new StringBuilder(20);
            if (this.getStart() != null) {
                query.append("FROM");
            }
            if (this.getEnd() != null) {
                if (query.length() > 0) {
                    query.append("_");
                }
                query.append("TO");
            }
            if (this.getWith() != null) {
                if (query.length() > 0) {
                    query.append("_");
                }
                query.append("WITH");
            }
            if (!this.getTags().isEmpty()) {
                if (query.length() > 0) {
                    query.append("_");
                }
                query.append("TAGS[").append(this.getTags().size()).append("]");
            }
            if (!this.getContains().isEmpty()) {
                if (query.length() > 0) {
                    query.append("_");
                }
                query.append("CONTAINS[").append(this.getContains().size()).append("]");
            }
            this.queryName = query.toString();
            return this.queryName;
        }

        public void setOwnerId(Long id) {
            this.ownerId = id == null ? 0L : id;
        }

        public void setBuddyId(Long id) {
            this.buddyId = id == null ? 0L : id;
        }

        public int setCountQueryParams(PreparedStatement stmt, DataRepository.dbTypes dbType) throws SQLException {
            int i = 1;
            stmt.setLong(i++, this.ownerId);
            return this.setCountQueryParams(stmt, dbType, i);
        }

        protected int setCountQueryParams(PreparedStatement stmt, DataRepository.dbTypes dbType, int i) throws SQLException {
            if (this.getStart() != null) {
                stmt.setTimestamp(i++, (Timestamp)this.getStart());
            }
            if (this.getEnd() != null) {
                stmt.setTimestamp(i++, (Timestamp)this.getEnd());
            }
            if (this.getWith() != null) {
                stmt.setLong(i++, this.buddyId);
            }
            for (String tag : this.getTags()) {
                stmt.setString(i++, tag);
            }
            for (String contains : this.getContains()) {
                stmt.setString(i++, "%" + contains + "%");
            }
            return i;
        }

        public void setItemsQueryParams(PreparedStatement stmt, DataRepository.dbTypes dbType) throws SQLException {
            int i = this.setCountQueryParams(stmt, dbType);
            switch (dbType) {
                case derby: {
                    stmt.setInt(i++, this.getOffset());
                    stmt.setInt(i++, this.getLimit());
                    break;
                }
                case sqlserver: 
                case jtds: {
                    stmt.setInt(i++, this.getOffset());
                    stmt.setInt(i++, this.getOffset() + this.getLimit());
                    break;
                }
                default: {
                    stmt.setInt(i++, this.getLimit());
                    stmt.setInt(i++, this.getOffset());
                }
            }
        }
    }

    public static class Item<Crit extends Criteria> {
        String message;
        Date timestamp;
        MessageArchiveRepository.Direction direction;
        String with;

        protected int read(ResultSet rs, Crit crit, boolean containsWith) throws SQLException {
            int i = 1;
            this.message = rs.getString(i++);
            this.timestamp = rs.getTimestamp(i++);
            this.direction = MessageArchiveRepository.Direction.getDirection(rs.getShort(i++));
            if (!containsWith) {
                this.with = rs.getString(i++);
            }
            return i;
        }
    }
}

