/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.cluster.strategy;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.cluster.strategy.ConnectionRecord;
import tigase.server.Packet;
import tigase.server.cluster.strategy.ConnectionRecordExt;
import tigase.sys.OnlineJidsReporter;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;

public class ClusteringMetadata
implements OnlineJidsReporter {
    private static final Logger a = Logger.getLogger(ClusteringMetadata.class.getName());
    private volatile int b = 0;
    private volatile int c = 0;
    protected final Map<BareJID, Map<JID, ConnectionRecordExt>> userConnections = new ConcurrentSkipListMap<BareJID, Map<JID, ConnectionRecordExt>>();
    private boolean d = false;

    public long connectionsSize() {
        return this.b;
    }

    public boolean containsJid(BareJID jid) {
        return this.userConnections.containsKey(jid);
    }

    public boolean containsJidLocally(BareJID jid) {
        return false;
    }

    public boolean containsJidLocally(JID jid) {
        return false;
    }

    public long mapSize() {
        return this.c;
    }

    public boolean needsSync() {
        return !this.d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllForNode(JID node) {
        if (a.isLoggable(Level.FINEST)) {
            a.log(Level.FINEST, "Removing connections from cache for node: {0}", node);
        }
        Iterator<Map<JID, ConnectionRecordExt>> iterator = this.userConnections.values().iterator();
        while (iterator.hasNext()) {
            Map<JID, ConnectionRecordExt> map;
            Map<JID, ConnectionRecordExt> map2 = map = iterator.next();
            synchronized (map2) {
                Iterator<Map.Entry<JID, ConnectionRecordExt>> iterator2 = map.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry<JID, ConnectionRecordExt> entry = iterator2.next();
                    if (node.equals((Object)entry.getValue().getNode())) {
                        iterator2.remove();
                        --this.b;
                        if (!a.isLoggable(Level.FINEST)) continue;
                        a.log(Level.FINEST, "Removed connection: {0}", (Object)entry.getValue());
                        continue;
                    }
                    if (!a.isLoggable(Level.FINEST)) continue;
                    a.log(Level.FINEST, "Different node: {0}", (Object)entry.getValue());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void userDisconnected(Queue<Packet> results, ConnectionRecordExt rec) {
        Map<JID, ConnectionRecordExt> map = this.userConnections.get(rec.getUserJid().getBareJID());
        if (map != null) {
            Map<JID, ConnectionRecordExt> map2 = map;
            synchronized (map2) {
                if (map.remove(rec.getConnectionId()) != null) {
                    --this.b;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void usersConnected(Queue<Packet> results, ConnectionRecordExt ... recs) {
        for (ConnectionRecordExt connectionRecordExt : recs) {
            Map<JID, ConnectionRecordExt> map;
            Map<Object, Object> map2 = this.userConnections;
            synchronized (map2) {
                map = this.userConnections.get(connectionRecordExt.getUserJid().getBareJID());
                if (map == null) {
                    map = new LinkedHashMap<JID, ConnectionRecordExt>(2);
                    this.userConnections.put(connectionRecordExt.getUserJid().getBareJID(), map);
                    ++this.c;
                }
            }
            map2 = map;
            synchronized (map2) {
                if (map.put(connectionRecordExt.getConnectionId(), connectionRecordExt) == null) {
                    ++this.b;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JID[] getConnectionIdsForJid(BareJID jid) {
        JID[] jIDArray = null;
        Map<JID, ConnectionRecordExt> map = this.userConnections.get(jid);
        if (map != null) {
            Map<JID, ConnectionRecordExt> map2 = map;
            synchronized (map2) {
                int n = map.size();
                if (n > 0) {
                    jIDArray = map.keySet().toArray(new JID[n]);
                }
            }
        }
        return jIDArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionRecordExt getConnectionRecord(JID jid) {
        ConnectionRecordExt connectionRecordExt = null;
        Map<JID, ConnectionRecordExt> map = this.userConnections.get(jid.getBareJID());
        if (map != null) {
            Map<JID, ConnectionRecordExt> map2 = map;
            synchronized (map2) {
                for (ConnectionRecordExt connectionRecordExt2 : map.values()) {
                    if (!jid.equals((Object)connectionRecordExt2.getUserJid())) continue;
                    connectionRecordExt = connectionRecordExt2;
                    break;
                }
            }
        }
        return connectionRecordExt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ConnectionRecordExt> getConnectionRecords(BareJID bareJID) {
        LinkedHashSet<ConnectionRecordExt> linkedHashSet = null;
        Map<JID, ConnectionRecordExt> map = this.userConnections.get(bareJID);
        if (map != null) {
            Map<JID, ConnectionRecordExt> map2 = map;
            synchronized (map2) {
                linkedHashSet = new LinkedHashSet<ConnectionRecordExt>(map.values());
            }
        }
        return linkedHashSet;
    }

    public Object getInternalData() {
        return this.userConnections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<JID> getNodesForJid(JID jid) {
        ArrayList<JID> arrayList = null;
        Map<JID, ConnectionRecordExt> map = this.userConnections.get(jid.getBareJID());
        if (map != null) {
            Map<JID, ConnectionRecordExt> map2 = map;
            synchronized (map2) {
                int n = map.size();
                if (n > 0) {
                    arrayList = new ArrayList<JID>(n);
                    for (ConnectionRecord connectionRecord : map.values()) {
                        if (arrayList.contains(connectionRecord.getNode())) continue;
                        arrayList.add(connectionRecord.getNode());
                    }
                }
            }
        }
        return arrayList;
    }

    public boolean hasCompleteJidsInfo() {
        return this.d;
    }
}

