/*
 * Decompiled with CFR 0.152.
 */
package tigase.util;

import java.util.concurrent.ScheduledFuture;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class TimerTask
implements Runnable {
    private ScheduledFuture<?> future = null;
    private static final Logger log = Logger.getLogger(TimerTask.class.getName());

    public void setScheduledFuture(ScheduledFuture<?> future) {
        this.future = future;
    }

    public boolean isScheduled() {
        return this.future != null && !this.future.isCancelled() && !this.future.isDone();
    }

    public void cancel() {
        this.cancel(false);
    }

    public void cancel(boolean mayInterruptIfRunning) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Cancelling tigase task, mayInterruptIfRunning: {0}, done: {1}, cancelled: {2}, future: {3}", new Object[]{mayInterruptIfRunning, this.future.isDone(), this.future.isCancelled(), this.future});
        }
        if (this.future != null && !this.future.isDone()) {
            this.future.cancel(mayInterruptIfRunning);
        }
    }
}

