/*
 * Decompiled with CFR 0.152.
 */
package tigase.util;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.logging.Logger;

@Deprecated
public abstract class JDBCAbstract {
    private static final Logger log = Logger.getLogger(JDBCAbstract.class.getName());
    public static final String SP_STARTS_WITH = "{ call";
    public static final String DERBY_CONNVALID_QUERY = "values 1";
    public static final String JDBC_CONNVALID_QUERY = "select 1";
    private Connection conn = null;
    private PreparedStatement conn_valid_st = null;
    private long connectionValidateInterval = 60000L;
    private String db_conn = null;
    private long lastConnectionValidated = 0L;
    private boolean derby_mode = false;

    public abstract void initRepository(String var1, Map<String, String> var2) throws SQLException;

    public String getResourceUri() {
        return this.db_conn;
    }

    public CallableStatement prepareCallable(String query) throws SQLException {
        return this.conn.prepareCall(query);
    }

    public PreparedStatement prepareQuery(String query) throws SQLException {
        if (query.startsWith(SP_STARTS_WITH)) {
            return this.conn.prepareCall(query);
        }
        return this.conn.prepareStatement(query);
    }

    public PreparedStatement prepareStatement(String query) throws SQLException {
        return this.conn.prepareStatement(query);
    }

    public void setResourceUri(String uri) {
        this.db_conn = uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkConnection() throws SQLException {
        try {
            PreparedStatement preparedStatement = this.conn_valid_st;
            synchronized (preparedStatement) {
                long tmp = System.currentTimeMillis();
                if (tmp - this.lastConnectionValidated >= this.connectionValidateInterval) {
                    this.conn_valid_st.executeQuery();
                    this.lastConnectionValidated = tmp;
                }
            }
        }
        catch (Exception e) {
            this.initRepo();
        }
        return true;
    }

    protected void initPreparedStatements() throws SQLException {
        String query = this.derby_mode ? DERBY_CONNVALID_QUERY : JDBC_CONNVALID_QUERY;
        this.conn_valid_st = this.conn.prepareStatement(query);
    }

    protected void release(Statement stmt, ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initRepo() throws SQLException {
        String string = this.db_conn;
        synchronized (string) {
            this.derby_mode = this.db_conn.startsWith("jdbc:derby");
            this.conn = DriverManager.getConnection(this.db_conn);
            this.conn.setAutoCommit(true);
            this.initPreparedStatements();
        }
    }
}

