/*
 * Decompiled with CFR 0.152.
 */
package tigase.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.xmpp.JID;

public class DataTypes {
    public static final Map<String, Character> typesMap = new LinkedHashMap<String, Character>();
    private static final Logger log = Logger.getLogger(DataTypes.class.getName());

    public static <T extends Number> T parseNum(String num, Class<T> cls, T def) {
        if (num == null) {
            return def;
        }
        Object result = def;
        String toParse = num;
        Long multiplier = 1L;
        try {
            switch (num.charAt(num.length() - 1)) {
                case 'K': 
                case 'k': {
                    multiplier = 1024L;
                    toParse = num.substring(0, num.length() - 1);
                    break;
                }
                case 'M': 
                case 'm': {
                    multiplier = 0x100000L;
                    toParse = num.substring(0, num.length() - 1);
                    break;
                }
                case 'G': 
                case 'g': {
                    multiplier = 0x40000000L;
                    toParse = num.substring(0, num.length() - 1);
                }
            }
            if (cls.equals(Integer.class)) {
                result = (Number)cls.cast(Integer.valueOf(toParse) * multiplier.intValue());
            } else if (cls.equals(Long.class)) {
                result = (Number)cls.cast(Long.valueOf(toParse) * multiplier);
            } else if (cls.equals(Double.class)) {
                result = (Number)cls.cast(Double.valueOf(toParse) * multiplier.doubleValue());
            } else if (cls.equals(Float.class)) {
                result = (Number)cls.cast(Float.valueOf(Float.valueOf(toParse).floatValue() * multiplier.floatValue()));
            } else if (cls.equals(Byte.class)) {
                Integer res = Byte.valueOf(toParse) * multiplier.byteValue();
                result = (Number)cls.cast(res.byteValue());
            } else if (cls.equals(Short.class)) {
                Integer res = Short.valueOf(toParse) * multiplier.shortValue();
                result = (Number)cls.cast(res.shortValue());
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Error parsing value: {0} as {1}, using default: {2}", new Object[]{num, cls, def});
            return def;
        }
        return result;
    }

    public static int parseSizeInt(String size, int def) {
        return DataTypes.parseNum(size, Integer.class, def);
    }

    public static boolean parseBool(String val) {
        return val != null && (val.equalsIgnoreCase("yes") || val.equalsIgnoreCase("true") || val.equalsIgnoreCase("on") || val.equals("1"));
    }

    public static Object decodeValueType(char typeId, String value) throws IllegalArgumentException {
        Object[] result = value.trim();
        try {
            switch (typeId) {
                case 'L': {
                    result = Long.decode(value.trim());
                    break;
                }
                case 'I': {
                    result = Integer.decode(value.trim());
                    break;
                }
                case 'B': {
                    result = DataTypes.parseBool(value.trim());
                    break;
                }
                case 'F': {
                    result = Float.valueOf(Float.parseFloat(value.trim()));
                    break;
                }
                case 'D': {
                    result = Double.parseDouble(value.trim());
                    break;
                }
                case 'J': {
                    result = JID.jidInstance(value);
                    break;
                }
                case 's': {
                    String[] s_str = value.split(",");
                    String[] trimed_str = new String[s_str.length];
                    int si = 0;
                    for (String s : s_str) {
                        trimed_str[si++] = s.trim();
                    }
                    result = trimed_str;
                    break;
                }
                case 'l': {
                    String[] longs_str = value.split(",");
                    long[] longs = new long[longs_str.length];
                    int l = 0;
                    for (String s : longs_str) {
                        longs[l++] = Long.parseLong(s.trim());
                    }
                    result = longs;
                    break;
                }
                case 'i': {
                    String[] ints_str = value.split(",");
                    int[] ints = new int[ints_str.length];
                    int i = 0;
                    for (String s : ints_str) {
                        ints[i++] = Integer.parseInt(s.trim());
                    }
                    result = ints;
                    break;
                }
                case 'b': {
                    String[] bools_str = value.split(",");
                    boolean[] bools = new boolean[bools_str.length];
                    int b = 0;
                    for (String s : bools_str) {
                        bools[b++] = DataTypes.parseBool(s.trim());
                    }
                    result = bools;
                    break;
                }
                case 'f': {
                    String[] float_str = value.split(",");
                    float[] floats = new float[float_str.length];
                    int f = 0;
                    for (String s : float_str) {
                        floats[f++] = Float.parseFloat(s.trim());
                    }
                    result = floats;
                    break;
                }
                case 'd': {
                    String[] doubles_str = value.split(",");
                    double[] doubles = new double[doubles_str.length];
                    int d = 0;
                    for (String s : doubles_str) {
                        doubles[d++] = Double.parseDouble(s.trim());
                    }
                    result = doubles;
                    break;
                }
                case 'j': {
                    String[] jids_str = value.split(",");
                    JID[] jids = new JID[jids_str.length];
                    int j = 0;
                    for (String s : jids_str) {
                        jids[j++] = JID.jidInstance(s);
                    }
                    result = jids;
                    break;
                }
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        return result;
    }

    public static String valueToString(Object value) {
        if (value == null) {
            return "<null>";
        }
        if (value.getClass().isArray()) {
            if (Array.getLength(value) == 0) {
                return "";
            }
            String varr = null;
            char t = DataTypes.getTypeId(value);
            switch (t) {
                case 'l': {
                    varr = value instanceof long[] ? Arrays.toString((long[])value) : Arrays.toString((Object[])((Long[])value));
                    break;
                }
                case 'i': {
                    varr = value instanceof int[] ? Arrays.toString((int[])value) : Arrays.toString((Object[])((Integer[])value));
                    break;
                }
                case 'b': {
                    varr = value instanceof boolean[] ? Arrays.toString((boolean[])value) : Arrays.toString((Object[])((Boolean[])value));
                    break;
                }
                case 'f': {
                    varr = value instanceof float[] ? Arrays.toString((float[])value) : Arrays.toString((Object[])((Float[])value));
                    break;
                }
                case 'd': {
                    varr = value instanceof double[] ? Arrays.toString((double[])value) : Arrays.toString((Object[])((Double[])value));
                    break;
                }
                default: {
                    varr = Arrays.toString((Object[])value);
                }
            }
            return varr.substring(1, varr.length() - 1);
        }
        return value.toString();
    }

    public static char decodeTypeIdFromName(String name) {
        char result = 'S';
        if (name.endsWith("]")) {
            result = name.charAt(name.length() - 2);
        }
        return result;
    }

    public static String stripNameFromTypeId(String name) {
        if (name.endsWith("]")) {
            return name.substring(0, name.length() - 3);
        }
        return name;
    }

    public static String encodeTypeIdInName(String name, Object value) {
        char t = DataTypes.getTypeId(value);
        return name + "[" + t + "]";
    }

    public static char getTypeId(Object instance) {
        Character result = instance == null ? Character.valueOf('S') : typesMap.get(instance.getClass().getName());
        if (result == null) {
            result = Character.valueOf('S');
        }
        return result.charValue();
    }

    public static boolean getProperty(String key, Boolean def) {
        String val = System.getProperty(key, def != null ? def.toString() : null);
        return DataTypes.parseBool(val);
    }

    public static void main(String[] args) {
        System.out.println(DataTypes.parseSizeInt("256k", 1));
        System.out.println(DataTypes.parseNum("256k", Integer.class, 1));
        System.out.println(DataTypes.parseNum("655k", Double.class, 1.0));
        System.out.println(DataTypes.parseNum("256k", Float.class, Float.valueOf(1.0f)));
        System.out.println(DataTypes.parseNum("256k", Long.class, 1L));
        System.out.println(DataTypes.parseNum("25", Short.class, Short.valueOf("1")));
        System.out.println(DataTypes.parseNum("25", Byte.class, (byte)1));
    }

    static {
        typesMap.put(String.class.getName(), Character.valueOf('S'));
        typesMap.put(Long.class.getName(), Character.valueOf('L'));
        typesMap.put(Integer.class.getName(), Character.valueOf('I'));
        typesMap.put(Boolean.class.getName(), Character.valueOf('B'));
        typesMap.put(Float.class.getName(), Character.valueOf('F'));
        typesMap.put(Double.class.getName(), Character.valueOf('D'));
        typesMap.put(JID.class.getName(), Character.valueOf('J'));
        typesMap.put(String[].class.getName(), Character.valueOf('s'));
        typesMap.put(Long[].class.getName(), Character.valueOf('l'));
        typesMap.put(Integer[].class.getName(), Character.valueOf('i'));
        typesMap.put(Boolean[].class.getName(), Character.valueOf('b'));
        typesMap.put(Float[].class.getName(), Character.valueOf('f'));
        typesMap.put(Double[].class.getName(), Character.valueOf('d'));
        typesMap.put(long[].class.getName(), Character.valueOf('l'));
        typesMap.put(int[].class.getName(), Character.valueOf('i'));
        typesMap.put(boolean[].class.getName(), Character.valueOf('b'));
        typesMap.put(float[].class.getName(), Character.valueOf('f'));
        typesMap.put(double[].class.getName(), Character.valueOf('d'));
        typesMap.put(JID[].class.getName(), Character.valueOf('j'));
    }
}

