/*
 * Decompiled with CFR 0.152.
 */
package tigase.io.jdk18;

import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Set;
import javax.net.ssl.ExtendedSSLSession;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509KeyManager;
import tigase.io.SSLContextContainer;

public class SNISSLContextContainer
extends SSLContextContainer {
    public SNISSLContextContainer() {
        this.kms = new X509KeyManager[]{new SniKeyManager()};
    }

    private class SniKeyManager
    extends X509ExtendedKeyManager {
        private SniKeyManager() {
        }

        @Override
        public String[] getClientAliases(String string, Principal[] prncpls) {
            return null;
        }

        @Override
        public String chooseClientAlias(String[] strings, Principal[] prncpls, Socket socket) {
            return null;
        }

        @Override
        public String[] getServerAliases(String string, Principal[] prncpls) {
            Set aliases = SNISSLContextContainer.this.sslContexts.keySet();
            return aliases.toArray(new String[aliases.size()]);
        }

        @Override
        public String chooseServerAlias(String string, Principal[] prncpls, Socket socket) {
            if (socket instanceof SSLSocket) {
                ExtendedSSLSession session = (ExtendedSSLSession)((SSLSocket)socket).getSession();
                return this.chooseServerAlias(session);
            }
            return null;
        }

        @Override
        public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine engine) {
            ExtendedSSLSession session = (ExtendedSSLSession)engine.getHandshakeSession();
            return this.chooseServerAlias(session);
        }

        private String chooseServerAlias(ExtendedSSLSession session) {
            String hostname = null;
            for (SNIServerName name : session.getRequestedServerNames()) {
                if (name.getType() != 0) continue;
                hostname = ((SNIHostName)name).getAsciiName();
                break;
            }
            if (hostname != null && this.getCertificateChain(hostname) != null && this.getPrivateKey(hostname) != null) {
                return hostname;
            }
            return SNISSLContextContainer.this.def_cert_alias;
        }

        @Override
        public X509Certificate[] getCertificateChain(String alias) {
            KeyManagerFactory kmf;
            if (alias == null) {
                alias = SNISSLContextContainer.this.def_cert_alias;
            }
            if ((kmf = (KeyManagerFactory)SSLContextContainer.find(SNISSLContextContainer.this.kmfs, alias)) == null) {
                alias = SNISSLContextContainer.this.def_cert_alias;
                kmf = (KeyManagerFactory)SSLContextContainer.find(SNISSLContextContainer.this.kmfs, alias);
            }
            return ((X509KeyManager)kmf.getKeyManagers()[0]).getCertificateChain(alias);
        }

        @Override
        public PrivateKey getPrivateKey(String alias) {
            KeyManagerFactory kmf;
            if (alias == null) {
                alias = SNISSLContextContainer.this.def_cert_alias;
            }
            if ((kmf = (KeyManagerFactory)SSLContextContainer.find(SNISSLContextContainer.this.kmfs, alias)) == null) {
                alias = SNISSLContextContainer.this.def_cert_alias;
                kmf = (KeyManagerFactory)SSLContextContainer.find(SNISSLContextContainer.this.kmfs, alias);
            }
            return ((X509KeyManager)kmf.getKeyManagers()[0]).getPrivateKey(alias);
        }
    }
}

