/*
 * Decompiled with CFR 0.152.
 */
package tigase.archive;

import java.util.Arrays;
import tigase.archive.RetentionType;
import tigase.archive.StoreMethod;
import tigase.archive.StoreMuc;
import tigase.vhosts.VHostItem;

public class VHostItemHelper {
    public static final String ENABLED_KEY = "xep0136Enabled";
    public static final String DEFAULT_STORE_METHOD_KEY = "xep0136DefaultStoreMethod";
    public static final String REQUIRED_STORE_METHOD_KEY = "xep0136RequiredStoreMethod";
    public static final String RETENTION_TYPE_KEY = "xep0136Retention";
    public static final String RETENTION_PERIOD_KEY = "xep0136RetentionPerion";
    public static final String MUC_SAVE_KEY = "xep0136SaveMuc";
    private static final VHostItem.DataType[] types = new VHostItem.DataType[]{new VHostItem.DataType("xep0136Enabled", "XEP-0136 - Message Archiving enabled", Boolean.class, (Object)true), new VHostItem.DataType("xep0136DefaultStoreMethod", "XEP-0136 - default store method", String.class, null, null, new Object[]{null, StoreMethod.False.toString(), StoreMethod.Body.toString(), StoreMethod.Message.toString(), StoreMethod.Stream.toString()}), new VHostItem.DataType("xep0136RequiredStoreMethod", "XEP-0136 - required store method", String.class, null, null, new Object[]{null, StoreMethod.False.toString(), StoreMethod.Body.toString(), StoreMethod.Message.toString(), StoreMethod.Stream.toString()}), new VHostItem.DataType("xep0136Retention", "XEP-0136 - retention type", String.class, null, null, new Object[]{RetentionType.userDefined.name(), RetentionType.unlimited.name(), RetentionType.numberOfDays.name()}, new String[]{"User defined", "Unlimited", "Number of days"}), new VHostItem.DataType("xep0136RetentionPerion", "XEP-0136 - retention period (in days)", Integer.class, null), new VHostItem.DataType("xep0136SaveMuc", "XEP-0136 - store MUC messages", String.class, null, null, new Object[]{StoreMuc.User.toString(), StoreMuc.False.toString(), StoreMuc.True.toString()})};

    public static void register() {
        VHostItem.registerData(Arrays.asList(types));
    }

    public static boolean isEnabled(VHostItem item) {
        return item.isData(ENABLED_KEY);
    }

    public static String getDefaultStoreMethod(VHostItem item, String defValue) {
        String val = (String)item.getData(DEFAULT_STORE_METHOD_KEY);
        if (val == null || val.isEmpty()) {
            val = defValue;
        }
        return val;
    }

    public static String getRequiredStoreMethod(VHostItem item, String defValue) {
        String val = (String)item.getData(REQUIRED_STORE_METHOD_KEY);
        if (val == null || val.isEmpty()) {
            val = defValue;
        }
        return val;
    }

    public static RetentionType getRetentionType(VHostItem item) {
        String val = (String)item.getData(RETENTION_TYPE_KEY);
        return val != null && !val.isEmpty() ? RetentionType.valueOf(val) : RetentionType.userDefined;
    }

    public static Integer getRetentionDays(VHostItem item) {
        return (Integer)item.getData(RETENTION_PERIOD_KEY);
    }

    public static StoreMuc getStoreMucMessages(VHostItem item, StoreMuc defValue) {
        String val = (String)item.getData(MUC_SAVE_KEY);
        if (val == null || val.isEmpty()) {
            return StoreMuc.User;
        }
        return StoreMuc.valueof(val);
    }
}

