/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.cluster;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.cluster.StrategyIfc;
import tigase.pubsub.repository.INodeMeta;
import tigase.pubsub.repository.NodeSubscriptions;
import tigase.pubsub.repository.PubSubDAO;
import tigase.pubsub.repository.RepositoryException;
import tigase.pubsub.repository.cached.CachedPubSubRepository;
import tigase.pubsub.repository.cached.Node;
import tigase.pubsub.repository.cached.NodeAffiliations;
import tigase.xmpp.BareJID;

public class CachedPubSubRepositoryClustered<T>
extends CachedPubSubRepository<T> {
    private static final Logger a = Logger.getLogger(CachedPubSubRepositoryClustered.class.getCanonicalName());
    private ThreadLocal<Map<String, Node>> b = new ThreadLocal();
    private StrategyIfc c;

    public CachedPubSubRepositoryClustered(PubSubDAO dao, Integer maxCacheSize, StrategyIfc strategy) {
        super(dao, maxCacheSize);
        this.c = strategy;
    }

    public void addToRootCollection(BareJID serviceJid, String nodeName) throws RepositoryException {
        super.addToRootCollection(serviceJid, nodeName);
        this.c.nodeAddedToRootCollection(serviceJid, nodeName);
    }

    public void removeFromRootCollection(BareJID serviceJid, String nodeName) throws RepositoryException {
        super.removeFromRootCollection(serviceJid, nodeName);
        this.c.nodeRemovedFromRootCollection(serviceJid, nodeName);
    }

    public CachedPubSubRepository.RootCollectionSet getRootCollectionSet(BareJID serviceJid) throws RepositoryException {
        return super.getRootCollectionSet(serviceJid);
    }

    public void forgetConfiguration(BareJID serviceJid, String nodeName) throws RepositoryException {
        super.forgetConfiguration(serviceJid, nodeName);
    }

    public void update(BareJID serviceJid, String nodeName, AbstractNodeConfig nodeConfig) throws RepositoryException {
        super.update(serviceJid, nodeName, nodeConfig);
        this.c.nodeConfigurationChanged(serviceJid, nodeName);
    }

    protected Node getNode(BareJID serviceJid, String nodeName) throws RepositoryException {
        Node node;
        String string = this.createKey(serviceJid, nodeName);
        if (a.isLoggable(Level.FINEST)) {
            a.log(Level.FINEST, "Getting node, serviceJid: {0}, nodeName: {1}, key: {2}, isLocalNode(): {3}", new Object[]{serviceJid, nodeName, string, this.isLocalNode(serviceJid, nodeName)});
        }
        if (this.isLocalNode(serviceJid, nodeName)) {
            node = super.getNode(serviceJid, nodeName);
        } else {
            Map<String, Node> map = this.b.get();
            if (map == null) {
                map = new HashMap<String, Node>();
                this.b.set(map);
            }
            if ((node = map.get(string)) == null) {
                INodeMeta iNodeMeta = this.dao.getNodeMeta(serviceJid, nodeName);
                if (iNodeMeta == null) {
                    if (a.isLoggable(Level.FINEST)) {
                        a.log(Level.FINEST, "Getting node[1] -- nodeId null! serviceJid: {0}, nodeName: {1}, nodeId: {2}", new Object[]{serviceJid, nodeName, null});
                    }
                    return null;
                }
                AbstractNodeConfig abstractNodeConfig = iNodeMeta.getNodeConfig();
                if (abstractNodeConfig == null) {
                    if (a.isLoggable(Level.FINEST)) {
                        a.log(Level.FINEST, "Getting node[2] -- config null! serviceJid: {0}, nodeName: {1}, cfgData: {2}", new Object[]{serviceJid, nodeName, null});
                    }
                    return null;
                }
                NodeAffiliations nodeAffiliations = new NodeAffiliations(this.dao.getNodeAffiliations(serviceJid, iNodeMeta.getNodeId()));
                tigase.pubsub.repository.cached.NodeSubscriptions nodeSubscriptions = this.wrapNodeSubscriptions(this.dao.getNodeSubscriptions(serviceJid, iNodeMeta.getNodeId()));
                node = new Node(iNodeMeta.getNodeId(), serviceJid, abstractNodeConfig, nodeAffiliations, nodeSubscriptions, iNodeMeta.getCreator(), iNodeMeta.getCreationTime());
                if (a.isLoggable(Level.FINEST)) {
                    a.log(Level.FINEST, "Getting node[2], serviceJid: {0}, nodeName: {1}, key: {2}, node: {3}, nodeAffiliations {4}, nodeSubscriptions: {5}", new Object[]{serviceJid, nodeName, string, node, nodeAffiliations, nodeSubscriptions});
                }
                map.put(string, node);
            }
        }
        return node;
    }

    public AbstractNodeConfig getNodeConfig(BareJID serviceJid, String nodeName) throws RepositoryException {
        AbstractNodeConfig abstractNodeConfig;
        if (a.isLoggable(Level.FINEST)) {
            a.log(Level.FINEST, "Getting node config wrapNodeConfig, serviceJid: {0}, nodeName: {1}", new Object[]{serviceJid, nodeName});
        }
        if ((abstractNodeConfig = super.getNodeConfig(serviceJid, nodeName)) != null) {
            return this.c.wrapNodeConfig(serviceJid, nodeName, abstractNodeConfig);
        }
        return abstractNodeConfig;
    }

    public void clearRemoteNodes() {
        Map<String, Node> map = this.b.get();
        if (map != null) {
            map.clear();
        }
    }

    public void onUserRemoved(BareJID userJid) throws RepositoryException {
        this.c.userRemoved(userJid);
        super.onUserRemoved(userJid);
    }

    protected boolean isLocalNode(BareJID serviceJid, String nodeName) {
        return this.c.isLocalNode(serviceJid, nodeName);
    }

    protected tigase.pubsub.repository.cached.NodeSubscriptions wrapNodeSubscriptions(NodeSubscriptions nodeSubscriptions) {
        return this.c.wrapNodeSubscriptions(nodeSubscriptions);
    }

    public void userRemoved(BareJID userJid) {
        super.userRemoved(userJid);
    }
}

