/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.cluster.strategy;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.server.cluster.strategy.CacheContenerIfc;
import tigase.server.cluster.strategy.ConnectionRecordExt;
import tigase.sys.OnlineJidsReporter;
import tigase.xml.Element;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;

public class CacheContenerV2
implements CacheContenerIfc,
OnlineJidsReporter {
    private static final Logger a = Logger.getLogger(CacheContenerV2.class.getName());
    private volatile int b = 0;
    private volatile int c = 0;
    private final ConcurrentMap<BareJID, Map<JID, ConnectionRecordExt>> d = new ConcurrentHashMap<BareJID, Map<JID, ConnectionRecordExt>>();
    private boolean e = true;

    public int connectionsSize() {
        return this.b;
    }

    @Override
    public boolean containsJid(BareJID jid) {
        return this.d.containsKey(jid);
    }

    public boolean containsJidLocally(BareJID jid) {
        return false;
    }

    public boolean containsJidLocally(JID jid) {
        return false;
    }

    public int mapSize() {
        return this.c;
    }

    public boolean needsSync() {
        return !this.e;
    }

    @Override
    public void setSync(boolean sync) {
        this.e = sync;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllForNode(JID node) {
        if (a.isLoggable(Level.FINEST)) {
            a.log(Level.FINEST, "Removing connections from cache for node: {0}", node);
        }
        for (Map.Entry entry : this.d.entrySet()) {
            Map map;
            Map map2 = map = (Map)entry.getValue();
            synchronized (map2) {
                Iterator iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry2 = iterator.next();
                    if (node.equals((Object)((ConnectionRecordExt)((Object)entry2.getValue())).getNode())) {
                        iterator.remove();
                        --this.b;
                        if (!a.isLoggable(Level.FINEST)) continue;
                        a.log(Level.FINEST, "Removed connection: {0}", entry2.getValue());
                        continue;
                    }
                    if (!a.isLoggable(Level.FINEST)) continue;
                    a.log(Level.FINEST, "Different node: {0}", entry2.getValue());
                }
                if (map.isEmpty() && this.d.remove(entry.getKey(), map)) {
                    --this.c;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePresence(Element presence, ConnectionRecordExt rec) {
        Map map = (Map)this.d.get(rec.getUserJid().getBareJID());
        if (map != null) {
            Map map2 = map;
            synchronized (map2) {
                ConnectionRecordExt connectionRecordExt = (ConnectionRecordExt)((Object)map.get(rec.getConnectionId()));
                if (connectionRecordExt != null) {
                    connectionRecordExt.setLastPresence(presence);
                    if (a.isLoggable(Level.FINEST)) {
                        a.log(Level.FINEST, "Last presence set for: {0}", (Object)connectionRecordExt);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void userDisconnected(ConnectionRecordExt rec) {
        Map map = (Map)this.d.get(rec.getUserJid().getBareJID());
        if (map != null) {
            Map map2 = map;
            synchronized (map2) {
                if (map.remove(rec.getConnectionId()) != null) {
                    --this.b;
                    if (map.isEmpty() && this.d.remove(rec.getUserJid().getBareJID(), map)) {
                        --this.c;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void usersConnected(ConnectionRecordExt ... recs) {
        for (ConnectionRecordExt connectionRecordExt : recs) {
            Map<Object, ConnectionRecordExt> map;
            LinkedHashMap<JID, ConnectionRecordExt> linkedHashMap = null;
            linkedHashMap = (LinkedHashMap<JID, ConnectionRecordExt>)this.d.get(connectionRecordExt.getUserJid().getBareJID());
            if (linkedHashMap == null) {
                linkedHashMap = new LinkedHashMap<JID, ConnectionRecordExt>(2);
                map = this.d.putIfAbsent(connectionRecordExt.getUserJid().getBareJID(), linkedHashMap);
                if (map != null) {
                    linkedHashMap = map;
                } else {
                    ++this.c;
                }
            }
            map = linkedHashMap;
            synchronized (map) {
                Map map2;
                if (linkedHashMap.put(connectionRecordExt.getConnectionId(), connectionRecordExt) == null) {
                    ++this.b;
                }
                if ((map2 = (Map)this.d.putIfAbsent(connectionRecordExt.getUserJid().getBareJID(), linkedHashMap)) == null) {
                    ++this.c;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void userChangedConnId(BareJID userId, JID oldConnectionId, JID newConnectionId) {
        Map map = (Map)this.d.get(userId);
        if (map != null) {
            Map map2 = map;
            synchronized (map2) {
                ConnectionRecordExt connectionRecordExt = (ConnectionRecordExt)((Object)map.remove(oldConnectionId));
                if (connectionRecordExt != null) {
                    connectionRecordExt.setConnectionId(newConnectionId);
                    map.put(newConnectionId, connectionRecordExt);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JID[] getConnectionIdsForJid(BareJID jid) {
        JID[] jIDArray = null;
        Map map = (Map)this.d.get(jid);
        if (map != null) {
            Map map2 = map;
            synchronized (map2) {
                int n = map.size();
                if (n > 0) {
                    jIDArray = map.keySet().toArray(new JID[n]);
                }
            }
        }
        return jIDArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectionRecordExt getConnectionRecord(JID jid) {
        ConnectionRecordExt connectionRecordExt = null;
        Map map = (Map)this.d.get(jid.getBareJID());
        if (map != null) {
            Map map2 = map;
            synchronized (map2) {
                for (ConnectionRecordExt connectionRecordExt2 : map.values()) {
                    if (!jid.equals((Object)connectionRecordExt2.getUserJid())) continue;
                    connectionRecordExt = connectionRecordExt2;
                    break;
                }
            }
        }
        return connectionRecordExt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ConnectionRecordExt> getConnectionRecords(BareJID bareJID) {
        LinkedHashSet linkedHashSet = null;
        Map map = (Map)this.d.get(bareJID);
        if (map != null) {
            Map map2 = map;
            synchronized (map2) {
                linkedHashSet = new LinkedHashSet(map.values());
            }
        }
        return linkedHashSet;
    }

    public Object getInternalData() {
        return this.d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<JID> getNodesForJid(JID jid) {
        ArrayList<JID> arrayList = null;
        Map map = (Map)this.d.get(jid.getBareJID());
        if (map != null) {
            Map map2 = map;
            synchronized (map2) {
                int n = map.size();
                if (n > 0) {
                    arrayList = new ArrayList<JID>(n);
                    for (ConnectionRecordExt connectionRecordExt : map.values()) {
                        if (jid.getResource() != null && !connectionRecordExt.getUserJid().equals((Object)jid) || arrayList.contains(connectionRecordExt.getNode())) continue;
                        arrayList.add(connectionRecordExt.getNode());
                    }
                }
            }
        }
        return arrayList;
    }

    public boolean hasCompleteJidsInfo() {
        return this.e;
    }
}

