/*
 * Decompiled with CFR 0.152.
 */
package tigase.http;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.conf.ConfigurationException;
import tigase.db.AuthRepository;
import tigase.db.UserRepository;
import tigase.http.HttpServer;
import tigase.http.IndexModule;
import tigase.http.Module;
import tigase.http.PacketWriter;
import tigase.http.admin.AdminModule;
import tigase.http.dnswebservice.DnsWebServiceModule;
import tigase.http.rest.ApiKeyRepository;
import tigase.http.rest.RestModule;
import tigase.http.server.ServerInfoModule;
import tigase.http.setup.SetupModule;
import tigase.http.ui.WebModule;
import tigase.server.AbstractMessageReceiver;
import tigase.server.Packet;
import tigase.server.Permissions;
import tigase.stats.StatisticsList;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.JID;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.StanzaType;

public class HttpMessageReceiver
extends AbstractMessageReceiver
implements PacketWriter {
    private static final Logger log = Logger.getLogger(HttpMessageReceiver.class.getCanonicalName());
    private ScheduledExecutorService scheduler;
    private ConcurrentHashMap<String, Request> pendingRequest = new ConcurrentHashMap();
    private Map<String, Module> modules = new ConcurrentHashMap<String, Module>();
    private static final Class[] ALL_MODULES = new Class[]{RestModule.class, DnsWebServiceModule.class, ServerInfoModule.class, SetupModule.class, WebModule.class, AdminModule.class, IndexModule.class};
    private HttpServer httpServer = new HttpServer();
    private UserRepository user_repo_impl = null;
    private AuthRepository auth_repo_impl = null;

    public void everyHour() {
        for (Module m : this.modules.values()) {
            m.everyHour();
        }
    }

    public void everyMinute() {
        for (Module m : this.modules.values()) {
            m.everyMinute();
        }
    }

    public void everySecond() {
        for (Module m : this.modules.values()) {
            m.everySecond();
        }
    }

    public void start() {
        this.scheduler = Executors.newScheduledThreadPool(2);
        super.start();
    }

    public void stop() {
        if (this.httpServer != null) {
            this.httpServer.stop();
            this.httpServer = null;
        }
        this.scheduler.shutdown();
        super.stop();
    }

    @Override
    public UserRepository getUserRepository() {
        return this.user_repo_impl;
    }

    @Override
    public AuthRepository getAuthRepository() {
        return this.auth_repo_impl;
    }

    public String getDiscoDescription() {
        return "HTTP server integration module";
    }

    public boolean isSubdomain() {
        return true;
    }

    public Map<String, Object> getDefaults(Map<String, Object> params) {
        Map props = super.getDefaults(params);
        Map<String, Object> httpProps = this.httpServer.getDefaults();
        for (Map.Entry<String, Object> e : httpProps.entrySet()) {
            props.put("http/" + e.getKey(), e.getValue());
        }
        ApiKeyRepository tmp = new ApiKeyRepository();
        tmp.getDefaults(props, params);
        return props;
    }

    public Element getDiscoInfo(String node, JID jid, JID from) {
        if (jid.getLocalpart() == null) {
            return super.getDiscoInfo(node, jid, from);
        }
        Module module = this.modules.get(jid.getLocalpart());
        if (module != null) {
            return module.getDiscoInfo(node, this.isAdmin(from));
        }
        return null;
    }

    public List<Element> getDiscoItems(String node, JID jid, JID from) {
        if (jid.getDomain().startsWith(String.valueOf(this.getName()) + ".")) {
            if (jid.getLocalpart() != null) {
                Module module = this.modules.get(jid.getLocalpart());
                if (module != null) {
                    return module.getDiscoItems(node, jid, from);
                }
                return Collections.emptyList();
            }
            if (node == null) {
                ArrayList<Element> items = new ArrayList<Element>();
                for (Module module : this.modules.values()) {
                    items.addAll(module.getDiscoItems(node, jid, from));
                }
                List pitems = super.getDiscoItems(node, jid, from);
                if (pitems != null) {
                    items.addAll(pitems);
                }
                return items;
            }
            return super.getDiscoItems(node, jid, from);
        }
        return super.getDiscoItems(node, jid, from);
    }

    public void getStatistics(StatisticsList list) {
        super.getStatistics(list);
        for (Module m : this.modules.values()) {
            m.getStatistics(this.getName(), list);
        }
    }

    public void setProperties(Map<String, Object> props) throws ConfigurationException {
        super.setProperties(props);
        if (props.size() == 1) {
            return;
        }
        if (this.httpServer != null) {
            HashMap<String, Object> httpProps = new HashMap<String, Object>();
            String keyPrefix = "http/";
            for (Map.Entry<String, Object> e : props.entrySet()) {
                if (!e.getKey().startsWith(keyPrefix)) continue;
                httpProps.put(e.getKey().substring(keyPrefix.length()), e.getValue());
            }
            this.httpServer.setProperties(httpProps);
        }
        this.user_repo_impl = (UserRepository)props.get("shared-user-repo");
        this.auth_repo_impl = (AuthRepository)props.get("shared-auth-repo");
        this.reconfigure(props);
    }

    protected void reconfigure(Map<String, Object> props) {
        JID componentJid = JID.jidInstanceNS((String)(String.valueOf(this.getName()) + "." + this.getDefHostName().getDomain()));
        this.httpServer.start();
        Class[] classArray = ALL_MODULES;
        int n = ALL_MODULES.length;
        int n2 = 0;
        while (n2 < n) {
            Class cls = classArray[n2];
            try {
                Module oldModule;
                Module module = (Module)cls.newInstance();
                String name = module.getName();
                Map<String, Object> moduleProps = module.getDefaults();
                moduleProps.put("componentName", this.getName());
                moduleProps.put("shared-user-repo", props.get("shared-user-repo"));
                moduleProps.put("api-keys", props.get("api-keys"));
                String modulePrefix = String.valueOf(name) + "/";
                for (Map.Entry<String, Object> e : props.entrySet()) {
                    if (!e.getKey().startsWith(modulePrefix)) continue;
                    moduleProps.put(e.getKey().substring(modulePrefix.length()), e.getValue());
                }
                if (((Boolean)moduleProps.get("active")).booleanValue()) {
                    oldModule = this.modules.get(name);
                    if (oldModule != null) {
                        module = oldModule;
                    }
                    moduleProps.put("http-server", this.httpServer);
                    StringBuilder sb = new StringBuilder();
                    for (Map.Entry<String, Object> e : moduleProps.entrySet()) {
                        sb.append(e.getKey());
                        sb.append(" = ");
                        sb.append(e.getValue());
                        sb.append(", ");
                    }
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "configuring module " + name + " with parameters = [" + sb.toString() + "]");
                    }
                    module.setProperties(moduleProps);
                    module.init(componentJid, this);
                    this.modules.put(name, module);
                    module.start();
                } else {
                    oldModule = this.modules.remove(name);
                    if (oldModule != null) {
                        this.removeServiceDiscoveryItem(module.getJid().toString(), module.getJid().toString(), module.getDescription());
                        oldModule.stop();
                    }
                }
            }
            catch (Exception ex) {
                log.log(Level.WARNING, "exception setting properties for module", ex);
            }
            ++n2;
        }
    }

    public void processPacket(Packet packet) {
        block5: {
            block6: {
                Module module;
                boolean handled = false;
                if (packet.getType() == StanzaType.result || packet.getType() == StanzaType.error) {
                    handled = this.processResultPacket(packet);
                }
                if (!handled && packet.getStanzaTo() != null && packet.getStanzaTo().getLocalpart() != null && (module = this.modules.get(packet.getStanzaTo().getLocalpart())) != null) {
                    handled = module.processPacket(packet);
                }
                if (handled) break block5;
                if (!packet.isCommand()) break block6;
                ArrayDeque results = new ArrayDeque();
                if (!super.processScriptCommand(packet, results)) break block5;
                Packet result = null;
                while ((result = (Packet)results.poll()) != null) {
                    this.addOutPacket(result);
                }
                break block5;
            }
            try {
                this.addOutPacket(Authorization.FEATURE_NOT_IMPLEMENTED.getResponseMessage(packet, null, false));
            }
            catch (PacketErrorTypeException ex) {
                log.log(Level.FINEST, "packet processing type error", ex);
            }
        }
    }

    public void requestTimedOut(String key) {
        Request request = this.pendingRequest.remove(key);
        if (request == null) {
            return;
        }
        request.callback.onResult(null);
    }

    @Override
    public boolean write(Module module, Packet packet) {
        String id;
        JID from = module.getJid().copyWithoutResource();
        if (packet.getStanzaFrom() == null) {
            packet.initVars(from, packet.getStanzaTo());
        }
        if ((id = packet.getAttributeStaticStr("id")) == null) {
            id = UUID.randomUUID().toString();
            packet.getElement().setAttribute("id", id);
            packet.initVars(packet.getStanzaFrom(), packet.getStanzaTo());
        }
        packet.setPacketFrom(from);
        return this.addOutPacket(packet);
    }

    @Override
    public boolean write(Module module, Packet packet, Integer timeout, PacketWriter.Callback callback) {
        String id;
        String uuid = UUID.randomUUID().toString();
        JID from = this.getComponentId().copyWithResourceNS(uuid);
        if (packet.getStanzaFrom() == null) {
            packet.initVars(from, packet.getStanzaTo());
        }
        if ((id = packet.getAttributeStaticStr("id")) == null) {
            id = UUID.randomUUID().toString();
            packet.getElement().setAttribute("id", id);
            packet.initVars(packet.getStanzaFrom(), packet.getStanzaTo());
        }
        packet.setPacketFrom(from);
        if (packet.getStanzaFrom() != null && !this.isLocalDomainOrComponent(packet.getStanzaFrom().toString())) {
            if (this.isAdmin(packet.getStanzaFrom())) {
                packet.setPermissions(Permissions.ADMIN);
            } else {
                packet.setPermissions(Permissions.AUTH);
            }
        }
        final String key = this.generateKey(uuid, id);
        if (callback != null) {
            if (timeout == null || timeout < 0) {
                timeout = 30;
            }
            Request request = new Request(callback, this.scheduler.schedule(new Runnable(){

                @Override
                public void run() {
                    HttpMessageReceiver.this.requestTimedOut(key);
                }
            }, (long)timeout.intValue(), TimeUnit.SECONDS));
            this.pendingRequest.put(key, request);
        }
        return this.addOutPacket(packet);
    }

    private String generateKey(String uuid, String key) {
        return String.valueOf(uuid) + "-" + key;
    }

    private boolean processResultPacket(Packet packet) {
        Request request;
        block3: {
            String id;
            String uuid = packet.getTo().getResource();
            String key = this.generateKey(uuid, id = packet.getAttributeStaticStr("id"));
            request = this.pendingRequest.remove(key);
            if (request != null) {
                request.future.cancel(false);
                try {
                    request.callback.onResult(packet);
                }
                catch (IllegalStateException ex) {
                    if (!log.isLoggable(Level.FINEST)) break block3;
                    log.log(Level.FINEST, "exception while processing response on HTTP request, is HTTP connection closed?", ex);
                }
            }
        }
        return request != null;
    }

    private class Request {
        final Future future;
        final PacketWriter.Callback callback;

        Request(PacketWriter.Callback callback, Future future) {
            this.callback = callback;
            this.future = future;
        }
    }
}

