/*
 * Decompiled with CFR 0.152.
 */
package tigase.mongodb.cluster;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import java.util.Date;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.cluster.repo.ClConConfigRepository;
import tigase.cluster.repo.ClusterRepoConstants;
import tigase.db.DBInitException;
import tigase.db.Repository;

@Repository.Meta(supportedUris={"mongodb:.*"})
public class ClConMongoRepository
extends ClConConfigRepository
implements ClusterRepoConstants {
    private static final Logger log = Logger.getLogger(ClConMongoRepository.class.getCanonicalName());
    private static final String CLUSTER_NODES = "cluster_nodes";
    private String resourceUri;
    private MongoClient mongo;
    private DB db;

    public void destroy() {
        super.destroy();
        if (this.mongo != null) {
            this.mongo.close();
        }
    }

    public void getDefaults(Map<String, Object> defs, Map<String, Object> params) {
        super.getDefaults(defs, params);
        String repo_uri = "jdbc:derby:tigase-derbydb;create=true";
        if (params.get("--user-db-uri") != null) {
            repo_uri = (String)params.get("--user-db-uri");
        }
        defs.put("repo-uri", repo_uri);
    }

    public void initRepository(String resource_uri, Map<String, String> params) throws DBInitException {
        super.initRepository(resource_uri, params);
        try {
            this.resourceUri = resource_uri;
            MongoClientURI uri = new MongoClientURI(resource_uri);
            this.mongo = new MongoClient(uri);
            this.db = this.mongo.getDB(uri.getDatabase());
            DBCollection clusterNodes = this.db.collectionExists(CLUSTER_NODES) ? this.db.getCollection(CLUSTER_NODES) : this.db.createCollection(CLUSTER_NODES, (DBObject)new BasicDBObject());
            clusterNodes.createIndex((DBObject)new BasicDBObject("hostname", (Object)1));
        }
        catch (Exception ex) {
            throw new DBInitException("Could not initialize MongoDB repository", (Throwable)ex);
        }
    }

    public void removeItem(String key) {
        super.removeItem(key);
        try {
            BasicDBObject crit = new BasicDBObject("hostname", (Object)key);
            this.db.getCollection(CLUSTER_NODES).remove((DBObject)crit);
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "Problem removing element from DB: ", ex);
        }
    }

    public void storeItem(tigase.cluster.repo.ClusterRepoItem item) {
        try {
            BasicDBObject crit = new BasicDBObject("hostname", (Object)item.getHostname());
            BasicDBObject dto = new BasicDBObject("password", (Object)item.getPassword()).append("secondary", (Object)item.getSecondaryHostname()).append("updated", (Object)new Date()).append("port", (Object)item.getPortNo()).append("cpu_usage", (Object)Float.valueOf(item.getCpuUsage())).append("mem_usage", (Object)Float.valueOf(item.getMemUsage()));
            this.db.getCollection(CLUSTER_NODES).update((DBObject)crit, (DBObject)new BasicDBObject("$set", (Object)dto), true, false);
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "Problem setting element to DB: ", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        if (System.currentTimeMillis() - this.lastReloadTime <= this.autoreload_interval * this.lastReloadTimeFactor) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Last reload performed in {0}, skipping: ", System.currentTimeMillis() - this.lastReloadTime);
            }
            return;
        }
        this.lastReloadTime = System.currentTimeMillis();
        super.reload();
        try (DBCursor cursor = null;){
            cursor = this.db.getCollection(CLUSTER_NODES).find();
            while (cursor.hasNext()) {
                DBObject dto = cursor.next();
                ClusterRepoItem item = this.getItemInstance();
                item.setHostname((String)dto.get("hostname"));
                item.setSecondaryHostname((String)dto.get("secondary"));
                item.setPassword((String)dto.get("password"));
                item.setLastUpdate(((Date)dto.get("updated")).getTime());
                item.setPort((Integer)dto.get("port"));
                item.setCpuUsage((Double)dto.get("cpu_usage"));
                item.setMemUsage((Double)dto.get("mem_usage"));
                this.itemLoaded(item);
            }
        }
    }

    public ClusterRepoItem getItemInstance() {
        return new ClusterRepoItem();
    }

    public void store() {
    }

    private class ClusterRepoItem
    extends tigase.cluster.repo.ClusterRepoItem {
        private ClusterRepoItem() {
        }

        protected void setCpuUsage(Double cpuUsage) {
            super.setCpuUsage(cpuUsage == null ? 0.0f : cpuUsage.floatValue());
        }

        protected void setMemUsage(Double memUsage) {
            super.setMemUsage(memUsage == null ? 0.0f : memUsage.floatValue());
        }

        protected void setCpuUsage(float cpuUsage) {
            super.setCpuUsage(cpuUsage);
        }

        protected void setHostname(String hostname) {
            super.setHostname(hostname);
        }

        protected void setLastUpdate(long update) {
            super.setLastUpdate(update);
        }

        protected void setMemUsage(float memUsage) {
            super.setMemUsage(memUsage);
        }

        protected void setPassword(String password) {
            super.setPassword(password);
        }

        protected void setPort(int port) {
            super.setPort(port);
        }

        protected void setSecondaryHostname(String secondaryHostname) {
            super.setSecondaryHostname(secondaryHostname);
        }
    }
}

