/*
 * Decompiled with CFR 0.152.
 */
package tigase.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.DBInitException;
import tigase.db.Repository;
import tigase.server.xmppclient.SeeOtherHostDualIP;
import tigase.util.TigaseStringprepException;
import tigase.xmpp.BareJID;

@Repository.Meta(supportedUris={"mongodb:.*"})
public class MongoDualIPRepository
implements SeeOtherHostDualIP.DualIPRepository {
    private static final Logger log = Logger.getLogger(MongoDualIPRepository.class.getCanonicalName());
    private static final String CLUSTER_NODES = "cluster_nodes";
    private String resourceUri;
    private MongoClient mongo;
    private DB db;

    public void getDefaults(Map<String, Object> defs, Map<String, Object> params) {
        String repo_uri = "jdbc:derby:tigase-derbydb;create=true";
        if (params.get("--user-db-uri") != null) {
            repo_uri = (String)params.get("--user-db-uri");
        }
        defs.put("repo-uri", repo_uri);
    }

    public void initRepository(String resource_uri, Map<String, String> params) throws DBInitException {
        try {
            this.resourceUri = resource_uri;
            MongoClientURI uri = new MongoClientURI(resource_uri);
            this.mongo = new MongoClient(uri);
            this.db = this.mongo.getDB(uri.getDatabase());
            DBCollection clusterNodes = this.db.collectionExists(CLUSTER_NODES) ? this.db.getCollection(CLUSTER_NODES) : this.db.createCollection(CLUSTER_NODES, (DBObject)new BasicDBObject());
            clusterNodes.createIndex((DBObject)new BasicDBObject("hostname", (Object)1));
        }
        catch (Exception ex) {
            throw new DBInitException("Could not initialize MongoDB repository", (Throwable)ex);
        }
    }

    public Map<BareJID, BareJID> queryAllDB() throws SQLException {
        ConcurrentSkipListMap<BareJID, BareJID> result;
        block18: {
            result = new ConcurrentSkipListMap<BareJID, BareJID>();
            try {
                DBCursor cursor = this.db.getCollection(CLUSTER_NODES).find();
                Throwable throwable = null;
                block13: while (true) {
                    try {
                        while (cursor.hasNext()) {
                            DBObject dto = cursor.next();
                            String user_jid = (String)dto.get("hostname");
                            String node_jid = (String)dto.get("secondary");
                            try {
                                BareJID hostname_hid = BareJID.bareJIDInstance((String)user_jid);
                                BareJID secondary = BareJID.bareJIDInstance((String)node_jid);
                                result.put(hostname_hid, secondary);
                                continue block13;
                            }
                            catch (TigaseStringprepException ex) {
                                log.warning("Invalid host or secondary hostname JID: " + user_jid + ", " + node_jid);
                            }
                        }
                        break block18;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                finally {
                    if (cursor != null) {
                        if (throwable != null) {
                            try {
                                cursor.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            cursor.close();
                        }
                    }
                }
            }
            catch (Exception ex) {
                log.log(Level.WARNING, "Problem getting elements from DB: ", ex);
            }
        }
        log.info("Loaded " + result.size() + " redirect definitions from database.");
        return result;
    }

    public void setProperties(Map<String, Object> props) {
    }
}

