/*
 * Decompiled with CFR 0.152.
 */
package tigase.mongo.stats;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import java.sql.SQLException;
import java.util.Date;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.DBInitException;
import tigase.db.Repository;
import tigase.stats.CounterDataLogger;

@Repository.Meta(supportedUris={"mongodb:.*"})
public class CounterDataLoggerMongo
extends CounterDataLogger {
    private static final Logger log = Logger.getLogger(CounterDataLoggerMongo.class.getName());
    private String resourceUri;
    private MongoClient mongo;
    private DB db;
    private DBCollection tigaseStatsLogCollection;

    public void addStatsLogEntry(float cpu_usage, float mem_usage, long uptime, int vhosts, long sm_packets, long muc_packets, long pubsub_packets, long c2s_packets, long s2s_packets, long ext_packets, long presences, long messages, long iqs, long registered, int c2s_conns, int s2s_conns, int bosh_conns) {
        try {
            BasicDBObject dto = new BasicDBObject().append("ts", (Object)new Date()).append("hostname", (Object)defaultHostname).append("cpu_usage", (Object)Float.valueOf(cpu_usage)).append("mem_usage", (Object)Float.valueOf(mem_usage)).append("uptime", (Object)uptime).append("vhosts", (Object)vhosts).append("sm_packets", (Object)sm_packets).append("muc_packets", (Object)muc_packets).append("pubsub_packets", (Object)pubsub_packets).append("c2s_packets", (Object)c2s_packets).append("s2s_packets", (Object)s2s_packets).append("ext_packets", (Object)ext_packets).append("presences", (Object)presences).append("messages", (Object)messages).append("iqs", (Object)iqs).append("registered", (Object)registered).append("c2s_conns", (Object)c2s_conns).append("s2s_conns", (Object)s2s_conns).append("bosh_conns", (Object)bosh_conns);
            this.tigaseStatsLogCollection.insert(new DBObject[]{dto});
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "Problem setting element to DB: ", ex);
        }
    }

    public void init(Map<String, Object> archivizerConf) {
        super.init(archivizerConf);
    }

    public void initRepository(String conn_str, Map<String, String> map) throws SQLException, ClassNotFoundException, IllegalAccessException, InstantiationException, DBInitException {
        try {
            this.resourceUri = conn_str;
            MongoClientURI uri = new MongoClientURI(this.resourceUri);
            this.mongo = new MongoClient(uri);
            this.db = this.mongo.getDB(uri.getDatabase());
            this.tigaseStatsLogCollection = this.db.collectionExists("tig_stats_log") ? this.db.getCollection("tig_stats_log") : this.db.createCollection("tig_stats_log", (DBObject)new BasicDBObject());
        }
        catch (Exception ex) {
            throw new DBInitException("Could not initialize MongoDB repository", (Throwable)ex);
        }
    }
}

