select count(1) from (
select MAX(x.msg_id) as msg_id
from
	(select
		m1.msg_id, m1.owner_id, m1.buddy_id, m1.ts,
		case m1.item_type
			when 'chat' then case m1.type
				when 'groupchat' then 'groupchat'
				else 'chat'
			end
			when 'call' then 'call'
		end as item_type,
		case
			when m1.item_type <> 'call' then null
			when m1.jingle_action='session-accept' or (m1.jingle_action='session-terminate' and m1.jingle_reason = 'success') then 'success'
			when m1.jingle_offline = 1
				or (m1.jingle_action = 'session-terminate' and (
					m1.jingle_reason = 'busy' or m1.jingle_reason = 'timeout'
					or m1.jingle_reason = 'failed-application'
					or (m1.jingle_reason = 'cancel' and m1.direction = 1 and not exists(select 1 from tig_ma_msgs m0 where m0.owner_id = m1.owner_id and m0.buddy_id = m1.buddy_id and m0.jingle_sid = m1.jingle_sid and m0.jingle_action = 'session-accept' and m0.ts < m1.ts))
				))
				or m1.jingle_action = 'session-initiate' then 'missed'
			else 'canceled'
		end as "condition"
	from tig_ma_msgs m1
	where m1.owner_id = (select jid_id from tig_ma_jids where jid = ?)
	and (? is null or ts >= ?)
	and (? is null or ts <= ?)
	and m1.offline <> 2
	) as x
where
	(1=? and x.item_type = 'chat')
	or (1=? and x.item_type = 'groupchat')
	or (1=? and x.item_type = 'call' and (
		(1=? and x.condition = 'success')
		or (1=? and x.condition = 'missed')
		or (1=? and x.condition = 'canceled')
	))
group by x.owner_id, x.buddy_id
) as y
