/*
 * Decompiled with CFR 0.152.
 */
package tigase.stats.collector.provider;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyStore;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import javax.xml.ws.http.HTTPException;
import tigase.stats.collector.ElementSigner;
import tigase.stats.collector.SignatureException;
import tigase.stats.collector.StatisticsData;
import tigase.xml.DomBuilderHandler;
import tigase.xml.Element;
import tigase.xml.SimpleHandler;
import tigase.xml.SimpleParser;
import tigase.xml.SingletonFactory;

public class StatisticsUploader {
    private static final Logger a = Logger.getLogger(StatisticsUploader.class.getCanonicalName());
    private static final Timer b = new Timer();
    private static final SimpleParser c = SingletonFactory.getParserInstance();
    private static SSLSocketFactory d = null;
    private final ElementSigner e;

    /*
     * WARNING - void declaration
     */
    public StatisticsUploader(ElementSigner signer) {
        void var1_1;
        this.e = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void upload(StatisticsData data, ResultCallback callback) {
        void var2_2;
        Object object = data.toElement();
        object = this.e.sign(object);
        object = object.toString();
        this.a((String)object, (ResultCallback)var2_2, 0);
    }

    private void a(String string, ResultCallback resultCallback, int n) {
        a.log(Level.FINEST, "queuing data for upload = {0} try no = {1}", new Object[]{string, n});
        b.schedule(new TimerTask(this, string, n, resultCallback){
            private /* synthetic */ String a;
            private /* synthetic */ int b;
            private /* synthetic */ ResultCallback c;
            private /* synthetic */ StatisticsUploader d;
            {
                this.d = statisticsUploader;
                this.a = string;
                this.b = n;
                this.c = resultCallback;
            }

            @Override
            public final void run() {
                block7: {
                    try {
                        boolean bl = false;
                        Element element = null;
                        Throwable throwable = null;
                        try {
                            element = StatisticsUploader.a(this.d, this.a);
                            element = this.d.e.verify(element);
                            bl = "result".equals(element.getAttribute("type"));
                        }
                        catch (IOException | SignatureException throwable2) {
                            a.log(Level.SEVERE, "exception uploading statistics", throwable2);
                            throwable = throwable2;
                        }
                        if (!bl) {
                            if (this.b >= 10) {
                                a.log(Level.WARNING, "could not upload statistics data, permanent upload failure");
                                this.c.onFailure((Exception)throwable);
                            } else {
                                a.log(Level.FINE, "could not upload statistics data, queuing for retry, attempt " + this.b + " out of 10");
                                this.d.a(this.a, this.c, this.b + 1);
                            }
                            break block7;
                        }
                        a.log(Level.FINER, "statistics data successfully uploaded");
                        this.c.onSuccess(element);
                        return;
                    }
                    catch (Exception exception) {
                        a.log(Level.SEVERE, "exception during processing upload request, should not happen", exception);
                    }
                }
            }
        }, TimeUnit.MINUTES.toMillis(n << 1));
    }

    private static SSLSocketFactory b() {
        if (d == null) {
            try {
                Object object = KeyStore.getInstance("JKS");
                ((KeyStore)object).load(new FileInputStream("certs/keystore-letsencrypt"), "keystore".toCharArray());
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                keyManagerFactory.init((KeyStore)object, "keystore".toCharArray());
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                trustManagerFactory.init((KeyStore)object);
                object = SSLContext.getInstance("TLS");
                ((SSLContext)object).init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
                d = ((SSLContext)object).getSocketFactory();
            }
            catch (Exception exception) {
                Exception exception2 = exception;
                exception.printStackTrace();
            }
        }
        return d;
    }

    static /* synthetic */ Element a(StatisticsUploader object, String charSequence) throws IOException {
        object = new URL("https://stats.tigase.net/upload");
        Object object2 = (HttpURLConnection)((URL)object).openConnection();
        ((URLConnection)object2).setConnectTimeout(5000);
        ((URLConnection)object2).setReadTimeout(5000);
        if ("https".equals(((URL)object).getProtocol())) {
            ((HttpsURLConnection)object2).setSSLSocketFactory(StatisticsUploader.b());
        }
        ((URLConnection)object2).setDoOutput(true);
        ((HttpURLConnection)object2).setRequestMethod("POST");
        ((URLConnection)object2).setRequestProperty("Accept", "*/*");
        ((URLConnection)object2).setRequestProperty("Content-Type", "application/xml");
        ((URLConnection)object2).setRequestProperty("Content-Length", String.valueOf(((String)charSequence).length()));
        a.log(Level.FINE, "Sending data: {0} to url: {1}", new Object[]{charSequence, object});
        object = ((URLConnection)object2).getOutputStream();
        ((OutputStream)object).write(((String)charSequence).getBytes());
        ((OutputStream)object).flush();
        int n = ((HttpURLConnection)object2).getResponseCode();
        if (n / 100 != 2) {
            a.log(Level.FINE, "Server responded with the code: {0} and message: {1}", new Object[]{n, ((HttpURLConnection)object2).getResponseMessage()});
            throw new HTTPException(n);
        }
        Object object3 = new BufferedReader(new InputStreamReader(((URLConnection)object2).getInputStream()));
        charSequence = new StringBuffer();
        DomBuilderHandler domBuilderHandler = new DomBuilderHandler();
        while ((object2 = ((BufferedReader)object3).readLine()) != null) {
            ((StringBuffer)charSequence).append((String)object2);
            c.parse((SimpleHandler)domBuilderHandler, ((String)object2).toCharArray(), 0, ((String)object2).length());
        }
        a.log(Level.FINE, "Received: {0}", new Object[]{((StringBuffer)charSequence).toString()});
        object3 = domBuilderHandler.getParsedElements();
        if (object3.isEmpty()) {
            throw new IOException("No response");
        }
        return (Element)object3.poll();
    }

    public static interface ResultCallback {
        public void onSuccess(Element var1);

        public void onFailure(Exception var1);
    }
}

