/*
 * Decompiled with CFR 0.152.
 */
package tigase.licence;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import tigase.licence.Licence;
import tigase.licence.LicenceCheckDailyTask;
import tigase.licence.LicenceCheckerUpdateCallback;
import tigase.licence.LicenceCheckerUpdateCallbackImpl;
import tigase.licence.LicenceLoader;
import tigase.licence.LicenceLoaderFactory;
import tigase.licence.LicenceRetriever;
import tigase.licence.b;
import tigase.licence.utils.VHostsRetriever;
import tigase.util.Base64;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.JID;

public class LicenceChecker {
    public static final String INSTALLATION_ID_KEY = "installation-id";
    private static final Map<String, LicenceChecker> d = new ConcurrentHashMap<String, LicenceChecker>(5);
    private static final Logger e = Logger.getLogger("tigase.licence");
    private static final ScheduledExecutorService f = Executors.newSingleThreadScheduledExecutor();
    static String a = null;
    private static boolean g = false;
    private static LicenceCheckDailyTask h;
    private final File i;
    private final String j;
    private long k = (long)(ThreadLocalRandom.current().nextDouble(1.0, 16.0) * 60.0);
    Licence b;
    private long l = TimeUnit.DAYS.toSeconds(1L);
    LicenceCheckerUpdateCallback c;
    private Date m;

    static boolean a() {
        return g;
    }

    /*
     * WARNING - void declaration
     */
    private LicenceChecker(String cmpName, LicenceCheckerUpdateCallback call) {
        void var1_1;
        void var2_2;
        new SimpleDateFormat("yyyy-MM-dd'T'HHmm");
        Object object = System.getProperty("licence-library-test-mode");
        if (object != null && Boolean.valueOf((String)object).booleanValue()) {
            e.log(Level.WARNING, "Licence library running in demo mode (faster checks!)");
            g = true;
            this.k = 5L;
            this.l = TimeUnit.MINUTES.toSeconds(15L);
        }
        object = System.getProperty("statistics-log-level");
        Level level = Level.ALL;
        if (object != null) {
            level = Level.parse((String)object);
        }
        object = this;
        Logger logger = Logger.getLogger("tigase.stats.collector");
        e.setLevel(level);
        logger.setLevel(level);
        try {
            FileHandler fileHandler = new FileHandler("logs/statistics.log", 10000000, 5, true);
            fileHandler.setLevel(level);
            logger.addHandler(fileHandler);
            e.addHandler(fileHandler);
        }
        catch (IOException iOException) {
            e.log(Level.CONFIG, ((LicenceChecker)object).j);
        }
        this.c = var2_2;
        this.j = cmpName;
        if (h == null) {
            h = new LicenceCheckDailyTask(d);
            e.log(Level.FINEST, "initialCheckDelay: {0}, subsequentCheckDelay: {1}", new Object[]{this.k, this.l});
            f.scheduleAtFixedRate(h, this.k, this.l, TimeUnit.SECONDS);
        }
        e.log(Level.CONFIG, "Created licence checker for {0}", var1_1);
        this.i = new File("etc/" + this.j + ".licence");
    }

    public static LicenceChecker getLicenceChecker(String cmpName) {
        return LicenceChecker.getLicenceChecker(cmpName, null);
    }

    /*
     * WARNING - void declaration
     */
    public static LicenceChecker getLicenceChecker(String cmpName, LicenceCheckerUpdateCallback call) {
        LicenceChecker licenceChecker;
        e.log(Level.FINEST, "Getting logger for: {0}, call: {1}, exists: {2}", new Object[]{cmpName, call, d.get(cmpName)});
        LicenceChecker licenceChecker2 = d.get(cmpName);
        if (licenceChecker2 == null) {
            if (call == null) {
                call = new LicenceCheckerUpdateCallbackImpl(cmpName);
            }
            licenceChecker2 = new LicenceChecker(cmpName, call);
            d.put((String)((Object)licenceChecker), licenceChecker2);
        } else if (call != null) {
            void var1_1;
            licenceChecker = licenceChecker2;
            licenceChecker2.c = var1_1;
        }
        return licenceChecker2;
    }

    public Licence reloadLicenceFromServer() throws NoSuchAlgorithmException, IOException, InvalidKeySpecException {
        return this.b(true);
    }

    private Licence a(LicenceLoader object) {
        Object object2 = new LicenceRetriever();
        object2 = ((LicenceRetriever)object2).a(this.j);
        if (e.isLoggable(Level.FINEST)) {
            e.log(Level.FINEST, "Loading licence for component: {0} from server, licenceData: {1}", new Object[]{this.j, object2});
        }
        if (object2 == null || ((String)object2).isEmpty()) {
            e.info("Cannot load licence from Server.");
            return null;
        }
        try {
            object2 = new ByteArrayInputStream(((String)object2).getBytes());
            object = object.loadLicence((InputStream)object2);
            ((ByteArrayInputStream)object2).close();
            return object;
        }
        catch (Exception exception) {
            e.log(Level.WARNING, "Cannot parse licence data.", exception);
            return null;
        }
    }

    private Licence b(LicenceLoader object) {
        if ((object = this.a((LicenceLoader)object)) != null && object instanceof b) {
            try {
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(this.i), Charset.forName("UTF-8").newEncoder());
                ((b)object).a(outputStreamWriter);
                ((Writer)outputStreamWriter).close();
            }
            catch (Exception exception) {
                e.log(Level.WARNING, "Cannot store licence in file " + this.i, exception);
            }
        }
        return object;
    }

    private Licence b(boolean bl) throws NoSuchAlgorithmException, IOException, InvalidKeySpecException {
        Object object;
        LicenceLoader licenceLoader = LicenceLoaderFactory.create();
        if (e.isLoggable(Level.FINEST)) {
            e.log(Level.FINEST, "Trying to load licence file from file: {0} (exists: {1}, empty: {2}), forcing load from server: {3}", new Object[]{this.i, this.i.exists(), this.i.length() == 0L, bl});
        }
        if (bl && (object = this.b(licenceLoader)) != null) {
            this.b = object;
            return object;
        }
        if (!this.i.exists() || this.i.length() == 0L) {
            e.log(Level.INFO, "Missing licence file ({0}), retrieving from the server!", new Object[]{this.i});
            if (!bl) {
                return this.b(licenceLoader);
            }
            return null;
        }
        object = licenceLoader.loadLicence(this.i);
        try {
            Object object2 = object.getPropertyAsDate("valid-until");
            if (System.currentTimeMillis() > ((Date)object2).getTime() - 172800000L && (object2 = this.b(licenceLoader)) != null) {
                object = object2;
            }
            if (object.getPropertyAsString(INSTALLATION_ID_KEY) == null) {
                e.log(Level.FINEST, "Legacy Licence! Force reload from server!");
                object2 = this.b(licenceLoader);
                if (object2 != null) {
                    e.log(Level.FINEST, "Loaded new licence from server: " + object2);
                    object = object2;
                }
            }
        }
        catch (ParseException parseException) {
            e.log(Level.WARNING, "Ouch! We can't load new licence from server! ", this.i);
        }
        return object;
    }

    final boolean a(boolean bl) {
        try {
            this.b = this.b(bl);
            if (this.b == null) {
                e.log(Level.WARNING, "Missing licence file ({0})!", new Object[]{this.i});
                return false;
            }
            this.m = this.b.getPropertyAsDate("valid-until");
            try {
                switch (this.b.check()) {
                    case invalidDates: {
                        e.log(Level.WARNING, "Licence expired.");
                        return false;
                    }
                    case invalidVHosts: {
                        e.log(Level.WARNING, "VHost list does not match.");
                        return false;
                    }
                    case invalidSignature: {
                        e.log(Level.WARNING, "Licence file has been tempered with!");
                        return false;
                    }
                    case valid: {
                        e.log(Level.INFO, "Licence OK");
                    }
                }
            }
            catch (Exception exception) {
                e.log(Level.WARNING, "Licence invalid", exception);
                return false;
            }
            String string = this.b.getPropertyAsString("app-id");
            if (string == null || !string.equals(this.j)) {
                e.log(Level.WARNING, "This is not licence for {0} Component!", this.j);
                return false;
            }
        }
        catch (Exception exception) {
            e.log(Level.WARNING, "Can't load licence file. Error: {0}", new Object[]{exception.getMessage()});
            return false;
        }
        return true;
    }

    public static Set<String> getLicencedComponents() {
        return Collections.unmodifiableSet(d.keySet());
    }

    public static String getInstallationId() {
        return a;
    }

    public static Element getLicencingDetails(String component) {
        List<JID> list;
        Element element = new Element("licence-details");
        element.addChild((XMLNodeIfc)new Element(INSTALLATION_ID_KEY, a));
        element.addChild((XMLNodeIfc)new Element("module", (String)((Object)list)));
        list = VHostsRetriever.getManagedVHosts();
        if (list != null && !list.isEmpty()) {
            element.addChild((XMLNodeIfc)new Element("vhosts", list.stream().map(Object::toString).collect(Collectors.joining(","))));
        }
        return element;
    }

    public static String getCodeForLicenceRetrieval(String component) throws Exception {
        String string;
        List<JID> list = VHostsRetriever.getManagedVHosts();
        new LicenceRetriever();
        string = LicenceRetriever.a(a, string, list);
        return Base64.encode((byte[])string.getBytes("UTF-8"));
    }

    public String getLicenceDigest() {
        if (this.b != null) {
            return this.b.getLicenceDigest();
        }
        return null;
    }

    public Date getValidUntil() {
        return this.m;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("LicenceChecker{");
        stringBuilder.append("LICENCE_FILE=").append(this.i);
        stringBuilder.append(", componentName='").append(this.j).append('\'');
        stringBuilder.append(", initialCheckDelay=").append(this.k);
        stringBuilder.append(", subsequentCheckDelay=").append(this.l);
        stringBuilder.append(", updateCall=").append(this.c);
        stringBuilder.append(", lic=").append(this.b);
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public static void main(String[] args) {
        System.setProperty("licence-library-test-mode", "true");
        LicenceChecker.getLicenceChecker("acs");
    }
}

