/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;

public class PresenceStore {
    private final Map<BareJID, Presence> bestPresence = new ConcurrentHashMap<BareJID, Presence>();
    private final Map<JID, Presence> presenceByJid = new ConcurrentHashMap<JID, Presence>();
    protected static final Logger log = Logger.getLogger(PresenceStore.class.getName());
    private Map<BareJID, Map<String, Presence>> presencesMapByBareJid = new ConcurrentHashMap<BareJID, Map<String, Presence>>();
    private PresenceDeliveryLogic presenceOrdening;

    public PresenceStore() {
        this.presenceOrdening = PresenceDeliveryLogic.PREFERE_PRIORITY;
    }

    public PresenceStore(PresenceDeliveryLogic pdl) {
        this.presenceOrdening = pdl;
    }

    public void clear() {
        this.presenceByJid.clear();
        this.bestPresence.clear();
        this.presencesMapByBareJid.clear();
    }

    public Collection<JID> getAllKnownJIDs() {
        ArrayList<JID> result = new ArrayList<JID>();
        for (Map.Entry<JID, Presence> entry : this.presenceByJid.entrySet()) {
            if (entry.getValue().type != null) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    public Element getBestPresence(BareJID jid) {
        Map<String, Presence> set;
        Presence p = this.getBestPresenceInt(jid);
        if (p == null && (set = this.presencesMapByBareJid.get(jid)) != null && !set.isEmpty()) {
            return set.values().iterator().next().element;
        }
        return p == null ? null : p.element;
    }

    public Presence getBestPresenceInt(BareJID jid) {
        return this.bestPresence.get(jid);
    }

    public Element getPresence(JID jid) {
        Presence p = this.presenceByJid.get(jid);
        return p == null ? null : p.element;
    }

    private Presence intGetBestPresence(BareJID jid) {
        Map<String, Presence> resourcesPresence = this.presencesMapByBareJid.get(jid);
        Presence result = null;
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "User resources presences: " + resourcesPresence);
        }
        if (resourcesPresence != null) {
            for (Presence x : resourcesPresence.values()) {
                switch (this.presenceOrdening) {
                    case PREFERE_PRIORITY: {
                        if (result != null && (x.type != null || x.priority <= result.priority && (x.priority != result.priority || !x.lastUpdated.after(result.lastUpdated)))) break;
                        result = x;
                        break;
                    }
                    case PREFERE_LAST: {
                        Date l = x.lastUpdated;
                        if (result != null && (!l.after(result.lastUpdated) || x.type != null)) break;
                        result = x;
                    }
                }
            }
        }
        return result;
    }

    public boolean isAvailable(BareJID jid) {
        boolean result;
        Map<String, Presence> resourcesPresence = this.presencesMapByBareJid.get(jid);
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "resourcesPresence: " + resourcesPresence);
        }
        if (resourcesPresence != null) {
            Presence x;
            Iterator<Presence> it = resourcesPresence.values().iterator();
            for (result = false; it.hasNext() && !result; result |= x.type == null) {
                x = it.next();
            }
        }
        return result;
    }

    public void setOrdening(PresenceDeliveryLogic pdl) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Setting presence delivery logic to: " + (Object)((Object)pdl));
        }
        this.presenceOrdening = pdl;
    }

    public void remove(JID from) throws TigaseStringprepException {
        String resource = from.getResource() == null ? "" : from.getResource();
        this.presenceByJid.remove(from);
        Map<String, Presence> m = this.presencesMapByBareJid.get(from.getBareJID());
        if (m != null) {
            m.remove(resource);
            if (m.isEmpty()) {
                this.presencesMapByBareJid.remove(from.getBareJID());
            }
        }
        this.updateBestPresence(from.getBareJID());
    }

    public void update(Element presence) throws TigaseStringprepException {
        String f = presence.getAttributeStaticStr("from");
        if (f == null) {
            return;
        }
        JID from = JID.jidInstance((String)f);
        BareJID bareFrom = from.getBareJID();
        String resource = from.getResource() == null ? "" : from.getResource();
        Presence p = new Presence(presence);
        if (p.type != null && p.type.equals("unavailable")) {
            this.presenceByJid.remove(from);
            Map<String, Presence> m = this.presencesMapByBareJid.get(bareFrom);
            if (m != null) {
                m.remove(resource);
                if (m.isEmpty()) {
                    this.presencesMapByBareJid.remove(bareFrom);
                }
            }
        } else {
            this.presenceByJid.put(from, p);
            Map<String, Presence> m = this.presencesMapByBareJid.get(bareFrom);
            if (m == null) {
                m = new ConcurrentHashMap<String, Presence>();
                this.presencesMapByBareJid.put(bareFrom, m);
            }
            m.put(resource, p);
        }
        this.updateBestPresence(bareFrom);
    }

    private void updateBestPresence(BareJID bareFrom) throws TigaseStringprepException {
        Presence x = this.intGetBestPresence(bareFrom);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Selected BestPresence: " + (x != null ? x.element.toString() : "n/a"));
        }
        if (x == null) {
            this.bestPresence.remove(bareFrom);
        } else {
            this.bestPresence.put(bareFrom, x);
        }
    }

    public static enum PresenceDeliveryLogic {
        PREFERE_LAST,
        PREFERE_PRIORITY;

    }

    public class Presence {
        final Element element;
        final int priority;
        final String type;
        final String show;
        final JID from;
        final Date lastUpdated = new Date();

        public Presence(Element presence) {
            this.element = presence;
            this.type = presence.getAttributeStaticStr("type");
            this.from = JID.jidInstanceNS((String)presence.getAttributeStaticStr("from"));
            this.show = presence.getChildCDataStaticStr(tigase.server.Presence.PRESENCE_SHOW_PATH);
            String p = presence.getChildCDataStaticStr(tigase.server.Presence.PRESENCE_PRIORITY_PATH);
            int x = 0;
            try {
                x = Integer.parseInt(p);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.priority = x;
        }

        public Element getElement() {
            return this.element;
        }

        public Date getLastUpdated() {
            return this.lastUpdated;
        }

        public String getShow() {
            return this.show;
        }

        public int getPriority() {
            return this.priority;
        }

        public String toString() {
            return "Presence[priority=" + this.priority + ", type=" + this.type + ", show=" + this.show + ", from=" + this.from + ", lastUpdated=" + this.lastUpdated + "]";
        }
    }
}

