/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.xmppserver;

import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.server.Packet;
import tigase.server.xmppserver.CID;
import tigase.server.xmppserver.ConnectionHandlerIfc;
import tigase.xmpp.XMPPIOService;

@Deprecated
public class ServerConnections {
    private static final Logger log = Logger.getLogger("tigase.server.xmppserver.ServerConnections");
    private CID cid = null;
    private ConnectionHandlerIfc<XMPPIOService<Object>> handler = null;
    private XMPPIOService<Object> outgoing = null;
    private OutgoingState conn_state = OutgoingState.NULL;
    private long receivedPackets = 0L;
    private long sentPackets = 0L;
    private ConcurrentLinkedQueue<Packet> waitingPackets = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<Packet> waitingControlPackets = new ConcurrentLinkedQueue();
    private ConcurrentHashMap<String, String> db_keys = new ConcurrentHashMap();
    private long creationTime = System.currentTimeMillis();

    public ServerConnections(ConnectionHandlerIfc<XMPPIOService<Object>> handler, CID cid) {
        this.handler = handler;
        this.cid = cid;
    }

    public void addControlPacket(Packet packet) {
        this.waitingControlPackets.offer(packet);
    }

    public void addDataPacket(Packet packet) {
        if (this.waitingPackets.size() == 0) {
            this.creationTime = System.currentTimeMillis();
        }
        this.waitingPackets.offer(packet);
    }

    public synchronized void addOutgoing(XMPPIOService<Object> serv) {
        XMPPIOService<Object> old = this.outgoing;
        if (this.outgoing != serv) {
            this.outgoing = serv;
            this.conn_state = OutgoingState.HANDSHAKING;
        }
        if (old != null) {
            log.info("Old outgoing connection: " + old + " replaced with new one: " + this.outgoing);
            old.forceStop();
        }
    }

    public CID getCID() {
        return this.cid;
    }

    public String getDBKey(String sessionId) {
        return this.db_keys.get(sessionId);
    }

    public int getDBKeysSize() {
        return this.db_keys.size();
    }

    public OutgoingState getOutgoingState() {
        return this.conn_state;
    }

    public Queue<Packet> getWaitingPackets() {
        return this.waitingPackets;
    }

    public synchronized void handleDialbackFailure() {
        if (this.outgoing != null) {
            this.outgoing.forceStop();
            this.outgoing = null;
        }
        this.conn_state = OutgoingState.NULL;
    }

    public synchronized boolean handleDialbackSuccess() {
        if (this.outgoing != null && this.conn_state == OutgoingState.HANDSHAKING) {
            this.setValid();
            ArrayDeque<Packet> all = new ArrayDeque<Packet>();
            Packet packet = null;
            while ((packet = this.waitingControlPackets.poll()) != null) {
                all.offer(packet);
                if (!log.isLoggable(Level.FINEST)) continue;
                log.finest("Sending on connection: " + this.outgoing + " control packet: " + packet);
            }
            this.sentPackets += (long)this.waitingPackets.size();
            while ((packet = this.waitingPackets.poll()) != null) {
                all.offer(packet);
                if (!log.isLoggable(Level.FINEST)) continue;
                log.finest("Sending on connection: " + this.outgoing + " packet: " + packet);
            }
            this.handler.writePacketsToSocket(this.outgoing, all);
            return true;
        }
        log.warning("Something wrong, the method was called when the outgoing connection is null for cid: " + this.cid);
        this.outgoing = null;
        this.conn_state = OutgoingState.NULL;
        return false;
    }

    public boolean isOutgoing(XMPPIOService<Object> serv) {
        return serv == this.outgoing;
    }

    public boolean isOutgoingConnected() {
        return this.outgoing != null && this.outgoing.isConnected();
    }

    public boolean needsConnection() {
        return this.conn_state == OutgoingState.NULL;
    }

    public boolean outgoingIsNull() {
        return this.outgoing == null;
    }

    public void putDBKey(String sessionId, String dbKey) {
        this.db_keys.put(sessionId, dbKey);
    }

    public synchronized boolean sendAllControlPackets() {
        if (log.isLoggable(Level.FINEST)) {
            for (Packet packet : this.waitingControlPackets) {
                log.finest("Sending on connection: " + this.outgoing + " control packet: " + packet);
            }
        }
        this.handler.writePacketsToSocket(this.outgoing, this.waitingControlPackets);
        return true;
    }

    public synchronized boolean sendControlPacket(Packet packet) {
        boolean result = false;
        if (this.outgoing != null && this.outgoing.isConnected() && (this.conn_state == OutgoingState.OK || this.conn_state == OutgoingState.HANDSHAKING)) {
            result = this.handler.writePacketToSocket(this.outgoing, packet);
            if (!result) {
                this.outgoing.forceStop();
                this.outgoing = null;
            } else if (log.isLoggable(Level.FINEST)) {
                log.finest("Sent on connection: " + this.outgoing + " control packet: " + packet);
            }
        }
        if (!result) {
            this.addControlPacket(packet);
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Connection not ready: " + this.outgoing + " control packet added to waiting: " + packet);
            }
        }
        return result;
    }

    public synchronized boolean sendPacket(Packet packet) {
        boolean result = false;
        if (this.outgoing != null && this.outgoing.isConnected() && this.conn_state == OutgoingState.OK) {
            result = this.handler.writePacketToSocket(this.outgoing, packet);
            if (!result) {
                this.outgoing.forceStop();
                this.outgoing = null;
            } else {
                ++this.sentPackets;
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Sent on connection: " + this.outgoing + " packet sent: " + packet);
                }
            }
        }
        if (!result) {
            this.addDataPacket(packet);
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Connection not ready: " + this.outgoing + " packet added to waiting: " + packet);
            }
        }
        return result;
    }

    public void serviceStopped(XMPPIOService<Object> serv) {
        String session_id = (String)serv.getSessionData().get("sessionID");
        if (session_id != null) {
            this.db_keys.remove(session_id);
        } else {
            log.info("Session_ID is null for: " + serv);
        }
        if (serv == this.outgoing) {
            this.outgoing = null;
            this.conn_state = OutgoingState.NULL;
            if (log.isLoggable(Level.FINER)) {
                log.finer("Connection removed: " + this.outgoing + ", session id: " + session_id);
            }
        }
    }

    public void setConnecting() {
        this.conn_state = OutgoingState.CONNECTING;
    }

    public void setValid() {
        this.conn_state = OutgoingState.OK;
    }

    public void stopAll() {
        if (this.outgoing != null) {
            this.outgoing.forceStop();
            this.outgoing = null;
        }
        this.conn_state = OutgoingState.NULL;
    }

    public String toString() {
        return "cid: " + this.cid + ", conn_state: " + this.conn_state.name() + ", outgoing: " + this.outgoing + ", waitingPackets: " + this.waitingPackets.size() + ", controlPacket: " + this.waitingControlPackets.size() + ", db_keys: " + this.db_keys.size();
    }

    public long waitingTime() {
        return System.currentTimeMillis() - this.creationTime;
    }

    public static enum OutgoingState {
        NULL,
        CONNECTING,
        HANDSHAKING,
        OK;

    }
}

