/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.sreceiver;

import java.util.Date;
import java.util.Map;
import java.util.Queue;
import tigase.server.Message;
import tigase.server.Packet;
import tigase.server.sreceiver.PropertyConstants;
import tigase.server.sreceiver.PropertyItem;
import tigase.server.sreceiver.RepoRosterTask;
import tigase.sys.TigaseRuntime;
import tigase.xml.Element;
import tigase.xmpp.JID;
import tigase.xmpp.StanzaType;

public class PubSubTestsTask
extends RepoRosterTask {
    private static final String[] IQ_PUBSUB_CONFIGURE_PATH = new String[]{"iq", "pubsub", "configure"};
    private static final String[] IQ_PUBSUB_PATH = new String[]{"iq", "pubsub"};
    private static final String[] IQ_PUBSUB_SUBSCRIPTIONS_PATH = new String[]{"iq", "pubsub", "subscriptions"};
    private static final String TASK_HELP = "This is a PubSub component testing task. Only for testing and only to be run by an admnistrator.";
    private static final String TASK_TYPE = "PubSub tests";
    private long delay = 2000L;
    private Element conf = new Element("x", new Element[]{new Element("field", new Element[]{new Element("value", "http://jabber.org/protocol/pubsub#node_config")}, new String[]{"var", "type"}, new String[]{"FORM_TYPE", "hidden"}), new Element("field", new Element[]{new Element("value", "0")}, new String[]{"var"}, new String[]{"pubsub#notify_sub_aff_state"})}, new String[]{"xmlns", "type"}, new String[]{"jabber:x:data", "submit"});
    private String[] last_nodes = null;
    private long packetsGenerated = 0L;
    private boolean stop = false;

    @Override
    public Map<String, PropertyItem> getDefaultParams() {
        Map<String, PropertyItem> defs = super.getDefaultParams();
        defs.put("description", new PropertyItem("description", "Description", "PubSub Testing Task"));
        defs.put("message-type", new PropertyItem("message-type", "Message type", PropertyConstants.MessageType.NORMAL));
        defs.put("online-users-only", new PropertyItem("online-users-only", "Send to online users only", false));
        defs.put("replace-sender", new PropertyItem("replace-sender", "Replace sender address", PropertyConstants.SenderAddress.LEAVE));
        defs.put("subscription-restr", new PropertyItem("subscription-restr", "Subscription restrictions", PropertyConstants.SubscrRestrictions.MODERATED));
        return defs;
    }

    @Override
    public String getHelp() {
        return TASK_HELP;
    }

    @Override
    public String getType() {
        return TASK_TYPE;
    }

    @Override
    protected boolean addOutPacket(Packet packet) {
        ++this.packetsGenerated;
        return super.addOutPacket(packet);
    }

    @Override
    protected void processMessage(Packet packet, Queue<Packet> results) {
        if (this.isPostCommand(packet)) {
            this.runCommand(packet, results);
        }
    }

    private void addSubscriptionsForNode(JID from, JID to, String node, int subscr) {
        int j = 0;
        Element el = this.createPubSubEl(from, to, "ids-" + ++j, node, "subscriptions", "http://jabber.org/protocol/pubsub#owner");
        for (int i = 0; i < subscr; ++i) {
            Element subs = new Element("subscription", new String[]{"jid", "subscription"}, new String[]{"frank-" + i + "@" + this.getJID().getDomain(), "subscribed"});
            el.findChildStaticStr(IQ_PUBSUB_SUBSCRIPTIONS_PATH).addChild(subs);
            if (i % 100 != 0) continue;
            this.addOutPacket(Packet.packetInstance(el, from, to));
            el = this.createPubSubEl(from, to, "ids-" + ++j, node, "subscriptions", "http://jabber.org/protocol/pubsub#owner");
        }
        this.addOutPacket(Packet.packetInstance(el, from, to));
    }

    private void addSubscriptionsForNodes(JID from, JID to, String[] nodes, int subscr) {
        for (String node : nodes) {
            this.addSubscriptionsForNode(from, to, node, subscr);
        }
    }

    private String commandsHelp() {
        StringBuilder sb = new StringBuilder();
        for (command comm : command.values()) {
            sb.append("//" + comm.name() + comm.getHelp() + "\n");
        }
        return "Available commands are:\n" + sb.toString();
    }

    private String[] createNodes(JID from, JID to, int ... nums) {
        String[] nodes = new String[nums[0]];
        for (int i = 0; i < nums[0] && !this.stop; ++i) {
            String node;
            nodes[i] = node = "node-" + i;
            Element el = this.createPubSubEl(from, to, "id-" + i, node, "create", "http://jabber.org/protocol/pubsub");
            el.findChildStaticStr(IQ_PUBSUB_PATH).addChild(new Element("configure"));
            el.findChildStaticStr(IQ_PUBSUB_CONFIGURE_PATH).addChild(this.conf);
            this.addOutPacket(Packet.packetInstance(el, from, to));
            if (nums.length > 1 && nums[1] > 0) {
                this.addSubscriptionsForNode(from, to, node, nums[1]);
            }
            while (this.memoryLow()) {
                try {
                    System.gc();
                    Thread.sleep(this.delay);
                }
                catch (Exception exception) {}
            }
        }
        this.stop = false;
        return nodes;
    }

    private Element createPubSubEl(JID from, JID to, String id, String node, String pubsub_call, String xmlns) {
        Element elem = new Element("iq", new Element[]{new Element("pubsub", new Element[]{new Element(pubsub_call, new String[]{"node"}, new String[]{node})}, new String[]{"xmlns"}, new String[]{xmlns})}, new String[]{"type", "from", "to", "id"}, new String[]{"set", from.toString(), to.toString(), id});
        return elem;
    }

    private boolean isPostCommand(Packet packet) {
        String body = packet.getElemCDataStaticStr(Message.MESSAGE_BODY_PATH);
        if (body != null) {
            for (command comm : command.values()) {
                if (!body.startsWith("//" + comm.toString())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean memoryLow() {
        return TigaseRuntime.getTigaseRuntime().getHeapMemUsage() > 80.0f;
    }

    private int[] parseNumbers(String[] args, int pos, int num) {
        int[] res = new int[num];
        for (int i = 0; i < res.length; ++i) {
            try {
                res[i] = Integer.parseInt(args[i + pos]);
                continue;
            }
            catch (Exception e) {
                return null;
            }
        }
        return res;
    }

    private void runCommand(final Packet packet, Queue<Packet> results) {
        String body = packet.getElemCDataStaticStr(Message.MESSAGE_BODY_PATH);
        final String[] body_split = body.split("\\s");
        command comm = command.valueOf(body_split[0].substring(2));
        final JID to = JID.jidInstanceNS("pubsub." + this.getJID().getDomain());
        switch (comm) {
            case help: {
                results.offer(Message.getMessage(packet.getStanzaTo(), packet.getStanzaFrom(), StanzaType.chat, this.commandsHelp(), "Commands description", null, packet.getStanzaId()));
                break;
            }
            case setdelay: {
                int[] pars = this.parseNumbers(body_split, 1, 1);
                if (pars == null) break;
                this.delay = pars[0];
                break;
            }
            case newnodes: {
                final int[] pars = this.parseNumbers(body_split, 1, 1);
                if (pars != null) {
                    this.addOutPacket(Message.getMessage(packet.getStanzaTo(), packet.getStanzaFrom(), StanzaType.chat, "Task accepted, processing...", "PubSub testing task", null, packet.getStanzaId()));
                    this.runInThread(new Runnable(){

                        @Override
                        public void run() {
                            PubSubTestsTask.access$002(PubSubTestsTask.this, PubSubTestsTask.this.createNodes(packet.getStanzaFrom(), to, pars));
                        }
                    }, packet);
                    break;
                }
                results.offer(Message.getMessage(packet.getStanzaTo(), packet.getStanzaFrom(), StanzaType.chat, "Incorrect command parameters.", "PubSub testing task", null, packet.getStanzaId()));
                return;
            }
            case newsubscr: {
                if (this.last_nodes != null) {
                    final int[] pars = this.parseNumbers(body_split, 2, 1);
                    if (pars != null) {
                        this.addOutPacket(Message.getMessage(packet.getStanzaTo(), packet.getStanzaFrom(), StanzaType.chat, "Task accepted, processing...", "PubSub testing task", null, packet.getStanzaId()));
                        this.runInThread(new Runnable(){

                            @Override
                            public void run() {
                                PubSubTestsTask.this.addSubscriptionsForNode(packet.getStanzaFrom(), to, body_split[1], pars[0]);
                            }
                        }, packet);
                        break;
                    }
                    results.offer(Message.getMessage(packet.getStanzaTo(), packet.getStanzaFrom(), StanzaType.chat, "Incorrect command parameters.", "PubSub testing task", null, packet.getStanzaId()));
                    return;
                }
                results.offer(Message.getMessage(packet.getStanzaTo(), packet.getStanzaFrom(), StanzaType.chat, "There are no pubsub nodes created yet.", "PubSub testing task", null, packet.getStanzaId()));
                return;
            }
            case newnodessubscr: {
                final int[] pars = this.parseNumbers(body_split, 1, 2);
                if (pars != null) {
                    this.addOutPacket(Message.getMessage(packet.getStanzaTo(), packet.getStanzaFrom(), StanzaType.chat, "" + new Date() + " Task accepted, processing...", "PubSub testing task", null, packet.getStanzaId()));
                    this.runInThread(new Runnable(){

                        @Override
                        public void run() {
                            PubSubTestsTask.access$002(PubSubTestsTask.this, PubSubTestsTask.this.createNodes(packet.getStanzaFrom(), to, pars));
                        }
                    }, packet);
                    break;
                }
                results.offer(Message.getMessage(packet.getStanzaTo(), packet.getStanzaFrom(), StanzaType.chat, "Incorrect command parameters.", "PubSub testing task", null, packet.getStanzaId()));
                return;
            }
            case stop: {
                this.stop = true;
            }
        }
    }

    private void runInThread(final Runnable job, final Packet packet) {
        Thread thr = new Thread(){

            @Override
            public void run() {
                long gen_start = System.currentTimeMillis();
                job.run();
                long gen_end = System.currentTimeMillis();
                long gen_time = gen_end - gen_start;
                long gen_hours = gen_time / 3600000L;
                long gen_mins = (gen_time - gen_hours * 3600000L) / 60000L;
                long gen_secs = (gen_time - (gen_hours * 3600000L + gen_mins * 60000L)) / 1000L;
                PubSubTestsTask.this.addOutPacket(Message.getMessage(packet.getStanzaTo(), packet.getStanzaFrom(), StanzaType.chat, "" + new Date() + " Generation of the test data completed.\nGenerated in: " + gen_hours + "h, " + gen_mins + "m, " + gen_secs + "sec, packets generated: " + PubSubTestsTask.this.packetsGenerated, "PubSub testing task", null, packet.getStanzaId()));
            }
        };
        thr.setName("pubsub-test-job");
        thr.start();
    }

    static /* synthetic */ String[] access$002(PubSubTestsTask x0, String[] x1) {
        x0.last_nodes = x1;
        return x1;
    }

    private static enum command {
        help(" - Displays help info."),
        newnodes(" N - Create N nodes in the pubsub."),
        newsubscr(" node-name N - create N subscriptions for a given node name."),
        newnodessubscr(" N M -  create N nodes with M subscriptions each."),
        setdelay(" N - set the delay between sending node creation packet."),
        stop(" - Stops the current packets generation.");

        private String helpText = null;

        private command(String helpText) {
            this.helpText = helpText;
        }

        public String getHelp() {
            return this.helpText;
        }
    }
}

