/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.bosh;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.Bindings;
import tigase.conf.ConfigurationException;
import tigase.net.IOService;
import tigase.server.Command;
import tigase.server.Iq;
import tigase.server.Packet;
import tigase.server.ReceiverTimeoutHandler;
import tigase.server.bosh.BoshIOService;
import tigase.server.bosh.BoshSendQueueTask;
import tigase.server.bosh.BoshSession;
import tigase.server.bosh.BoshSessionTaskHandler;
import tigase.server.bosh.BoshSidLoggerFilter;
import tigase.server.bosh.BoshTask;
import tigase.server.bosh.Constants;
import tigase.server.xmppclient.ClientConnectionManager;
import tigase.server.xmppclient.SeeOtherHostIfc;
import tigase.stats.StatisticsList;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.StreamError;
import tigase.xmpp.XMPPIOService;

public class BoshConnectionManager
extends ClientConnectionManager
implements BoshSessionTaskHandler {
    private static final int DEF_PORT_NO = 5280;
    private static final Logger log = Logger.getLogger(BoshConnectionManager.class.getName());
    private int[] PORTS = new int[]{5280};
    private long min_polling = 10L;
    private long max_wait = 30L;
    private long max_pause = 10L;
    private long max_inactivity = 10L;
    private int hold_requests = 1;
    private int concurrent_requests = 2;
    private ReceiverTimeoutHandler stoppedHandler = this.newStoppedHandler();
    private ReceiverTimeoutHandler startedHandler = this.newStartedHandler();
    private int max_batch_size = 15;
    private long bosh_session_close_delay = 0L;
    private long batch_queue_timeout = 100L;
    private int maxSessionWaitingPackets = 100;
    private boolean sendNodeHostname = true;
    private static Handler sidFilehandler;
    protected final Map<UUID, BoshSession> sessions = new ConcurrentSkipListMap<UUID, BoshSession>();

    @Override
    public boolean addOutStreamClosed(Packet packet, BoshSession bs, boolean withTimeout) {
        packet.setPacketFrom(this.getFromAddress(bs.getSid().toString()));
        packet.setPacketTo(bs.getDataReceiver());
        packet.initVars(packet.getPacketFrom(), packet.getPacketTo());
        bs.close();
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "{0} : {1} ({2})", new Object[]{BOSH_OPERATION_TYPE.REMOVE, bs.getSid(), "Closing bosh session"});
        }
        this.sessions.remove(bs.getSid());
        if (withTimeout) {
            return this.addOutPacketWithTimeout(packet, this.stoppedHandler, 15L, TimeUnit.SECONDS);
        }
        return this.addOutPacket(packet);
    }

    @Override
    public boolean addOutStreamOpen(Packet packet, BoshSession bs) {
        packet.initVars(this.getFromAddress(bs.getSid().toString()), bs.getDataReceiver());
        return this.addOutPacketWithTimeout(packet, this.startedHandler, 15L, TimeUnit.SECONDS);
    }

    @Override
    public void cancelSendQueueTask(BoshSendQueueTask tt) {
        tt.cancel();
    }

    @Override
    public void cancelTask(BoshTask tt) {
        tt.cancel();
    }

    @Override
    public void processPacket(Packet packet) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Processing packet: {0}", packet.toString());
        }
        super.processPacket(packet);
    }

    protected static void setupSidlogger(Level lvl) {
        if (!Level.OFF.equals(lvl)) {
            BoshSidLoggerFilter bslf = new BoshSidLoggerFilter();
            Logger BoshConnectionManagerLogger = Logger.getLogger(BoshConnectionManager.class.getName());
            Logger BoshSessionLogger = Logger.getLogger(BoshSession.class.getName());
            if (BoshConnectionManagerLogger.getLevel() == null || BoshSessionLogger.getLevel() == null || BoshConnectionManagerLogger.getLevel().intValue() < lvl.intValue()) {
                BoshConnectionManagerLogger.setLevel(lvl);
                BoshConnectionManagerLogger.setFilter(bslf);
                BoshSessionLogger.setLevel(lvl);
                BoshSessionLogger.setFilter(bslf);
                BoshConnectionManagerLogger.getParent().setFilter(bslf);
            }
            try {
                if (null == sidFilehandler) {
                    sidFilehandler = new FileHandler("logs/bosh_sid.log", 10000000, 5, false);
                    sidFilehandler.setLevel(lvl);
                    sidFilehandler.setFilter(bslf);
                    BoshConnectionManagerLogger.getParent().addHandler(sidFilehandler);
                }
            }
            catch (IOException ex) {
                log.log(Level.CONFIG, "Error creating BOSH SID logger" + ex);
            }
        }
    }

    @Override
    protected void setupWatchdogThread() {
    }

    protected Map<String, String> preBindSession(Map<String, String> attr) {
        String hostname = attr.get("to");
        ArrayDeque<Packet> out_results = new ArrayDeque<Packet>(2);
        BoshSession bs = new BoshSession(this.getDefVHostItem().getDomain(), JID.jidInstanceNS(this.routings.computeRouting(hostname)), this, this.sendNodeHostname ? this.getDefHostName().getDomain() : null, this.maxSessionWaitingPackets);
        String jid = attr.get("from");
        String uuid = UUID.randomUUID().toString();
        JID userId = JID.jidInstanceNS(jid);
        if (null == userId.getResource()) {
            userId = userId.copyWithResourceNS(uuid);
            attr.put("from", userId.toString());
            bs.setUserJid(jid);
        }
        long rid = (long)(Math.random() * 1.0E7);
        attr.put("rid", Long.toString(rid));
        UUID sid = bs.getSid();
        this.sessions.put(sid, bs);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "{0} : {1} ({2})", new Object[]{BOSH_OPERATION_TYPE.CREATE, bs.getSid(), "Pre-bind"});
        }
        attr.put("sid", sid.toString());
        Packet p = null;
        try {
            Element el = new Element("body");
            el.setAttributes(attr);
            p = Packet.packetInstance(el);
            p.setPacketTo(this.getComponentId().copyWithResource(sid.toString()));
        }
        catch (TigaseStringprepException ex) {
            Logger.getLogger(BoshConnectionManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        bs.init(p, null, this.max_wait, this.min_polling, this.max_inactivity, this.concurrent_requests, this.hold_requests, this.max_pause, this.max_batch_size, this.batch_queue_timeout, out_results, true);
        this.addOutPackets(out_results, bs);
        attr.put("hostname", this.getDefHostName().toString());
        return attr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Queue<Packet> processSocketData(XMPPIOService<Object> srv) {
        BoshIOService serv = (BoshIOService)srv;
        Packet p = null;
        while ((p = serv.getReceivedPackets().poll()) != null) {
            ArrayDeque<Packet> out_results = new ArrayDeque<Packet>(2);
            BoshSession bs = null;
            String sid_str = null;
            Object object = this.sessions;
            synchronized (object) {
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "Processing packet: {0}, type: {1}", new Object[]{p.getElemName(), p.getType()});
                }
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Processing socket data: {0}", p);
                }
                sid_str = p.getAttributeStaticStr("sid");
                UUID sid = null;
                if (sid_str == null) {
                    String hostname = p.getAttributeStaticStr("to");
                    if (hostname != null && this.isLocalDomain(hostname)) {
                        if (!this.isAllowed(srv, hostname)) {
                            if (log.isLoggable(Level.FINE)) {
                                log.log(Level.FINE, "Policy violation. Closing connection: {0}", p);
                            }
                            try {
                                serv.sendErrorAndStop(Authorization.NOT_ALLOWED, StreamError.PolicyViolation, p, "Policy violation.");
                            }
                            catch (IOException e) {
                                log.log(Level.WARNING, "Problem sending invalid hostname error for sid =  " + sid, e);
                            }
                        } else {
                            bs = new BoshSession(this.getDefVHostItem().getDomain(), JID.jidInstanceNS(this.routings.computeRouting(hostname)), this, this.sendNodeHostname ? this.getDefHostName().getDomain() : null, this.maxSessionWaitingPackets);
                            sid = bs.getSid();
                            this.sessions.put(sid, bs);
                            if (log.isLoggable(Level.FINE)) {
                                log.log(Level.FINE, "{0} : {1} ({2})", new Object[]{BOSH_OPERATION_TYPE.CREATE, sid, "Socket bosh session"});
                            }
                        }
                    } else {
                        try {
                            serv.sendErrorAndStop(Authorization.NOT_ALLOWED, hostname == null ? StreamError.ImproperAddressing : StreamError.HostUnknown, p, "Invalid hostname.");
                        }
                        catch (IOException e) {
                            log.log(Level.WARNING, "Problem sending invalid hostname error for sid =  " + sid, e);
                        }
                    }
                } else {
                    try {
                        sid = UUID.fromString(sid_str);
                        bs = this.sessions.get(sid);
                    }
                    catch (IllegalArgumentException e) {
                        log.log(Level.WARNING, "Problem processing socket data, sid =  " + sid_str + " does not conform to the UUID string representation.", e);
                    }
                }
            }
            try {
                if (bs != null) {
                    object = bs;
                    synchronized (object) {
                        if (sid_str == null) {
                            bs.init(p, serv, this.max_wait, this.min_polling, this.max_inactivity, this.concurrent_requests, this.hold_requests, this.max_pause, this.max_batch_size, this.batch_queue_timeout, out_results);
                        } else {
                            bs.processSocketPacket(p, serv, out_results);
                        }
                    }
                } else {
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "{0} : {1} ({2})", new Object[]{BOSH_OPERATION_TYPE.INVALID_SID, sid_str, "Invalid SID"});
                    }
                    serv.sendErrorAndStop(Authorization.ITEM_NOT_FOUND, null, p, "Invalid SID");
                }
                this.addOutPackets(out_results, bs);
            }
            catch (IOException e) {
                log.log(Level.WARNING, "Problem processing socket data for sid =  " + sid_str, e);
            }
        }
        return null;
    }

    @Override
    public BoshSendQueueTask scheduleSendQueueTask(BoshSession bs, long delay) {
        BoshSendQueueTask bt = new BoshSendQueueTask(bs);
        this.addTimerTask(bt, delay);
        return bt;
    }

    @Override
    public BoshTask scheduleTask(BoshSession bs, long delay) {
        BoshTask bt = new BoshTask(bs, this);
        this.addTimerTask(bt, delay);
        return bt;
    }

    @Override
    public void serviceStarted(XMPPIOService<Object> service) {
        super.serviceStarted(service);
    }

    @Override
    public boolean serviceStopped(XMPPIOService<Object> xmppService) {
        BoshSession bs;
        BoshIOService service = (BoshIOService)xmppService;
        boolean result = super.serviceStopped(service);
        UUID sid = service.getSid();
        if (sid != null && (bs = this.sessions.get(sid)) != null) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "{0} : {1} ({2})", new Object[]{BOSH_OPERATION_TYPE.REMOVE, bs.getSid(), "Closing bosh session"});
            }
            bs.disconnected(service);
        }
        return result;
    }

    @Override
    public void writeRawData(BoshIOService ios, String data) {
        super.writeRawData(ios, data);
    }

    @Override
    public void xmppStreamClosed(XMPPIOService<Object> serv) {
        if (log.isLoggable(Level.FINER)) {
            log.finer("Stream closed.");
        }
    }

    @Override
    public String xmppStreamOpened(XMPPIOService<Object> serv, Map<String, String> attribs) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Ups, what just happened? Stream open. Hey, this is a Bosh connection manager. c2s and s2s are not supported on the same port as Bosh yet.");
        }
        return "<?xml version='1.0'?><stream:stream xmlns='jabber:client' xmlns:stream='http://etherx.jabber.org/streams' id='1' from='" + this.getDefVHostItem() + "' version='1.0' xml:lang='en'><stream:error><invalid-namespace xmlns='urn:ietf:params:xml:ns:xmpp-streams'/><text xmlns='urn:ietf:params:xml:ns:xmpp-streams' xml:lang='langcode'>Ups, what just happened? Stream open. Hey, this is a Bosh connection manager. c2s and s2s are not supported on the same port... yet.</text></stream:error></stream:stream>";
    }

    @Override
    public Map<String, Object> getDefaults(Map<String, Object> params) {
        Map<String, Object> props = super.getDefaults(params);
        props.put("max-wait", 30L);
        props.put("min-polling", 10L);
        props.put("max-inactivity", 10L);
        props.put("concurrent-requests", 2);
        props.put("hold-requests", 1);
        props.put("max-inactivity", 10L);
        props.put("max-batch-size", 15);
        props.put("batch-queue-timeout", 100L);
        props.put("max-session-waiting-packets", 100);
        props.put("send-node-hostname", true);
        props.put("sid-logger-level", Constants.SID_LOGGER_VAL);
        return props;
    }

    @Override
    public String getDiscoCategoryType() {
        return "c2s";
    }

    @Override
    public String getDiscoDescription() {
        return "Bosh connection manager";
    }

    @Override
    public JID getJidForBoshSession(BoshSession bs) {
        return this.getFromAddress(bs.getSid().toString());
    }

    @Override
    public Element getSeeOtherHostError(Packet packet, BareJID destination) {
        Object xmppioService = this.getXMPPIOService(packet);
        Integer redirect_port = (Integer)((IOService)xmppioService).getSessionData().get("force-redirect-to");
        return this.see_other_host_strategy.getStreamError("urn:ietf:params:xml:ns:xmpp-streams", destination, redirect_port);
    }

    @Override
    public BareJID getSeeOtherHostForJID(Packet packet, BareJID fromJID, SeeOtherHostIfc.Phase ph) {
        Object xmppioService;
        if (this.see_other_host_strategy == null) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("no see-other-host implementation set");
            }
            return null;
        }
        if (!this.see_other_host_strategy.isEnabled(this.vHostManager.getVHostItem(fromJID.getDomain()), ph)) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("see-other-host not enabled for the Phase: " + ph.toString());
            }
            return null;
        }
        BareJID see_other_host = this.see_other_host_strategy.findHostForJID(fromJID, this.getDefHostName());
        if (log.isLoggable(Level.FINEST)) {
            log.finest("using = " + this.see_other_host_strategy.getClass().getCanonicalName() + "for jid = " + fromJID.toString() + " got = " + (see_other_host != null ? see_other_host.toString() : "null") + " in phase: " + ph.toString());
        }
        Integer redirect_port = (xmppioService = this.getXMPPIOService(packet)) != null ? (Integer)((IOService)xmppioService).getSessionData().getOrDefault("force-redirect-to", -1) : -1;
        return see_other_host != null && (redirect_port > 0 || this.see_other_host_strategy.isRedirectionRequired(this.getDefHostName(), see_other_host)) ? see_other_host : null;
    }

    @Override
    public void getStatistics(StatisticsList list) {
        super.getStatistics(list);
        if (list.checkLevel(Level.FINEST)) {
            list.add(this.getName(), "Bosh sessions", this.sessions.size(), Level.FINEST);
        }
    }

    @Override
    public void setProperties(Map<String, Object> props) throws ConfigurationException {
        super.setProperties(props);
        if (props.get("max-wait") != null) {
            this.max_wait = (Long)props.get("max-wait");
            log.info("Setting max_wait to: " + this.max_wait);
        }
        if (props.get("min-polling") != null) {
            this.min_polling = (Long)props.get("min-polling");
            log.info("Setting min_polling to: " + this.min_polling);
        }
        if (props.get("max-inactivity") != null) {
            this.max_inactivity = (Long)props.get("max-inactivity");
            log.info("Setting max_inactivity to: " + this.max_inactivity);
        }
        if (props.get("concurrent-requests") != null) {
            this.concurrent_requests = (Integer)props.get("concurrent-requests");
            log.info("Setting concurrent_requests to: " + this.concurrent_requests);
        }
        if (props.get("hold-requests") != null) {
            this.hold_requests = (Integer)props.get("hold-requests");
            log.info("Setting hold_requests to: " + this.hold_requests);
        }
        if (props.get("max-inactivity") != null) {
            this.max_pause = (Long)props.get("max-inactivity");
            log.info("Setting max_pause to: " + this.max_pause);
        }
        if (props.get("max-batch-size") != null) {
            this.max_batch_size = (Integer)props.get("max-batch-size");
            log.info("Setting max_batch_size to: " + this.max_batch_size);
        }
        if (props.get("batch-queue-timeout") != null) {
            this.batch_queue_timeout = (Long)props.get("batch-queue-timeout");
            log.info("Setting batch_queue_timeout to: " + this.batch_queue_timeout);
        }
        if (props.get("max-session-waiting-packets") != null) {
            this.maxSessionWaitingPackets = (Integer)props.get("max-session-waiting-packets");
            log.info("Setting max session waiting packets to: " + this.maxSessionWaitingPackets);
        }
        if (props.get("send-node-hostname") != null) {
            this.sendNodeHostname = (Boolean)props.get("send-node-hostname");
        }
        if (props.size() == 1 && props.get("sid-logger-level") != null) {
            Level lvl = Level.parse((String)props.get("sid-logger-level"));
            BoshConnectionManager.setupSidlogger(lvl);
            log.info("Setting SID log level to: " + lvl);
        }
    }

    protected void addOutPackets(Queue<Packet> out_results, BoshSession bs) {
        for (Packet res : out_results) {
            res.setPacketFrom(this.getFromAddress(bs.getSid().toString()));
            res.setPacketTo(bs.getDataReceiver());
            if (res.getCommand() != null) {
                switch (res.getCommand()) {
                    case STREAM_CLOSED: 
                    case GETFEATURES: {
                        res.initVars(res.getPacketFrom(), res.getPacketTo());
                        break;
                    }
                }
            }
            this.addOutPacket(res);
        }
        out_results.clear();
    }

    @Override
    protected JID changeDataReceiver(Packet packet, JID newAddress, String command_sessionId, XMPPIOService<Object> serv) {
        BoshSession session = this.getBoshSession(packet.getTo());
        if (session != null) {
            String sessionId = session.getSessionId();
            if (sessionId.equals(command_sessionId)) {
                JID old_receiver = session.getDataReceiver();
                session.setDataReceiver(newAddress);
                return old_receiver;
            }
            log.info("Incorrect session ID, ignoring data redirect for: " + newAddress);
        }
        return null;
    }

    @Override
    protected ReceiverTimeoutHandler newStartedHandler() {
        return new StartedHandler();
    }

    @Override
    protected void processCommand(Packet packet) {
        BoshSession session = this.getBoshSession(packet.getTo());
        switch (packet.getCommand()) {
            case USER_LOGIN: {
                String jid = Command.getFieldValue(packet, "user-jid");
                if (jid != null) {
                    if (session != null) {
                        try {
                            BareJID fromJID = BareJID.bareJIDInstance(jid);
                            BareJID hostJid = this.getSeeOtherHostForJID(packet, fromJID, SeeOtherHostIfc.Phase.LOGIN);
                            if (hostJid != null) {
                                Object xmppioService = this.getXMPPIOService(packet);
                                Integer port = (Integer)((IOService)xmppioService).getSessionData().get("force-redirect-to");
                                Element streamErrorElement = this.see_other_host_strategy.getStreamError("urn:ietf:params:xml:ns:xmpp-streams", hostJid, port);
                                Packet redirectPacket = Packet.packetInstance(streamErrorElement);
                                redirectPacket.setPacketTo(packet.getTo());
                                this.writePacketToSocket(redirectPacket);
                                session.sendWaitingPackets();
                                session.close();
                                if (log.isLoggable(Level.FINE)) {
                                    log.log(Level.FINE, "{0} : {1} ({2})", new Object[]{BOSH_OPERATION_TYPE.REMOVE, session.getSid(), "See other host"});
                                }
                                this.sessions.remove(session.getSid());
                                break;
                            }
                            session.setUserJid(jid);
                        }
                        catch (TigaseStringprepException ex) {
                            log.log(Level.SEVERE, "user JID violates RFC6122 (XMPP:Address Format): ", ex);
                        }
                        break;
                    }
                    if (!log.isLoggable(Level.FINE)) break;
                    log.log(Level.FINE, "Missing XMPPIOService for USER_LOGIN command: {0}", packet);
                    break;
                }
                log.log(Level.WARNING, "Missing user-jid for USER_LOGIN command: {0}", packet);
                break;
            }
            case CLOSE: {
                if (session != null) {
                    if (log.isLoggable(Level.FINER)) {
                        log.log(Level.FINER, "Closing session for command CLOSE: {0}", session.getSid());
                    }
                    try {
                        List<Element> err_el = packet.getElement().getChildrenStaticStr(Iq.IQ_COMMAND_PATH);
                        if (err_el != null && err_el.size() > 0) {
                            Element error = new Element("stream:error");
                            error.addChild(err_el.get(0));
                            Packet condition = Packet.packetInstance(error);
                            condition.setPacketTo(packet.getTo());
                            this.writePacketToSocket(condition);
                            session.sendWaitingPackets();
                            this.bosh_session_close_delay = 100L;
                        }
                    }
                    catch (TigaseStringprepException ex) {
                        Logger.getLogger(BoshConnectionManager.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    if (this.bosh_session_close_delay > 0L) {
                        try {
                            Thread.sleep(this.bosh_session_close_delay);
                        }
                        catch (InterruptedException ex) {
                            // empty catch block
                        }
                    }
                    session.close();
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "{0} : {1} ({2})", new Object[]{BOSH_OPERATION_TYPE.REMOVE, session.getSid(), "Closing session for command CLOSE"});
                    }
                    this.sessions.remove(session.getSid());
                    break;
                }
                if (!log.isLoggable(Level.FINE)) break;
                log.log(Level.FINE, "Session does not exist for packet: {0}", packet);
                break;
            }
            case CHECK_USER_CONNECTION: {
                if (session != null) {
                    this.addOutPacket(packet.okResult((String)null, 0));
                    break;
                }
                try {
                    this.addOutPacket(Authorization.ITEM_NOT_FOUND.getResponseMessage(packet, "Connection gone.", false));
                }
                catch (PacketErrorTypeException e) {
                    log.log(Level.INFO, "Error packet is not really expected here: {0}", packet);
                }
                break;
            }
            default: {
                super.processCommand(packet);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean writePacketToSocket(Packet packet) {
        BoshSession session = this.getBoshSession(packet.getTo());
        if (session != null) {
            BoshSession boshSession = session;
            synchronized (boshSession) {
                ArrayDeque<Packet> out_results = new ArrayDeque<Packet>();
                session.processPacket(packet, out_results);
                this.addOutPackets(out_results, session);
            }
            return true;
        }
        log.info("Session does not exist for packet: " + packet.toString());
        return false;
    }

    protected BoshSession getBoshSession(JID jid) {
        String res = jid.getResource();
        if (res != null) {
            UUID sid = UUID.fromString(res);
            return this.sessions.get(sid);
        }
        return null;
    }

    @Override
    protected int[] getDefPlainPorts() {
        return this.PORTS;
    }

    @Override
    protected int[] getDefSSLPorts() {
        return null;
    }

    @Override
    protected long getMaxInactiveTime() {
        return 600000L;
    }

    @Override
    public void initBindings(Bindings binds) {
        super.initBindings(binds);
        binds.put("boshCM", (Object)this);
    }

    @Override
    protected BoshIOService getXMPPIOServiceInstance() {
        return new BoshIOService();
    }

    private JID getFromAddress(String id) {
        return JID.jidInstanceNS(this.getName(), this.getDefHostName().getDomain(), id);
    }

    private class StartedHandler
    implements ReceiverTimeoutHandler {
        private StartedHandler() {
        }

        @Override
        public void responseReceived(Packet packet, Packet response) {
            String pb = Command.getFieldValue(packet, "prebind");
            boolean prebind = Boolean.valueOf(pb);
            String sessionId = Command.getFieldValue(packet, "session-id");
            String userID = Command.getFieldValue(packet, "jid");
            if (prebind) {
                Packet packetOut = Command.USER_STATUS.getPacket(packet.getFrom(), packet.getTo(), StanzaType.get, UUID.randomUUID().toString());
                Command.addFieldValue(packetOut, "jid", userID);
                if (null != sessionId) {
                    Command.addFieldValue(packetOut, "session-id", sessionId);
                }
                Command.addFieldValue(packetOut, "prebind", String.valueOf(prebind));
                BoshConnectionManager.this.addOutPacket(packetOut);
            } else {
                BoshConnectionManager.this.addOutPacket(Command.GETFEATURES.getPacket(packet.getFrom(), packet.getTo(), StanzaType.get, UUID.randomUUID().toString(), null));
            }
        }

        @Override
        public void timeOutExpired(Packet packet) {
            log.warning("No response within time limit received for a packet: " + packet.toString());
            BoshSession session = BoshConnectionManager.this.getBoshSession(packet.getFrom());
            if (session != null) {
                log.fine("Closing session for timeout: " + session.getSid());
                session.close();
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "{0} : {1} ({2})", new Object[]{BOSH_OPERATION_TYPE.REMOVE, session.getSid(), "Closing session for timeout"});
                }
                BoshConnectionManager.this.sessions.remove(session.getSid());
            } else {
                log.info("Session does not exist for packet: " + packet.toString());
            }
        }
    }

    protected static enum BOSH_OPERATION_TYPE {
        CREATE,
        REMOVE,
        INVALID_SID,
        TIMER;

        private static final Map<String, BOSH_OPERATION_TYPE> nameToValueMap;

        public static BOSH_OPERATION_TYPE forName(String name) {
            return nameToValueMap.get(name);
        }

        static {
            nameToValueMap = new HashMap<String, BOSH_OPERATION_TYPE>();
            for (BOSH_OPERATION_TYPE value : EnumSet.allOf(BOSH_OPERATION_TYPE.class)) {
                nameToValueMap.put(value.name(), value);
            }
        }
    }
}

