/*
 * Decompiled with CFR 0.152.
 */
package tigase.db;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.DBInitException;
import tigase.db.DataRepository;
import tigase.stats.StatisticsList;
import tigase.stats.StatisticsProviderIfc;
import tigase.xmpp.BareJID;

public class DataRepositoryPool
implements DataRepository,
StatisticsProviderIfc {
    private static final Logger log = Logger.getLogger(DataRepositoryPool.class.getName());
    private CopyOnWriteArrayList<DataRepository> repoPool = new CopyOnWriteArrayList();
    private String resource_uri = null;
    private DataRepository.dbTypes database = null;

    public void addRepo(DataRepository repo) {
        this.repoPool.addIfAbsent(repo);
    }

    public DataRepository takeRepo(BareJID user_id) {
        int idx = user_id != null ? Math.abs(user_id.hashCode() % this.repoPool.size()) : 0;
        DataRepository result = null;
        try {
            result = this.repoPool.get(idx);
        }
        catch (IndexOutOfBoundsException ioobe) {
            result = this.repoPool.get(0);
        }
        return result;
    }

    @Override
    public DataRepository takeRepoHandle(BareJID user_id) {
        return this.takeRepo(user_id);
    }

    @Override
    public void releaseRepoHandle(DataRepository repo) {
    }

    @Override
    public boolean checkTable(String tableName) throws SQLException {
        DataRepository repo = this.takeRepo(null);
        if (repo != null) {
            return repo.checkTable(tableName);
        }
        log.log(Level.WARNING, "repo is NULL, pool empty? - {0}", this.repoPool.size());
        return false;
    }

    @Override
    public boolean checkTable(String tableName, String createTableQuery) throws SQLException {
        DataRepository repo = this.takeRepo(null);
        if (repo != null) {
            return repo.checkTable(tableName, createTableQuery);
        }
        log.log(Level.WARNING, "repo is NULL, pool empty? - {0}", this.repoPool.size());
        return false;
    }

    @Override
    public Statement createStatement(BareJID user_id) throws SQLException {
        DataRepository repo = this.takeRepo(user_id);
        if (repo != null) {
            return repo.createStatement(user_id);
        }
        log.log(Level.WARNING, "repo is NULL, pool empty? - {0}", this.repoPool.size());
        return null;
    }

    @Override
    public PreparedStatement getPreparedStatement(BareJID user_id, String stIdKey) throws SQLException {
        DataRepository repo = this.takeRepo(user_id);
        if (repo != null) {
            return repo.getPreparedStatement(user_id, stIdKey);
        }
        log.log(Level.WARNING, "repo is NULL, pool empty? - {0}", this.repoPool.size());
        return null;
    }

    @Override
    public String getResourceUri() {
        return this.resource_uri;
    }

    @Override
    public DataRepository.dbTypes getDatabaseType() {
        return this.database;
    }

    @Override
    public void getStatistics(String compName, StatisticsList list) {
        list.add(compName, "repository " + this.getResourceUri() + " connections count", this.repoPool.size(), Level.FINE);
        for (DataRepository repo : this.repoPool) {
            if (!(repo instanceof StatisticsProviderIfc)) continue;
            ((StatisticsProviderIfc)((Object)repo)).getStatistics(compName, list);
        }
    }

    @Override
    public void initPreparedStatement(String stIdKey, String query) throws SQLException {
        for (DataRepository dataRepository : this.repoPool) {
            dataRepository.initPreparedStatement(stIdKey, query);
        }
    }

    @Override
    public void initPreparedStatement(String stIdKey, String query, int autoGeneratedKeys) throws SQLException {
        for (DataRepository dataRepository : this.repoPool) {
            dataRepository.initPreparedStatement(stIdKey, query, autoGeneratedKeys);
        }
    }

    @Override
    public void initRepository(String resource_uri, Map<String, String> params) throws DBInitException {
        this.resource_uri = resource_uri;
        for (DataRepository dataRepository : this.repoPool) {
            dataRepository.initRepository(resource_uri, params);
            this.database = dataRepository.getDatabaseType();
        }
        if (this.database == null) {
            if (resource_uri.startsWith("jdbc:postgresql")) {
                this.database = DataRepository.dbTypes.postgresql;
            } else if (resource_uri.startsWith("jdbc:mysql")) {
                this.database = DataRepository.dbTypes.mysql;
            } else if (resource_uri.startsWith("jdbc:derby")) {
                this.database = DataRepository.dbTypes.derby;
            } else if (resource_uri.startsWith("jdbc:jtds:sqlserver")) {
                this.database = DataRepository.dbTypes.jtds;
            } else if (resource_uri.startsWith("jdbc:sqlserver")) {
                this.database = DataRepository.dbTypes.sqlserver;
            }
        }
    }

    @Override
    public void release(Statement stmt, ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Override
    public void startTransaction() throws SQLException {
    }

    @Override
    public void commit() throws SQLException {
    }

    @Override
    public void rollback() throws SQLException {
    }

    @Override
    public void endTransaction() throws SQLException {
    }
}

