/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.admin;

import groovy.lang.Writable;
import groovy.text.GStringTemplateEngine;
import groovy.text.Template;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.AsyncContext;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.groovy.control.CompilationFailedException;
import tigase.http.ServiceImpl;
import tigase.http.api.Service;
import tigase.server.Command;
import tigase.server.Packet;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;
import tigase.xmpp.StanzaType;

public class Servlet
extends HttpServlet {
    private static final Logger log = Logger.getLogger(Servlet.class.getCanonicalName());
    public static final String MODULE_ID_KEY = "module-id-key";
    public static final String SCRIPTS_DIR_KEY = "scripts-dir";
    private Service service = null;
    private File scriptsDir = null;
    private static final String DISCO_ITEMS_XMLNS = "http://jabber.org/protocol/disco#items";
    private static final String ADHOC_COMMANDS_XMLNS = "http://jabber.org/protocol/commands";

    public void init() throws ServletException {
        super.init();
        ServletConfig cfg = super.getServletConfig();
        String moduleName = cfg.getInitParameter(MODULE_ID_KEY);
        this.service = new ServiceImpl(moduleName);
        this.scriptsDir = new File(cfg.getInitParameter(SCRIPTS_DIR_KEY));
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            this.processRequest(request, response);
        }
        catch (Exception ex) {
            log.log(Level.FINE, "exception processing request", ex);
            response.sendError(500);
        }
    }

    private void processRequest(HttpServletRequest request, HttpServletResponse response) throws TigaseStringprepException, IOException, ServletException {
        if (request.getUserPrincipal() == null && !request.authenticate(response)) {
            return;
        }
        AsyncContext asyncCtx = request.startAsync((ServletRequest)request, (ServletResponse)response);
        HashMap model = new HashMap();
        this.retrieveComponentsCommands(request.getUserPrincipal(), commands -> {
            model.put("commands", commands);
            try {
                String node = request.getParameter("_node");
                String jidStr = request.getParameter("_jid");
                if (node != null && jidStr != null) {
                    JID jid = JID.jidInstance((String)jidStr);
                    this.processRequestStep(request, asyncCtx, model, jid, node, null);
                } else {
                    this.generateResult(asyncCtx, model);
                }
            }
            catch (Exception ex) {
                log.log(Level.FINE, "exception processing HTTP request", ex);
            }
        });
    }

    public void processRequestStep(HttpServletRequest request, AsyncContext asyncCtx, Map model, JID jid, String node, List<Element> formFields) throws TigaseStringprepException {
        this.executeAdhocForm(request.getUserPrincipal(), jid, node, formFields, (formType1, formFields1) -> {
            int iteration;
            int n = iteration = model.containsKey("iteration") ? (Integer)model.get("iteration") : 1;
            if (formType1 == Command.DataType.form && (this.requestHasValuesForFields((List<Element>)formFields1, request) && iteration < 10 || iteration == 1 && "POST".equals(request.getMethod()))) {
                this.setFieldValuesFromRequest((List<Element>)formFields1, request, iteration);
                model.put("iteration", ++iteration);
                try {
                    this.processRequestStep(request, asyncCtx, model, jid, node, (List<Element>)formFields1);
                }
                catch (TigaseStringprepException ex) {
                    log.log(Level.FINE, "exception processing HTTP request", ex);
                }
            } else {
                model.put("formFields", formFields1);
                try {
                    this.generateResult(asyncCtx, model);
                }
                catch (Exception ex) {
                    log.log(Level.FINE, "exception processing HTTP request", ex);
                }
            }
        });
    }

    private void generateResult(AsyncContext asyncCtx, Map model) throws IOException, CompilationFailedException, ClassNotFoundException {
        GStringTemplateEngine templateEngine = new GStringTemplateEngine();
        File file = new File(this.scriptsDir, "template.html");
        Template template = templateEngine.createTemplate(file);
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("imports", new ArrayList());
        context.put("model", model);
        context.put("request", asyncCtx.getRequest());
        context.put("response", asyncCtx.getResponse());
        Writable result = template.make(context);
        result.writeTo((Writer)asyncCtx.getResponse().getWriter());
        asyncCtx.complete();
    }

    private void executeAdhocForm(Principal principal, JID componentJid, String node, List<Element> formFields, CallbackExecuteForm<List<Element>> callback) throws TigaseStringprepException {
        Element iqEl = new Element("iq");
        iqEl.setXMLNS("jabber:client");
        iqEl.setAttribute("from", principal.getName());
        iqEl.setAttribute("type", StanzaType.set.name());
        iqEl.setAttribute("to", componentJid.toString());
        Element commandEl = new Element("command");
        commandEl.setXMLNS(ADHOC_COMMANDS_XMLNS);
        commandEl.setAttribute("node", node);
        iqEl.addChild((XMLNodeIfc)commandEl);
        if (formFields != null) {
            Element x = new Element("x", new String[]{"xmlns", "type"}, new String[]{"jabber:x:data", "submit"});
            formFields.forEach(formField -> x.addChild((XMLNodeIfc)formField));
            commandEl.addChild((XMLNodeIfc)x);
        }
        Packet iq = Packet.packetInstance((Element)iqEl);
        this.service.sendPacket(iq, null, result -> {
            Element xEl = result.getElement().findChildStaticStr(new String[]{"iq", "command", "x"});
            List<Element> fields = xEl == null ? new ArrayList() : xEl.getChildren();
            Command.DataType formType = xEl != null && xEl.getAttributeStaticStr("type") != null ? Command.DataType.valueOf((String)xEl.getAttributeStaticStr("type")) : Command.DataType.result;
            fields.forEach(e -> {
                if (e.getName() != "field") {
                    return;
                }
                if (e.getAttributeStaticStr("type") == null) {
                    e.setAttribute("type", formType == Command.DataType.form ? "text-single" : "fixed");
                }
            });
            if (fields.isEmpty()) {
                fields.add(new Element("title", "Execution completed"));
            }
            callback.call(formType, fields);
        });
    }

    private void retrieveComponentsCommands(Principal principal, Callback<List<Map>> callback) throws TigaseStringprepException {
        this.retrieveComponents(principal, componentJids -> {
            AtomicInteger counter = new AtomicInteger(componentJids.size());
            ArrayList commands = new ArrayList();
            componentJids.forEach(jid -> {
                try {
                    this.retrieveComponentCommands(principal, (JID)jid, componentCommands -> {
                        List list2 = commands;
                        synchronized (list2) {
                            if (componentCommands != null) {
                                commands.addAll(componentCommands);
                            }
                        }
                        if (counter.decrementAndGet() == 0) {
                            callback.call(commands);
                        }
                    });
                }
                catch (TigaseStringprepException ex) {
                    Logger.getLogger(Servlet.class.getName()).log(Level.FINE, null, ex);
                }
            });
        });
    }

    private void retrieveComponents(Principal principal, Callback<List<JID>> callback) throws TigaseStringprepException {
        long start = System.currentTimeMillis();
        Element iqEl = new Element("iq");
        iqEl.setXMLNS("jabber:client");
        iqEl.setAttribute("from", principal.getName());
        BareJID jid = BareJID.bareJIDInstance((String)principal.getName());
        iqEl.setAttribute("type", StanzaType.get.name());
        iqEl.setAttribute("to", jid.getDomain());
        Element queryEl = new Element("query");
        queryEl.setXMLNS(DISCO_ITEMS_XMLNS);
        iqEl.addChild((XMLNodeIfc)queryEl);
        Packet iq = Packet.packetInstance((Element)iqEl);
        this.service.sendPacket(iq, (Long)1L, result -> {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "discovery of components took {0}ms", System.currentTimeMillis() - start);
            }
            if (result == null || result.getType() != StanzaType.result) {
                log.fine("discovery of components failed");
                callback.call(null);
                return;
            }
            List jids = result.getElement().getChild("query", DISCO_ITEMS_XMLNS).mapChildren(item -> JID.jidInstanceNS((String)item.getAttributeStaticStr("jid")));
            callback.call(jids);
        });
    }

    private void retrieveComponentCommands(Principal principal, JID componentJid, Callback<List<Map>> callback) throws TigaseStringprepException {
        long start = System.currentTimeMillis();
        Element iqEl = new Element("iq");
        iqEl.setXMLNS("jabber:client");
        iqEl.setAttribute("from", principal.getName());
        iqEl.setAttribute("type", StanzaType.get.name());
        iqEl.setAttribute("to", componentJid.toString());
        Element queryEl = new Element("query");
        queryEl.setXMLNS(DISCO_ITEMS_XMLNS);
        queryEl.setAttribute("node", ADHOC_COMMANDS_XMLNS);
        iqEl.addChild((XMLNodeIfc)queryEl);
        Packet iq = Packet.packetInstance((Element)iqEl);
        this.service.sendPacket(iq, (Long)1L, result -> {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "discovery of commands of component {0} took {1}ms", new Object[]{componentJid, System.currentTimeMillis() - start});
            }
            if (result == null || result.getType() != StanzaType.result) {
                log.log(Level.FINE, "discovery of component {0} adhoc commands failed", componentJid);
                callback.call(null);
                return;
            }
            List commands = result.getElement().getChild("query", DISCO_ITEMS_XMLNS).mapChildren(item -> item.getAttributes());
            callback.call(commands);
        });
    }

    private boolean requestHasValuesForFields(List<Element> formFields, HttpServletRequest request) {
        ArrayList<String> missing;
        int contains = 0;
        int needed = 0;
        ArrayList<String> arrayList = missing = log.isLoggable(Level.FINEST) ? new ArrayList<String>() : null;
        if (formFields != null) {
            for (Element formField : formFields) {
                String type;
                if (formField.getName() != "field" || (type = formField.getAttributeStaticStr("type")) == null || "boolean".equals(type) || "fixed".equals(type)) continue;
                if (request.getParameter(formField.getAttributeStaticStr("var")) != null || request.getParameterValues(formField.getAttributeStaticStr("var")) != null) {
                    ++contains;
                } else if (missing != null) {
                    missing.add(formField.getAttributeStaticStr("var"));
                }
                ++needed;
            }
        }
        if (log.isLoggable(Level.FINEST) && contains != needed && needed > 0) {
            log.log(Level.FINEST, "for URI = {0} needed field {1} but got {2}, still missing = {3}", new Object[]{String.valueOf(request.getRequestURI()) + "?" + request.getQueryString(), needed, contains, missing});
        }
        return contains == needed && needed > 0;
    }

    private void setFieldValuesFromRequest(List<Element> formFields, HttpServletRequest request, int iteration) {
        if (formFields == null) {
            return;
        }
        formFields.forEach(formField -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[10] lbl96 : CaseStatement: default:\u000a, @NONE, blocks:[10] lbl96 : CaseStatement: default:\u000a]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
             *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
             *     at java.base/java.util.TimSort.sort(TimSort.java:220)
             *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
             *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
             *     at java.base/java.util.Collections.sort(Collections.java:178)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
    }

    private static /* synthetic */ void lambda$12(Element element, List list, Element oldChild) {
        if (oldChild != null) {
            element.removeChild(oldChild);
            list.add(oldChild);
        }
    }

    private static interface Callback<T> {
        public void call(T var1);
    }

    private static interface CallbackExecuteForm<T> {
        public void call(Command.DataType var1, T var2);
    }
}

