/*
 * Decompiled with CFR 0.152.
 */
package tigase.licence.callbacks;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.cluster.strategy.ClusteringStrategyIfc;
import tigase.conf.ConfiguratorAbstract;
import tigase.db.comp.RepositoryItem;
import tigase.licence.Licence;
import tigase.licence.LicenceCheckerUpdateCallbackImpl;
import tigase.licence.LicenceCheckerUpdater;
import tigase.server.XMPPServer;
import tigase.server.cluster.strategy.ConnectionRecordExt;
import tigase.stats.MaxDailyCounterQueue;
import tigase.vhosts.VHostItem;
import tigase.vhosts.VHostManager;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.JID;

public class LicenceCheckerUpdateCallbackImplACS
extends LicenceCheckerUpdateCallbackImpl {
    private ClusteringStrategyIfc<ConnectionRecordExt> b;
    final int a = 7;
    private static final Logger c = Logger.getLogger(LicenceCheckerUpdateCallbackImplACS.class.getName());

    public LicenceCheckerUpdateCallbackImplACS(String cmpName, ClusteringStrategyIfc<ConnectionRecordExt> strategy) {
        super(cmpName);
        this.b = strategy;
    }

    public Element getComponentAdditionalData() {
        Element element = super.getComponentAdditionalData();
        try {
            block7: {
                try {
                    element.addChild((XMLNodeIfc)new Element("activeUsers", this.b()));
                }
                catch (Exception exception) {
                    c.warning("Cannot retrieve activeUsers. Field skipped. (msg:" + exception.getMessage() + ")");
                    if (!c.isLoggable(Level.FINEST)) break block7;
                    c.log(Level.FINEST, "Cannot retrieve activeUsers. Field skipped. (msg:" + exception.getMessage() + ")", exception);
                }
            }
            try {
                element.addChild((XMLNodeIfc)new Element("clusterNodesCount", this.a()));
            }
            catch (Exception exception) {
                c.warning("Cannot retrieve clusterNodesCount. Field skipped. (msg:" + exception.getMessage() + ")");
                if (c.isLoggable(Level.FINEST)) {
                    c.log(Level.FINEST, "Cannot retrieve clusterNodesCount. Field skipped. (msg:" + exception.getMessage() + ")", exception);
                }
            }
        }
        catch (Exception exception) {
            c.log(Level.SEVERE, "Problem creating StatisticsData", exception);
        }
        return element;
    }

    private String a() {
        String string = (String)LicenceCheckerUpdater.getStats().getAllStats().getValue("cl-comp/Max daily cluster nodes count in last month");
        return string;
    }

    public boolean additionalValidation(Licence lic) {
        try {
            Object object;
            Object object2;
            Integer n = lic.getPropertyAsInteger("max-online-users");
            if (n != null) {
                object2 = LicenceCheckerUpdater.getStats().getAllStats().getCollectionValue("sess-man/strategy/OnlineUsersCachingStrategy/Max daily users sessions count last month (whole cluster)[C]");
                object = (MaxDailyCounterQueue)object2;
                boolean bl = object.isLimitSurpassedAllItems(7, (long)n.intValue());
                if (c.isLoggable(Level.FINEST)) {
                    c.log(Level.FINEST, "Checking licence limits, maxUsersLastWeek: {0}, maxOnlineUsers(licence): {1}, userLimitSurpassed: {2}", new Object[]{object.subQueue(7), n, bl});
                }
                if (bl) {
                    c.log(Level.WARNING, "Licence user limits exceeded! Max users last week: {0}, Max allowed users (licence): {1}", new Object[]{object.subQueue(7), n});
                    return false;
                }
            }
            if ((object2 = lic.getPropertyAsInteger("max-cluster-nodes")) != null) {
                Object object3 = object = LicenceCheckerUpdater.getStats().getAllStats().getCollectionValue("cl-comp/Max daily cluster nodes count in last month[C]");
                boolean bl = object3.isLimitSurpassedAllItems(7, (long)((Integer)object2).intValue());
                if (c.isLoggable(Level.FINEST)) {
                    c.log(Level.FINEST, "Checking licence limits, maxNodesLastWeek: {0}, maxNumberOfACSNodes(licence): {1}, clusterNodesSurpassed: {2}", new Object[]{object3, object2, bl});
                }
                if (bl) {
                    c.log(Level.WARNING, "Too many ACS nodes ({0} of allowed {1}).", new Object[]{object3, object2});
                    return false;
                }
            }
            if ((object = lic.getPropertyAsString("vhost-name")) != null) {
                JID jID = JID.jidInstanceNS((String)object);
                ConfiguratorAbstract configuratorAbstract = XMPPServer.getConfigurator();
                VHostManager vHostManager = (VHostManager)configuratorAbstract.getComponent("vhost-man");
                List list = vHostManager.getAllVHosts();
                if (!list.contains(jID)) {
                    c.log(Level.WARNING, "Required VHost is not managed by Tigase.");
                    return false;
                }
                VHostItem vHostItem = vHostManager.getVHostItem(jID.getDomain());
                String string = vHostManager.getComponentRepository().validateItem((RepositoryItem)vHostItem);
                if (string != null) {
                    c.log(Level.WARNING, "Cannot validate vhost " + jID + ": " + string);
                    return false;
                }
            }
            return true;
        }
        catch (Exception exception) {
            c.log(Level.WARNING, "Problem on validating licence", exception);
            return false;
        }
    }

    private String b() {
        String string = (String)LicenceCheckerUpdater.getStats().getAllStats().getValue("sess-man/strategy/OnlineUsersCachingStrategy/Max daily users sessions count last month (whole cluster)");
        return string;
    }
}

