/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.annotations.TigaseDeprecatedComponent;
import tigase.db.NonAuthUserRepository;
import tigase.db.TigaseDBException;
import tigase.osgi.ModulesManagerImpl;
import tigase.server.Packet;
import tigase.server.PolicyViolationException;
import tigase.server.Priority;
import tigase.stats.StatisticsList;
import tigase.sys.TigaseRuntime;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;
import tigase.xmpp.NoConnectionIdException;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPProcessor;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.XMPPSession;
import tigase.xmpp.XMPPStopListenerIfc;
import tigase.xmpp.impl.PresenceCapabilitiesManager;
import tigase.xmpp.impl.roster.DynamicRoster;
import tigase.xmpp.impl.roster.RepositoryAccessException;
import tigase.xmpp.impl.roster.RosterAbstract;
import tigase.xmpp.impl.roster.RosterElement;
import tigase.xmpp.impl.roster.RosterFactory;
import tigase.xmpp.impl.roster.RosterRetrievingException;

@TigaseDeprecatedComponent(note="Please remove '+presence' from '--sm-plugins=' or switch to 'presence-state' and 'presence-subscription' plugins")
public class Presence
extends XMPPProcessor
implements XMPPProcessorIfc,
XMPPStopListenerIfc {
    public static final String AUTO_AUTHORIZE_PROP_KEY = "auto-authorize";
    public static final String DIRECT_PRESENCE = "direct-presences";
    public static final String DISABLE_ROSTER_LAZY_LOADING_KEY = "disable-roster-lazy-loading";
    public static final String EXTENDED_PRESENCE_PROCESSORS_KEY = "extended-presence-processors";
    public static final String OFFLINE_BUD_SENT = "offline-bud-sent";
    public static final String OFFLINE_RES_SENT = "offline-res-sent";
    public static final String OFFLINE_ROSTER_LAST_SEEN_PROP_KEY = "offline-roster-last-seen";
    public static final String PRESENCE_ELEMENT_NAME = "presence";
    public static final String PRESENCE_GLOBAL_FORWARD = "presence-global-forward";
    public static final String SKIP_OFFLINE_PROP_KEY = "skip-offline";
    public static final String SKIP_OFFLINE_SYS_PROP_KEY = "skip-offline-sys";
    public static final String USERS_STATUS_CHANGES = "Users status changes";
    protected static final String XMLNS = "jabber:client";
    private static int HIGH_PRIORITY_PRESENCES_NO = 10;
    private static final Logger log = Logger.getLogger(Presence.class.getName());
    private static final long MAX_DIRECT_PRESENCES_NO = 1000L;
    private static final String[] PRESENCE_PRIORITY_PATH = new String[]{"presence", "priority"};
    private static final String[] XMLNSS = new String[]{"jabber:client", "jabber:iq:roster-load"};
    private static boolean rosterLazyLoading = true;
    private static boolean skipOfflineSys = true;
    private static boolean skipOffline = false;
    private static final String[] PRESENCE_C_PATH = new String[]{"presence", "c"};
    private static final String ID = "presence";
    private static final String[][] ELEMENTS = new String[][]{{"presence"}, {"iq", "query"}};
    private static boolean autoAuthorize = false;
    protected RosterAbstract roster_util = Presence.getRosterUtil();
    private String[] offlineRosterLastSeen = null;
    private JID presenceGLobalForward = null;
    private long usersStatusChanges = 0L;
    private static final List<ExtendedPresenceProcessorIfc> extendedPresenceProcessors = new ArrayList<ExtendedPresenceProcessorIfc>();

    public static void addDirectPresenceJID(JID jid, XMPPResourceConnection session) {
        LinkedHashSet<JID> direct_presences = (LinkedHashSet<JID>)session.getSessionData(DIRECT_PRESENCE);
        if (direct_presences == null) {
            direct_presences = new LinkedHashSet<JID>(10);
            session.putSessionData(DIRECT_PRESENCE, direct_presences);
        }
        if ((long)direct_presences.size() < 1000L) {
            direct_presences.add(jid);
        }
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Added direct presence jid: {0}", jid);
        }
    }

    public static void broadcastOffline(XMPPResourceConnection session, Queue<Packet> results, Map<String, Object> settings, RosterAbstract roster_util) throws NotAuthorizedException, TigaseDBException {
        if (session.getSessionData(OFFLINE_BUD_SENT) != null) {
            return;
        }
        session.putSessionData(OFFLINE_BUD_SENT, OFFLINE_BUD_SENT);
        Element pres = session.getPresence();
        if (pres != null) {
            Presence.sendPresenceBroadcast(StanzaType.unavailable, session, RosterAbstract.FROM_SUBSCRIBED, results, pres, settings, roster_util);
        } else {
            Presence.broadcastDirectPresences(StanzaType.unavailable, session, results, pres);
        }
    }

    public void broadcastProbe(XMPPResourceConnection session, Queue<Packet> results, Map<String, Object> settings) throws NotAuthorizedException, TigaseDBException {
        JID[] buddies_from;
        JID[] buddies_to;
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Broadcasting probes for: {0}", session);
        }
        Element presInit = session.getPresence();
        Element presProbe = this.prepareProbe(session);
        JID[] buddies = this.roster_util.getBuddies(session, RosterAbstract.SUB_BOTH);
        try {
            buddies = DynamicRoster.addBuddies(session, settings, buddies);
        }
        catch (RepositoryAccessException | RosterRetrievingException xMPPException) {
            // empty catch block
        }
        if (buddies != null) {
            for (JID buddy : buddies) {
                if (Presence.requiresPresenceSending(this.roster_util, buddy, session, true)) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, session.getBareJID() + " | Sending presence probe to: " + buddy);
                    }
                    Presence.sendPresence(null, null, buddy, results, presProbe);
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, session.getBareJID() + " | Sending intial presence to: " + buddy);
                    }
                    Presence.sendPresence(null, null, buddy, results, presInit);
                    this.roster_util.setPresenceSent(session, buddy, true);
                    continue;
                }
                if (!log.isLoggable(Level.FINEST)) continue;
                log.log(Level.FINEST, session.getBareJID() + " | Skipping sending initial presence and probe to: " + buddy);
            }
        }
        if ((buddies_to = this.roster_util.getBuddies(session, RosterAbstract.SUB_TO)) != null) {
            for (JID buddy : buddies_to) {
                if (Presence.requiresPresenceSending(this.roster_util, buddy, session, true)) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, session.getBareJID() + " | Sending probe to: " + buddy);
                    }
                    Presence.sendPresence(null, null, buddy, results, presProbe);
                    continue;
                }
                if (!log.isLoggable(Level.FINEST)) continue;
                log.log(Level.FINEST, session.getBareJID() + " | Skipping sending presence probe to: " + buddy);
            }
        }
        if ((buddies_from = this.roster_util.getBuddies(session, RosterAbstract.SUB_FROM)) != null) {
            for (JID buddy : buddies_from) {
                if (Presence.requiresPresenceSending(this.roster_util, buddy, session, true)) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, session.getBareJID() + " | Sending initial presence to: " + buddy);
                    }
                    Presence.sendPresence(null, null, buddy, results, presInit);
                    this.roster_util.setPresenceSent(session, buddy, true);
                    continue;
                }
                if (!log.isLoggable(Level.FINEST)) continue;
                log.log(Level.FINEST, session.getBareJID() + " | Skipping sending initial presence and probe to: " + buddy);
            }
        }
    }

    private Element prepareProbe(XMPPResourceConnection session) throws NotAuthorizedException {
        Element presProbe = new Element("presence");
        presProbe.setXMLNS(XMLNS);
        presProbe.setAttribute("type", StanzaType.probe.toString());
        presProbe.setAttribute("from", session.getBareJID().toString());
        return presProbe;
    }

    @Override
    public int concurrentQueuesNo() {
        return super.concurrentQueuesNo() * 4;
    }

    @Override
    public String id() {
        return "presence";
    }

    @Override
    public void init(Map<String, Object> settings) throws TigaseDBException {
        String[] extPresenceProcessorsClasses;
        String tmp = (String)settings.get(SKIP_OFFLINE_PROP_KEY);
        skipOffline = tmp != null ? Boolean.parseBoolean(tmp) : skipOffline;
        tmp = (String)settings.get(SKIP_OFFLINE_SYS_PROP_KEY);
        boolean bl = skipOfflineSys = tmp != null ? Boolean.parseBoolean(tmp) : skipOfflineSys;
        if (skipOffline || skipOfflineSys) {
            log.config(String.format("Skipping sending presence to offline contacts enabled :: skipOffline: %1$s, skipOfflineSys: %2$s", skipOffline, skipOfflineSys));
        }
        if (autoAuthorize = Boolean.parseBoolean((String)settings.get(AUTO_AUTHORIZE_PROP_KEY))) {
            log.config("Automatic presence autorization enabled, results in less strict XMPP specs compatibility ");
        }
        if ((tmp = (String)settings.get(OFFLINE_ROSTER_LAST_SEEN_PROP_KEY)) != null) {
            if (tmp.contains("off")) {
                this.offlineRosterLastSeen = null;
            } else {
                this.offlineRosterLastSeen = tmp.split(",");
                log.log(Level.CONFIG, "Loaded roster offline last seen config: {0}", tmp);
            }
        }
        if ((tmp = (String)settings.get(PRESENCE_GLOBAL_FORWARD)) != null) {
            try {
                this.presenceGLobalForward = JID.jidInstance(tmp);
            }
            catch (TigaseStringprepException ex) {
                this.presenceGLobalForward = null;
                log.log(Level.WARNING, "Presence global forward misconfiguration, cannot parse JID {0}", tmp);
            }
        }
        rosterLazyLoading = (tmp = (String)settings.get(DISABLE_ROSTER_LAZY_LOADING_KEY)) == null || !Boolean.parseBoolean(tmp);
        tmp = (String)settings.get(EXTENDED_PRESENCE_PROCESSORS_KEY);
        String[] stringArray = extPresenceProcessorsClasses = tmp != null ? tmp.split(",") : null;
        if (extPresenceProcessorsClasses != null) {
            for (String clazz : extPresenceProcessorsClasses) {
                try {
                    ExtendedPresenceProcessorIfc processor = (ExtendedPresenceProcessorIfc)ModulesManagerImpl.getInstance().forName(clazz).newInstance();
                    extendedPresenceProcessors.add(processor);
                    log.log(Level.CONFIG, "Loadeded ExtendedPresenceProcessor: {0}", processor.getClass());
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
                    Logger.getLogger(Presence.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws XMPPException {
        if (session == null) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Session is null, ignoring packet: {0}", packet);
            }
            return;
        }
        if (!session.isAuthorized()) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Session is not authorized, ignoring packet: {0}", packet);
            }
            return;
        }
        if (packet.getElemName() == "iq") {
            boolean finishProcessing = true;
            switch (packet.getType()) {
                case result: {
                    XMPPResourceConnection xMPPResourceConnection = session;
                    synchronized (xMPPResourceConnection) {
                        Element presEl = session.getPresence();
                        if (presEl != null) {
                            session.removeSessionData("user-presence");
                            presEl.removeAttribute("from");
                            presEl.removeAttribute("to");
                            Packet pres = Packet.packetInstance(presEl, packet.getStanzaFrom(), packet.getStanzaTo());
                            pres.setPacketFrom(packet.getPacketFrom());
                            pres.setPacketTo(packet.getPacketTo());
                            try {
                                this.processOutInitial(pres, session, results, settings, RosterAbstract.PresenceType.out_initial);
                            }
                            catch (NotAuthorizedException e) {
                                log.log(Level.INFO, "Can not access user Roster, user session is not authorized yet: {0}", packet);
                                log.log(Level.FINEST, "presence problem...", e);
                            }
                            catch (TigaseDBException e) {
                                log.log(Level.WARNING, "Error accessing database for presence data: {0}", e);
                            }
                        }
                        break;
                    }
                }
            }
            if (finishProcessing) {
                return;
            }
        }
        XMPPResourceConnection xMPPResourceConnection = session;
        synchronized (xMPPResourceConnection) {
            try {
                RosterAbstract.PresenceType pres_type = this.roster_util.getPresenceType(session, packet);
                if (pres_type == null) {
                    log.log(Level.INFO, "Invalid presence found: {0}", packet);
                    return;
                }
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "{0} | {1} presence found: {2}", new Object[]{session.getBareJID().toString(), pres_type, packet});
                }
                switch (pres_type) {
                    case in_unsubscribe: 
                    case in_subscribe: 
                    case in_unsubscribed: 
                    case in_subscribed: {
                        if (packet.getStanzaFrom() == null) {
                            if (log.isLoggable(Level.FINE)) {
                                log.fine("'in' subscription presence without valid 'from' address, dropping packet: " + packet);
                            }
                            return;
                        }
                        if (session.isUserId(packet.getStanzaFrom().getBareJID())) {
                            if (log.isLoggable(Level.FINE)) {
                                log.log(Level.FINE, "''in'' subscription to myself, not allowed, returning error for packet: {0}", packet);
                            }
                            results.offer(Authorization.NOT_ALLOWED.getResponseMessage(packet, "You can not subscribe to yourself.", false));
                            return;
                        }
                        packet.initVars(packet.getStanzaFrom().copyWithoutResource(), session.getJID().copyWithoutResource());
                        break;
                    }
                    case out_subscribe: 
                    case out_unsubscribe: 
                    case out_subscribed: 
                    case out_unsubscribed: {
                        if (packet.getStanzaTo() == null || packet.getStanzaTo().toString().isEmpty()) {
                            results.offer(Authorization.JID_MALFORMED.getResponseMessage(packet, "The destination address is incorrect.", false));
                            return;
                        }
                        packet.initVars(session.getJID().copyWithoutResource(), packet.getStanzaTo().copyWithoutResource());
                        break;
                    }
                }
                switch (pres_type) {
                    case out_initial: {
                        this.processOutInitial(packet, session, results, settings, pres_type);
                        break;
                    }
                    case out_subscribe: 
                    case out_unsubscribe: {
                        this.processOutSubscribe(packet, session, results, settings, pres_type);
                        break;
                    }
                    case out_subscribed: 
                    case out_unsubscribed: {
                        this.processOutSubscribed(packet, session, results, settings, pres_type);
                        break;
                    }
                    case in_initial: {
                        this.processInInitial(packet, session, results, settings, pres_type);
                        break;
                    }
                    case in_subscribe: {
                        this.processInSubscribe(packet, session, results, settings, pres_type);
                        break;
                    }
                    case in_unsubscribe: {
                        this.processInUnsubscribe(packet, session, results, settings, pres_type);
                        break;
                    }
                    case in_subscribed: {
                        this.processInSubscribed(packet, session, results, settings, pres_type);
                        break;
                    }
                    case in_unsubscribed: {
                        this.processInUnsubscribed(packet, session, results, settings, pres_type);
                        break;
                    }
                    case in_probe: {
                        if (session.getPresence() == null) {
                            return;
                        }
                        this.processInProbe(packet, session, results, settings, pres_type);
                        break;
                    }
                    case out_probe: {
                        Presence.forwardPresence(results, packet, session.getJID());
                        break;
                    }
                    case error: {
                        this.processError(packet, session, results, settings, pres_type);
                        break;
                    }
                    default: {
                        results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, "Request type is incorrect", false));
                        break;
                    }
                }
            }
            catch (NotAuthorizedException e) {
                log.log(Level.INFO, "Can not access user Roster, user session is not authorized yet: {0}", packet);
                log.log(Level.FINEST, "presence problem...", e);
            }
            catch (PolicyViolationException e) {
                log.log(Level.FINE, "Violation of roster items number policy: {0}", packet);
            }
            catch (TigaseDBException e) {
                log.log(Level.WARNING, "Error accessing database for presence data: {0}", e);
            }
        }
    }

    public static void removeDirectPresenceJID(JID jid, XMPPResourceConnection session) {
        Set direct_presences = (Set)session.getSessionData(DIRECT_PRESENCE);
        if (direct_presences != null) {
            direct_presences.remove(jid);
        }
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Added direct presence jid: {0}", jid);
        }
    }

    public void resendPendingInRequests(XMPPResourceConnection session, Queue<Packet> results) throws NotAuthorizedException, TigaseDBException {
        JID[] buddies = this.roster_util.getBuddies(session, RosterAbstract.PENDING_IN);
        if (buddies != null) {
            for (JID buddy : buddies) {
                Element presence = new Element("presence");
                presence.setAttribute("type", StanzaType.subscribe.toString());
                presence.setXMLNS(XMLNS);
                Packet pres = Packet.packetInstance(presence, buddy, null);
                Presence.updatePresenceChange(pres, session, results);
            }
        }
    }

    public static void sendPresence(StanzaType t, BareJID from, BareJID to, Queue<Packet> results, Element pres) {
        Presence.sendPresence(t, JID.jidInstance(from), JID.jidInstance(to), results, pres);
    }

    public static Packet sendPresence(StanzaType t, JID from, JID to, Queue<Packet> results, Element pres) {
        Element presence = null;
        Packet result = null;
        if (pres == null) {
            presence = new Element("presence");
            if (t != null) {
                presence.setAttribute("type", t.toString());
            } else {
                presence.setAttribute("type", StanzaType.unavailable.toString());
            }
            if (null != from) {
                presence.setAttribute("from", from.toString());
            }
            presence.setXMLNS(XMLNS);
        } else {
            presence = pres.clone();
        }
        presence.setAttribute("to", to.toString());
        try {
            result = Packet.packetInstance(presence);
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Sending presence info: {0}", result);
            }
            results.offer(result);
        }
        catch (TigaseStringprepException ex) {
            log.log(Level.FINE, "Packet stringprep addressing problem, skipping presence send: {0}", presence);
        }
        return result;
    }

    public static void sendPresenceBroadcast(StanzaType t, XMPPResourceConnection session, EnumSet<RosterAbstract.SubscriptionType> subscrs, Queue<Packet> results, Element pres, Map<String, Object> settings, RosterAbstract roster_util) throws NotAuthorizedException, TigaseDBException {
        Presence.broadcastDirectPresences(t, session, results, pres);
        RosterAbstract roster = roster_util;
        if (roster == null) {
            roster = RosterFactory.getRosterImplementation(true);
        }
        Object[] buddies = roster.getBuddies(session, subscrs);
        try {
            buddies = DynamicRoster.addBuddies(session, settings, (JID[])buddies);
        }
        catch (RepositoryAccessException | RosterRetrievingException xMPPException) {
            // empty catch block
        }
        if (buddies != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, session.getBareJID() + " | Buddies found: " + Arrays.toString(buddies));
            }
            Priority pack_priority = Priority.PRESENCE;
            int pres_cnt = 0;
            for (Object buddy : buddies) {
                if (Presence.requiresPresenceSending(roster, (JID)buddy, session, false)) {
                    Packet pack = Presence.sendPresence(t, session.getJID(), (JID)buddy, results, pres);
                    if (pres_cnt == HIGH_PRIORITY_PRESENCES_NO) {
                        ++pres_cnt;
                        pack_priority = Priority.LOWEST;
                    }
                    if (pack == null) continue;
                    pack.setPriority(pack_priority);
                    roster.setPresenceSent(session, (JID)buddy, true);
                    continue;
                }
                if (!log.isLoggable(Level.FINEST)) continue;
                log.log(Level.FINEST, session.getBareJID() + " | Not sending presence to buddy: " + buddy);
            }
        } else if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "No buddies found!!!!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopped(XMPPResourceConnection session, Queue<Packet> results, Map<String, Object> settings) {
        XMPPResourceConnection xMPPResourceConnection = session;
        synchronized (xMPPResourceConnection) {
            try {
                if (session.getPresence() != null) {
                    Element pres = session.getPresence();
                    if (!StanzaType.unavailable.toString().equals(pres.getAttributeStaticStr("type"))) {
                        pres.setAttribute("type", StanzaType.unavailable.toString());
                        session.setPresence(pres);
                    }
                    Presence.broadcastOffline(session, results, settings, this.roster_util);
                    Presence.updateOfflineChange(session, results);
                } else {
                    Presence.broadcastDirectPresences(StanzaType.unavailable, session, results, null);
                }
                this.roster_util.logout(session);
            }
            catch (NotAuthorizedException pres) {
            }
            catch (TigaseDBException e) {
                log.log(Level.WARNING, "Error accessing database for offline message: ", e);
            }
        }
    }

    @Override
    public String[][] supElementNamePaths() {
        return ELEMENTS;
    }

    @Override
    public String[] supNamespaces() {
        return XMLNSS;
    }

    public static void rebroadcastPresence(XMPPResourceConnection session, Queue<Packet> results) throws NotAuthorizedException, TigaseDBException {
        if (session.getPresence() == null) {
            return;
        }
        Element presence = session.getPresence().clone();
        for (ExtendedPresenceProcessorIfc processor : extendedPresenceProcessors) {
            Element extendContent = processor.extend(session, results);
            if (extendContent == null) continue;
            Element child = presence.getChild(extendContent.getName(), extendContent.getXMLNS());
            if (child != null) {
                presence.removeChild(child);
            }
            presence.addChild(extendContent);
        }
        Presence.sendPresenceBroadcast(StanzaType.available, session, RosterAbstract.FROM_SUBSCRIBED, results, presence, null, Presence.getRosterUtil());
        Presence.updateUserResources(presence, session, results, false);
    }

    public static void updatePresenceChange(Packet presence, XMPPResourceConnection session, Queue<Packet> results) throws NotAuthorizedException {
        boolean initial_p = presence.getAttributeStaticStr("type") == null || "available".equals(presence.getAttributeStaticStr("type")) || "unavailable".equals(presence.getAttributeStaticStr("type"));
        for (XMPPResourceConnection conn : session.getActiveSessions()) {
            if (conn.getPresence() == null && initial_p) {
                if (!log.isLoggable(Level.FINEST)) continue;
                log.finest("Skipping update presence change for a resource which hasn't sent initial presence yet, or is remote connection: " + conn);
                continue;
            }
            try {
                if (log.isLoggable(Level.FINER)) {
                    log.finer("Update presence change to: " + conn);
                }
                Packet pres_update = presence.copyElementOnly();
                pres_update.initVars(presence.getStanzaFrom(), conn.getJID().copyWithoutResource());
                pres_update.setPacketTo(conn.getConnectionId());
                results.offer(pres_update);
            }
            catch (NoConnectionIdException | NotAuthorizedException xMPPException) {}
        }
    }

    public static void updateUserResources(Element presence, XMPPResourceConnection session, Queue<Packet> results, boolean initial) throws NotAuthorizedException {
        for (XMPPResourceConnection conn : session.getActiveSessions()) {
            try {
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "Update presence change to: {0}", conn.getJID());
                }
                if (conn.isResourceSet()) {
                    Element pres_update = presence.clone();
                    Packet pack_update = Packet.packetInstance(pres_update, session.getJID(), conn.getJID().copyWithoutResource());
                    pack_update.setPacketTo(conn.getConnectionId());
                    results.offer(pack_update);
                    Element presence_el = conn.getPresence();
                    if (presence_el == null || !initial || conn == session) continue;
                    pres_update = presence_el.clone();
                    pack_update = Packet.packetInstance(pres_update, conn.getJID(), session.getJID().copyWithoutResource());
                    pack_update.setPacketTo(session.getConnectionId());
                    results.offer(pack_update);
                    continue;
                }
                if (!log.isLoggable(Level.FINER)) continue;
                log.finer("Skipping presence update to: " + conn.getJID());
            }
            catch (NoConnectionIdException | NotAuthorizedException xMPPException) {}
        }
    }

    @Override
    public void getStatistics(StatisticsList list) {
        super.getStatistics(list);
        list.add(this.id(), USERS_STATUS_CHANGES, this.usersStatusChanges, Level.INFO);
    }

    protected static void broadcastDirectPresences(StanzaType t, XMPPResourceConnection session, Queue<Packet> results, Element pres) throws NotAuthorizedException, TigaseDBException {
        Set direct_presences = (Set)session.getSessionData(DIRECT_PRESENCE);
        if (direct_presences != null && t != null && t == StanzaType.unavailable) {
            for (JID buddy : direct_presences) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Updating direct presence for: {0}", buddy);
                }
                Packet pack = Presence.sendPresence(t, session.getJID(), buddy, results, pres);
                pack.setPriority(Priority.LOW);
            }
        }
    }

    protected void buddyOnline(XMPPResourceConnection session, JID buddy, Queue<Packet> results, boolean online) throws NotAuthorizedException, TigaseDBException {
        Element pres;
        this.roster_util.setOnline(session, buddy, online);
        if (online && skipOffline && !this.roster_util.presenceSent(session, buddy) && this.roster_util.isSubscribedFrom(session, buddy) && (pres = session.getPresence()) != null) {
            Presence.sendPresence(null, null, buddy, results, pres);
            this.roster_util.setPresenceSent(session, buddy, true);
        }
    }

    protected static void forwardPresence(Queue<Packet> results, Packet packet, JID from) {
        Element result = packet.getElement().clone();
        result.setAttribute("from", from.toString());
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "\n\nFORWARD presence: {0}", result.toString());
        }
        results.offer(Packet.packetInstance(result, from, packet.getStanzaTo()));
    }

    protected void processError(Packet packet, XMPPResourceConnection session, Queue<Packet> results, Map<String, Object> settings, RosterAbstract.PresenceType presenceType) throws NotAuthorizedException, TigaseDBException, NoConnectionIdException {
        if (session.isUserId(packet.getStanzaTo().getBareJID())) {
            Packet result = packet.copyElementOnly();
            result.setPacketTo(session.getConnectionId());
            result.setPacketFrom(packet.getTo());
            results.offer(result);
        }
    }

    protected void processInInitial(Packet packet, XMPPResourceConnection session, Queue<Packet> results, Map<String, Object> settings, RosterAbstract.PresenceType presenceType) throws NoConnectionIdException, NotAuthorizedException, TigaseDBException {
        Element dynItem;
        if (packet.getStanzaFrom() == null) {
            log.log(Level.WARNING, "Initial presence without from attribute set: {0}", packet);
            return;
        }
        String resource = packet.getStanzaTo().getResource();
        if (resource != null && !resource.isEmpty()) {
            XMPPResourceConnection direct = session.getParentSession().getResourceForResource(resource);
            if (direct != null) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Received direct presence from: {0} to: {1}", new Object[]{packet.getStanzaFrom(), packet.getStanzaTo()});
                }
                Packet result = packet.copyElementOnly();
                result.setPacketTo(direct.getConnectionId());
                result.setPacketFrom(packet.getTo());
                results.offer(result);
            } else if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Ignoring direct presence from: {0} to: {1}, resource gone.", new Object[]{packet.getStanzaFrom(), packet.getStanzaTo()});
            }
            return;
        }
        boolean online = StanzaType.unavailable != packet.getType();
        this.buddyOnline(session, packet.getStanzaFrom(), results, online);
        if (session.getPresence() == null) {
            return;
        }
        JID presBuddy = packet.getStanzaFrom().copyWithoutResource();
        try {
            dynItem = DynamicRoster.getBuddyItem(session, settings, presBuddy);
        }
        catch (RepositoryAccessException | RosterRetrievingException ex) {
            dynItem = null;
        }
        if (this.roster_util.isSubscribedTo(session, presBuddy) || dynItem != null) {
            RosterElement rel = this.roster_util.getRosterElement(session, presBuddy);
            if (rel != null) {
                rel.setLastSeen(System.currentTimeMillis());
            }
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Received initial presence, setting buddy: {0} online status to: {1}", new Object[]{packet.getStanzaFrom(), online});
            }
            Presence.updatePresenceChange(packet, session, results);
        }
    }

    protected void processInProbe(Packet packet, XMPPResourceConnection session, Queue<Packet> results, Map<String, Object> settings, RosterAbstract.PresenceType presenceType) throws NotAuthorizedException, TigaseDBException, PacketErrorTypeException {
        Element dynItem;
        RosterAbstract.SubscriptionType buddy_subscr = null;
        try {
            dynItem = DynamicRoster.getBuddyItem(session, settings, packet.getStanzaFrom());
        }
        catch (RepositoryAccessException | RosterRetrievingException ex) {
            dynItem = null;
        }
        buddy_subscr = dynItem != null ? RosterAbstract.SubscriptionType.both : this.roster_util.getBuddySubscription(session, packet.getStanzaFrom());
        if (buddy_subscr == null) {
            buddy_subscr = RosterAbstract.SubscriptionType.none;
        }
        if (this.roster_util.isSubscribedFrom(buddy_subscr)) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Received probe, setting buddy: {0} as online.", packet.getStanzaFrom());
            }
            if (packet.getStanzaFrom().getResource() != null) {
                this.roster_util.setOnline(session, packet.getStanzaFrom(), true);
            }
            for (XMPPResourceConnection conn : session.getActiveSessions()) {
                try {
                    Element pres = conn.getPresence();
                    if (pres == null) continue;
                    Presence.sendPresence(null, null, packet.getStanzaFrom().copyWithoutResource(), results, pres);
                    this.roster_util.setPresenceSent(session, packet.getStanzaFrom(), true);
                    if (!log.isLoggable(Level.FINEST)) continue;
                    log.log(Level.FINEST, "Received probe, sending presence response to: {0}", packet.getStanzaFrom());
                }
                catch (TigaseDBException | NotAuthorizedException pres) {}
            }
        } else if (!this.isAllowedForPresenceProbe(session, packet.getStanzaFrom())) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Received probe, users bare JID: {0} is not in the roster. Responding with unsubscribed", packet.getStanzaFrom().getBareJID());
            }
            Presence.sendPresence(StanzaType.unsubscribed, session.getBareJID(), packet.getStanzaFrom().getBareJID(), results, null);
        } else {
            for (XMPPResourceConnection conn : session.getActiveSessions()) {
                Element pres = conn.getPresence();
                if (pres == null) continue;
                Presence.sendPresence(null, null, packet.getStanzaFrom(), results, pres);
                if (!log.isLoggable(Level.FINEST)) continue;
                log.log(Level.FINEST, "Received probe, sending presence response to: {0}", packet.getStanzaFrom());
            }
        }
    }

    protected void processInSubscribe(Packet packet, XMPPResourceConnection session, Queue<Packet> results, Map<String, Object> settings, RosterAbstract.PresenceType pres_type) throws NotAuthorizedException, TigaseDBException, NoConnectionIdException, PolicyViolationException {
        if (this.roster_util.isSubscribedFrom(session, packet.getStanzaFrom())) {
            Presence.sendPresence(StanzaType.subscribed, session.getJID().copyWithoutResource(), packet.getStanzaFrom(), results, null);
        } else {
            RosterAbstract.SubscriptionType curr_sub = this.roster_util.getBuddySubscription(session, packet.getStanzaFrom());
            if (curr_sub == null) {
                this.roster_util.addBuddy(session, packet.getStanzaFrom(), null, null, null);
            }
            this.roster_util.updateBuddySubscription(session, pres_type, packet.getStanzaFrom());
            if (!autoAuthorize) {
                Presence.updatePresenceChange(packet, session, results);
            } else {
                this.roster_util.setBuddySubscription(session, RosterAbstract.SubscriptionType.both, packet.getStanzaFrom().copyWithoutResource());
            }
        }
        if (autoAuthorize) {
            this.roster_util.updateBuddyChange(session, results, this.roster_util.getBuddyItem(session, packet.getStanzaFrom().copyWithoutResource()));
            this.broadcastProbe(session, results, settings);
            Presence.sendPresence(StanzaType.subscribed, session.getJID(), packet.getStanzaFrom(), results, null);
        }
    }

    protected void processInSubscribed(Packet packet, XMPPResourceConnection session, Queue<Packet> results, Map<String, Object> settings, RosterAbstract.PresenceType pres_type) throws NotAuthorizedException, TigaseDBException, NoConnectionIdException, PolicyViolationException {
        boolean subscr_changed;
        RosterAbstract.SubscriptionType curr_sub = this.roster_util.getBuddySubscription(session, packet.getStanzaFrom());
        if (!autoAuthorize && curr_sub == null) {
            this.roster_util.addBuddy(session, packet.getStanzaFrom(), null, null, null);
        }
        if (subscr_changed = this.roster_util.updateBuddySubscription(session, pres_type, packet.getStanzaFrom())) {
            Packet forward_p = packet.copyElementOnly();
            forward_p.setPacketTo(session.getConnectionId());
            results.offer(forward_p);
            if (autoAuthorize) {
                this.roster_util.setBuddySubscription(session, RosterAbstract.SubscriptionType.both, packet.getStanzaFrom().copyWithoutResource());
            }
            this.roster_util.updateBuddyChange(session, results, this.roster_util.getBuddyItem(session, packet.getStanzaFrom()));
            Element delay = packet.getElement().getChild("delay", "urn:xmpp:delay");
            if (delay != null) {
                Element presProbe = this.prepareProbe(session);
                Presence.sendPresence(null, null, packet.getStanzaFrom(), results, presProbe);
            }
        }
    }

    protected void processInUnsubscribe(Packet packet, XMPPResourceConnection session, Queue<Packet> results, Map<String, Object> settings, RosterAbstract.PresenceType pres_type) throws NotAuthorizedException, TigaseDBException, NoConnectionIdException, PolicyViolationException {
        boolean subscr_changed = this.roster_util.updateBuddySubscription(session, pres_type, packet.getStanzaFrom());
        if (subscr_changed) {
            Element item;
            if (!autoAuthorize) {
                Packet forward_p = packet.copyElementOnly();
                forward_p.setPacketTo(session.getConnectionId());
                results.offer(forward_p);
            }
            if ((item = this.roster_util.getBuddyItem(session, packet.getStanzaFrom())) != null) {
                this.roster_util.updateBuddyChange(session, results, item);
            } else if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Received unsubscribe request from a user who is not in the roster: {0}", packet.getStanzaFrom());
            }
            if (autoAuthorize) {
                this.broadcastProbe(session, results, settings);
            }
        }
    }

    protected void processInUnsubscribed(Packet packet, XMPPResourceConnection session, Queue<Packet> results, Map<String, Object> settings, RosterAbstract.PresenceType pres_type) throws NotAuthorizedException, TigaseDBException, NoConnectionIdException, PolicyViolationException {
        RosterAbstract.SubscriptionType curr_sub = this.roster_util.getBuddySubscription(session, packet.getStanzaFrom());
        if (curr_sub != null) {
            boolean subscr_changed;
            if (!autoAuthorize) {
                Packet forward_p = packet.copyElementOnly();
                forward_p.setPacketTo(session.getConnectionId());
                results.offer(forward_p);
            }
            if (subscr_changed = this.roster_util.updateBuddySubscription(session, pres_type, packet.getStanzaFrom())) {
                Element item = this.roster_util.getBuddyItem(session, packet.getStanzaFrom());
                if (item != null) {
                    this.roster_util.updateBuddyChange(session, results, this.roster_util.getBuddyItem(session, packet.getStanzaFrom()));
                } else if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Received unsubscribe request from a user who is not in the roster: {0}", packet.getStanzaFrom());
                }
                if (autoAuthorize) {
                    this.broadcastProbe(session, results, settings);
                }
            }
        }
    }

    protected void processOutInitial(Packet packet, XMPPResourceConnection session, Queue<Packet> results, Map<String, Object> settings, RosterAbstract.PresenceType type) throws NotAuthorizedException, TigaseDBException {
        if (packet.getStanzaTo() != null) {
            results.offer(packet.copyElementOnly());
            if (packet.getType() == StanzaType.unavailable) {
                Presence.removeDirectPresenceJID(packet.getStanzaTo(), session);
            } else {
                Presence.addDirectPresenceJID(packet.getStanzaTo(), session);
            }
        } else {
            ++this.usersStatusChanges;
            boolean first = false;
            if (session.getPresence() == null) {
                first = true;
            }
            Packet resultPacket = packet.copyElementOnly();
            resultPacket.initVars(session.getJID(), packet.getStanzaTo());
            Element presenceEl = resultPacket.getElement();
            for (ExtendedPresenceProcessorIfc processor : extendedPresenceProcessors) {
                Element extendContent = processor.extend(session, results);
                if (extendContent == null) continue;
                presenceEl.addChild(extendContent);
            }
            session.setPresence(presenceEl);
            if (!rosterLazyLoading || this.roster_util.isRosterLoaded(session)) {
                if (packet.getType() == null || packet.getType() == StanzaType.available) {
                    session.removeSessionData(OFFLINE_BUD_SENT);
                    session.removeSessionData(OFFLINE_RES_SENT);
                    if (first) {
                        try {
                            this.sendRosterOfflinePresence(session, results);
                        }
                        catch (TigaseDBException | NoConnectionIdException | NotAuthorizedException ex) {
                            log.log(Level.INFO, "Experimental code throws exception: ", ex);
                        }
                        this.broadcastProbe(session, results, settings);
                        this.resendPendingInRequests(session, results);
                    } else {
                        Presence.sendPresenceBroadcast(StanzaType.available, session, RosterAbstract.FROM_SUBSCRIBED, results, presenceEl, settings, this.roster_util);
                    }
                    Presence.updateUserResources(presenceEl, session, results, first);
                } else {
                    this.stopped(session, results, settings);
                }
                JID forwardTo = session.getDomain().getPresenceForward();
                if (forwardTo == null) {
                    forwardTo = this.presenceGLobalForward;
                }
                if (forwardTo != null) {
                    Presence.sendPresence(null, session.getJID(), forwardTo, results, presenceEl);
                }
            } else {
                Element iq = new Element("iq", new String[]{"type"}, new String[]{"set"});
                Element query = new Element("query", new String[]{"xmlns"}, new String[]{"jabber:iq:roster-load"});
                iq.addChild(query);
                Packet loadCmd = Packet.packetInstance(iq, packet.getStanzaFrom(), packet.getStanzaTo());
                loadCmd.setPacketFrom(packet.getPacketFrom());
                loadCmd.setPacketTo(packet.getPacketTo());
                results.add(loadCmd);
            }
        }
    }

    protected void processOutSubscribe(Packet packet, XMPPResourceConnection session, Queue<Packet> results, Map<String, Object> settings, RosterAbstract.PresenceType pres_type) throws NotAuthorizedException, TigaseDBException, NoConnectionIdException, PolicyViolationException {
        boolean subscr_changed = false;
        Presence.forwardPresence(results, packet, session.getJID().copyWithoutResource());
        RosterAbstract.SubscriptionType current_subscription = this.roster_util.getBuddySubscription(session, packet.getStanzaTo());
        if (pres_type == RosterAbstract.PresenceType.out_subscribe) {
            if (current_subscription == null) {
                this.roster_util.addBuddy(session, packet.getStanzaTo(), null, null, null);
            }
            subscr_changed = this.roster_util.updateBuddySubscription(session, pres_type, packet.getStanzaTo());
            if (autoAuthorize) {
                this.roster_util.setBuddySubscription(session, RosterAbstract.SubscriptionType.both, packet.getStanzaTo().copyWithoutResource());
            }
            if (subscr_changed) {
                this.roster_util.updateBuddyChange(session, results, this.roster_util.getBuddyItem(session, packet.getStanzaTo()));
            }
        } else {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "out_subscribe: current_subscription = " + (Object)((Object)current_subscription));
            }
            if (current_subscription != null) {
                subscr_changed = this.roster_util.updateBuddySubscription(session, pres_type, packet.getStanzaTo());
                current_subscription = this.roster_util.getBuddySubscription(session, packet.getStanzaTo());
                if (subscr_changed) {
                    this.roster_util.updateBuddyChange(session, results, this.roster_util.getBuddyItem(session, packet.getStanzaTo()));
                }
                if (RosterAbstract.SUB_NONE.contains((Object)current_subscription)) {
                    this.roster_util.removeBuddy(session, packet.getStanzaTo());
                }
            }
        }
    }

    protected void processOutSubscribed(Packet packet, XMPPResourceConnection session, Queue<Packet> results, Map<String, Object> settings, RosterAbstract.PresenceType pres_type) throws NotAuthorizedException, TigaseDBException, NoConnectionIdException, PolicyViolationException {
        Presence.forwardPresence(results, packet, session.getJID().copyWithoutResource());
        Element initial_presence = session.getPresence();
        JID buddy = packet.getStanzaTo().copyWithoutResource();
        boolean subscr_changed = this.roster_util.updateBuddySubscription(session, pres_type, buddy);
        if (autoAuthorize && pres_type == RosterAbstract.PresenceType.out_subscribed) {
            this.roster_util.setBuddySubscription(session, RosterAbstract.SubscriptionType.both, buddy.copyWithoutResource());
        }
        if (subscr_changed) {
            this.roster_util.updateBuddyChange(session, results, this.roster_util.getBuddyItem(session, buddy));
            if (initial_presence != null) {
                if (pres_type == RosterAbstract.PresenceType.out_subscribed) {
                    List<XMPPResourceConnection> activeSessions = session.getActiveSessions();
                    for (XMPPResourceConnection userSessions : activeSessions) {
                        Element presence = userSessions.getPresence();
                        Presence.sendPresence(StanzaType.available, userSessions.getjid(), buddy, results, presence);
                    }
                    this.roster_util.setPresenceSent(session, buddy, true);
                } else {
                    Presence.sendPresence(StanzaType.unavailable, session.getJID(), buddy, results, null);
                }
            }
        }
    }

    protected void sendRosterOfflinePresence(XMPPResourceConnection session, Queue<Packet> results) throws NotAuthorizedException, TigaseDBException, NoConnectionIdException {
        Object[] buddies;
        if (this.offlineRosterLastSeen == null) {
            log.finest("No clients specified in config, skipping...");
            return;
        }
        Element pres = session.getPresence();
        if (pres == null) {
            log.finest("Presence not set yet, skipping...");
            return;
        }
        String node = pres.getAttributeStaticStr(PRESENCE_C_PATH, "node");
        if (node == null) {
            log.finest("Presence node not set, skipping...");
            return;
        }
        boolean validClient = false;
        int i = 0;
        if (this.offlineRosterLastSeen.length > 0 && !this.offlineRosterLastSeen[0].equals("*")) {
            while (i < this.offlineRosterLastSeen.length && !(validClient |= node.contains(this.offlineRosterLastSeen[i++]))) {
            }
            if (!validClient) {
                log.finest("Client does not match, skipping...");
                return;
            }
        }
        if ((buddies = this.roster_util.getBuddies(session, RosterAbstract.TO_SUBSCRIBED)) != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Buddies found: {0}", Arrays.toString(buddies));
            }
            Priority pack_priority = Priority.PRESENCE;
            int pres_cnt = 0;
            for (Object buddy : buddies) {
                List<Element> children = this.roster_util.getCustomChildren(session, (JID)buddy);
                if (children == null || children.isEmpty()) continue;
                Packet pack = Presence.sendPresence(StanzaType.unavailable, (JID)buddy, session.getJID(), results, null);
                if (pres_cnt == HIGH_PRIORITY_PRESENCES_NO) {
                    ++pres_cnt;
                    pack_priority = Priority.LOWEST;
                }
                pack.setPriority(pack_priority);
                pack.setPacketTo(session.getConnectionId());
                for (Element child : children) {
                    pack.getElement().addChild(child);
                }
            }
        }
    }

    protected static void updateOfflineChange(XMPPResourceConnection session, Queue<Packet> results) throws NotAuthorizedException {
        if (session.getSessionData(OFFLINE_RES_SENT) != null) {
            return;
        }
        session.putSessionData(OFFLINE_RES_SENT, OFFLINE_RES_SENT);
        for (XMPPResourceConnection conn : session.getActiveSessions()) {
            try {
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "Update presence change to: {0}", conn.getJID());
                }
                if (conn != session && conn.isResourceSet() && !conn.getResource().equals(session.getResource())) {
                    Element pres_update = new Element("presence");
                    pres_update.setAttribute("type", StanzaType.unavailable.toString());
                    pres_update.setXMLNS(XMLNS);
                    Packet pack_update = Packet.packetInstance(pres_update, session.getJID(), conn.getJID());
                    pack_update.setPacketTo(conn.getConnectionId());
                    results.offer(pack_update);
                    continue;
                }
                if (!log.isLoggable(Level.FINER)) continue;
                log.log(Level.FINER, "Skipping presence update to: {0}", conn.getJID());
            }
            catch (NoConnectionIdException | NotAuthorizedException xMPPException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void updateResourcesAvailable(XMPPResourceConnection session, StanzaType type, Packet packet) {
        XMPPSession parentSession = session.getParentSession();
        if (parentSession != null) {
            ConcurrentHashMap resources;
            boolean online = type == null || type == StanzaType.available;
            XMPPSession xMPPSession = parentSession;
            synchronized (xMPPSession) {
                resources = (ConcurrentHashMap)parentSession.getCommonSessionData("all-resources");
                if (resources == null) {
                    if (!online) {
                        return;
                    }
                    resources = new ConcurrentHashMap();
                    session.putCommonSessionData("all-resources", resources);
                }
            }
            if (online) {
                String priorityStr;
                ConcurrentHashMap<String, Object> map = (ConcurrentHashMap<String, Object>)resources.get(packet.getStanzaFrom());
                if (map == null) {
                    map = new ConcurrentHashMap<String, Object>();
                    resources.put(packet.getStanzaFrom(), map);
                }
                if ((priorityStr = packet.getElemCDataStaticStr(PRESENCE_PRIORITY_PATH)) != null) {
                    map.put("priority", Integer.parseInt(priorityStr));
                } else if (!map.containsKey("priority")) {
                    map.put("priority", 0);
                }
                Element c = packet.getElement().getChild("c", "http://jabber.org/protocol/caps");
                if (c != null) {
                    map.put("caps", PresenceCapabilitiesManager.processPresence(c));
                }
            } else {
                resources.remove(packet.getStanzaFrom());
            }
        }
    }

    protected static RosterAbstract getRosterUtil() {
        return RosterFactory.getRosterImplementation(true);
    }

    private boolean isAllowedForPresenceProbe(XMPPResourceConnection session, JID jid) {
        if (jid == null) {
            return false;
        }
        return session.getDomain().isTrustedJID(jid);
    }

    private static boolean requiresPresenceSending(RosterAbstract roster, JID buddy, XMPPResourceConnection session, boolean systemCheck) throws NotAuthorizedException, TigaseDBException {
        boolean result = true;
        if (!systemCheck) {
            boolean isOnline = roster.isOnline(session, buddy);
            if (skipOffline && !isOnline) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "{0} | buddy: {1} is online: {2}", new Object[]{session.getJID(), buddy, isOnline});
                }
                if (result) {
                    // empty if block
                }
                result = false;
            }
        }
        if (skipOfflineSys) {
            TigaseRuntime runtime = TigaseRuntime.getTigaseRuntime();
            boolean isJidOnline = runtime.isJidOnline(buddy);
            if (runtime.hasCompleteJidsInfo() && session.isLocalDomain(buddy.getDomain(), false) && !isJidOnline) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "{0} | buddy: {1} is online (sys): {2}", new Object[]{session.getJID(), buddy, isJidOnline});
                }
                if (result) {
                    // empty if block
                }
                result = false;
            }
        }
        return result;
    }

    public static interface ExtendedPresenceProcessorIfc {
        public Element extend(XMPPResourceConnection var1, Queue<Packet> var2);
    }
}

