/*
 * Decompiled with CFR 0.152.
 */
package tigase.vhosts.filter;

import java.util.HashSet;

public enum DomainFilterPolicy {
    ALL(false),
    LOCAL(false),
    OWN(false),
    LIST(true),
    BLACKLIST(true),
    CUSTOM(true),
    BLOCK(false);

    boolean domainListRequired;
    private static String[] valuesStr;
    private static HashSet<String> valuesDomainsListStr;

    private DomainFilterPolicy(boolean domainListRequired) {
        this.domainListRequired = domainListRequired;
    }

    public static DomainFilterPolicy valueof(String domainFilteringPolicy) {
        if (domainFilteringPolicy == null) {
            return null;
        }
        try {
            return DomainFilterPolicy.valueOf(domainFilteringPolicy);
        }
        catch (Exception e) {
            return ALL;
        }
    }

    public static String[] valuesStr() {
        if (valuesStr == null) {
            DomainFilterPolicy[] vals = DomainFilterPolicy.values();
            valuesStr = new String[vals.length];
            for (int i = 0; i < vals.length; ++i) {
                DomainFilterPolicy.valuesStr[i] = vals[i].name();
            }
        }
        return valuesStr;
    }

    public static HashSet<String> valuePoliciesWithDomainListStr() {
        if (valuesDomainsListStr == null) {
            DomainFilterPolicy[] vals = DomainFilterPolicy.values();
            valuesDomainsListStr = new HashSet();
            for (DomainFilterPolicy val : vals) {
                if (!val.isDomainListRequired()) continue;
                valuesDomainsListStr.add(val.name());
            }
        }
        return valuesDomainsListStr;
    }

    public boolean isDomainListRequired() {
        return this.domainListRequired;
    }

    static {
        valuesStr = null;
        valuesDomainsListStr = null;
    }
}

