/*
 * Decompiled with CFR 0.152.
 */
package tigase.io;

import java.nio.ByteBuffer;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import tigase.cert.CertCheckResult;
import tigase.cert.CertificateUtil;
import tigase.io.TLSEventHandler;
import tigase.io.TLSStatus;
import tigase.io.TLSUtil;
import tigase.server.XMPPServer;

public class TLSWrapper {
    private static final Logger log;
    private int appBuffSize = 0;
    private String debugId = null;
    private TLSEventHandler eventHandler = null;
    private int netBuffSize = 0;
    private SSLEngine tlsEngine = null;
    private SSLEngineResult tlsEngineResult = null;
    private static final boolean tls_jdk_nss_workaround;
    private static final String[] TLS_WORKAROUND_CIPHERS;
    private static final String[] HARDENED_MODE_FORBIDDEN_SIPHERS;
    private static String[] enabledProtocols;
    private static String[] enabledCiphers;

    private static String markEnabled(String[] enabled, String[] supported) {
        List<Object> en = enabled == null ? new ArrayList() : Arrays.asList(enabled);
        String result = "";
        if (supported != null) {
            for (int i = 0; i < supported.length; ++i) {
                String t = supported[i];
                result = result + (en.contains(t) ? "(+)" : "(-)");
                result = result + t;
                if (i + 1 >= supported.length) continue;
                result = result + ",";
            }
        }
        return result;
    }

    public TLSWrapper(SSLContext sslc, TLSEventHandler eventHandler, String hostname, int port, boolean clientMode, boolean wantClientAuth) {
        this(sslc, eventHandler, hostname, port, clientMode, wantClientAuth, false);
    }

    public TLSWrapper(SSLContext sslc, TLSEventHandler eventHandler, String hostname, int port, boolean clientMode, boolean wantClientAuth, boolean needClientAuth) {
        this.tlsEngine = clientMode && hostname != null ? sslc.createSSLEngine(hostname, port) : sslc.createSSLEngine();
        this.tlsEngine.setUseClientMode(clientMode);
        if (enabledCiphers != null) {
            this.tlsEngine.setEnabledCipherSuites(enabledCiphers);
        }
        if (enabledProtocols != null) {
            this.tlsEngine.setEnabledProtocols(enabledProtocols);
        }
        this.netBuffSize = this.tlsEngine.getSession().getPacketBufferSize();
        this.appBuffSize = this.tlsEngine.getSession().getApplicationBufferSize();
        this.eventHandler = eventHandler;
        if (!clientMode && wantClientAuth) {
            this.tlsEngine.setWantClientAuth(true);
        }
        if (!clientMode && needClientAuth) {
            this.tlsEngine.setNeedClientAuth(true);
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Created " + (clientMode ? "client" : "server") + " TLSWrapper. Protocols:" + (this.tlsEngine.getEnabledProtocols() == null ? " default" : Arrays.toString(this.tlsEngine.getEnabledProtocols())) + "; Ciphers:" + (this.tlsEngine.getEnabledCipherSuites() == null ? " default" : Arrays.toString(this.tlsEngine.getEnabledCipherSuites())));
        }
    }

    public int bytesConsumed() {
        return this.tlsEngineResult.bytesConsumed();
    }

    public byte[] getTlsUniqueBindingData() {
        return null;
    }

    public void close() throws SSLException {
        this.tlsEngine.closeOutbound();
        this.tlsEngine.getSession().invalidate();
    }

    public int getAppBuffSize() {
        return this.appBuffSize;
    }

    public CertCheckResult getCertificateStatus(boolean revocationEnabled) {
        Certificate[] peerChain = null;
        try {
            peerChain = this.tlsEngine.getSession().getPeerCertificates();
        }
        catch (SSLPeerUnverifiedException ex) {
            return CertCheckResult.none;
        }
        try {
            return CertificateUtil.validateCertificate(peerChain, TLSUtil.getTrustStore(), revocationEnabled);
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "Problem validating certificate", ex);
            return CertCheckResult.invalid;
        }
    }

    public int getNetBuffSize() {
        return this.netBuffSize;
    }

    public int getPacketBuffSize() {
        return this.tlsEngine.getSession().getPacketBufferSize();
    }

    public TLSStatus getStatus() {
        TLSStatus status = null;
        if (this.tlsEngineResult != null && this.tlsEngineResult.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
            status = TLSStatus.UNDERFLOW;
        } else if (this.tlsEngineResult != null && this.tlsEngineResult.getStatus() == SSLEngineResult.Status.CLOSED) {
            status = TLSStatus.CLOSED;
        } else {
            switch (this.tlsEngine.getHandshakeStatus()) {
                case NEED_WRAP: {
                    status = TLSStatus.NEED_WRITE;
                    break;
                }
                case NEED_UNWRAP: {
                    status = TLSStatus.NEED_READ;
                    break;
                }
                default: {
                    status = TLSStatus.OK;
                }
            }
        }
        return status;
    }

    public boolean isClientMode() {
        return this.tlsEngine.getUseClientMode();
    }

    public void setDebugId(String id) {
        this.debugId = id;
    }

    public ByteBuffer unwrap(ByteBuffer net, ByteBuffer app) throws SSLException {
        ByteBuffer out = app;
        out.order(app.order());
        this.tlsEngineResult = this.tlsEngine.unwrap(net, out);
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "{0}, unwrap() tlsEngineRsult.getStatus() = {1}, tlsEngineRsult.getHandshakeStatus() = {2}", new Object[]{this.debugId, this.tlsEngineResult.getStatus(), this.tlsEngineResult.getHandshakeStatus()});
        }
        if (this.tlsEngineResult.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED && this.eventHandler != null) {
            this.eventHandler.handshakeCompleted(this);
        }
        if (this.tlsEngineResult.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
            out = this.resizeApplicationBuffer(net, out);
            this.tlsEngineResult = this.tlsEngine.unwrap(net, out);
        }
        if (this.tlsEngineResult.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
            this.doTasks();
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "unwrap() doTasks(), handshake: {0}, {1}", new Object[]{this.tlsEngine.getHandshakeStatus(), this.debugId});
            }
        }
        return out;
    }

    public void wrap(ByteBuffer app, ByteBuffer net) throws SSLException {
        this.tlsEngineResult = this.tlsEngine.wrap(app, net);
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "{0}, tlsEngineRsult.getStatus() = {1}, tlsEngineRsult.getHandshakeStatus() = {2}", new Object[]{this.debugId, this.tlsEngineResult.getStatus(), this.tlsEngineResult.getHandshakeStatus()});
        }
        if (this.tlsEngineResult.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED && this.eventHandler != null) {
            this.eventHandler.handshakeCompleted(this);
        }
        if (this.tlsEngineResult.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
            this.doTasks();
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "doTasks(): {0}, {1}", new Object[]{this.tlsEngine.getHandshakeStatus(), this.debugId});
            }
        }
    }

    private void doTasks() {
        Runnable runnable = null;
        while ((runnable = this.tlsEngine.getDelegatedTask()) != null) {
            runnable.run();
        }
    }

    private ByteBuffer resizeApplicationBuffer(ByteBuffer net, ByteBuffer app) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Resizing tlsInput to {0} bytes, {1}", new Object[]{2048 + app.capacity(), this.debugId});
        }
        ByteBuffer bb = ByteBuffer.allocate(app.capacity() + 2048);
        bb.order(app.order());
        app.flip();
        bb.put(app);
        return bb;
    }

    public SSLEngine getTlsEngine() {
        return this.tlsEngine;
    }

    static {
        String enabledCiphersProp;
        String enabledProtocolsProp;
        log = Logger.getLogger(TLSWrapper.class.getName());
        tls_jdk_nss_workaround = System.getProperty("tls-jdk-nss-bug-workaround-active") == null ? false : Boolean.getBoolean("tls-jdk-nss-bug-workaround-active");
        TLS_WORKAROUND_CIPHERS = new String[]{"SSL_RSA_WITH_RC4_128_MD5", "SSL_RSA_WITH_RC4_128_SHA", "TLS_RSA_WITH_AES_128_CBC_SHA", "TLS_DHE_RSA_WITH_AES_128_CBC_SHA", "TLS_DHE_DSS_WITH_AES_128_CBC_SHA", "SSL_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA", "SSL_RSA_WITH_DES_CBC_SHA", "SSL_DHE_RSA_WITH_DES_CBC_SHA", "SSL_DHE_DSS_WITH_DES_CBC_SHA", "SSL_RSA_EXPORT_WITH_RC4_40_MD5", "SSL_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA", "TLS_EMPTY_RENEGOTIATION_INFO_SCSV"};
        HARDENED_MODE_FORBIDDEN_SIPHERS = new String[]{"TLS_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA", "TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_RSA_WITH_3DES_EDE_CBC_SHA", "TLS_ECDH_ECDSA_WITH_3DES_EDE_CBC_SHA", "TLS_ECDH_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA", "TLS_ECDHE_ECDSA_WITH_RC4_128_SHA", "TLS_ECDHE_RSA_WITH_RC4_128_SHA", "SSL_RSA_WITH_RC4_128_SHA", "TLS_ECDH_ECDSA_WITH_RC4_128_SHA", "TLS_ECDH_RSA_WITH_RC4_128_SHA", "SSL_RSA_WITH_RC4_128_MD5", "SSL_RSA_EXPORT_WITH_RC4_40_MD5", "TLS_KRB5_WITH_RC4_128_SHA", "TLS_KRB5_WITH_RC4_128_MD5", "TLS_KRB5_EXPORT_WITH_RC4_40_SHA", "TLS_KRB5_EXPORT_WITH_RC4_40_MD5"};
        String[] allEnabledCiphers = null;
        try {
            SSLEngine tmpE = SSLContext.getDefault().createSSLEngine();
            allEnabledCiphers = tmpE.getEnabledCipherSuites();
            log.config("Supported protocols: " + TLSWrapper.markEnabled(tmpE.getEnabledProtocols(), tmpE.getSupportedProtocols()));
            log.config("Supported ciphers: " + TLSWrapper.markEnabled(allEnabledCiphers, tmpE.getSupportedCipherSuites()));
        }
        catch (NoSuchAlgorithmException e) {
            log.log(Level.WARNING, "Can't determine supported protocols", e);
        }
        if (log.isLoggable(Level.CONFIG)) {
            log.config("Hardened mode is " + (XMPPServer.isHardenedModeEnabled() ? "enabled" : "disabled"));
        }
        if ((enabledProtocolsProp = System.getProperty("tls-enabled-protocols")) != null) {
            enabledProtocols = enabledProtocolsProp.split(",");
        } else if (XMPPServer.isHardenedModeEnabled()) {
            enabledProtocols = new String[]{"SSLv2Hello", "TLSv1", "TLSv1.1", "TLSv1.2"};
        }
        if (log.isLoggable(Level.CONFIG)) {
            log.config("Enabled protocols: " + (enabledProtocols == null ? "default" : Arrays.toString(enabledProtocols)));
        }
        if ((enabledCiphersProp = System.getProperty("tls-enabled-ciphers")) != null) {
            enabledCiphers = enabledCiphersProp.split(",");
        } else if (XMPPServer.isHardenedModeEnabled()) {
            System.setProperty("jdk.tls.ephemeralDHKeySize", "2048");
            ArrayList<String> ciphers = new ArrayList<String>(Arrays.asList(allEnabledCiphers));
            ciphers.removeAll(Arrays.asList(HARDENED_MODE_FORBIDDEN_SIPHERS));
            enabledCiphers = ciphers.toArray(new String[0]);
        } else if (tls_jdk_nss_workaround) {
            if (log.isLoggable(Level.CONFIG)) {
                log.config("Workaround for TLS/SSL bug is enabled");
            }
            enabledCiphers = TLS_WORKAROUND_CIPHERS;
        }
        if (log.isLoggable(Level.CONFIG)) {
            log.config("Enabled ciphers: " + (enabledCiphers == null ? "default" : Arrays.toString(enabledCiphers)));
        }
    }
}

