/*
 * Decompiled with CFR 0.152.
 */
package tigase.disteventbus.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.disteventbus.EventBus;
import tigase.disteventbus.EventHandler;
import tigase.disteventbus.impl.EventName;
import tigase.disteventbus.impl.EventsNameMap;
import tigase.xml.Element;

public class LocalEventBus
implements EventBus {
    public static final String EVENTBUS_INTERNAL_EVENTS_XMLNS = "tigase:eventbus:internal:events:0";
    public static final String HANDLER_ADDED_EVENT_NAME = "HandlerAdded";
    public static final String HANDLER_REMOVED_EVENT_NAME = "HandlerRemoved";
    protected final Logger log = Logger.getLogger(this.getClass().getName());
    private final EventsNameMap<EventHandler> handlers;
    private Executor executor;

    public LocalEventBus() {
        this.setThreadPool(4);
        this.handlers = this.createHandlersMap();
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    @Override
    public void addHandler(String name, String xmlns, EventHandler handler) {
        if (name != null && xmlns == null) {
            throw new RuntimeException("Illegal handler registration. If name is specified, then xmlns must also be specified.");
        }
        this.handlers.put(name, xmlns, handler);
        this.fireOnAddHandler(name, xmlns, handler);
    }

    protected EventsNameMap<EventHandler> createHandlersMap() {
        return new EventsNameMap<EventHandler>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFire(String name, String xmlns, Element event) {
        if (event == null) {
            throw new NullPointerException("Cannot fire null event");
        }
        ArrayList<EventHandler> handlers = new ArrayList<EventHandler>();
        EventsNameMap<EventHandler> eventsNameMap = this.handlers;
        synchronized (eventsNameMap) {
            handlers.addAll(this.getHandlersList(name, xmlns));
            handlers.addAll(this.getHandlersList(null, xmlns));
            handlers.addAll(this.getHandlersList(null, null));
        }
        this.doFireThreadPerHandler(name, xmlns, event, handlers);
    }

    private void doFireThreadPerHandler(String name, String xmlns, Element event, ArrayList<EventHandler> handlersList) {
        for (EventHandler eventHandler : handlersList) {
            Runnable task = () -> {
                block2: {
                    try {
                        eventHandler.onEvent(name, xmlns, event);
                    }
                    catch (Throwable e) {
                        if (!this.log.isLoggable(Level.WARNING)) break block2;
                        this.log.log(Level.WARNING, "Problem during handling event name=" + name + ", xmlns=" + xmlns + " in handler " + eventHandler, e);
                    }
                }
            };
            this.executor.execute(task);
        }
    }

    private void doFireThreadPerEvent(String name, String xmlns, Element event, ArrayList<EventHandler> handlersList) {
        Runnable task = () -> {
            for (EventHandler eventHandler : handlersList) {
                try {
                    eventHandler.onEvent(name, xmlns, event);
                }
                catch (Throwable e) {
                    if (!this.log.isLoggable(Level.WARNING)) continue;
                    this.log.log(Level.WARNING, "Problem during handling event name=" + name + ", xmlns=" + xmlns + " in handler " + eventHandler, e);
                }
            }
        };
        this.executor.execute(task);
    }

    @Override
    public void fire(Element event) {
        String name = event.getName();
        String xmlns = event.getXMLNS();
        this.doFire(name, xmlns, event);
    }

    private void fireOnAddHandler(String name, String xmlns, EventHandler handler) {
        Element event = new Element(HANDLER_ADDED_EVENT_NAME);
        event.setAttribute("local", "true");
        event.setXMLNS(EVENTBUS_INTERNAL_EVENTS_XMLNS);
        event.addChild(new Element("name", name));
        event.addChild(new Element("xmlns", xmlns));
        this.fire(event);
    }

    private void fireOnRemoveHandler(String name, String xmlns, EventHandler handler) {
        Element event = new Element(HANDLER_REMOVED_EVENT_NAME);
        event.setAttribute("local", "true");
        event.setXMLNS(EVENTBUS_INTERNAL_EVENTS_XMLNS);
        event.addChild(new Element("name", name));
        event.addChild(new Element("xmlns", xmlns));
        this.fire(event);
    }

    public Set<EventName> getAllListenedEvents() {
        return this.handlers.getAllListenedEvents();
    }

    protected Collection<EventHandler> getHandlersList(String name, String xmlns) {
        return this.handlers.get(name, xmlns);
    }

    public boolean hasHandlers(String name, String xmlns) {
        return this.handlers.hasData(name, xmlns);
    }

    @Override
    public void removeHandler(String name, String xmlns, EventHandler handler) {
        this.handlers.delete(name, xmlns, handler);
        this.fireOnRemoveHandler(name, xmlns, handler);
    }

    public void setThreadPool(int pool) {
        this.executor = Executors.newFixedThreadPool(pool);
    }
}

