/*
 * Decompiled with CFR 0.152.
 */
package tigase.archive.db;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import tigase.archive.AbstractCriteria;
import tigase.archive.db.MessageArchiveRepository;
import tigase.xml.Element;
import tigase.xmpp.JID;

public abstract class AbstractMessageArchiveRepository<Crit extends AbstractCriteria>
implements MessageArchiveRepository<Crit> {
    private static final SimpleDateFormat TIMESTAMP_FORMATTER1 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXX");
    protected static final String[] MSG_BODY_PATH = new String[]{"message", "body"};
    protected static final String[] MSG_SUBJECT_PATH = new String[]{"message", "subject"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Element addCollectionToResults(List<Element> results, Crit criteria, String with, Date start, String type) {
        String formattedStart = null;
        SimpleDateFormat simpleDateFormat = TIMESTAMP_FORMATTER1;
        synchronized (simpleDateFormat) {
            formattedStart = TIMESTAMP_FORMATTER1.format(start);
        }
        Element elem = new Element("chat", new String[]{"with", "start"}, new String[]{with, formattedStart});
        if (type != null && !type.isEmpty()) {
            elem.addAttribute("type", type);
        }
        results.add(elem);
        return elem;
    }

    protected Element addMessageToResults(List<Element> results, Crit criteria, Date collectionStart, Element msg, Date timestamp, MessageArchiveRepository.Direction direction, String with) {
        JID from;
        Element item = new Element(direction.toElementName());
        item.addChildren(msg.getChildren());
        item.setAttribute("secs", String.valueOf((timestamp.getTime() - collectionStart.getTime()) / 1000L));
        if (with != null) {
            item.setAttribute("with", with);
        }
        if ("groupchat".equals(msg.getAttributeStaticStr("type")) && (from = JID.jidInstanceNS((String)msg.getAttributeStaticStr("from"))) != null && from.getResource() != null) {
            item.setAttribute("name", from.getResource());
        }
        results.add(item);
        return item;
    }

    protected byte[] generateHashOfMessage(MessageArchiveRepository.Direction direction, Element msg, Date ts, Map<String, Object> additionalData) {
        try {
            String body;
            String peer;
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            String string = peer = direction == MessageArchiveRepository.Direction.incoming ? msg.getAttributeStaticStr("from") : msg.getAttributeStaticStr("to");
            if (peer != null) {
                md.update(peer.getBytes());
            }
            String type = msg.getAttributeStaticStr("type");
            Element subjectEl = msg.getChild("subject");
            String subject = msg.getChildCData(MSG_SUBJECT_PATH);
            String id = msg.getAttributeStaticStr("id");
            if (id != null) {
                if (!"groupchat".equals(type) || subjectEl == null) {
                    md.update(id.getBytes());
                } else {
                    md.update(":".getBytes());
                    md.update(new Long(ts.getTime() / 60000L).toString().getBytes());
                    if (subject != null) {
                        md.update(subject.getBytes());
                    }
                    md.update(":".getBytes());
                }
            }
            if (type == null || !"groupchat".equals(type)) {
                md.update(new Long(ts.getTime() / 1000L).toString().getBytes());
            }
            if ((body = msg.getChildCData(MSG_BODY_PATH)) != null) {
                md.update(body.getBytes());
            }
            return md.digest();
        }
        catch (NoSuchAlgorithmException ex) {
            return null;
        }
    }

    static {
        TIMESTAMP_FORMATTER1.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

