/*
 * Decompiled with CFR 0.152.
 */
package tigase.archive;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.archive.RetentionType;
import tigase.archive.Settings;
import tigase.archive.StoreMethod;
import tigase.archive.StoreMuc;
import tigase.archive.VHostItemHelper;
import tigase.db.NonAuthUserRepository;
import tigase.db.TigaseDBException;
import tigase.server.Packet;
import tigase.util.DNSResolverFactory;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.ElementMatcher;
import tigase.xmpp.JID;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPProcessor;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.C2SDeliveryErrorProcessor;
import tigase.xmpp.impl.Message;

public class MessageArchivePlugin
extends XMPPProcessor
implements XMPPProcessorIfc {
    public static final String DEFAULT_SAVE = "default-save";
    public static final String MUC_SAVE = "muc-save";
    public static final String LIST = "list";
    public static final String OWNER_JID = "owner";
    public static final String REMOVE = "remove";
    public static final String RETRIEVE = "retrieve";
    public static final String XEP0136NS = "urn:xmpp:archive";
    private static final String ARCHIVE = "message-archive";
    protected static final String AUTO = "auto";
    private static final String EXPIRE = "expire";
    protected static final String ID = "message-archive-xep-0136";
    private static final Logger log = Logger.getLogger(MessageArchivePlugin.class.getCanonicalName());
    private static final String MESSAGE = "message";
    private static final String SAVE = "save";
    protected static final String SETTINGS = "message-archive/settings";
    private static final String XMLNS = "jabber:client";
    private static final String[][] ELEMENT_PATHS = new String[][]{{"message"}, {"iq", "auto"}, {"iq", "retrieve"}, {"iq", "list"}, {"iq", "remove"}, {"iq", "save"}, {"iq", "pref"}, {"iq", "tags"}};
    private static final String[] XMLNSS = new String[]{"jabber:client", "urn:xmpp:archive", "urn:xmpp:archive", "urn:xmpp:archive", "urn:xmpp:archive", "urn:xmpp:archive", "urn:xmpp:archive", "http://tigase.org/protocol/archive#query"};
    private static final Element[] DISCO_FEATURES = new Element[]{new Element("feature", new String[]{"var"}, new String[]{"urn:xmpp:archive:auto"}), new Element("feature", new String[]{"var"}, new String[]{"urn:xmpp:archive:manage"})};
    public static final String MSG_ARCHIVE_PATHS = "msg-archive-paths";
    private static final String DEFAULT_STORE_METHOD_KEY = "default-store-method";
    private static final String REQUIRED_STORE_METHOD_KEY = "required-store-method";
    private static final String STORE_MUC_MESSAGES_KEY = "store-muc-messages";
    private static final String[] MESSAGE_HINTS_NO_STORE = new String[]{"message", "no-store"};
    private static final String[] MESSAGE_HINTS_NO_PERMANENT_STORE = new String[]{"message", "no-permanent-store"};
    private static final String MESSAGE_HINTS_XMLNS = "urn:xmpp:hints";
    private ElementMatcher[] archivingMatchers = new ElementMatcher[]{new ElementMatcher(new String[]{"message", "body"}, null, true)};
    private StoreMethod globalDefaultStoreMethod = StoreMethod.Body;
    private StoreMethod globalRequiredStoreMethod = StoreMethod.False;
    private StoreMuc globalStoreMucMessages = StoreMuc.User;
    private final SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private JID ma_jid = null;
    private Message message = new Message();

    public void init(Map<String, Object> settings) throws TigaseDBException {
        super.init(settings);
        VHostItemHelper.register();
        String componentJidStr = (String)settings.get("component-jid");
        if (componentJidStr != null) {
            this.ma_jid = JID.jidInstanceNS((String)componentJidStr);
        } else {
            String defHost = DNSResolverFactory.getInstance().getDefaultHost();
            this.ma_jid = JID.jidInstanceNS((String)ARCHIVE, (String)defHost, null);
        }
        log.log(Level.CONFIG, "Loaded message archiving component jid option: {0} = {1}", new Object[]{"component-jid", this.ma_jid});
        System.out.println("MA LOADED = " + this.ma_jid.toString());
        if (settings.containsKey(REQUIRED_STORE_METHOD_KEY)) {
            this.globalRequiredStoreMethod = StoreMethod.valueof((String)settings.get(REQUIRED_STORE_METHOD_KEY));
        }
        if (settings.containsKey(DEFAULT_STORE_METHOD_KEY)) {
            this.globalDefaultStoreMethod = StoreMethod.valueof((String)settings.get(DEFAULT_STORE_METHOD_KEY));
        }
        if (this.globalDefaultStoreMethod.ordinal() < this.globalRequiredStoreMethod.ordinal()) {
            this.globalDefaultStoreMethod = this.globalRequiredStoreMethod;
        }
        if (settings.containsKey(STORE_MUC_MESSAGES_KEY)) {
            this.globalStoreMucMessages = StoreMuc.valueof((String)settings.get(STORE_MUC_MESSAGES_KEY));
        }
        if (settings.containsKey(MSG_ARCHIVE_PATHS)) {
            String[] matcherStrs = (String[])settings.get(MSG_ARCHIVE_PATHS);
            ArrayList<ElementMatcher> matchers = new ArrayList<ElementMatcher>();
            for (String matcherStr : matcherStrs) {
                ElementMatcher matcher = ElementMatcher.create((String)matcherStr);
                if (matcher == null) continue;
                matchers.add(matcher);
            }
            this.archivingMatchers = matchers.toArray(new ElementMatcher[0]);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws XMPPException {
        block59: {
            if (session == null) {
                return;
            }
            try {
                block60: {
                    block61: {
                        if ("message" == packet.getElemName()) {
                            if (!(this.message.hasConnectionForMessageDelivery(session) || packet.getStanzaTo() != null && packet.getStanzaTo().getResource() != null)) {
                                return;
                            }
                            this.processMessage(packet, session, results);
                            break block59;
                        }
                        if ("iq" != packet.getElemName()) break block59;
                        if (this.ma_jid.equals((Object)packet.getPacketFrom())) {
                            connId = session.getConnectionId(packet.getStanzaTo());
                            result = packet.copyElementOnly();
                            result.setPacketTo(connId);
                            results.offer(result);
                            return;
                        }
                        if (packet.getType() != StanzaType.get && packet.getType() != StanzaType.set) {
                            return;
                        }
                        auto = packet.getElement().getChild("auto");
                        pref = packet.getElement().getChild("pref");
                        requiredStoreMethod = this.getRequiredStoreMethod(session);
                        if (auto == null && pref == null) {
                            result = packet.copyElementOnly();
                            result.setPacketTo(this.ma_jid);
                            results.offer(result);
                            break block59;
                        }
                        if (pref == null) break block60;
                        if (packet.getType() == StanzaType.get) {
                            prefEl = new Element("pref");
                            prefEl.setXMLNS("urn:xmpp:archive");
                            autoEl = new Element("auto");
                            autoEl.setAttribute("save", String.valueOf(this.getAutoSave(session)));
                            prefEl.addChild((XMLNodeIfc)autoEl);
                            defaultEl = new Element("default");
                            defaultEl.setAttribute("otr", "forbid");
                            try {
                                retentionType = VHostItemHelper.getRetentionType(session.getDomain());
                                expire = null;
                                switch (1.$SwitchMap$tigase$archive$RetentionType[retentionType.ordinal()]) {
                                    case 1: {
                                        expire = session.getData("message-archive/settings", "expire", null);
                                        break;
                                    }
                                    case 2: {
                                        retention = VHostItemHelper.getRetentionDays(session.getDomain());
                                        if (retention == null) break;
                                        expire = String.valueOf(retention.longValue() * 60L * 60L * 24L);
                                        break;
                                    }
                                }
                                if (expire != null) {
                                    defaultEl.setAttribute("expire", expire);
                                }
                            }
                            catch (TigaseDBException ex) {
                                MessageArchivePlugin.log.log(Level.WARNING, "could not retrieve expire setting for message archive for user {0}", session.getjid());
                            }
                            isStoreMuc = this.isStoreMucMessages(session);
                            defaultEl.setAttribute("muc-save", Boolean.toString(isStoreMuc));
                            storeMethod = this.getStoreMethod(session);
                            defaultEl.setAttribute("save", storeMethod.toString());
                            prefEl.addChild((XMLNodeIfc)defaultEl);
                            methodEl = new Element("method");
                            methodEl.setAttribute("type", "auto");
                            methodEl.setAttribute("use", "prefer");
                            prefEl.addChild((XMLNodeIfc)methodEl);
                            methodEl = new Element("method");
                            methodEl.setAttribute("type", "local");
                            methodEl.setAttribute("use", "prefer");
                            prefEl.addChild((XMLNodeIfc)methodEl);
                            methodEl = new Element("method");
                            methodEl.setAttribute("type", "manual");
                            methodEl.setAttribute("use", "prefer");
                            prefEl.addChild((XMLNodeIfc)methodEl);
                            results.offer(packet.okResult(prefEl, 0));
                            break block59;
                        }
                        if (packet.getType() != StanzaType.set) break block61;
                        error = null;
                        storeMethod = null;
                        autoSave = null;
                        errorMsg = null;
                        expire = null;
                        storeMuc = null;
                        block34: for (Element elem : pref.getChildren()) {
                            var17_35 = elem.getName();
                            var18_36 = -1;
                            switch (var17_35.hashCode()) {
                                case 1544803905: {
                                    if (!var17_35.equals("default")) break;
                                    var18_36 = 0;
                                    break;
                                }
                                case 3005871: {
                                    if (!var17_35.equals("auto")) break;
                                    var18_36 = 1;
                                }
                            }
                            switch (var18_36) {
                                case 0: {
                                    storeMethodStr = elem.getAttributeStaticStr("save");
                                    if (storeMethodStr == null) ** GOTO lbl111
                                    try {
                                        storeMethod = StoreMethod.valueof(storeMethodStr);
                                        if (storeMethod == StoreMethod.Stream) {
                                            error = Authorization.FEATURE_NOT_IMPLEMENTED;
                                            errorMsg = "Value stream of save attribute is not supported";
                                            break;
                                        }
                                        if (storeMethod.ordinal() < requiredStoreMethod.ordinal()) {
                                            error = Authorization.NOT_ACCEPTABLE;
                                            errorMsg = "Required minimal message archiving level is " + requiredStoreMethod.toString();
                                        }
                                        ** GOTO lbl111
                                    }
                                    catch (IllegalArgumentException ex) {
                                        error = Authorization.BAD_REQUEST;
                                        errorMsg = "Value " + storeMethodStr + " of save attribute is valid";
                                    }
                                    break;
lbl111:
                                    // 2 sources

                                    if ((otr = elem.getAttributeStaticStr("otr")) != null && !"forbid".equals(otr)) {
                                        error = Authorization.FEATURE_NOT_IMPLEMENTED;
                                        errorMsg = "Value " + otr + " of otr attribute is not supported";
                                    }
                                    if ((expire = elem.getAttributeStaticStr("expire")) == null) ** GOTO lbl130
                                    if (RetentionType.userDefined == VHostItemHelper.getRetentionType(session.getDomain())) ** GOTO lbl119
                                    error = Authorization.NOT_ALLOWED;
                                    errorMsg = "Expire value is not allowed to be changed by user";
                                    ** GOTO lbl130
lbl119:
                                    // 1 sources

                                    try {
                                        val = Long.parseLong(expire);
                                        if (val <= 0L) {
                                            error = Authorization.NOT_ACCEPTABLE;
                                            errorMsg = "Value of expire attribute must be bigger than 0";
                                        }
                                        ** GOTO lbl130
                                    }
                                    catch (NumberFormatException ex) {
                                        error = Authorization.BAD_REQUEST;
                                        errorMsg = "Value of expire attribute must be a number";
                                    }
                                    break;
lbl130:
                                    // 3 sources

                                    if ((storeMuc = elem.getAttributeStaticStr("muc-save")) == null) continue block34;
                                    if (StoreMuc.User != VHostItemHelper.getStoreMucMessages(session.getDomain(), this.globalStoreMucMessages)) {
                                        error = Authorization.NOT_ALLOWED;
                                        errorMsg = "Store MUC value is not allowed to be changed by user";
                                        break;
                                    }
                                    if (!"true".equals(storeMuc) && !"false".equals(storeMuc)) {
                                        error = Authorization.BAD_REQUEST;
                                        errorMsg = "Value of muc-save attribute must be 'true' or 'false'";
                                        break;
                                    }
                                    sm = storeMethod == null ? this.getStoreMethod(session) : storeMethod;
                                    if (sm != StoreMethod.False) continue block34;
                                    error = Authorization.NOT_ACCEPTABLE;
                                    errorMsg = "Can not change MUC message storage configuration as Message Archiving is disabled";
                                    break;
                                }
                                case 1: {
                                    autoSave = Boolean.valueOf(elem.getAttributeStaticStr("save"));
                                    if (!(requiredStoreMethod == StoreMethod.False || autoSave != null && autoSave.booleanValue())) {
                                        error = Authorization.NOT_ACCEPTABLE;
                                        errorMsg = "Required minimal message archiving level is " + requiredStoreMethod.toString() + " and that requires automatic archiving to be enabled";
                                    }
                                    if (!autoSave.booleanValue() || VHostItemHelper.isEnabled(session.getDomain())) continue block34;
                                    error = Authorization.NOT_ALLOWED;
                                    errorMsg = "Message archiving is not allowed for domain " + session.getDomainAsJID().toString();
                                    break;
                                }
                                default: {
                                    error = Authorization.FEATURE_NOT_IMPLEMENTED;
                                    errorMsg = null;
                                }
                            }
                        }
                        if (error != null) {
                            results.offer(error.getResponseMessage(packet, errorMsg, true));
                        } else {
                            try {
                                if (autoSave != null) {
                                    this.setAutoSave(session, autoSave);
                                }
                                if (storeMethod != null) {
                                    this.setStoreMethod(session, storeMethod);
                                }
                                if (expire != null) {
                                    session.setData("message-archive/settings", "expire", expire);
                                }
                                if (storeMuc != null) {
                                    session.setData("message-archive/settings", "muc-save", storeMuc);
                                    session.putCommonSessionData("message-archive-xep-0136/muc-save", (Object)(Boolean.parseBoolean(storeMuc) != false ? StoreMuc.True : StoreMuc.False));
                                }
                                results.offer(packet.okResult((String)null, 0));
                            }
                            catch (TigaseDBException ex) {
                                results.offer(Authorization.INTERNAL_SERVER_ERROR.getResponseMessage(packet, null, false));
                            }
                        }
                        break block59;
                    }
                    results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, null, true));
                    break block59;
                }
                val = auto.getAttributeStaticStr("save");
                if (val == null) {
                    val = "";
                }
                save = false;
                autoSave = val;
                var12_27 = -1;
                switch (autoSave.hashCode()) {
                    case 3569038: {
                        if (!autoSave.equals("true")) break;
                        var12_27 = 0;
                        break;
                    }
                    case 49: {
                        if (!autoSave.equals("1")) break;
                        var12_27 = 1;
                        break;
                    }
                    case 97196323: {
                        if (!autoSave.equals("false")) break;
                        var12_27 = 2;
                        break;
                    }
                    case 48: {
                        if (!autoSave.equals("0")) break;
                        var12_27 = 3;
                    }
                }
                switch (var12_27) {
                    case 0: 
                    case 1: {
                        save = true;
                        break;
                    }
                    case 2: 
                    case 3: {
                        save = false;
                        break;
                    }
                    default: {
                        results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, "Save value is incorrect or missing", false));
                        return;
                    }
                }
                if (!save && requiredStoreMethod != StoreMethod.False) {
                    results.offer(Authorization.NOT_ACCEPTABLE.getResponseMessage(packet, "Required minimal message archiving level is " + requiredStoreMethod.toString() + " and that requires automatic archiving to be enabled", false));
                    return;
                }
                if (save && !VHostItemHelper.isEnabled(session.getDomain())) {
                    results.offer(Authorization.NOT_ACCEPTABLE.getResponseMessage(packet, "Message archiving is not allowed for domain " + session.getDomainAsJID().toString(), false));
                    return;
                }
                try {
                    this.setAutoSave(session, save);
                    session.putCommonSessionData("message-archive-xep-0136/auto", (Object)save);
                    res = new Element("auto");
                    res.setXMLNS("urn:xmpp:archive");
                    res.setAttribute("save", save != false ? "true" : "false");
                    results.offer(packet.okResult(res, 0));
                    return;
                }
                catch (TigaseDBException ex) {
                    MessageArchivePlugin.log.log(Level.WARNING, "Error setting Message Archive state: {0}", ex.getMessage());
                    results.offer(Authorization.INTERNAL_SERVER_ERROR.getResponseMessage(packet, "Database error occured", true));
                }
            }
            catch (NotAuthorizedException ex) {
                MessageArchivePlugin.log.log(Level.WARNING, "NotAuthorizedException for packet: {0}", packet);
                results.offer(Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "You must authorize session first.", true));
            }
        }
    }

    public String id() {
        return ID;
    }

    public String[][] supElementNamePaths() {
        return ELEMENT_PATHS;
    }

    public String[] supNamespaces() {
        return XMLNSS;
    }

    public Element[] supDiscoFeatures(XMPPResourceConnection session) {
        return DISCO_FEATURES;
    }

    private void processMessage(Packet packet, XMPPResourceConnection session, Queue<Packet> results) throws NotAuthorizedException {
        StoreMethod requiredStoreMethod;
        if (C2SDeliveryErrorProcessor.isDeliveryError((Packet)packet)) {
            log.log(Level.FINEST, "not processong packet as it is delivery error = {0}", packet);
            return;
        }
        StanzaType type = packet.getType();
        if (type == null) {
            type = StanzaType.normal;
        }
        Element body = packet.getElement().findChildStaticStr(tigase.server.Message.MESSAGE_BODY_PATH);
        boolean auto = this.getAutoSave(session);
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "got state of automatic storage of messages as {0}", auto);
        }
        if (!auto) {
            return;
        }
        if ((packet.getAttributeStaticStr(MESSAGE_HINTS_NO_STORE, "xmlns") == MESSAGE_HINTS_XMLNS || packet.getAttributeStaticStr(MESSAGE_HINTS_NO_PERMANENT_STORE, "xmlns") == MESSAGE_HINTS_XMLNS) && (requiredStoreMethod = this.getRequiredStoreMethod(session)) == StoreMethod.False) {
            return;
        }
        StoreMethod storeMethod = StoreMethod.False;
        switch (type) {
            case chat: 
            case normal: {
                storeMethod = this.getStoreMethod(session);
                break;
            }
            case groupchat: {
                if (!this.isStoreMucMessages(session)) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "not storing message as archiving of MUC messages is disabled: {0}", packet);
                    }
                    return;
                }
                if (session.isUserId(packet.getStanzaFrom().getBareJID())) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "not storing message sent to MUC room from user = {0}", packet.toString());
                    }
                    return;
                }
                storeMethod = this.getStoreMethod(session);
                break;
            }
        }
        switch (storeMethod) {
            case False: {
                if (!log.isLoggable(Level.FINEST)) break;
                log.log(Level.FINEST, "not logging packet due to storage method: {0}, {1}", new Object[]{storeMethod, packet});
                return;
            }
            case Body: {
                if (body != null || !log.isLoggable(Level.FINEST)) break;
                log.log(Level.FINEST, "not logging packet as there is not body element: ", new Object[]{storeMethod, packet});
                return;
            }
        }
        boolean archive = false;
        for (ElementMatcher matcher : this.archivingMatchers) {
            if (!matcher.matches(packet)) continue;
            archive = matcher.getValue();
            break;
        }
        if (!archive) {
            return;
        }
        this.storeMessage(packet, session, storeMethod, results);
    }

    private void storeMessage(Packet packet, XMPPResourceConnection session, StoreMethod storeMethod, Queue<Packet> results) throws NotAuthorizedException {
        Packet result = packet.copyElementOnly();
        result.setPacketFrom(session.getJID().copyWithoutResource());
        result.setPacketTo(this.ma_jid);
        result.getElement().addAttribute(OWNER_JID, session.getBareJID().toString());
        switch (storeMethod) {
            case Body: {
                Element message = result.getElement();
                block11: for (Element elem : message.getChildren()) {
                    switch (elem.getName()) {
                        case "body": {
                            continue block11;
                        }
                        case "delay": {
                            continue block11;
                        }
                    }
                    message.removeChild(elem);
                }
                break;
            }
        }
        results.offer(result);
    }

    private boolean getAutoSave(XMPPResourceConnection session) throws NotAuthorizedException {
        return Settings.getAutoSave(session, this.globalRequiredStoreMethod);
    }

    private StoreMethod getRequiredStoreMethod(XMPPResourceConnection session) {
        return Settings.getRequiredStoreMethod(session, this.globalRequiredStoreMethod);
    }

    private StoreMethod getStoreMethod(XMPPResourceConnection session) throws NotAuthorizedException {
        StoreMethod save = (StoreMethod)((Object)session.getCommonSessionData("message-archive-xep-0136/default-save"));
        if (save == null) {
            try {
                String data = session.getData(SETTINGS, DEFAULT_SAVE, null);
                if (data == null) {
                    data = VHostItemHelper.getDefaultStoreMethod(session.getDomain(), this.globalDefaultStoreMethod.toString());
                }
                save = StoreMethod.valueof(data);
                session.putCommonSessionData("message-archive-xep-0136/default-save", (Object)save);
            }
            catch (TigaseDBException ex) {
                log.log(Level.WARNING, "Error getting Message Archive state: {0}", ex.getMessage());
                save = StoreMethod.False;
            }
            StoreMethod requiredStoreMethod = this.getRequiredStoreMethod(session);
            if (save.ordinal() < requiredStoreMethod.ordinal()) {
                save = requiredStoreMethod;
                session.putCommonSessionData("message-archive-xep-0136/default-save", (Object)save);
                try {
                    this.setStoreMethod(session, save);
                }
                catch (TigaseDBException ex) {
                    log.log(Level.WARNING, "Error updating message archiving level to required level {0}", ex.getMessage());
                }
            }
        }
        return save;
    }

    private boolean isStoreMucMessages(XMPPResourceConnection session) throws NotAuthorizedException {
        StoreMuc save = (StoreMuc)((Object)session.getCommonSessionData("message-archive-xep-0136/muc-save"));
        if (save == null) {
            block6: {
                if (this.globalStoreMucMessages == StoreMuc.User) {
                    try {
                        String val = session.getData(SETTINGS, MUC_SAVE, null);
                        if (val == null) {
                            save = VHostItemHelper.getStoreMucMessages(session.getDomain(), this.globalStoreMucMessages);
                            break block6;
                        }
                        save = StoreMuc.valueof(val);
                    }
                    catch (TigaseDBException ex) {
                        log.log(Level.WARNING, "Error getting Message Archive state of storage of MUC messages: {0}", ex.getMessage());
                        save = StoreMuc.User;
                    }
                } else {
                    save = this.globalStoreMucMessages;
                }
            }
            session.putCommonSessionData("message-archive-xep-0136/muc-save", (Object)save);
        }
        return save == StoreMuc.True;
    }

    public void setAutoSave(XMPPResourceConnection session, Boolean auto) throws NotAuthorizedException, TigaseDBException {
        session.setData(SETTINGS, AUTO, String.valueOf(auto));
        session.putCommonSessionData("message-archive-xep-0136/auto", (Object)auto);
    }

    public void setStoreMethod(XMPPResourceConnection session, StoreMethod save) throws NotAuthorizedException, TigaseDBException {
        session.setData(SETTINGS, DEFAULT_SAVE, (save == null ? StoreMethod.False : save).toString());
        session.putCommonSessionData("message-archive-xep-0136/default-save", (Object)save);
    }
}

