/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.cluster;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.cluster.api.ClusterControllerIfc;
import tigase.cluster.api.CommandListener;
import tigase.component2.exceptions.ComponentException;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.LeafNodeConfig;
import tigase.pubsub.cluster.AbstractStrategy;
import tigase.pubsub.cluster.CachedPubSubRepositoryClustered;
import tigase.pubsub.cluster.StrategyIfc;
import tigase.pubsub.cluster.commands.NodesChangedCommand;
import tigase.pubsub.exceptions.PubSubException;
import tigase.pubsub.modules.PublishItemModule;
import tigase.pubsub.repository.NodeSubscriptions;
import tigase.pubsub.repository.stateless.UsersSubscription;
import tigase.server.Packet;
import tigase.sys.TigaseRuntime;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;
import tigase.xmpp.StanzaType;

public class ClusteredNodeStrategy
extends AbstractStrategy
implements StrategyIfc {
    private static final Logger a = Logger.getLogger(ClusteredNodeStrategy.class.getCanonicalName());
    private static final String[] b = new String[]{"iq", "pubsub", "publish"};
    public static final String[] FORWARD_ELEMENTS = new String[]{"publish", "retract", "subscribe", "unsubscribe", "options", "default"};
    private final Set<String> c = new HashSet<String>(Arrays.asList(FORWARD_ELEMENTS));
    private NodesChangedCommand d = new NodesChangedCommand(){

        @Override
        protected CachedPubSubRepositoryClustered getPubSubRepositoryClustered() {
            return ClusteredNodeStrategy.this.pubSubComponent.getPubSubRepository();
        }
    };
    private final ThreadLocal<String> e = new ThreadLocal();

    @Override
    public boolean filterOutPacket(Packet packet) {
        String string;
        if (packet.getElemName() == "iq" && (packet.getType() == StanzaType.result || packet.getType() == StanzaType.error) && (string = this.e.get()) != null) {
            boolean bl;
            String string2 = packet.getAttributeStaticStr("id");
            boolean bl2 = bl = string2 != null && string2.equals(string);
            if (a.isLoggable(Level.FINEST)) {
                a.log(Level.FINEST, "filtering result: {0}, idToFilter: {1}, for packet: {2}", new Object[]{bl, string, packet});
            }
            return bl;
        }
        return false;
    }

    @Override
    public List<JID> getNodesForPacket(Packet packet) throws PubSubException {
        if (packet.getElemName() == "presence") {
            if (this.pubSubComponent != null && this.pubSubComponent.getName().equals(packet.getPacketFrom().getLocalpart())) {
                if (a.isLoggable(Level.FINEST)) {
                    a.log(Level.FINEST, "Presence packet from pubsub component, returning local node, packet: {0}", new Object[]{packet});
                }
                return Collections.singletonList(this.getLocalNodeJid());
            }
            if (a.isLoggable(Level.FINEST)) {
                a.log(Level.FINEST, "Presence packet - other, returning all nodes, packet: {0}", new Object[]{packet});
            }
            return this.getNodesConnectedWithLocal();
        }
        if (packet.getElemName() == "message") {
            if (a.isLoggable(Level.FINEST)) {
                a.log(Level.FINEST, "Message packet, returning current node, packet: {0}", new Object[]{packet});
            }
            return Collections.singletonList(this.getLocalNodeJid());
        }
        if (packet.getElemName() == "iq") {
            JID jID = packet.getStanzaTo();
            List list = packet.getElemChildrenStaticStr(PUBSUB_PATH);
            Element element = list != null && !list.isEmpty() ? (Element)list.get(0) : null;
            Element element2 = packet.getElement().findChildStaticStr(new String[]{"iq", "command"});
            if (element == null) {
                Element element3;
                if (!(element2 == null || this.pubSubComponent != null && this.pubSubComponent.getName().equals(packet.getPacketFrom().getLocalpart()))) {
                    List list2;
                    if (a.isLoggable(Level.FINEST)) {
                        a.log(Level.FINEST, "IQ packet, ad-hoc command, returning all nodes, packet: {0}", new Object[]{packet});
                    }
                    if ((list2 = element2.getChildrenStaticStr(new String[]{"command", "x"})) != null && !list2.isEmpty()) {
                        for (Element element4 : list2) {
                            if (element4.getAttributeStaticStr("var") == null || element4.getAttributeStaticStr("var") != "item-id" || element4.getChild("value") == null || element4.getChild("value").getCData() != null) continue;
                            String string = UUID.randomUUID().toString();
                            element4.getChild("value").setCData(string);
                        }
                    }
                    return this.getNodesConnectedWithLocal();
                }
                if (packet.getType() == StanzaType.result && (element3 = packet.getElement().getChild("query", "http://jabber.org/protocol/disco#info")) != null && element3.getAttributeStaticStr("node") != null) {
                    if (this.pubSubComponent != null && packet.getPacketFrom() != null && this.pubSubComponent.getName().equals(packet.getPacketFrom().getLocalpart())) {
                        if (a.isLoggable(Level.FINEST)) {
                            a.log(Level.FINEST, "IQ packet, forwarded disco#info for CAPS, returning local node, packet: {0}", new Object[]{packet});
                        }
                        return Collections.singletonList(this.getLocalNodeJid());
                    }
                    if (a.isLoggable(Level.FINEST)) {
                        a.log(Level.FINEST, "IQ packet, disco#info for CAPS, returning all nodes, packet: {0}", new Object[]{packet});
                    }
                    return this.getNodesConnectedWithLocal();
                }
                if (packet.getType() != StanzaType.get) {
                    if (a.isLoggable(Level.FINEST)) {
                        a.log(Level.FINEST, "adding packet to filterResponse, id: {0}, filterResponse: {1}", new Object[]{packet.getAttributeStaticStr("id"), this.e});
                    }
                    this.e.set(packet.getAttributeStaticStr("id"));
                }
                if (a.isLoggable(Level.FINEST)) {
                    a.log(Level.FINEST, "IQ packet, other, returning current node, packet: {0}", new Object[]{packet});
                }
                return Collections.singletonList(this.getLocalNodeJid());
            }
            String string = element.getAttributeStaticStr("node");
            if (string == null || this.isNodeConfigure(element)) {
                JID jID2 = this.getNodeForServiceJid(jID);
                if (a.isLoggable(Level.FINEST)) {
                    a.log(Level.FINEST, "IQ packet, configuration or related to nodes, returning dedicated node, nodeJid: {0}, packet: {1}", new Object[]{jID2, packet});
                }
                return Collections.singletonList(jID2);
            }
            boolean bl = false;
            List list3 = list;
            if (list3 != null) {
                for (Object object : list3) {
                    bl |= this.c.contains(object.getName());
                }
            }
            Element element5 = packet.getElement().findChildStaticStr(b);
            if (!(this.pubSubComponent != null && this.pubSubComponent.getName().equals(packet.getPacketFrom().getLocalpart()) || element5 == null && !bl)) {
                PublishItemModule publishItemModule;
                Object object;
                List list4 = object = element5 != null ? element5.getChildren() : null;
                if (object != null) {
                    publishItemModule = object.iterator();
                    while (publishItemModule.hasNext()) {
                        Element element6 = (Element)publishItemModule.next();
                        if (element6.getAttributeStaticStr("id") != null) continue;
                        String string2 = UUID.randomUUID().toString();
                        element6.setAttribute("id", string2);
                    }
                }
                if (packet.getStanzaTo().getLocalpart() != null && this.config.isPepPeristent()) {
                    publishItemModule = this.pubSubComponent.getPublishItemModule();
                    if (publishItemModule != null) {
                        publishItemModule.ensurePepNode(packet.getStanzaTo().getBareJID(), string, packet.getStanzaFrom().getBareJID());
                    } else {
                        throw new PubSubException(Authorization.INTERNAL_SERVER_ERROR);
                    }
                }
                if (a.isLoggable(Level.FINEST)) {
                    a.log(Level.FINEST, "IQ packet, forwarding to all nodes, forwardElementsMatch: {0}, packet: {1}", new Object[]{bl, packet});
                }
                return this.getNodesConnectedWithLocal();
            }
            if (packet.getType() != StanzaType.get) {
                if (a.isLoggable(Level.FINEST)) {
                    a.log(Level.FINEST, "adding packet to filterResponse, id: {0}, filterResponse: {1}", new Object[]{packet.getAttributeStaticStr("id"), this.e});
                }
                this.e.set(packet.getAttributeStaticStr("id"));
            }
            if (a.isLoggable(Level.FINEST)) {
                a.log(Level.ALL, "IQ other packet, local node, packet: {0}", packet);
            }
            return Collections.singletonList(this.getLocalNodeJid());
        }
        a.log(Level.SEVERE, "received unknown packet = {0}", packet);
        return null;
    }

    @Override
    public boolean isLocalNode(BareJID serviceJid, String node) {
        return true;
    }

    @Override
    public void nodeAddedToRootCollection(BareJID serviceJid, String nodeName) {
        ((ArrayDeque)this.nodesModifications.get()).offer(new Element("root-node-added", new String[]{"service-jid", "node"}, new String[]{serviceJid.toString(), nodeName}));
    }

    @Override
    public void nodeRemovedFromRootCollection(BareJID serviceJid, String nodeName) {
        ((ArrayDeque)this.nodesModifications.get()).offer(new Element("root-node-removed", new String[]{"service-jid", "node"}, new String[]{serviceJid.toString(), nodeName}));
    }

    @Override
    public void nodeConfigurationChanged(BareJID serviceJid, String nodeName) {
        ((ArrayDeque)this.nodesModifications.get()).offer(new Element("node-config-changed", new String[]{"service-jid", "node"}, new String[]{serviceJid.toString(), nodeName}));
    }

    public void notifyNodeConfigurationChanges() {
        List<JID> list = this.getNodesConnected();
        Queue queue = (Queue)this.nodesModifications.get();
        this.nodesModifications.remove();
        Map<String, String> map = this.prepareCommandData(null, null);
        this.cl_controller.sendToNodes("nodes-changed-cmd", map, queue, this.getLocalNodeJid(), null, list.toArray(new JID[list.size()]));
    }

    @Override
    public boolean sendException(Packet packet, ComponentException ex) {
        if (this.pubSubComponent.getName().equals(packet.getPacketFrom().getLocalpart()) && packet.getElement().findChildStaticStr(b) != null) {
            return false;
        }
        return super.sendException(packet, ex);
    }

    @Override
    public void setClusterController(ClusterControllerIfc cl_controller) {
        if (this.cl_controller != null) {
            this.cl_controller.removeCommandListener((CommandListener)this.d);
        }
        super.setClusterController(cl_controller);
        this.cl_controller.setCommandListener((CommandListener)this.d);
    }

    @Override
    public void setProperties(Map<String, Object> props) {
    }

    private boolean a(BareJID bareJID) {
        JID jID = this.getNodeForHashCode(bareJID.hashCode());
        if (a.isLoggable(Level.FINEST)) {
            a.log(Level.FINEST, "NodeJIDhandleLocally, jid: {0}, nodeJid: {1}", new Object[]{bareJID, jID});
        }
        return this.localNodeJid.equals((Object)jID);
    }

    @Override
    public boolean isOnlineLocally(JID jid) {
        TigaseRuntime tigaseRuntime = TigaseRuntime.getTigaseRuntime();
        if (this.pubSubComponent.isLocalDomain(jid.getDomain()) && tigaseRuntime.isJidOnline(jid)) {
            return tigaseRuntime.isJidOnlineLocally(jid);
        }
        return this.a(jid.getBareJID());
    }

    @Override
    public AbstractNodeConfig wrapNodeConfig(BareJID serviceJid, String nodeName, AbstractNodeConfig config) {
        if (config instanceof LeafNodeConfig && this.e.get() != null) {
            ((LeafNodeConfig)config).setValue("pubsub#persist_items", false);
            if (a.isLoggable(Level.FINEST)) {
                a.log(Level.FINEST, "forcing item to ignore persistence setting for node {0} on request {1} as item it will be saved by other cluster node", new Object[]{nodeName, this.e.get()});
            }
        } else if (a.isLoggable(Level.FINEST)) {
            a.log(Level.FINEST, "Not wrapping nodeConfig, filterResponse: {0}", this.e.get());
        }
        return config;
    }

    @Override
    public tigase.pubsub.repository.cached.NodeSubscriptions wrapNodeSubscriptions(NodeSubscriptions nodeSubscriptions) {
        if (a.isLoggable(Level.FINEST)) {
            a.log(Level.FINEST, "wrapNodeSubscriptions[1], nodeSubscriptions: {0}", nodeSubscriptions);
        }
        return new tigase.pubsub.repository.cached.NodeSubscriptions(nodeSubscriptions){

            public UsersSubscription[] getSubscriptionsForPublish() {
                UsersSubscription[] usersSubscriptionArray = super.getSubscriptionsForPublish();
                if (this.log.isLoggable(Level.FINEST)) {
                    this.log.log(Level.FINEST, "wrapNodeSubscriptions[2], nodeSubscriptions(this): {0}, allSubs: {1}", new Object[]{this, Arrays.asList(usersSubscriptionArray)});
                }
                if (usersSubscriptionArray == null || usersSubscriptionArray.length == 0) {
                    return usersSubscriptionArray;
                }
                TigaseRuntime tigaseRuntime = TigaseRuntime.getTigaseRuntime();
                ArrayList<UsersSubscription> arrayList = new ArrayList<UsersSubscription>();
                for (int i = 0; i < usersSubscriptionArray.length; ++i) {
                    UsersSubscription usersSubscription = usersSubscriptionArray[i];
                    if (this.log.isLoggable(Level.FINEST)) {
                        this.log.log(Level.FINEST, "procesing sub: {0}, isLocalDomain: {1}, jidOnline: {2}, onlineLocally: {3}, handleLocally: {4} ", new Object[]{usersSubscription, ClusteredNodeStrategy.this.pubSubComponent.isLocalDomain(usersSubscription.getJid().getDomain()), tigaseRuntime.isJidOnline(JID.jidInstance((BareJID)usersSubscription.getJid())), tigaseRuntime.isJidOnlineLocally(usersSubscription.getJid()), ClusteredNodeStrategy.this.a(usersSubscription.getJid())});
                    }
                    if (ClusteredNodeStrategy.this.pubSubComponent.isLocalDomain(usersSubscription.getJid().getDomain()) && tigaseRuntime.isJidOnline(JID.jidInstance((BareJID)usersSubscription.getJid()))) {
                        if (!tigaseRuntime.isJidOnlineLocally(usersSubscription.getJid())) continue;
                        arrayList.add(usersSubscription);
                        continue;
                    }
                    if (!ClusteredNodeStrategy.this.a(usersSubscription.getJid())) continue;
                    arrayList.add(usersSubscription);
                }
                if (this.log.isLoggable(Level.FINEST)) {
                    this.log.log(Level.FINEST, "wrapNodeSubscriptions[3], subs: {0}", arrayList);
                }
                return arrayList.toArray(new UsersSubscription[arrayList.size()]);
            }
        };
    }

    @Override
    public void packetProcessed() {
        this.e.remove();
        if (!((ArrayDeque)this.nodesModifications.get()).isEmpty()) {
            this.notifyNodeConfigurationChanges();
        }
        super.packetProcessed();
    }

    @Override
    public void userRemoved(BareJID serviceJid) {
        ((ArrayDeque)this.nodesModifications.get()).offer(new Element("user-removed", new String[]{"service-jid"}, new String[]{serviceJid.toString()}));
    }
}

