/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.server.Iq;
import tigase.server.Packet;
import tigase.server.XMPPServer;
import tigase.xml.Element;
import tigase.xmpp.JID;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.XMPPProcessorAbstract;
import tigase.xmpp.XMPPResourceConnection;

public class JabberIqVersion
extends XMPPProcessorAbstract {
    private static final Logger log = Logger.getLogger(JabberIqVersion.class.getName());
    private static final String XMLNS = "jabber:iq:version";
    private static final String ID = "jabber:iq:version";
    private static final String[][] ELEMENTS = new String[][]{Iq.IQ_QUERY_PATH};
    private static final String[] XMLNSS = new String[]{"jabber:iq:version"};
    private static final Element SERVER_VERSION = new Element("query", new Element[]{new Element("name", "Tigase"), new Element("version", XMPPServer.getImplementationVersion()), new Element("os", System.getProperty("os.name") + "-" + System.getProperty("os.arch") + "-" + System.getProperty("os.version") + ", " + System.getProperty("java.vm.name") + "-" + System.getProperty("java.vm.version") + "-" + System.getProperty("java.vm.vendor"))}, new String[]{"xmlns"}, new String[]{"jabber:iq:version"});
    private static final Element[] DISCO_FEATURES = new Element[]{new Element("feature", new String[]{"var"}, new String[]{"jabber:iq:version"})};

    @Override
    public String id() {
        return "jabber:iq:version";
    }

    @Override
    public void processFromUserPacket(JID connectionId, Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws PacketErrorTypeException {
        if (packet.getStanzaTo() == null || session.isLocalDomain(packet.getStanzaTo().toString(), false)) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Calling method: {0}, for packet={1}, for session={2}", new Object[]{"processFromUserToServerPacket", packet, session});
            }
            this.processFromUserToServerPacket(connectionId, packet, session, repo, results, settings);
        } else {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Calling method: {0}, for packet={1}, for session={2}", new Object[]{"processFromUserOutPacket", packet, session});
            }
            this.processFromUserOutPacket(connectionId, packet, session, repo, results, settings);
        }
    }

    @Override
    public void processFromUserOutPacket(JID connectionId, Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) {
        results.offer(packet.copyElementOnly());
    }

    @Override
    public void processFromUserToServerPacket(JID connectionId, Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) {
        results.offer(packet.okResult(SERVER_VERSION, 0));
    }

    @Override
    public void processServerSessionPacket(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) {
        results.offer(packet.okResult(SERVER_VERSION, 0));
    }

    @Override
    public Element[] supDiscoFeatures(XMPPResourceConnection session) {
        return DISCO_FEATURES;
    }

    @Override
    public String[][] supElementNamePaths() {
        return ELEMENTS;
    }

    @Override
    public String[] supNamespaces() {
        return XMLNSS;
    }
}

